dat_clean_total      <- clean_data(dat_raw,
                             HOCONUMBER_to_exclude = households_to_exclude,
                             NickID_to_exclude     = NULL)

dat_to_analyse_total <- map(.x = min_SIs, .f = ~drop_long_SIs(dat_clean_total, dat_SI, .x))


dat_to_analyse_total_long <- 
    dat_to_analyse_total %>% 
    map_df(.x = .,
           ~mutate(.x,
                   Age = cut(RoundedAge, right = FALSE,
                             breaks = c(0,18,50,65,Inf), 
                             labels = c("<18", "18-49", "50-64", "65+"))) %>%
               arrange(Age) %>%
               mutate(Age = fct_inorder(Age)) %>%
               distinct(NickID, STATUS, 
                        ReCodedVaccineType, DosesCovidVacc, Age) %>%
               group_by_at(.vars = vars(-NickID)) %>%
               tally %>%
               ungroup %>%
               mutate(STATUS = str_to_title(STATUS)) %>%
               mutate(key = case_when(
                   DosesCovidVacc == "Zero" ~ "None",
                   DosesCovidVacc == "One"  ~ sprintf("1 %s", ReCodedVaccineType),
                   DosesCovidVacc == "Two"  ~ sprintf("2 %s", ReCodedVaccineType),
                   TRUE                     ~ NA_character_)) %>%
               arrange(STATUS, ReCodedVaccineType) %>%
               select(-ReCodedVaccineType, -DosesCovidVacc) %>%
               mutate(key = factor(key),
                      key = fct_inorder(key)),
           .id = "Analysis" ) %>%
    filter(Analysis == "Sensitivity") %>%
    select(-Analysis) %>%
    mutate(key = fct_relevel(key, "None")) %>%
    arrange(key)

dat_to_analyse_total_long %>% group_by(STATUS) %>% summarise(n = sum(n)) %>%
    kable(format = 'simple', caption = "Number of cases and contacts in data")

dat_to_analyse_total_long %>% 
    spread(Age, n, fill = 0) %>%
    rename(Status = STATUS, Vaccine = key)  %>%
    mutate(Status = unfill_for_table(Status)) %T>%
    write_csv("figures/hsa_pres_table.csv") %>%
    knitr::kable(., booktabs = TRUE, 
                 linesep = "", align = 'llrrrr',
                 format = 'simple', caption = 'Number of index cases and their household contacts with listed vaccine status for each age group. Numbers in brackets show the additional individuals included in the sensitivity analysis. There are no index cases younger than 18') 


