# calculate Risk Ratios

SARs <- map(vas_fit, "vas_prd") %>%
  map_df(mcmc_to_dt, .id = 'Analysis')

SARs[, id := parse_number(as.character(parameter))][
  , Analysis := factor(Analysis, levels = names(min_SIs))
]

pred_covars <- vas_pred$Main %>%
    {.[grep(x = names(.),
            pattern = "idx", invert = T, value = T)]} %>%
    as.data.frame %>%
    mutate(id = 1:n()) %>%
    as.data.table

SARs_covars <- merge(SARs, pred_covars)

setnames(SARs_covars, old = names(SARs_covars),
         new = gsub(pattern = "_pred", replacement = "", x = names(SARs_covars)))

# unvaccinated in both case and contact
SARs_covars_main <- SARs_covars[ 
    vax_CONTACT == "None" & 
        vax_CASE == "None"
    , ]

### UP TO HERE ###
### ADD ANALYSIS VARIABLE TO ALL BELOW ###

# what is the relative risk for infectivity of Delta over Alpha variant?
RR_Variant <- dcast(SARs_covars_main[ age_CASE == 25  , 
             c("iteration", "Variant", "value", "age_CONTACT", "Analysis") ],
             Analysis + iteration + age_CONTACT ~ Variant)

kable(RR_Variant[, .(RR = Delta/Alpha), by= .(Analysis, age_CONTACT)][
    , as.list(quantile(RR, probs = c(.025, .5, .975))), 
    by= .(Analysis, age_CONTACT)][
      , age_CONTACT := ifelse(age_CONTACT == 15, "Child", "Adult")
    ][
      , (c("Analysis")) := lapply(.SD, unfill_for_table),
      .SDcols = c("Analysis")
    ], 
      format = 'simple', digits = 2,
    caption = "RR for transmission of Delta over Alpha from non-elderly adults")

# For a Delta household, what is the relative risk for infectivity of 
# elderly over non-elderly variant?
RR_age_case <- dcast(SARs_covars_main[  age_CONTACT == 25 , 
                                 c("iteration", "age_CASE", "Variant" , "value", "Analysis") ],
                     Analysis + iteration + Variant ~ age_CASE )

kable(RR_age_case[, .(RR = `55`/`25`), by = .(Analysis, Variant)][
  , as.list(quantile(RR, probs = c(.025, .5, .975))),
  by = .(Analysis, Variant)][
    , (c("Analysis", "Variant")) := lapply(.SD, unfill_for_table),
    .SDcols = c("Analysis", "Variant")
  ], 
  format = 'simple', digits = 1,
  caption = "RR for transmission from elderly over non-elderly adults")


RR_age_contact <- dcast(SARs_covars_main[ age_CASE == 25 , 
                                  c("iteration", "age_CONTACT", "Variant", "value", "Analysis") ],
                    Analysis + iteration + Variant ~ age_CONTACT)

kable(RR_age_contact[ , .(RR = `25`/`15`), by = .(Variant, Analysis)
                     ][, as.list(quantile(1/RR, probs = c(.025, .5, .975))),
                       by = .(Analysis, Variant)][
                         , (c("Analysis", "Variant")) := 
                           lapply(.SD, unfill_for_table),
                         .SDcols = c("Analysis", "Variant")
                       ], 
      format = 'simple', digits = 1,
      caption = "RR for acquisition by children over adults")


## what about the BNT162b2 vs ChAdOx1 statements?

# unvaccinated in both case and contact
SARs_covars_protection <- SARs_covars[ 
  vax_CONTACT != "None" & 
    vax_CASE == "None"
  , ]

RR_vax_protect <- dcast(SARs_covars_protection[ age_CASE == 25 & 
                                                  dwp1_CONTACT > 0, 
                                     c("iteration", "age_CONTACT", "Variant", "vax_CONTACT",
                                       "value", "dwp2_CONTACT", "Analysis") ],
                        Analysis + iteration + Variant + age_CONTACT + dwp2_CONTACT ~ vax_CONTACT)
RR_vax_protect[ , doses := 1L + (dwp2_CONTACT > 0)]

kable(RR_vax_protect[, .(RR = `BNT162b2`/`ChAdOx1`), 
                     by = .(Variant, doses, Analysis)][
                       , as.list(quantile(RR, probs = c(.025, .5, .975))),
                       by =  .(Analysis, Variant, doses)][
                         , .(RR = sprintf("%0.1f (%0.1f, %0.1f)",
                                          `50%`, `2.5%`, `97.5%`)),
                         by = .(Analysis, Variant, doses)][
                           , (c("Analysis", "Variant")) := lapply(.SD, unfill_for_table),
                           .SDcols = c("Analysis", "Variant")
                         ], 
      format = 'simple', 
      caption = "RR for acquisition for BNT162b2 over ChAdOx1 for by number of doses for an adult contact")



SARs_covars_transmit <- SARs_covars[ 
  vax_CONTACT == "None" & 
    vax_CASE != "None"
  , ]

RR_vax_transmit <- dcast(SARs_covars_transmit[ age_CONTACT == 25 & dwp1_CASE > 0 & 
                                                 age_CASE == 25, 
                                                c("iteration", "age_CASE",
                                                  "Variant", "vax_CASE",
                                                  "value", "dwp2_CASE",
                                                  "Analysis") ],
                        Analysis + iteration + Variant + age_CASE + dwp2_CASE ~ vax_CASE)
RR_vax_transmit[ , doses := 1L + (dwp2_CASE > 0)]

RR_vax_transmit_groups = c("Analysis", "Variant", "doses", "age_CASE", "dwp2_CASE")

kable(RR_vax_transmit[, .(RR = `BNT162b2`/`ChAdOx1`), 
                     by = RR_vax_transmit_groups][
                       , as.list(quantile(RR, probs = c(.025, .5, .975))),
                       by = RR_vax_transmit_groups][
                         , .(RR = sprintf("%0.1f (%0.1f, %0.1f)",
                                          `50%`, `2.5%`, `97.5%`)),
                         by = RR_vax_transmit_groups][
                           , c("Analysis", "Variant", "doses", "RR")
                         ][
                           , (c("Analysis", "Variant")) := lapply(.SD, unfill_for_table),
                           .SDcols = c("Analysis", "Variant")
                         ],
      format = 'simple',
      caption = "RR for acquisition for BNT162b2 over ChAdOx1 for two doses for an adult contact")

