# effectiveness of BNT162b2 compared to ChAdOx1

vaccine_ORs <- vas_fit$Main$vas_pst %>%
    as.mcmc %>%
    as.data.frame %>%
    select(matches(match = '(Beta|Gamma)\\.[1-2]\\[[1-2],[1-2]\\]')) %>%
    mutate(sample = 1:n()) %>%
    gather(key, value, -sample) %>%
    separate(col = key, into = c("Effect", "Dose", "Vaccine", "Variant",
                                 "dummy"), 
             sep = "(\\.|\\[|,|\\])") %>%
    select(-dummy) %>%
    spread(Vaccine, value) %>%
    mutate(OR = exp(`2` - `1`)) %>%
    group_by(Effect, Dose, Variant) %>%
    nest %>% 
    mutate(Q = map(data, ~quantile(.x$OR, c(0.025, 0.5, 0.975)))) %>%
    select(-data) %>%
    unnest_wider(Q)

vaccine_ORs %>%
    mutate_at(.vars = vars(Dose, Variant),
              .funs = parse_integer) %>%
    mutate(Dose    = decode_doses(Dose),
           Variant = c("Alpha", "Delta")[Variant]) %>%
    mutate(Effect = case_when(
        grepl(pattern = "^Beta",  x = Effect) ~ "Infection protection",
        grepl(pattern = "^Gamma", x = Effect) ~ "Transmission reduction")) %>%
    rename(median = `50%`) %>%
    mutate(Analysis = "Main",
           Vaccine  = "Dummy") %>%
    #group_by(Effect, Dose, Variant) %>%
    pretty_ors %>%
    select(-Analysis, -Vaccine) %>%
    ungroup %>%
    mutate(Variant = unfill_for_table(Variant)) %>%
    knitr::kable(format = 'simple', 
                 caption = 'Ratios of odds ratios for the effect of BNT162b2 vs ChAdOx1')

# effectiveness of a given vaccine in alpha vs delta

variant_ORs <- vas_fit$Main$vas_pst %>%#head %>%
    as.mcmc %>%
    as.data.frame %>%
    #head %>%
    select(matches(match = '(Beta|Gamma)\\.[1-2]\\[[1-2],[1-2]\\]')) %>%
    mutate(sample = 1:n()) %>%
    gather(key, value, -sample) %>%
    separate(col = key, into = c("Effect", "Dose", "Vaccine", "Variant",
                                 "dummy"), 
             sep = "(\\.|\\[|,|\\])") %>%
    select(-dummy) %>%
    spread(Variant, value) %>%
    mutate(OR = exp(`2` - `1`)) %>%
    group_by(Effect, Dose, Vaccine) %>%
    nest %>% 
    mutate(Q = map(data, ~quantile(.x$OR, c(0.025, 0.5, 0.975)))) %>%
    select(-data) %>%
    unnest_wider(Q)

variant_ORs %>%
    mutate(Dose    = decode_doses(Dose),
           Vaccine = decode_vax(Vaccine)) %>%
    mutate(Effect = case_when(
        grepl(pattern = "^Beta",  x = Effect) ~ "Infection protection",
        grepl(pattern = "^Gamma", x = Effect) ~ "Transmission reduction"))  %>%
    ungroup %>%
    mutate_at(.vars = vars(Effect, Dose),
              .funs = unfill_for_table) %>%
    knitr::kable(format = 'simple', digits = 2,
                 caption = "Ratios of odds ratios for the effect of a given vaccine product in Alpha vs Delta") 
