```
#          _/        _/
#         _/        _/          _/_/_/    _/_/    _/_/_/    
#        _/_/_/    _/_/_/    _/        _/    _/  _/    _/   
#       _/    _/  _/    _/    _/_/    _/_/_/_/  _/_/_/      
#      _/    _/  _/    _/        _/  _/    _/  _/    _/     
#     _/    _/  _/    _/  _/_/_/    _/    _/  _/    _/      
#     
#    household Secondary Attack Rates
#   
#    Paper title:  Effectiveness of BNT162b2 and ChAdOx1 against SARS-CoV-2
#                  household transmission
#     
#    Source:       https://github.com/samclifford/hhSAR 
# 
#    Institution:  London School of Hygiene & Tropical Medicine
#    Code authors: Samuel Clifford, Jada Hackman
#    Co-authors:   Stefan Flasche, Stephane Hue, Pauline Waight (HSA), Liz Miller
```

The `hhSARmain.R` file calls all other relevant scripts in order to clean the `SEQUENCINGOutput.xlsx` file, and fit a Bayesian model to estimate the odds ratio associated with contacts and cases being vaccinated when computing **h**ouse**h**old **S**econdary **A**ttack **R**ates.

The output files are stored in `figures`.

A few caveats about the modelling:

* households with at least one serial interval less than -2 days are omitted, on the grounds that they may represent the true case being misidentified as a contact. Phylodynamics work by Jada Hackmann might help confirm who acquired infection from whom in order to include all observed households
* vaccine-derived protection is assumed to occur after 14 days post-vaccination. This has been included in the model as parameters `k1` and `k2`. If, instead, we wish to incorporate prior information about the vaccine-to-immunity time, then we can change `k1,k2` from fixed to stochastic nodes
* We have no interaction terms in the model because the vaccines' effect on transmission potential from the case and infection protection for the contact are assumed independent
