(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     79888,       2304]
NotebookOptionsPosition[     71055,       2153]
NotebookOutlinePosition[     71478,       2170]
CellTagsIndexPosition[     71435,       2167]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Local shear-instability in Newtonian gravity", "Title",
 CellChangeTimes->{{3.8846829525563726`*^9, 
  3.884683005615779*^9}},ExpressionUUID->"98cf13f5-37b4-427c-b103-\
5fc2eff87700"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Author: Thomas Celora",
 FontColor->RGBColor[1, 0.5, 0]]], "Author",
 CellChangeTimes->{{3.884683030506843*^9, 
  3.884683073992838*^9}},ExpressionUUID->"218d5f5c-de03-4d73-a488-\
e309f324b90c"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"systemInfo", "[", "]"}], " ", ":=", " ", 
  RowBox[{"Column", "[", 
   RowBox[{"{", 
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<Last Modified: \>\"", ",", " ", "Bold"}], "]"}], ",", 
       " ", 
       RowBox[{"DateString", "[", 
        RowBox[{"FileDate", "[", 
         RowBox[{"NotebookFileName", "[", "]"}], "]"}], "]"}]}], "}"}], "]"}],
     "}"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"clearMemory", "[", "]"}], " ", ":=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"MemoryInUse", "[", "]"}], ",", " ", 
     RowBox[{"Unprotect", "[", 
      RowBox[{"In", ",", " ", "Out"}], "]"}], ",", " ", 
     RowBox[{"Clear", "[", 
      RowBox[{"In", ",", " ", "Out"}], "]"}], ",", " ", 
     RowBox[{"Protect", "[", 
      RowBox[{"In", ",", " ", "Out"}], "]"}], ",", " ", 
     RowBox[{"MemoryInUse", "[", "]"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"e1d42829-4589-4f1f-a2dc-87dfdfc7f51b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"systemInfo", "[", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"clearMemory", "[", "]"}], ";"}]}], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"2d643e16-196a-4c32-a21a-c232159576ff"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       StyleBox["\"Last Modified: \"", Bold, StripOnInput -> False], 
       "\"Mon 6 Feb 2023 14:50:17\""},
      "RowDefault"]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{
  3.884683152808213*^9, {3.884683821970592*^9, 3.88468382750369*^9}},
 CellLabel->"Out[17]=",ExpressionUUID->"7feb07b3-c2b1-4b60-8376-c0297143b653"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fluid background with shear and viscosity", "Chapter",
 CellChangeTimes->{{3.884683395342326*^9, 
  3.884683417620208*^9}},ExpressionUUID->"6e00058f-a1c8-43f8-86f9-\
0c0d2b988b3e"],

Cell[CellGroupData[{

Cell["Dispersion relation", "Section",
 CellChangeTimes->{{3.876800451025693*^9, 3.87680046097456*^9}, 
   3.884683497847517*^9},ExpressionUUID->"d769902a-119a-4b1b-b8fb-\
e43dbf1784ae"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "om"}], ",", " ", 
        RowBox[{"ro", " ", "k1"}], ",", " ", 
        RowBox[{"ro", " ", "k2"}], ",", " ", 
        RowBox[{"ro", " ", "k3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"cs", "^", "2"}], " ", "/", " ", "ro"}], " ", "k1"}], " ", 
        ",", 
        RowBox[{
         RowBox[{"-", "om"}], " ", "-", 
         RowBox[{"I", " ", "s1"}], "-", " ", 
         RowBox[{"I", " ", "eta", " ", "E1"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "I"}], "/", "6"}], " ", "eta", " ", "k1", " ", "k2"}], 
        ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "I"}], "/", "6"}], " ", "eta", " ", "k1", " ", 
         "k3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"cs", "^", "2"}], " ", "/", " ", "ro"}], " ", "k2"}], ",", 
        " ", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "I"}], "/", "6"}], " ", "eta", " ", "k2", " ", "k1"}], 
        ",", 
        RowBox[{
         RowBox[{"-", "om"}], " ", "-", " ", 
         RowBox[{"I", " ", "s2"}], " ", "-", " ", 
         RowBox[{"I", " ", "eta", " ", "E2"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "I"}], "/", "6"}], " ", "eta", " ", "k2", " ", 
         "k3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"cs", "^", "2"}], " ", "/", " ", "ro"}], " ", "k3"}], " ", 
        ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "I"}], "/", "6"}], " ", "eta", " ", "k3", " ", "k1"}], 
        ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "I"}], "/", "6"}], " ", "eta", " ", "k3", " ", "k2"}], 
        ",", " ", 
        RowBox[{
         RowBox[{"-", "om"}], " ", "+", 
         RowBox[{"I", 
          RowBox[{"(", 
           RowBox[{"s1", "+", "s2"}], ")"}]}], "-", " ", 
         RowBox[{"I", " ", "eta", " ", "E3"}]}]}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", " ", "=", " ", 
   RowBox[{"mat", " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"E1", " ", "\[Rule]", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"2", "/", "3"}], " ", 
         RowBox[{"k1", " ", "^", "2"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"1", "/", "2"}], " ", 
         RowBox[{"k2", "^", "2"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"1", "/", "2"}], " ", 
         RowBox[{"k3", "^", "2"}]}]}]}], ",", 
      RowBox[{"E2", "\[Rule]", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2"}], " ", 
         RowBox[{"k1", "^", "2"}]}], " ", "+", 
        RowBox[{
         RowBox[{"2", "/", "3"}], " ", 
         RowBox[{"k2", " ", "^", "2"}]}], "+", "  ", 
        RowBox[{
         RowBox[{"1", "/", "2"}], " ", 
         RowBox[{"k3", "^", "2"}]}]}]}], ",", 
      RowBox[{"E3", " ", "\[Rule]", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2"}], " ", 
         RowBox[{"k1", "^", "2"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"1", "/", "2"}], " ", 
         RowBox[{"k2", "^", "2"}]}], "+", " ", 
        RowBox[{
         RowBox[{"2", "/", "3"}], " ", 
         RowBox[{"k3", " ", "^", "2"}]}]}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", " ", "//", "MatrixForm"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"det", " ", "=", " ", 
   RowBox[{"Det", "[", "mat", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Exponent", "[", 
   RowBox[{"det", ",", " ", "om"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.876800435227521*^9, 3.876800436713081*^9}, {
   3.876800466868104*^9, 3.876800687168419*^9}, {3.8768056975527353`*^9, 
   3.8768057471366367`*^9}, 3.884683441034259*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"1ee9d10b-3e94-43e8-81f1-c4d01f3ac8d1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "om"}], 
      RowBox[{"k1", " ", "ro"}], 
      RowBox[{"k2", " ", "ro"}], 
      RowBox[{"k3", " ", "ro"}]},
     {
      FractionBox[
       RowBox[{
        SuperscriptBox["cs", "2"], " ", "k1"}], "ro"], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "eta", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["k1", "2"]}], "3"], "+", 
          FractionBox[
           SuperscriptBox["k2", "2"], "2"], "+", 
          FractionBox[
           SuperscriptBox["k3", "2"], "2"]}], ")"}]}], "-", "om", "-", 
       RowBox[{"\[ImaginaryI]", " ", "s1"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "6"]}], " ", "\[ImaginaryI]", " ", "eta", " ", "k1", 
       " ", "k2"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "6"]}], " ", "\[ImaginaryI]", " ", "eta", " ", "k1", 
       " ", "k3"}]},
     {
      FractionBox[
       RowBox[{
        SuperscriptBox["cs", "2"], " ", "k2"}], "ro"], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "6"]}], " ", "\[ImaginaryI]", " ", "eta", " ", "k1", 
       " ", "k2"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "eta", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           SuperscriptBox["k1", "2"], "2"], "+", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["k2", "2"]}], "3"], "+", 
          FractionBox[
           SuperscriptBox["k3", "2"], "2"]}], ")"}]}], "-", "om", "-", 
       RowBox[{"\[ImaginaryI]", " ", "s2"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "6"]}], " ", "\[ImaginaryI]", " ", "eta", " ", "k2", 
       " ", "k3"}]},
     {
      FractionBox[
       RowBox[{
        SuperscriptBox["cs", "2"], " ", "k3"}], "ro"], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "6"]}], " ", "\[ImaginaryI]", " ", "eta", " ", "k1", 
       " ", "k3"}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "6"]}], " ", "\[ImaginaryI]", " ", "eta", " ", "k2", 
       " ", "k3"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "eta", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           SuperscriptBox["k1", "2"], "2"], "+", 
          FractionBox[
           SuperscriptBox["k2", "2"], "2"], "+", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["k3", "2"]}], "3"]}], ")"}]}], "-", "om", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"s1", "+", "s2"}], ")"}]}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8768004807287483`*^9, {3.876800513783298*^9, 3.876800535062553*^9}, 
   3.8768005915243883`*^9, {3.876800668435162*^9, 3.876800688211212*^9}, {
   3.876805699755973*^9, 3.8768057481680613`*^9}, {3.884683431144086*^9, 
   3.884683441528508*^9}},
 CellLabel->
  "Out[35]//MatrixForm=",ExpressionUUID->"c380c714-cdcd-4b06-976d-\
f024b1be809a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Collect", "[", 
   RowBox[{"det", ",", "om"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a0", " ", "=", " ", 
   RowBox[{"ReplaceAll", "[", 
    RowBox[{
     RowBox[{"Expand", "[", "det", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"om", "^", "4"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"om", "^", "3"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"om", "^", "2"}], "\[Rule]", "0"}], ",", 
       RowBox[{"om", "\[Rule]", "0"}]}], "}"}]}], "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a1", " ", "=", " ", 
   RowBox[{
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Expand", "[", "det", "]"}], " ", "-", " ", "a0"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"om", "^", "4"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"om", "^", "3"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"om", "^", "2"}], "\[Rule]", "0"}]}], "}"}]}], "]"}], " ", "/.",
     " ", 
    RowBox[{"om", "\[Rule]", "1"}]}]}], "  ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a2", " ", "=", " ", 
   RowBox[{
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Expand", "[", "det", "]"}], "-", " ", "a0", "-", 
       RowBox[{"a1", " ", "om"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"om", "^", "4"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"om", "^", "3"}], "\[Rule]", "0"}]}], "}"}]}], "]"}], " ", "/.",
     " ", 
    RowBox[{"om", "\[Rule]", "1"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a3", " ", "=", " ", 
   RowBox[{
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Expand", "[", "det", "]"}], " ", "-", " ", "a0", "-", 
       RowBox[{"a1", " ", "om"}], "-", 
       RowBox[{"a2", " ", 
        RowBox[{"om", "^", "2"}]}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"om", "^", "4"}], "\[Rule]", "0"}], "}"}]}], "]"}], " ", "/.",
     " ", 
    RowBox[{"om", "\[Rule]", "1"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a4", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Expand", "[", "det", "]"}], " ", "-", " ", "a0", "-", 
      RowBox[{"a1", " ", "om"}], "-", 
      RowBox[{"a2", " ", 
       RowBox[{"om", "^", "2"}]}], "-", 
      RowBox[{"a3", " ", 
       RowBox[{"om", "^", "3"}]}]}], ")"}], "/.", " ", 
    RowBox[{"om", " ", "\[Rule]", "1"}]}]}], " ", ";"}]}], "Input",
 CellChangeTimes->{{3.8768007251422157`*^9, 3.8768007387655287`*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"f176984a-c463-4982-b3dc-7ad08c76aa2e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"coefflist", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"a0", ",", "a1", ",", "a2", ",", "a3", ",", "a4"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", " ", "<", " ", 
    RowBox[{
     RowBox[{"Length", "[", "coefflist", "]"}], "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"coefflist", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "0"}], ",", " ", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<0: \>\"", ",", 
       RowBox[{"i", "-", "1"}]}], "]"}]}], "]"}]}], " ", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", " ", "<", " ", 
    RowBox[{
     RowBox[{"Length", "[", "coefflist", "]"}], "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"coefflist", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", " ", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<-1:\>\"", ",", " ", 
       RowBox[{"i", "-", "1"}]}], "]"}]}], "]"}]}], " ", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", " ", "<", " ", 
    RowBox[{
     RowBox[{"Length", "[", "coefflist", "]"}], "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"coefflist", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "1"}], ",", " ", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<1: \>\"", ",", 
       RowBox[{"i", "-", "1"}]}], "]"}]}], "]"}]}], " ", "]"}]}], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"29c8152e-6037-4b6f-87d4-41e30834434d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"1: \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["1: ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.876800749989072*^9, {3.8768057523566723`*^9, 3.876805757632428*^9}, 
   3.884683447011016*^9},
 CellLabel->
  "During evaluation of \
In[44]:=",ExpressionUUID->"c4ee6a11-82ec-4c89-8603-1a6c40113175"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DumpSave", "[", 
   RowBox[{"\"\<fluidSEta_coeff.mx\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"a0", ",", "a1", ",", "a2", ",", "a3"}], "}"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.876800763051407*^9, 3.876800770859517*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"98f14b50-91d3-47ed-b7ad-35646d99df08"]
}, Closed]],

Cell[CellGroupData[{

Cell["Coefficients decomposition", "Section",
 CellChangeTimes->{{3.876800836435568*^9, 3.876800840443281*^9}, {
  3.8846835087519608`*^9, 
  3.884683513974989*^9}},ExpressionUUID->"51149208-e333-4938-93f7-\
c580a4d2fc2a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", " ", "\"\<fluidSEta_coeff.mx\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"K", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"k1", ",", "k2", ",", "k3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"shear", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "s2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", " ", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"s1", "+", "s2"}], ")"}]}]}], "}"}]}], "}"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"shear2", " ", "=", " ", 
   RowBox[{"shear", " ", ".", " ", "shear"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"shear3", " ", "=", " ", 
   RowBox[{"shear", ".", "shear", ".", "shear"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8768008520901937`*^9, 3.876800857697062*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"2a86e830-aa7b-441c-9737-65e20ac306fb"],

Cell[CellGroupData[{

Cell["Zero-th coefficient", "Subsection",
 CellChangeTimes->{{3.876802392974832*^9, 
  3.876802398353335*^9}},ExpressionUUID->"3bc76680-2f47-44aa-897f-\
9913e8955451"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Simplify", "[", 
   RowBox[{"a0", " ", "-", " ", 
    RowBox[{
     RowBox[{"cs", "^", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"K", ".", "shear2", ".", "K"}], " ", "-", " ", 
       RowBox[{
        RowBox[{"1", "/", "2"}], " ", 
        RowBox[{"Tr", "[", "shear2", "]"}], 
        RowBox[{"K", ".", "K"}]}], " ", "-", " ", 
       RowBox[{
        RowBox[{"eta", " ", "/", "2"}], " ", 
        RowBox[{"K", ".", "K"}], " ", 
        RowBox[{"K", ".", "shear", ".", "K"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"1", "/", "4"}], " ", 
        RowBox[{"eta", "^", "2"}], " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"K", ".", "K"}], ")"}], "^", "3"}]}]}], ")"}]}]}], "]"}],
  FontColor->RGBColor[0, 0, 1]]], "Input",
 CellChangeTimes->{{3.876803189970895*^9, 3.8768032432204313`*^9}, {
  3.8768059565151033`*^9, 3.876805956913802*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"c8648f9f-ea7f-40fa-a9a3-1a07a60d495d"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.8768032317463713`*^9, 3.876803260627461*^9}, 
   3.8768059584670486`*^9, 3.879334203386219*^9, 3.884683468644758*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"339f443c-76ea-499b-9387-b9abd6c755bc"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a0noeta", " ", "=", " ", 
   RowBox[{"a0", " ", "/.", " ", 
    RowBox[{"eta", "\[Rule]", "0"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"a0noeta", "-", " ", 
     RowBox[{
      RowBox[{"cs", "^", "2"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"K", ".", "shear2", ".", "K"}], " ", "-", " ", 
        RowBox[{
         RowBox[{"1", "/", "2"}], " ", 
         RowBox[{"Tr", "[", "shear2", "]"}], 
         RowBox[{"K", ".", "K"}]}]}], ")"}]}]}], "]"}], ";"}],
  FontColor->GrayLevel[0]]}], "Input",
 CellChangeTimes->{{3.8768020502501097`*^9, 3.876802094250085*^9}},
 CellLabel->
  "In[198]:=",ExpressionUUID->"b398b339-0bf6-4a57-9de2-171b03a3c56d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a0eta", " ", "=", " ", 
   RowBox[{"a0", " ", "-", 
    RowBox[{"(", 
     RowBox[{"a0", "/.", 
      RowBox[{"eta", "\[Rule]", "0"}]}], ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.87680209861548*^9, 3.876802118657242*^9}},
 CellLabel->
  "In[197]:=",ExpressionUUID->"09999e1c-d480-4c5d-93cd-d5305e776faa"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Exponent", "[", 
   RowBox[{"a0eta", " ", ",", "eta"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeff", " ", "=", " ", 
   RowBox[{"CoefficientList", "[", 
    RowBox[{"a0eta", ",", "eta"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lineta", " ", "=", " ", 
   RowBox[{"coeff", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"quadeta", " ", "=", " ", 
   RowBox[{"coeff", "[", 
    RowBox[{"[", "3", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.876802131525038*^9, 3.876802200331441*^9}},
 CellLabel->
  "In[193]:=",ExpressionUUID->"8a3b0ea3-2609-44d5-8277-d622c61ee621"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"lineta", " ", "-", " ", 
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", 
     RowBox[{"cs", "^", "2"}], " ", 
     RowBox[{"K", ".", "K"}], " ", 
     RowBox[{"(", 
      RowBox[{"K", ".", "shear", ".", "K"}], ")"}]}]}], " ", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.876802211920114*^9, 3.876802214388953*^9}, {
  3.876802252095291*^9, 3.876802281901622*^9}},
 CellLabel->
  "In[205]:=",ExpressionUUID->"ace181ec-416c-4cda-bc48-501992c6019a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"quadeta", " ", "-", " ", 
    RowBox[{
     RowBox[{"1", "/", "4"}], " ", 
     RowBox[{"cs", "^", "2"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"K", ".", "K"}], ")"}], "^", "3"}]}]}], "]"}], ";"}]], "Input",\

 CellChangeTimes->{3.876802283154725*^9},
 CellLabel->
  "In[206]:=",ExpressionUUID->"af858a61-144a-451b-984b-b6219df4189b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"a0eta", " ", "-", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "2"}], " ", 
       RowBox[{"cs", "^", "2"}], " ", 
       RowBox[{"K", ".", "K"}], " ", 
       RowBox[{"(", 
        RowBox[{"K", ".", "shear", ".", "K"}], ")"}], "eta"}], " ", "+", " ", 
      
      RowBox[{
       RowBox[{"1", "/", "4"}], " ", 
       RowBox[{"cs", "^", "2"}], " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"K", ".", "K"}], ")"}], "^", "3"}], " ", 
       RowBox[{"eta", "^", "2"}]}]}], ")"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.876802296187207*^9, 
  3.876802322448689*^9}},ExpressionUUID->"66323282-386b-4ee9-a5f8-\
d0279147e33e"]
}, Closed]],

Cell[CellGroupData[{

Cell["First coefficient", "Subsection",
 CellChangeTimes->{{3.8768019908386097`*^9, 
  3.876801993092228*^9}},ExpressionUUID->"995cd685-8577-43e5-bb6e-\
745d739c061a"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Simplify", "[", 
   RowBox[{"a1", " ", "-", " ", 
    RowBox[{"I", " ", 
     RowBox[{"cs", "^", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"K", ".", "shear", ".", "K"}], " ", "-", " ", 
       RowBox[{"eta", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"K", ".", "K"}], ")"}], "^", "2"}]}]}], ")"}]}], " ", "-", 
    " ", 
    RowBox[{"I", " ", 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", " ", "eta"}], "/", "6"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"K", ".", "shear2", ".", "K"}], " ", "-", " ", 
          RowBox[{"2", " ", 
           RowBox[{"Tr", "[", "shear2", "]"}], 
           RowBox[{"K", ".", "K"}]}]}], ")"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"eta", "^", "2"}], "/", "12"}], " ", 
        RowBox[{"K", ".", "K"}], " ", 
        RowBox[{"K", ".", "shear", ".", "K"}]}], " ", "-", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"eta", "^", "3"}], "/", "6"}], " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"K", ".", "K"}], ")"}], "^", "3"}]}], " ", "-", " ", 
       RowBox[{"Det", "[", "shear", "]"}]}], ")"}]}]}], "]"}],
  FontColor->RGBColor[0, 0, 1]]], "Input",
 CellChangeTimes->{{3.8768029085219383`*^9, 3.876803004087935*^9}, {
  3.876805876757771*^9, 3.876805895938867*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"2573a463-464c-4032-b8d2-b89bd106d68e"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.876803004526121*^9, 3.876805896590712*^9, 
  3.879334280643805*^9, 3.884683471998782*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"41d4c3fd-f5a0-4af8-b2ed-52768cd1bd5b"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a1noeta", " ", "=", " ", 
   RowBox[{"a1", " ", "/.", " ", 
    RowBox[{"eta", " ", "\[Rule]", "0"}]}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"a1noeta", " ", "-", " ", 
     RowBox[{"I", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"cs", "^", "2"}], " ", 
         RowBox[{"K", ".", "shear", ".", "K"}]}], "-", "  ", 
        RowBox[{"Det", "[", "shear", "]"}]}], ")"}]}]}], "]"}], ";"}],
  FontColor->GrayLevel[0]]}], "Input",
 CellChangeTimes->{{3.8768013111108932`*^9, 3.876801335792274*^9}, 
   3.876801893009597*^9},
 CellLabel->
  "In[163]:=",ExpressionUUID->"5e2c9230-8837-4c94-8302-958a5928624f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a1eta", " ", "=", " ", 
   RowBox[{"a1", "-", " ", 
    RowBox[{"(", " ", 
     RowBox[{"a1", " ", "/.", " ", 
      RowBox[{"eta", " ", "\[Rule]", "0"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a1etacs", " ", "=", " ", 
   RowBox[{"a1eta", " ", "-", " ", 
    RowBox[{"(", 
     RowBox[{"a1eta", "/.", 
      RowBox[{"cs", "\[Rule]", "0"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"a1etacs", " ", "-", " ", 
   RowBox[{"I", " ", 
    RowBox[{"cs", "^", "2"}], " ", "eta", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"K", ".", "K"}], ")"}], "^", "2"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.876801339031732*^9, 3.876801412719254*^9}, {
  3.876801855064588*^9, 
  3.8768018563939877`*^9}},ExpressionUUID->"b86ad1af-477c-4cfb-a9b3-\
41aa5bd7d272"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.876801353066773*^9, 3.8768014131513653`*^9}},
 CellLabel->"Out[51]=",ExpressionUUID->"94d5973f-0cf0-4a2d-966e-491a6bcb55b1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a1etanocs", " ", "=", " ", 
   RowBox[{"a1eta", "/.", 
    RowBox[{"cs", "\[Rule]", "0"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Exponent", "[", 
   RowBox[{"a1etanocs", " ", ",", "eta"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coeff", " ", "=", " ", 
    RowBox[{"DeleteCases", "[", 
     RowBox[{
      RowBox[{"CoefficientList", "[", 
       RowBox[{"a1etanocs", ",", "eta"}], "]"}], ",", "0"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lineta", " ", "=", " ", 
   RowBox[{"coeff", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"quadeta", " ", "=", " ", 
   RowBox[{"coeff", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cubeta", " ", "=", " ", 
   RowBox[{"coeff", "[", 
    RowBox[{"[", "3", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8768014177143793`*^9, 3.8768015262659283`*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"b39b39dc-5bd7-4836-9a23-62a48a59a872"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Decomposition of the term linear in eta",
 FontColor->RGBColor[0.6, 0.4, 0.2]]], "Text",
 CellChangeTimes->{{3.876801670677236*^9, 
  3.87680167808867*^9}},ExpressionUUID->"4b067115-9c11-4914-99ae-\
022666f09b46"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kterms", " ", "=", " ", 
   RowBox[{"Outer", "[", 
    RowBox[{"Times", ",", " ", "K", ",", " ", "K"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", " ", "=", " ", 
   RowBox[{"Length", "[", "kterms", "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Kterms", " ", "=", " ", 
   RowBox[{"kterms", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", "l"}], ",", " ", 
   RowBox[{"i", "++"}], ",", " ", "\[IndentingNewLine]", 
   RowBox[{"Kterms", " ", "=", " ", 
    RowBox[{"Join", "[", 
     RowBox[{"Kterms", ",", " ", 
      RowBox[{"kterms", "[", 
       RowBox[{"[", 
        RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}]}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Kterms", " ", "=", " ", 
    RowBox[{"DeleteDuplicates", "[", "Kterms", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"shearvec", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"s1", ",", "s2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sterms", " ", "=", " ", 
   RowBox[{"Outer", "[", 
    RowBox[{"Times", ",", "shearvec", ",", "shearvec"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", " ", "=", " ", 
   RowBox[{"Length", "[", "sterms", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sterms", " ", "=", " ", 
   RowBox[{"sterms", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", "l"}], ",", " ", 
   RowBox[{"i", "++"}], ",", " ", "\[IndentingNewLine]", 
   RowBox[{"Sterms", " ", "=", " ", 
    RowBox[{"Join", "[", 
     RowBox[{"Sterms", ",", " ", 
      RowBox[{"sterms", "[", 
       RowBox[{"[", 
        RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}]}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Sterms", " ", "=", " ", 
    RowBox[{"DeleteDuplicates", "[", "Sterms", "]"}]}], " ", ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"totterms", " ", "=", " ", 
   RowBox[{"Outer", "[", 
    RowBox[{"Times", ",", " ", "Kterms", ",", "Sterms"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", " ", "=", " ", 
   RowBox[{"Length", "[", "totterms", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TOTterms", " ", "=", " ", 
   RowBox[{"totterms", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", "l"}], ",", " ", 
   RowBox[{"i", "++"}], ",", " ", "\[IndentingNewLine]", 
   RowBox[{"TOTterms", " ", "=", " ", 
    RowBox[{"Join", "[", 
     RowBox[{"TOTterms", ",", " ", 
      RowBox[{"totterms", "[", 
       RowBox[{"[", 
        RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}]}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TOTterms", " ", "=", "  ", 
   RowBox[{"DeleteDuplicates", "[", "TOTterms", "]"}]}], " ", ";"}]}], "Input",\

 CellChangeTimes->{{3.876801594085353*^9, 3.876801600482894*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"2225dcc7-9fcc-47f9-be52-fe162744c23f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sc1", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{"(", 
     RowBox[{"K", ".", "shear2", ".", "K"}], ")"}], " ", "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sc2", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"Tr", "[", "shear2", "]"}], 
     RowBox[{"K", ".", "K"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scalars", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"sc1", ",", " ", "sc2"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"alphas", "=", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"expr", " ", "=", " ", 
    RowBox[{"Expand", "[", 
     RowBox[{"lineta", "  ", "-", " ", 
      RowBox[{"scalars", ".", "alphas"}]}], "  ", "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", " ", "=", " ", 
   RowBox[{"Length", "[", "TOTterms", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"subs", "=", "  ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"TOTterms", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[Rule]", "0"}], " ", ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "l"}], "}"}]}], "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Subs", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Delete", "[", 
      RowBox[{"subs", ",", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "l"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Expr", " ", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Collect", "[", " ", 
       RowBox[{
        RowBox[{"ReplaceAll", "[", 
         RowBox[{"expr", ",", 
          RowBox[{"Subs", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", "TOTterms", ",", 
        "Simplify"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "l"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expr", " ", "=", " ", 
   RowBox[{"ReplaceAll", "[", 
    RowBox[{"Expr", ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k1", "\[Rule]", "1"}], ",", 
       RowBox[{"k2", "\[Rule]", "1"}], ",", 
       RowBox[{"k3", "\[Rule]", "1"}], ",", 
       RowBox[{"s1", "\[Rule]", "1"}], ",", 
       RowBox[{"s2", "\[Rule]", "1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expr", " ", "=", " ", 
   RowBox[{"DeleteCases", "[", 
    RowBox[{"Expr", ",", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "[", "Expr", "]"}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"If", "[", " ", 
  RowBox[{
   RowBox[{"DuplicateFreeQ", "[", "Expr", "]"}], " ", ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"Expr", " ", "=", " ", "Expr"}], " ", ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Expr", " ", "=", " ", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Expand", "[", "Expr", "]"}], "]"}]}], " ", ";"}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "[", "Expr", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Expr", "[", 
       RowBox[{"[", "i", "]"}], "]"}], " ", "\[Equal]", " ", "0"}], " ", ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "Expr", "]"}]}], "}"}]}], "]"}], ",", " ", 
   "alphas"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8768016151948843`*^9, 3.8768016173336143`*^9}},
 CellLabel->
  "In[130]:=",ExpressionUUID->"a2dfec9c-e251-42d3-a431-a781abd684e1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     FractionBox["\[ImaginaryI]", "6"]}], ",", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["\[ImaginaryI]", "3"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.87680162335721*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"225f513d-2ac1-4e8e-bf3d-6aa5eed39d54"]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"lineta", " ", "-", " ", 
    RowBox[{
     RowBox[{"I", "/", "6"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"K", ".", "shear2", ".", "K"}], " ", "-", " ", 
       RowBox[{"2", 
        RowBox[{"Tr", "[", "shear2", "]"}], 
        RowBox[{"K", ".", "K"}]}]}], " ", ")"}]}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.87680162559039*^9, 3.8768016537289352`*^9}, {
   3.876801698084096*^9, 3.8768016993279247`*^9}, 3.8768018087046623`*^9},
 CellLabel->
  "In[155]:=",ExpressionUUID->"848a55c4-2867-479f-9b99-761200243867"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"quadeta", " ", "-", " ", 
    RowBox[{
     RowBox[{"I", "/", "12"}], " ", 
     RowBox[{"(", 
      RowBox[{"K", ".", "K"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"K", ".", "shear", ".", "K"}], ")"}]}]}], "]"}], ";"}]], "Input",\

 CellChangeTimes->{{3.87680170161482*^9, 3.8768017374005747`*^9}, 
   3.876801807348667*^9},
 CellLabel->
  "In[156]:=",ExpressionUUID->"5d583baf-dae5-491e-bb2e-0fcda10974a1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"cubeta", " ", "-", " ", 
    RowBox[{
     RowBox[{"I", "/", "6"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"K", ".", "K"}], ")"}], "^", "3"}]}]}], "]"}], ";"}]], "Input",\

 CellChangeTimes->{{3.876801743286192*^9, 3.8768017581233597`*^9}, 
   3.876801805793898*^9},
 CellLabel->
  "In[157]:=",ExpressionUUID->"f5e5dbbd-a423-4227-8b28-f191ca8756e2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"a1etanocs", "  ", "-", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"eta", " ", 
       RowBox[{"I", "/", "6"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"K", ".", "shear2", ".", "K"}], " ", "-", " ", 
         RowBox[{"2", 
          RowBox[{"Tr", "[", "shear2", "]"}], 
          RowBox[{"K", ".", "K"}]}]}], " ", ")"}]}], "+", " ", 
      RowBox[{
       RowBox[{"eta", "^", "2"}], " ", 
       RowBox[{"I", "/", "12"}], " ", 
       RowBox[{"(", 
        RowBox[{"K", ".", "K"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"K", ".", "shear", ".", "K"}], ")"}]}], "+", " ", 
      RowBox[{
       RowBox[{"eta", "^", "3"}], " ", 
       RowBox[{"I", "/", "6"}], " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"K", ".", "K"}], ")"}], "^", "3"}]}]}], " ", ")"}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.876801761956382*^9, 3.876801803103325*^9}, 
   3.876801871710374*^9},
 CellLabel->
  "In[160]:=",ExpressionUUID->"71d30987-5070-4865-b3de-57a9ba8024eb"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"a1eta", " ", "-", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"I", " ", 
      RowBox[{"cs", "^", "2"}], " ", "eta", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"K", ".", "K"}], ")"}], "^", "2"}]}], " ", "+", " ", 
     RowBox[{"eta", " ", 
      RowBox[{"I", "/", "6"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"K", ".", "shear2", ".", "K"}], " ", "-", " ", 
        RowBox[{"2", 
         RowBox[{"Tr", "[", "shear2", "]"}], 
         RowBox[{"K", ".", "K"}]}]}], " ", ")"}]}], "+", " ", 
     RowBox[{
      RowBox[{"eta", "^", "2"}], " ", 
      RowBox[{"I", "/", "12"}], " ", 
      RowBox[{"(", 
       RowBox[{"K", ".", "K"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"K", ".", "shear", ".", "K"}], ")"}]}], "+", " ", 
     RowBox[{
      RowBox[{"eta", "^", "3"}], " ", 
      RowBox[{"I", "/", "6"}], " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"K", ".", "K"}], ")"}], "^", "3"}]}]}], " ", ")"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8768018378315*^9, 3.8768018688665133`*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"1aaafc11-05a1-4e67-bdc3-8c4e0d2fb6d9"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.8768018692646227`*^9},
 CellLabel->
  "Out[159]=",ExpressionUUID->"1b953ffa-3fc8-4084-83bd-d9e4530b67a2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Second and Third coefficients", "Subsection",
 CellChangeTimes->{{3.8768012715022297`*^9, 
  3.8768012816194887`*^9}},ExpressionUUID->"2542838a-3005-4b02-946b-\
fe7fed6df211"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Simplify", "[", " ", 
   RowBox[{"a3", " ", "-", " ", 
    RowBox[{"I", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", "/", "3"}], " ", "eta", " ", 
       RowBox[{"K", ".", "K"}]}], ")"}]}]}], "]"}],
  FontColor->RGBColor[0, 0, 1]]], "Input",
 CellChangeTimes->{{3.876800905962225*^9, 3.8768009284987917`*^9}, 
   3.876805780874793*^9},
 CellLabel->"In[58]:=",ExpressionUUID->"c747114f-a2d5-4aa1-b550-4df861c582e9"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.8768009288337517`*^9, 3.876805782209394*^9, 
  3.879334421572357*^9, 3.8846834756853733`*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"27968435-1d7c-4f2b-b6ff-86198d23c738"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a2noeta", " ", "=", " ", 
   RowBox[{"a2", "/.", " ", 
    RowBox[{"eta", "\[Rule]", " ", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{"Simplify", "[", 
   RowBox[{"a2noeta", " ", "-", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "2"}], 
       RowBox[{"Tr", "[", "shear2", "]"}]}], " ", "-", " ", 
      RowBox[{
       RowBox[{"cs", "^", "2"}], " ", 
       RowBox[{"K", ".", "K"}]}]}], ")"}]}], "]"}],
  FontColor->GrayLevel[0]]}], "Input",
 CellChangeTimes->{{3.876801058543693*^9, 3.8768010932216377`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"aeabd192-40f3-4b19-8375-a2801b0843e3"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.8768010892289762`*^9, 3.876801093519187*^9}},
 CellLabel->"Out[29]=",ExpressionUUID->"664760e9-c175-4f39-80bd-59a34a935238"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a2eta", " ", "=", " ", 
   RowBox[{"a2", " ", "-", " ", 
    RowBox[{"(", 
     RowBox[{"a2", "/.", " ", 
      RowBox[{"eta", "\[Rule]", " ", "0"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"a2eta", " ", "-", " ", 
   RowBox[{
    RowBox[{"1", "/", "12"}], " ", "eta", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "11"}], "eta", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"K", ".", "K"}], ")"}], "^", "2"}]}], " ", "-", " ", 
      RowBox[{"2", " ", 
       RowBox[{"K", ".", "shear", ".", "K"}]}]}], " ", ")"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.876801108326991*^9, 3.876801120935298*^9}, {
  3.876801220053068*^9, 3.876801223512897*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"5de79b83-14c6-4027-957e-85db64d38b07"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.876801116286941*^9, 3.876801121285734*^9}, 
   3.876801225059298*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"bd1010f3-8026-4b80-98b7-e38439d06d21"]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"Simplify", "[", 
   RowBox[{"a2", " ", "-", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "2"}], 
       RowBox[{"Tr", "[", "shear2", "]"}]}], " ", "-", " ", 
      RowBox[{
       RowBox[{"cs", "^", "2"}], " ", 
       RowBox[{"K", ".", "K"}]}], "-", " ", 
      RowBox[{
       RowBox[{"1", "/", "12"}], " ", "eta", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", "eta", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"K", ".", "K"}], ")"}], "^", "2"}]}], " ", "-", " ", 
         RowBox[{"2", " ", 
          RowBox[{"K", ".", "shear", ".", "K"}]}]}], " ", ")"}]}]}], ")"}]}], 
   "]"}],
  FontColor->RGBColor[0, 0, 1]]], "Input",
 CellChangeTimes->{{3.87680123374088*^9, 3.876801255816259*^9}, {
  3.876804996819602*^9, 3.876805000658589*^9}, {3.876805803262252*^9, 
  3.87680581677197*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"703c7c3b-456d-470d-a566-2b15a8913567"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Fluid background with shear and vorticity", "Chapter",
 CellChangeTimes->{{3.884683520528284*^9, 
  3.884683559728489*^9}},ExpressionUUID->"d5e60209-a21f-4a88-841b-\
d53fbd292448"],

Cell[CellGroupData[{

Cell["Dispersion relation", "Section",
 CellChangeTimes->{{3.875358200700897*^9, 3.875358229566421*^9}, {
  3.87562002545287*^9, 3.8756200266500387`*^9}, {3.884683758127556*^9, 
  3.884683761118621*^9}},ExpressionUUID->"b03eef71-2e1c-4c49-adb7-\
abdd774b89b3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "om"}], ",", " ", 
       RowBox[{"ro", " ", "k1"}], ",", " ", 
       RowBox[{"ro", " ", "k2"}], ",", " ", 
       RowBox[{"ro", " ", "k3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"cs", "^", "2"}], " ", "/", " ", "ro"}], " ", "k1"}], " ", 
       ",", 
       RowBox[{
        RowBox[{"-", "om"}], " ", "-", 
        RowBox[{"I", " ", "s1"}]}], ",", 
       RowBox[{"I", " ", "W3"}], ",", 
       RowBox[{
        RowBox[{"-", "I"}], " ", "W2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"cs", "^", "2"}], " ", "/", " ", "ro"}], " ", "k2"}], ",", 
       " ", 
       RowBox[{
        RowBox[{"-", "I"}], " ", "W3"}], ",", 
       RowBox[{
        RowBox[{"-", "om"}], " ", "-", " ", 
        RowBox[{"I", " ", "s2"}]}], ",", 
       RowBox[{"I", " ", "W1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"cs", "^", "2"}], " ", "/", " ", "ro"}], " ", "k3"}], " ", 
       ",", 
       RowBox[{"I", " ", "W2"}], ",", 
       RowBox[{
        RowBox[{"-", "I"}], " ", "W1"}], ",", " ", 
       RowBox[{
        RowBox[{"-", "om"}], " ", "+", 
        RowBox[{"I", 
         RowBox[{"(", 
          RowBox[{"s1", "+", "s2"}], ")"}]}]}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", " ", "//", "MatrixForm"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"csdet", " ", "=", " ", 
   RowBox[{"Det", "[", "mat", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Exponent", "[", 
  RowBox[{"csdet", ",", " ", "om"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8753576039329863`*^9, 3.875357759886297*^9}, {
   3.875358719189834*^9, 3.875358720108252*^9}, 3.875358751269978*^9, {
   3.875358784400264*^9, 3.875358793885968*^9}, {3.875590484800235*^9, 
   3.875590495762065*^9}, {3.876462541855934*^9, 3.876462542075679*^9}},
 CellLabel->
  "In[339]:=",ExpressionUUID->"72ccd997-f217-48a4-a6cb-d760b79dbf32"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "om"}], 
      RowBox[{"k1", " ", "ro"}], 
      RowBox[{"k2", " ", "ro"}], 
      RowBox[{"k3", " ", "ro"}]},
     {
      FractionBox[
       RowBox[{
        SuperscriptBox["cs", "2"], " ", "k1"}], "ro"], 
      RowBox[{
       RowBox[{"-", "om"}], "-", 
       RowBox[{"\[ImaginaryI]", " ", "s1"}]}], 
      RowBox[{"\[ImaginaryI]", " ", "W3"}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "W2"}]},
     {
      FractionBox[
       RowBox[{
        SuperscriptBox["cs", "2"], " ", "k2"}], "ro"], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "W3"}], 
      RowBox[{
       RowBox[{"-", "om"}], "-", 
       RowBox[{"\[ImaginaryI]", " ", "s2"}]}], 
      RowBox[{"\[ImaginaryI]", " ", "W1"}]},
     {
      FractionBox[
       RowBox[{
        SuperscriptBox["cs", "2"], " ", "k3"}], "ro"], 
      RowBox[{"\[ImaginaryI]", " ", "W2"}], 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "W1"}], 
      RowBox[{
       RowBox[{"-", "om"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"s1", "+", "s2"}], ")"}]}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8753576500021973`*^9, {3.8753577051581097`*^9, 3.8753577607356663`*^9}, 
   3.8753579560189857`*^9, {3.87535836844802*^9, 3.875358397943592*^9}, 
   3.875358535338027*^9, 3.8753587151553926`*^9, 3.875358751773869*^9, {
   3.8753587892271013`*^9, 3.8753587944924517`*^9}, 3.8755904969636383`*^9, 
   3.8774349961170197`*^9},
 CellLabel->
  "Out[340]//MatrixForm=",ExpressionUUID->"d04b1712-5a45-4a83-975a-\
c1b8b1f75f62"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.8753576500021973`*^9, {3.8753577051581097`*^9, 3.8753577607356663`*^9}, 
   3.8753579560189857`*^9, {3.87535836844802*^9, 3.875358397943592*^9}, 
   3.875358535338027*^9, 3.8753587151553926`*^9, 3.875358751773869*^9, {
   3.8753587892271013`*^9, 3.8753587944924517`*^9}, 3.8755904969636383`*^9, 
   3.877434996120243*^9},
 CellLabel->
  "Out[342]=",ExpressionUUID->"beb16713-eae3-479c-9bff-45007a344ea8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Collect", "[", 
   RowBox[{"csdet", ",", "om"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a0", " ", "=", " ", 
   RowBox[{"ReplaceAll", "[", 
    RowBox[{
     RowBox[{"Expand", "[", "csdet", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"om", "^", "4"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"om", "^", "3"}], "\[Rule]", "0"}], ",", 
       RowBox[{
        RowBox[{"om", "^", "2"}], "\[Rule]", "0"}], ",", 
       RowBox[{"om", "\[Rule]", "0"}]}], "}"}]}], "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a1", " ", "=", " ", 
   RowBox[{
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Expand", "[", "csdet", "]"}], " ", "-", " ", "a0"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"om", "^", "4"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"om", "^", "3"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"om", "^", "2"}], "\[Rule]", "0"}]}], "}"}]}], "]"}], " ", "/.",
     " ", 
    RowBox[{"om", "\[Rule]", "1"}]}]}], "  ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a2", " ", "=", " ", 
   RowBox[{
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Expand", "[", "csdet", "]"}], "-", " ", "a0", "-", 
       RowBox[{"a1", " ", "om"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"om", "^", "4"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"om", "^", "3"}], "\[Rule]", "0"}]}], "}"}]}], "]"}], " ", "/.",
     " ", 
    RowBox[{"om", "\[Rule]", "1"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a3", " ", "=", " ", 
   RowBox[{
    RowBox[{"ReplaceAll", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Expand", "[", "csdet", "]"}], " ", "-", " ", "a0", "-", 
       RowBox[{"a1", " ", "om"}], "-", 
       RowBox[{"a2", " ", 
        RowBox[{"om", "^", "2"}]}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"om", "^", "4"}], "\[Rule]", "0"}], "}"}]}], "]"}], " ", "/.",
     " ", 
    RowBox[{"om", "\[Rule]", "1"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a4", " ", "=", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Expand", "[", "csdet", "]"}], " ", "-", " ", "a0", "-", 
       RowBox[{"a1", " ", "om"}], "-", 
       RowBox[{"a2", " ", 
        RowBox[{"om", "^", "2"}]}], "-", 
       RowBox[{"a3", " ", 
        RowBox[{"om", "^", "3"}]}]}], ")"}], "/.", " ", 
     RowBox[{"om", " ", "\[Rule]", "1"}]}]}], " ", ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coefflist", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"a0", ",", "a1", ",", "a2", ",", "a3", ",", "a4"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", " ", "<", " ", 
    RowBox[{
     RowBox[{"Length", "[", "coefflist", "]"}], "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"coefflist", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "0"}], ",", " ", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<0: \>\"", ",", 
       RowBox[{"i", "-", "1"}]}], "]"}]}], "]"}]}], " ", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", " ", "<", " ", 
    RowBox[{
     RowBox[{"Length", "[", "coefflist", "]"}], "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"coefflist", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", " ", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<-1:\>\"", ",", " ", 
       RowBox[{"i", "-", "1"}]}], "]"}]}], "]"}]}], " ", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", " ", "<", " ", 
    RowBox[{
     RowBox[{"Length", "[", "coefflist", "]"}], "+", "1"}]}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"coefflist", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "1"}], ",", " ", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<1: \>\"", ",", 
       RowBox[{"i", "-", "1"}]}], "]"}]}], "]"}]}], " ", "]"}]}], "Input",
 CellChangeTimes->{{3.875357767454461*^9, 3.875357777810351*^9}, {
  3.875357847486846*^9, 3.875357935297657*^9}, {3.875357993628027*^9, 
  3.8753580144682426`*^9}, {3.875358050123206*^9, 3.8753580976949368`*^9}, {
  3.8753584283486633`*^9, 3.8753584307956467`*^9}, {3.875590521166471*^9, 
  3.875590527338743*^9}, {3.877435016521531*^9, 3.877435016927534*^9}},
 CellLabel->
  "In[349]:=",ExpressionUUID->"aa880f83-7a0c-41bd-b94c-8ccdae2c7429"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"0: \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["0: ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.877435020897773*^9},
 CellLabel->
  "During evaluation of \
In[349]:=",ExpressionUUID->"b4671871-facf-49eb-a355-586563d5dcd6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"1: \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["1: ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.877435020901269*^9},
 CellLabel->
  "During evaluation of \
In[349]:=",ExpressionUUID->"e58f5964-f8b4-407c-8dda-f23e13b196d3"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DumpSave", "[", 
   RowBox[{"\"\<fluidSW_coeff.mx\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"a0", ",", "a1", ",", "a2"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.875358182230116*^9, 3.875358183460332*^9}, 
   3.8753583562340193`*^9, {3.87535868324407*^9, 3.875358683928141*^9}, {
   3.8753588033342447`*^9, 3.875358804021327*^9}},
 CellLabel->
  "In[359]:=",ExpressionUUID->"c75021c4-3da4-4f21-a4d4-c5b76edef98b"]
}, Closed]],

Cell[CellGroupData[{

Cell["Decomposing coefficients", "Section",
 CellChangeTimes->{{3.875358245886785*^9, 
  3.8753582514537287`*^9}},ExpressionUUID->"099d01a6-f0c8-415d-ba1e-\
1d625cc1776b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", " ", "\"\<fluidSW_coeff.mx\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"W1", ",", "W2", ",", "W3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"K", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"k1", ",", "k2", ",", "k3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"U", " ", "=", " ", 
    RowBox[{"Cross", "[", 
     RowBox[{"W", ",", "K"}], "]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"shear", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "s2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", " ", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"s1", "+", "s2"}], ")"}]}]}], "}"}]}], "}"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"shear2", " ", "=", " ", 
   RowBox[{"shear", " ", ".", " ", "shear"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"shear3", " ", "=", " ", 
   RowBox[{"shear", ".", "shear", ".", "shear"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.875358267832656*^9, 3.875358290191339*^9}, 
   3.875358364138298*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"b3caa515-16a5-42f4-adf6-2835a33d6b20"],

Cell[CellGroupData[{

Cell["Zero-th coefficient", "Subsection",
 CellChangeTimes->{{3.8753584407416286`*^9, 3.875358451163378*^9}, {
  3.875358850505436*^9, 
  3.875358878534893*^9}},ExpressionUUID->"db483fac-7ac4-4f3e-939d-\
ea01b0010add"],

Cell[BoxData[
 StyleBox[
  RowBox[{"Simplify", "[", 
   RowBox[{"a0", " ", "-", " ", 
    RowBox[{
     RowBox[{"cs", "^", "2"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"K", ".", "shear2", ".", "K"}], " ", "-", " ", 
       RowBox[{
        RowBox[{"1", "/", "2"}], " ", 
        RowBox[{"Tr", "[", "shear2", "]"}], 
        RowBox[{"K", ".", "K"}]}], "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"W", ".", "K"}], ")"}], "^", "2"}]}], ")"}]}]}], "]"}],
  FontColor->RGBColor[0, 0, 1]]], "Input",ExpressionUUID->"5437f7c7-fee2-4617-\
9c14-f66fa28e8823"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a0", "/.", " ", 
    RowBox[{"cs", "\[Rule]", "0"}]}], " ", ")"}], "\[Equal]", " ", 
  "0"}]], "Input",
 CellChangeTimes->{{3.875358879929451*^9, 3.875358931331532*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"de94722e-df33-463b-8908-c0a192e9b260"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.8753588975063953`*^9, 3.875358931881061*^9}, 
   3.875358997713695*^9, 3.8755905624249687`*^9, 3.877435041297625*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"1bc8e19b-4793-4c30-8637-4e94d1623ec2"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a0noShear", " ", "=", " ", 
   RowBox[{"a0", " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"s1", "\[Rule]", "0"}], ",", " ", 
      RowBox[{"s2", "\[Rule]", "0"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"a0noShear", " ", "-", " ", 
    RowBox[{
     RowBox[{"cs", "^", "2"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"K", ".", "W"}], ")"}], "^", "2"}]}]}], "]"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.87535893503407*^9, 3.875358983729903*^9}, 
   3.875359290085791*^9},
 CellLabel->"In[10]:=",ExpressionUUID->"bcf4854d-66f7-4f93-ba1d-533acf252866"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a0Shear", " ", "=", " ", 
   RowBox[{"a0", " ", "-", 
    RowBox[{"(", 
     RowBox[{"a0", " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"s1", "\[Rule]", "0"}], ",", " ", 
        RowBox[{"s2", "\[Rule]", "0"}]}], "}"}]}], ")"}]}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.875359008725758*^9, 3.875359071948234*^9}, 
   3.8753592920255136`*^9},
 CellLabel->"In[12]:=",ExpressionUUID->"53da7230-f311-4423-8f8e-150a00865a87"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["decomposition of the part with shear",
 FontColor->RGBColor[0.6, 0.4, 0.2]]], "Text",
 CellChangeTimes->{{3.875359243569345*^9, 
  3.8753592573250628`*^9}},ExpressionUUID->"cb29f8ce-a432-4a15-b765-\
ece4db56d487"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kterms", " ", "=", " ", 
   RowBox[{"Outer", "[", 
    RowBox[{"Times", ",", " ", "K", ",", " ", "K"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", " ", "=", " ", 
   RowBox[{"Length", "[", "kterms", "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Kterms", " ", "=", " ", 
   RowBox[{"kterms", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", "l"}], ",", " ", 
   RowBox[{"i", "++"}], ",", " ", "\[IndentingNewLine]", 
   RowBox[{"Kterms", " ", "=", " ", 
    RowBox[{"Join", "[", 
     RowBox[{"Kterms", ",", " ", 
      RowBox[{"kterms", "[", 
       RowBox[{"[", 
        RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}]}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Kterms", " ", "=", " ", 
    RowBox[{"DeleteDuplicates", "[", "Kterms", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"shearvec", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"s1", ",", "s2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sterms", " ", "=", " ", 
   RowBox[{"Outer", "[", 
    RowBox[{"Times", ",", "shearvec", ",", "shearvec"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", " ", "=", " ", 
   RowBox[{"Length", "[", "sterms", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sterms", " ", "=", " ", 
   RowBox[{"sterms", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", "l"}], ",", " ", 
   RowBox[{"i", "++"}], ",", " ", "\[IndentingNewLine]", 
   RowBox[{"Sterms", " ", "=", " ", 
    RowBox[{"Join", "[", 
     RowBox[{"Sterms", ",", " ", 
      RowBox[{"sterms", "[", 
       RowBox[{"[", 
        RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}]}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Sterms", " ", "=", " ", 
    RowBox[{"DeleteDuplicates", "[", "Sterms", "]"}]}], " ", ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"totterms", " ", "=", " ", 
   RowBox[{"Outer", "[", 
    RowBox[{"Times", ",", " ", "Kterms", ",", "Sterms"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", " ", "=", " ", 
   RowBox[{"Length", "[", "totterms", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TOTterms", " ", "=", " ", 
   RowBox[{"totterms", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", "l"}], ",", " ", 
   RowBox[{"i", "++"}], ",", " ", "\[IndentingNewLine]", 
   RowBox[{"TOTterms", " ", "=", " ", 
    RowBox[{"Join", "[", 
     RowBox[{"TOTterms", ",", " ", 
      RowBox[{"totterms", "[", 
       RowBox[{"[", 
        RowBox[{"i", "+", "1"}], "]"}], "]"}]}], "]"}]}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TOTterms", " ", "=", "  ", 
   RowBox[{"DeleteDuplicates", "[", "TOTterms", "]"}]}], " ", ";"}]}], "Input",\

 CellChangeTimes->{{3.875359128760025*^9, 
  3.875359136514697*^9}},ExpressionUUID->"f82b6314-bc50-4770-a42d-\
3f037d96ccea"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sc1", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{"(", 
     RowBox[{"K", ".", "shear2", ".", "K"}], ")"}], " ", "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sc2", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"Tr", "[", "shear2", "]"}], 
     RowBox[{"K", ".", "K"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scalars", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"sc1", ",", " ", "sc2"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"alphas", "=", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"expr", " ", "=", " ", 
    RowBox[{"Expand", "[", 
     RowBox[{"a0Shear", "  ", "-", " ", 
      RowBox[{"scalars", ".", "alphas"}]}], "  ", "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", " ", "=", " ", 
   RowBox[{"Length", "[", "TOTterms", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"subs", "=", "  ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"TOTterms", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[Rule]", "0"}], " ", ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "l"}], "}"}]}], "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Subs", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Delete", "[", 
      RowBox[{"subs", ",", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "l"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Expr", " ", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Collect", "[", " ", 
       RowBox[{
        RowBox[{"ReplaceAll", "[", 
         RowBox[{"expr", ",", 
          RowBox[{"Subs", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", "TOTterms", ",", 
        "Simplify"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "l"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expr", " ", "=", " ", 
   RowBox[{"ReplaceAll", "[", 
    RowBox[{"Expr", ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k1", "\[Rule]", "1"}], ",", 
       RowBox[{"k2", "\[Rule]", "1"}], ",", 
       RowBox[{"k3", "\[Rule]", "1"}], ",", 
       RowBox[{"s1", "\[Rule]", "1"}], ",", 
       RowBox[{"s2", "\[Rule]", "1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expr", " ", "=", " ", 
   RowBox[{"DeleteCases", "[", 
    RowBox[{"Expr", ",", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "[", "Expr", "]"}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"If", "[", " ", 
  RowBox[{
   RowBox[{"DuplicateFreeQ", "[", "Expr", "]"}], " ", ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"Expr", " ", "=", " ", "Expr"}], " ", ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Expr", " ", "=", " ", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Expand", "[", "Expr", "]"}], "]"}]}], " ", ";"}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "[", "Expr", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Expr", "[", 
       RowBox[{"[", "i", "]"}], "]"}], " ", "\[Equal]", " ", "0"}], " ", ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "Expr", "]"}]}], "}"}]}], "]"}], ",", " ", 
   "alphas"}], "]"}]}], "Input",
 CellChangeTimes->{{3.875359159072713*^9, 3.875359187689899*^9}},
 CellLabel->
  "In[118]:=",ExpressionUUID->"a74056fa-057a-4255-920b-fe1af3c19ed3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     SuperscriptBox["cs", "2"]}], ",", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["cs", "2"], "2"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8753591918199472`*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"4daf4def-ad3f-4e1f-b521-8be6a73a5fad"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"a0Shear", "-", " ", 
    RowBox[{
     RowBox[{"cs", "^", "2"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"K", ".", "shear2", ".", "K"}], " ", "-", " ", 
       RowBox[{
        RowBox[{"1", "/", "2"}], " ", 
        RowBox[{"Tr", "[", "shear2", "]"}], 
        RowBox[{"K", ".", "K"}]}]}], ")"}]}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.8753591969938517`*^9, 3.8753592298365793`*^9}, {
  3.875359295196225*^9, 3.875359327790704*^9}, {3.8774360411739607`*^9, 
  3.8774360638548098`*^9}, {3.884683781138648*^9, 
  3.884683781841939*^9}},ExpressionUUID->"32f28659-f89b-472d-ad4b-\
146a2a6ab5bd"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.877436064383226*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"81cd4ee1-13fa-4732-9376-95ef8c1d079d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["First coefficient", "Subsection",
 CellChangeTimes->{{3.8753593446672287`*^9, 
  3.875359346785941*^9}},ExpressionUUID->"79a4cb0f-6aaf-4249-b060-\
bf6aacd19831"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a1nocs", " ", "=", 
   RowBox[{"a1", " ", "/.", " ", 
    RowBox[{"cs", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"a1nocs", " ", "-", 
    RowBox[{"I", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "  ", 
        RowBox[{"Det", "[", "shear", "]"}]}], "-", " ", 
       RowBox[{"W", ".", "shear", ".", "W"}]}], ")"}]}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.875359360952341*^9, 3.875359398125165*^9}, {
   3.875359496968844*^9, 3.8753595012122297`*^9}, 3.875359574963682*^9},
 CellLabel->
  "In[159]:=",ExpressionUUID->"4fcc1e10-7617-4db0-a8f2-12875e96ad96"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a1cs", " ", "=", " ", 
   RowBox[{"a1", " ", "-", " ", 
    RowBox[{"(", 
     RowBox[{"a1", " ", "/.", " ", 
      RowBox[{"cs", "\[Rule]", "0"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"a1cs", "  ", "-", " ", 
    RowBox[{"I", " ", 
     RowBox[{"cs", "^", "2"}], " ", 
     RowBox[{"K", ".", "shear", ".", "K"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.875359506170629*^9, 3.8753595725851727`*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"0f20100d-d3c7-4f0e-ad47-3090c02ad344"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Simplify", "[", 
   RowBox[{"a1", " ", "-", " ", 
    RowBox[{"I", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"cs", "^", "2"}], " ", 
        RowBox[{"K", ".", "shear", ".", "K"}]}], "-", "  ", 
       RowBox[{"Det", "[", "shear", "]"}], "-", " ", 
       RowBox[{"W", ".", "shear", ".", "W"}]}], ")"}]}]}], "]"}],
  FontColor->RGBColor[0, 0, 1]]], "Input",
 CellChangeTimes->{{3.87535955148593*^9, 3.875359569668994*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"7ee377bd-c22f-4621-804b-6df245ff562a"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.87535957026961*^9, 3.8755906095256023`*^9, 
  3.877435060991941*^9, 3.877436082459427*^9, 3.8846838028529043`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"878269d8-7af7-4eed-9279-3c6a167530fa"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Second coefficient", "Subsection",
 CellChangeTimes->{{3.875359612350933*^9, 
  3.875359619838077*^9}},ExpressionUUID->"124e4989-31f7-4b7a-a976-\
3129ed958aa8"],

Cell[BoxData[
 StyleBox[
  RowBox[{"Simplify", "[", 
   RowBox[{"a2", " ", "-", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "2"}], 
       RowBox[{"Tr", "[", "shear2", "]"}]}], " ", "-", " ", 
      RowBox[{"W", ".", "W"}], " ", "-", " ", 
      RowBox[{
       RowBox[{"cs", "^", "2"}], " ", 
       RowBox[{"K", ".", "K"}]}]}], ")"}]}], "]"}],
  FontColor->RGBColor[0, 0, 1]]], "Input",
 CellChangeTimes->{{3.875359648158472*^9, 3.8753596805968847`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"253aa547-0a25-47eb-9330-0ac11d51ad05"]
}, Closed]]
}, Closed]]
}, Closed]]
},
CellGrouping->Manual,
WindowSize->{1157, 841},
WindowMargins->{{-1367, Automatic}, {Automatic, 50}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"15b1da00-3c8e-4e00-92e6-b36780b2ca36"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 189, 3, 98, "Title",ExpressionUUID->"98cf13f5-37b4-427c-b103-5fc2eff87700"],
Cell[CellGroupData[{
Cell[772, 27, 218, 4, 31, "Author",ExpressionUUID->"218d5f5c-de03-4d73-a488-e309f324b90c"],
Cell[993, 33, 1114, 29, 103, "Input",ExpressionUUID->"e1d42829-4589-4f1f-a2dc-87dfdfc7f51b"]
}, Closed]],
Cell[CellGroupData[{
Cell[2144, 67, 217, 4, 48, "Input",ExpressionUUID->"2d643e16-196a-4c32-a21a-c232159576ff"],
Cell[2364, 73, 538, 14, 35, "Output",ExpressionUUID->"7feb07b3-c2b1-4b60-8376-c0297143b653"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2939, 92, 186, 3, 69, "Chapter",ExpressionUUID->"6e00058f-a1c8-43f8-86f9-0c0d2b988b3e"],
Cell[CellGroupData[{
Cell[3150, 99, 186, 3, 67, "Section",ExpressionUUID->"d769902a-119a-4b1b-b8fb-e43dbf1784ae"],
Cell[CellGroupData[{
Cell[3361, 106, 4104, 120, 199, "Input",ExpressionUUID->"1ee9d10b-3e94-43e8-81f1-c4d01f3ac8d1"],
Cell[7468, 228, 3473, 103, 134, "Output",ExpressionUUID->"c380c714-cdcd-4b06-976d-f024b1be809a"]
}, Open  ]],
Cell[10956, 334, 2772, 80, 136, "Input",ExpressionUUID->"f176984a-c463-4982-b3dc-7ad08c76aa2e"],
Cell[CellGroupData[{
Cell[13753, 418, 1825, 54, 94, "Input",ExpressionUUID->"29c8152e-6037-4b6f-87d4-41e30834434d"],
Cell[15581, 474, 366, 10, 24, "Print",ExpressionUUID->"c4ee6a11-82ec-4c89-8603-1a6c40113175"]
}, Open  ]],
Cell[15962, 487, 485, 12, 52, "Input",ExpressionUUID->"98f14b50-91d3-47ed-b7ad-35646d99df08"]
}, Closed]],
Cell[CellGroupData[{
Cell[16484, 504, 222, 4, 53, "Section",ExpressionUUID->"51149208-e333-4938-93f7-c580a4d2fc2a"],
Cell[16709, 510, 1206, 35, 136, "Input",ExpressionUUID->"2a86e830-aa7b-441c-9737-65e20ac306fb"],
Cell[CellGroupData[{
Cell[17940, 549, 167, 3, 54, "Subsection",ExpressionUUID->"3bc76680-2f47-44aa-897f-9913e8955451"],
Cell[CellGroupData[{
Cell[18132, 556, 1002, 26, 30, "Input",ExpressionUUID->"c8648f9f-ea7f-40fa-a9a3-1a07a60d495d"],
Cell[19137, 584, 247, 3, 57, "Output",ExpressionUUID->"339f443c-76ea-499b-9387-b9abd6c755bc"]
}, Open  ]],
Cell[19399, 590, 760, 21, 52, "Input",ExpressionUUID->"b398b339-0bf6-4a57-9de2-171b03a3c56d"],
Cell[20162, 613, 347, 9, 30, "Input",ExpressionUUID->"09999e1c-d480-4c5d-93cd-d5305e776faa"],
Cell[20512, 624, 704, 18, 94, "Input",ExpressionUUID->"8a3b0ea3-2609-44d5-8277-d622c61ee621"],
Cell[21219, 644, 515, 14, 30, "Input",ExpressionUUID->"ace181ec-416c-4cda-bc48-501992c6019a"],
Cell[21737, 660, 415, 13, 30, "Input",ExpressionUUID->"af858a61-144a-451b-984b-b6219df4189b"],
Cell[22155, 675, 742, 22, 30, "Input",ExpressionUUID->"66323282-386b-4ee9-a5f8-d0279147e33e"]
}, Closed]],
Cell[CellGroupData[{
Cell[22934, 702, 167, 3, 38, "Subsection",ExpressionUUID->"995cd685-8577-43e5-bb6e-745d739c061a"],
Cell[CellGroupData[{
Cell[23126, 709, 1487, 41, 52, "Input",ExpressionUUID->"2573a463-464c-4032-b8d2-b89bd106d68e"],
Cell[24616, 752, 218, 3, 57, "Output",ExpressionUUID->"41d4c3fd-f5a0-4af8-b2ed-52768cd1bd5b"]
}, Open  ]],
Cell[24849, 758, 732, 21, 52, "Input",ExpressionUUID->"5e2c9230-8837-4c94-8302-958a5928624f"],
Cell[25584, 781, 867, 25, 73, "Input",ExpressionUUID->"b86ad1af-477c-4cfb-a9b3-41aa5bd7d272"],
Cell[26454, 808, 175, 2, 34, "Output",ExpressionUUID->"94d5973f-0cf0-4a2d-966e-491a6bcb55b1"],
Cell[26632, 812, 1120, 30, 157, "Input",ExpressionUUID->"b39b39dc-5bd7-4836-9a23-62a48a59a872"],
Cell[CellGroupData[{
Cell[27777, 846, 237, 4, 35, "Text",ExpressionUUID->"4b067115-9c11-4914-99ae-022666f09b46"],
Cell[28017, 852, 3380, 94, 514, "Input",ExpressionUUID->"2225dcc7-9fcc-47f9-be52-fe162744c23f"],
Cell[31400, 948, 3857, 112, 472, "Input",ExpressionUUID->"a2dfec9c-e251-42d3-a431-a781abd684e1"],
Cell[35260, 1062, 377, 11, 51, "Output",ExpressionUUID->"225f513d-2ac1-4e8e-bf3d-6aa5eed39d54"]
}, Closed]],
Cell[35652, 1076, 603, 15, 26, "Input",ExpressionUUID->"848a55c4-2867-479f-9b99-761200243867"],
Cell[36258, 1093, 474, 14, 30, "Input",ExpressionUUID->"5d583baf-dae5-491e-bb2e-0fcda10974a1"],
Cell[36735, 1109, 429, 13, 30, "Input",ExpressionUUID->"f5e5dbbd-a423-4227-8b28-f191ca8756e2"],
Cell[37167, 1124, 1074, 31, 30, "Input",ExpressionUUID->"71d30987-5070-4865-b3de-57a9ba8024eb"],
Cell[38244, 1157, 1181, 34, 30, "Input",ExpressionUUID->"1aaafc11-05a1-4e67-bdc3-8c4e0d2fb6d9"],
Cell[39428, 1193, 155, 3, 34, "Output",ExpressionUUID->"1b953ffa-3fc8-4084-83bd-d9e4530b67a2"]
}, Closed]],
Cell[CellGroupData[{
Cell[39620, 1201, 181, 3, 38, "Subsection",ExpressionUUID->"2542838a-3005-4b02-946b-fe7fed6df211"],
Cell[CellGroupData[{
Cell[39826, 1208, 460, 12, 30, "Input",ExpressionUUID->"c747114f-a2d5-4aa1-b550-4df861c582e9"],
Cell[40289, 1222, 222, 3, 34, "Output",ExpressionUUID->"27968435-1d7c-4f2b-b6ff-86198d23c738"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40548, 1230, 677, 18, 52, "Input",ExpressionUUID->"aeabd192-40f3-4b19-8375-a2801b0843e3"],
Cell[41228, 1250, 175, 2, 34, "Output",ExpressionUUID->"664760e9-c175-4f39-80bd-59a34a935238"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41440, 1257, 857, 24, 52, "Input",ExpressionUUID->"5de79b83-14c6-4027-957e-85db64d38b07"],
Cell[42300, 1283, 199, 3, 34, "Output",ExpressionUUID->"bd1010f3-8026-4b80-98b7-e38439d06d21"]
}, Open  ]],
Cell[42514, 1289, 984, 27, 30, "Input",ExpressionUUID->"703c7c3b-456d-470d-a566-2b15a8913567"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[43559, 1323, 186, 3, 58, "Chapter",ExpressionUUID->"d5e60209-a21f-4a88-841b-d53fbd292448"],
Cell[CellGroupData[{
Cell[43770, 1330, 260, 4, 67, "Section",ExpressionUUID->"b03eef71-2e1c-4c49-adb7-abdd774b89b3"],
Cell[CellGroupData[{
Cell[44055, 1338, 2175, 63, 136, "Input",ExpressionUUID->"72ccd997-f217-48a4-a6cb-d760b79dbf32"],
Cell[46233, 1403, 2014, 59, 130, "Output",ExpressionUUID->"d04b1712-5a45-4a83-975a-c1b8b1f75f62"],
Cell[48250, 1464, 457, 8, 34, "Output",ExpressionUUID->"beb16713-eae3-479c-9bff-45007a344ea8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48744, 1477, 4875, 140, 241, "Input",ExpressionUUID->"aa880f83-7a0c-41bd-b94c-8ccdae2c7429"],
Cell[53622, 1619, 290, 8, 24, "Print",ExpressionUUID->"b4671871-facf-49eb-a355-586563d5dcd6"],
Cell[53915, 1629, 290, 8, 24, "Print",ExpressionUUID->"e58f5964-f8b4-407c-8dda-f23e13b196d3"]
}, Open  ]],
Cell[54220, 1640, 598, 14, 52, "Input",ExpressionUUID->"c75021c4-3da4-4f21-a4d4-c5b76edef98b"]
}, Closed]],
Cell[CellGroupData[{
Cell[54855, 1659, 171, 3, 53, "Section",ExpressionUUID->"099d01a6-f0c8-415d-ba1e-1d625cc1776b"],
Cell[55029, 1664, 1528, 46, 178, "Input",ExpressionUUID->"b3caa515-16a5-42f4-adf6-2835a33d6b20"],
Cell[CellGroupData[{
Cell[56582, 1714, 218, 4, 54, "Subsection",ExpressionUUID->"db483fac-7ac4-4f3e-939d-ea01b0010add"],
Cell[56803, 1720, 584, 17, 30, "Input",ExpressionUUID->"5437f7c7-fee2-4617-9c14-f66fa28e8823"],
Cell[CellGroupData[{
Cell[57412, 1741, 299, 7, 30, "Input",ExpressionUUID->"de94722e-df33-463b-8908-c0a192e9b260"],
Cell[57714, 1750, 249, 3, 34, "Output",ExpressionUUID->"1bc8e19b-4793-4c30-8637-4e94d1623ec2"]
}, Open  ]],
Cell[57978, 1756, 677, 20, 52, "Input",ExpressionUUID->"bcf4854d-66f7-4f93-ba1d-533acf252866"],
Cell[58658, 1778, 483, 13, 30, "Input",ExpressionUUID->"53da7230-f311-4423-8f8e-150a00865a87"],
Cell[CellGroupData[{
Cell[59166, 1795, 237, 4, 35, "Text",ExpressionUUID->"cb29f8ce-a432-4a15-b765-ece4db56d487"],
Cell[59406, 1801, 3357, 94, 514, "Input",ExpressionUUID->"f82b6314-bc50-4770-a42d-3f037d96ccea"],
Cell[CellGroupData[{
Cell[62788, 1899, 3854, 112, 472, "Input",ExpressionUUID->"a74056fa-057a-4255-920b-fe1af3c19ed3"],
Cell[66645, 2013, 390, 12, 53, "Output",ExpressionUUID->"4daf4def-ad3f-4e1f-b521-8be6a73a5fad"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67084, 2031, 676, 17, 26, "Input",ExpressionUUID->"32f28659-f89b-472d-ad4b-146a2a6ab5bd"],
Cell[67763, 2050, 149, 2, 34, "Output",ExpressionUUID->"81cd4ee1-13fa-4732-9376-95ef8c1d079d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67961, 2058, 167, 3, 38, "Subsection",ExpressionUUID->"79a4cb0f-6aaf-4249-b060-bf6aacd19831"],
Cell[68131, 2063, 674, 18, 52, "Input",ExpressionUUID->"4fcc1e10-7617-4db0-a8f2-12875e96ad96"],
Cell[68808, 2083, 588, 16, 52, "Input",ExpressionUUID->"0f20100d-d3c7-4f0e-ad47-3090c02ad344"],
Cell[CellGroupData[{
Cell[69421, 2103, 561, 14, 30, "Input",ExpressionUUID->"7ee377bd-c22f-4621-804b-6df245ff562a"],
Cell[69985, 2119, 243, 3, 57, "Output",ExpressionUUID->"878269d8-7af7-4eed-9279-3c6a167530fa"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[70277, 2128, 166, 3, 38, "Subsection",ExpressionUUID->"124e4989-31f7-4b7a-a976-3129ed958aa8"],
Cell[70446, 2133, 569, 15, 30, "Input",ExpressionUUID->"253aa547-0a25-47eb-9330-0ac11d51ad05"]
}, Closed]]
}, Closed]]
}, Closed]]
}
]
*)

