# Mode Domain Specific Language (MDSL)
We defined our MDSL with [XText](https://www.eclipse.org/Xtext/) in the project [org.xtext.mdsl](https://github.com/rmtec/modeswitcher/tree/main/org.xtext.mdsl) and the grammar in the file [org.xtext.mdsl/src/org/xtext/mdsl/Mdsl.xtext](https://github.com/rmtec/modeswitcher/blob/main/org.xtext.mdsl/src/org/xtext/mdsl/Mdsl.xtext).

Using the MDSL within the Eclipse Editor, files with the extension .MDSL will support syntax highlighting, code-completion and validation.
The validation is defined in [org.xtext.mdsl/src/org/xtext/mdsl/validation/MdslValidator.java](https://github.com/rmtec/modeswitcher/blob/main/org.xtext.mdsl/src/org/xtext/mdsl/validation/MdslValidator.java).
The Xtext parser automatically validates if the syntax conforms to the defined MDSL. For example, only defined modes are allowed in a system. In addition, we statically analyze the system description and show error messages if there are duplicates of mode names, priorities, or action names. If the Debian OS and the distribution are specified, we check if the software and the packages are within the official package list. If not, we display a warning. If there are no errors the [XTend](https://www.eclipse.org/xtend/) code generator [org.xtext.mdsl/src/org/xtext/mdsl/generator/MdslGenerator.xtend](https://github.com/rmtec/modeswitcher/blob/main/org.xtext.mdsl/src/org/xtext/mdsl/generator/MdslGenerator.xtend) is executed and creates the system configuration as Java Code from the .MDSL-File. Then we create the Java bytecode from it.
