/*
 * generated by Xtext 2.25.0
 */
package org.xtext.mdsl.generator

import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import org.xtext.mdsl.mdsl.Action
import org.xtext.mdsl.mdsl.Mode
import org.xtext.mdsl.mdsl.Model
import org.xtext.mdsl.mdsl.Service
import org.xtext.mdsl.mdsl.Software
import org.xtext.mdsl.mdsl.System

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
class MdslGenerator extends AbstractGenerator {

	override void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
		fsa.generateFile('SystemConfigurationCreator.java', generateModes(resource.contents.head as Model));
	}
	
	def generateModes(Model model) {'''
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SystemConfigurationCreator{
		public static SystemConfiguration create() {
			List<Mode> modes  = new ArrayList<Mode>();
			HashMap<String, Software> software = new HashMap<String, Software>();
			String debianRelease;
			String releaseDate;
			FOR sys : model.declarations.filter(System)
			debianRelease = "sys.distribution";
			releaseDate = "sys.releaseDate";
			ENDFOR
			
			FOR s : model.declarations.filter(Software)
			Software s.name.toFirstLower = new Software("s.vendor","s.product","s.version", "s.package");
			software.put("cpe:/:s.vendor:s.product:s.version", s.name.toFirstLower);
			ENDFOR
			
			FOR a : model.declarations.filter(Action)
			Action a.name.toFirstLower = new Action("", "a.shellCmd");
			ENDFOR
			
			FOR s : model.declarations.filter(Service)
			Service s.name.toFirstLower = new Service("s.name",
				Arrays.asList(s.usesSoftware.map[name.toFirstLower].join(', ')),
				Arrays.asList(s.startActions.map[action.name.concat(".withParams(\"").concat(params.join('", "')).concat("\")")].join(', ')),
				Arrays.asList(s.stopActions.map[action.name.concat(".withParams(\"").concat(params.join('", "')).concat("\")")].join(', '))
			);
			ENDFOR
			
			FOR m : model.declarations.filter(Mode)
			Mode m.name.toFirstLower = new Mode("m.description", m.priority,
				Arrays.asList(m.startServices.map[name.toFirstLower].join(', ')),
				Arrays.asList(m.stopServices.map[name.toFirstLower].join(', '))
			);
			modes.add(m.name.toFirstLower);
			ENDFOR
			
			return new SystemConfiguration(modes, software, debianRelease, releaseDate);
		}
}
	'''
	}
	
	def getReleaseDate(System s) { s.releaseDate }
	def getDistribution(System s) { s.distribution }
}
