import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;

public class Vulnerability implements Serializable{
	private static final long serialVersionUID = 715694482512382193L;
	
	private String cveId;
	private LocalDate publishDate;
	private LocalDate modifiedDate;

	private LocalDate resolvedDate;
	private double score;
	
	public Vulnerability(String publishDate, String cveId, double score) {
		this(cveId, LocalDate.parse( publishDate ), null, null, score);
	}
	
	public Vulnerability(String publishDate, String modifiedDate, String cveId, double score) {
		this(cveId, LocalDate.parse( publishDate ), LocalDate.parse( modifiedDate ), null, score);
	}

	public Vulnerability(String cveId, LocalDate publishDate, LocalDate modifiedDate, LocalDate resolvedDate, double score) {
		this.setCveId(cveId);
		this.setPublishDate(publishDate);
		this.setModifiedDate(modifiedDate);
		this.setResolvedDate(resolvedDate);
		this.setScore(score);
	}

	public String getCveId() {
		return cveId;
	}

	public void setCveId(String cveId) {
		this.cveId = cveId;
	}

	public double getScore() {
		return score;
	}

	public void setScore(double score) {
		this.score = score;
	}

	public LocalDate getPublishDate() {
		return publishDate;
	}

	public void setPublishDate(LocalDate publishDate) {
		this.publishDate = publishDate;
	}

	public LocalDate getResolvedDate() {
		return resolvedDate;
	}

	public void setResolvedDate(LocalDate resolvedDate) {
		this.resolvedDate = resolvedDate;
	}
	
	public void setResolvedDate(String resolvedDate) {
		this.resolvedDate = LocalDate.parse( resolvedDate );
	}
	
	public int getDaysForUpdate() {
		int days = 0;
		if(publishDate != null && resolvedDate != null) {
			days = Period.between(publishDate, resolvedDate).getDays();
		}
		return days;
	}
	
	public boolean isActive() {
		return (getResolvedDate() == null);
	}
	
	public boolean isResolved() {
		return !isActive();
	}
	
	public LocalDate getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(LocalDate modifiedDate) {
		this.modifiedDate = modifiedDate;
	}
	
	public void setModifiedDate(String modifiedDate) {
		this.modifiedDate = LocalDate.parse( modifiedDate );
	}
	
}
