# 3D Laplace Solver

This provides a test for the fully 3D implementation of the Laplace
solver (which includes y-derivatives). It works with a user-provided
gridfile. It should be placed at `data/grid.nc`.

The test is generated as below:

1. Some initial data (random mixed fourier-modes, varying in x and z)
   is created at isolated poloidal (y) points - outboard midplane,
   inboard midplane and the nearest point to each divertor target - so
   every topological region has some non-zero data in it
2. The initial state is evolved in time with a parallel diffusion
   operator to fill up the domain
3. The field is evolved for a short time with diffusion in the x- and
   z-directions to smooth out any very small-scale structures that
   might have been generated by the magnetic shear
4. The result of the above process is saved into the grid file, and
   loaded from there into 'rhs' when test-laplace3d is run

All this is done by invoking the `run` script.

Note that the way BOUT++ handles the topology means that some grid
files may need at least 12 processes to run (the `run` script is set
up to use 12). It still manages to run OK on a 4-core desktop. It is
recommended to use an optimized build to generate the initial data.

The plotcheck.py script may be used to plot the function, original rhs,
recalculated rhs and error at a certain y-index, in order to search for any
problems. The first argument is the data directory, and the second is the
y-index to plot. For example::

    $ ./plotcheck.py data 8
