# Description
Code each issue in the mastodon and diapsora folders. Follow the procedure below for each issue.

# Notes
* None of the codes are mutually exclusive. An utterance could be coded with `OPT`, `RID`, and `RAT` if it satisifies critera for each code.
* Normally, OPT, RID, and RAT codes are filled in with unique identifiers. Annotators only need to mark these codes with an 'X' instead (since tracking identifier numbers can be tedious and error-prone).

# Procedure  
1. Mark utterances with `OPT` if they propose an option. See the 'Discussion Model' sheet of the codebook for more information.
2. Mark utterances as `RID` if they identify a T&S risk, threat, or vulnerability. See the 'Discussion Model' sheet of the codebook for more information.
3. Mark all `RID` utterances with an additional `TS` code. The value should be one of the possible `TS` values. See the 'Discussion Model' sheet of the codebook for more information.
4. Mark utterances as `Chosen` if they are selected by engineers and the issue is marked closed. See the 'Discussion Model' sheet of the codebook for more information.
5. Mark utterances as `RAT` if they are a rationale for selecting a `Chosen` option.