
close all
clear all
restoredefaultpath
path = '/Users/tthomas/Documents/research/mars-canary/CANARY/';
addpath(genpath(path));

c1 = load('postsave_final_ext300'); %300
c2 = load('postsave_final_ext900'); %900
c3 = load('postsave_final_ext1400'); %1400

param_labels  = {'f_{og}','f_{sp}','f_{pC}','f_{pN}','z/T','X^{m}_{CO2}','euv_{pl}','lym_{pl}','f_{ce}'};

c1_params = c1.out.sols_3sigma_params;
c1_pinits = [c1.out.sols_3sigma_pinits(:,1),c1.out.sols_3sigma_pinits(:,2),c1.out.sols_3sigma_pinits(:,3)+c1.out.sols_3sigma_pinits(:,4)+c1.out.sols_3sigma_pinits(:,5)];
c1_results = [c1.out.sols_3sigma_results(:,1),c1.out.sols_3sigma_results(:,2),c1.out.sols_3sigma_results(:,3)+c1.out.sols_3sigma_results(:,4)+c1.out.sols_3sigma_results(:,5),c1.out.sols_3sigma_results(:,6),c1.out.sols_3sigma_results(:,7),c1.out.sols_3sigma_results(:,8),c1.out.sols_3sigma_results(:,9)];
c1_results(:,4:7) = (c1_results(:,4:7) - 1)*1000;

c2_params = c2.out.sols_3sigma_params;
c2_pinits = [c2.out.sols_3sigma_pinits(:,1),c2.out.sols_3sigma_pinits(:,2),c2.out.sols_3sigma_pinits(:,3)+c2.out.sols_3sigma_pinits(:,4)+c2.out.sols_3sigma_pinits(:,5)];
c2_results = [c2.out.sols_3sigma_results(:,1),c2.out.sols_3sigma_results(:,2),c2.out.sols_3sigma_results(:,3)+c2.out.sols_3sigma_results(:,4)+c2.out.sols_3sigma_results(:,5),c2.out.sols_3sigma_results(:,6),c2.out.sols_3sigma_results(:,7),c2.out.sols_3sigma_results(:,8),c2.out.sols_3sigma_results(:,9)];
c2_results(:,4:7) = (c2_results(:,4:7) - 1)*1000;

c3_params = c3.out.sols_3sigma_params;
c3_pinits = [c3.out.sols_3sigma_pinits(:,1),c3.out.sols_3sigma_pinits(:,2),c3.out.sols_3sigma_pinits(:,3)+c3.out.sols_3sigma_pinits(:,4)+c3.out.sols_3sigma_pinits(:,5)];
c3_results = [c3.out.sols_3sigma_results(:,1),c3.out.sols_3sigma_results(:,2),c3.out.sols_3sigma_results(:,3)+c3.out.sols_3sigma_results(:,4)+c3.out.sols_3sigma_results(:,5),c3.out.sols_3sigma_results(:,6),c3.out.sols_3sigma_results(:,7),c3.out.sols_3sigma_results(:,8),c3.out.sols_3sigma_results(:,9)];
c3_results(:,4:7) = (c3_results(:,4:7) - 1)*1000;

% Statistics...

%Get median values for the three peaks
idx = 1;
carbon_medians = [median(c1_pinits(:,idx)), median(c2_pinits(:,idx)), median(c3_pinits(:,idx))];
carbon_CI = [conf(c1_pinits(:,idx),0.025,0.975), conf(c2_pinits(:,idx),0.025,0.975), conf(c3_pinits(:,idx),0.025,0.975)];

idx = 2;
nitrogen_medians = [median(c1_pinits(:,idx)), median(c2_pinits(:,idx)), median(c3_pinits(:,idx))];
nitrogen_CI = [conf(c1_pinits(:,idx),0.025,0.975), conf(c2_pinits(:,idx),0.025,0.975), conf(c3_pinits(:,idx),0.025,0.975)];

idx = 3;
argon_medians = [median(c1_pinits(:,idx)), median(c2_pinits(:,idx)), median(c3_pinits(:,idx))];
argon_CI = [conf(c1_pinits(:,idx),0.025,0.975), conf(c2_pinits(:,idx),0.025,0.975), conf(c3_pinits(:,idx),0.025,0.975)];

yellow = [0.9290 0.6940 0.1250];
green  = [0.4660 0.6740 0.1880];
blue   = [0 0.4470 0.7410];
purple = [199 111 214]/255;
orange = [0.8500 0.3250 0.0980];
dgreen = [0 0.4 0];
dblue = [0 0 0.7410];
dpurple = [135 67 148]/255;

blue1 = [158, 194, 255]/255;
blue2 = [68, 117, 201]/255;
blue3 = [7, 59, 148]/255;

font = 30;
ticks_font_size = 20;

fig_length = 1800;
fig_scale  = .45;
fig_lw = 3;

subplot = @(m,n,p) subtightplot (m, n, p, [0.09 0.04], [0.1 0.01], [0.03 0.01]);

dim1 = 3;
dim2 = 4;

f1 = figure('Renderer', 'painters', 'Position', [10 10 fig_length fig_length*fig_scale]);

letterloc1 = 0.025;
letterloc2 = 0.9;
letter_fs = 34;
letter_w = 'bold';

subplot(dim1,dim2,1);
hold on
histogram(c1_pinits(:,1), 'BinEdges', 0:20:2000, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_pinits(:,1), 'BinEdges', 0:20:2000, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_pinits(:,1), 'BinEdges', 0:20:2000, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[0,2000]);
xlabel('pCO_{2} at 3.8 Ga (mbar)','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
text(letterloc1,letterloc2,'a','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on
hold off

subplot(dim1,dim2,2);
hold on
histogram(c1_pinits(:,2), 'BinEdges', 0:500:20000, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_pinits(:,2), 'BinEdges', 0:500:20000, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_pinits(:,2), 'BinEdges', 0:500:20000, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[0,20000]);
xlabel('pN_{2} at 3.8 Ga (mbar)','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
text(letterloc1,letterloc2,'b','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on
hold off

subplot(dim1,dim2,3);
hold on
histogram(c1_pinits(:,3), 'BinEdges', 0:0.02:2, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_pinits(:,3), 'BinEdges', 0:0.02:2, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_pinits(:,3), 'BinEdges', 0:0.02:2, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[0,2]);
xlabel('pAr at 3.8 Ga (mbar)','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
text(0.1,0.93,'c','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on
hold off

n = 9;
subplot(dim1,dim2,4);
hold on
histogram(c1_params(:,n), 'BinEdges', 0:0.02:1, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_params(:,n), 'BinEdges', 0:0.02:1, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_params(:,n), 'BinEdges', 0:0.02:1, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[0,1]);
xlabel('f_{ce}','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
text(0.017,letterloc2,'d','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on
hold off

n = 1;
subplot(dim1,dim2,n+4);
hold on
histogram(c1_params(:,n), 'BinEdges', 0:0.75:22, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_params(:,n), 'BinEdges', 0:0.75:22, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_params(:,n), 'BinEdges', 0:0.75:22, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[0,20]);
xlabel('f_{og}','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
text(letterloc1,letterloc2,'e','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on
hold off

n = 2;
subplot(dim1,dim2,n+4);
hold on
histogram(c1_params(:,n), 'BinEdges', 0.01:0.75:20.26, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_params(:,n), 'BinEdges', 0.01:0.75:20.26, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_params(:,n), 'BinEdges', 0.01:0.75:20.26, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[0,20]);
xlabel('f_{sp}','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
text(letterloc1,letterloc2,'f','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on
hold off

n = 3;
subplot(dim1,dim2,n+4);
hold on
histogram(c1_params(:,n), 'BinEdges', 0.01:0.75:20.26, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_params(:,n), 'BinEdges', 0.01:0.75:20.26, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_params(:,n), 'BinEdges', 0.01:0.75:20.26, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[0,20]);
xlabel('f_{pC}','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
text(letterloc1,letterloc2,'g','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on
hold off

n = 4;
subplot(dim1,dim2,n+4);
hold on
histogram(c1_params(:,n), 'BinEdges', 0.01:0.75:20.26, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_params(:,n), 'BinEdges', 0.01:0.75:20.26, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_params(:,n), 'BinEdges', 0.01:0.75:20.26, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[0,20]);
xlabel('f_{pN}','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
text(letterloc1,letterloc2,'h','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on
hold off

n = 5;
subplot(dim1,dim2,n+4);
hold on
histogram(c1_params(:,n), 'BinEdges', 0.2:0.01:5, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_params(:,n), 'BinEdges', 0.2:0.01:5, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_params(:,n), 'BinEdges', 0.2:0.01:5, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[0.2,0.5]);
xlabel('\Delta z/T (km K^{-1})','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
text(0.2,letterloc2,'i','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on
hold off

n = 6;
subplot(dim1,dim2,n+4);
hold on
histogram(c1_params(:,n)*10^6, 'BinEdges', 5:5:1000, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_params(:,n)*10^6, 'BinEdges', 5:5:1000, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_params(:,n)*10^6, 'BinEdges', 5:5:1000, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[5,1000]);
xlabel('X^C_{mag} (ppm)','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
text(0.04,letterloc2,'j','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on
hold off

n = 7;
subplot(dim1,dim2,n+4);
hold on
histogram(c1_params(:,n), 'BinEdges', 0.5:0.1:3, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_params(:,n), 'BinEdges', 0.5:0.1:3, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_params(:,n), 'BinEdges', 0.5:0.1:3, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[0.5,3]);
xlabel('a_{EUV}','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
text(letterloc1,letterloc2,'k','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on
hold off

n = 8;
subplot(dim1,dim2,n+4);
hold on
histogram(c1_params(:,n), 'BinEdges', 0.5:0.1:3, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue1, 'LineWidth', fig_lw);
histogram(c2_params(:,n), 'BinEdges', 0.5:0.1:3, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue2, 'LineWidth', fig_lw);
histogram(c3_params(:,n), 'BinEdges', 0.5:0.1:3, 'Normalization','Probability','DisplayStyle','stairs', 'EdgeColor', blue3, 'LineWidth', fig_lw);
set(gca,'Xlim',[0.5,3]);
xlabel('a_{LYM}','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
box on
text(letterloc1,letterloc2,'l','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w)
hold off

legend({'C-DEP = 300 mbar', 'C-DEP = 900 mbar', 'C-DEP = 1400 mbar'},'FontSize', 20);

