

%Clear everything
close all
clear all

%Set Path
restoredefaultpath
canary_path = '/Users/tthomas/Documents/research/mars-canary/CANARY/'; %Path to the CANARY directory
addpath(genpath(canary_path)); %Add all subdirectories to path

l1 = load('base300_3sigma_100runs'); %300
l2 = load('base900_3sigma_100runs'); %900
l3 = load('base1400_3sigma_100runs'); %1400

% l1 = load('ext900_3sigma_100runs'); %300
% l2 = load('ext900_3sigma_100runs'); %900
% l3 = load('ext900_3sigma_100runs'); %1400

c1 = l1.single_out_rec;
c2 = l2.single_out_rec;
c3 = l3.single_out_rec;

subplot = @(m,n,p) subtightplot (m, n, p, [0.075 0.055], [0.1 0.03], [0.05 0.01]);
fg = figure('Renderer', 'painters', 'Position', [10 10 1800 800]);

plot1_color = [68, 117, 201, 70]/255;
plot2_color = [144, 230, 133, 70]/255;
plot3_color = [161, 63, 63, 70]/255;

plot1_color_o = [68, 117, 201]/255;
plot2_color_o = [144, 230, 133]/255;
plot3_color_o = [161, 63, 63]/255;

letterloc1 = 0.04;
letterloc2 = 0.93;
letter_fs = 34;
letter_w = 'bold';

line_width = 2;
font = 30;
ticks_font_size = 18;
legend_font_size = 18;

subplot(2,4,1)
semilogy((4500 - c1{1}.times.t)/1000,c1{1}.pressures.c,'LineWidth', line_width, 'Color', plot1_color_o);
hold on
semilogy((4500 - c2{1}.times.t)/1000,c2{1}.pressures.c,'LineWidth', line_width, 'Color', plot2_color_o);
semilogy((4500 - c3{1}.times.t)/1000,c3{1}.pressures.c,'LineWidth', line_width, 'Color', plot3_color_o);
for i = 2:1:length(c1)
    semilogy((4500 - c1{i}.times.t)/1000,c1{i}.pressures.c,'LineWidth', line_width, 'Color', plot1_color);
    semilogy((4500 - c2{i}.times.t)/1000,c2{i}.pressures.c,'LineWidth', line_width, 'Color', plot2_color);
    semilogy((4500 - c3{i}.times.t)/1000,c3{i}.pressures.c,'LineWidth', line_width, 'Color', plot3_color);
end
ylabel('pCO_{2} (mbar)','FontSize',font);
set(gca,'Xdir','reverse');
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
set(gca,'xtick',[0,.5:0.5:3.5,3.8],'Xlim',[0,3.8]);
set(gca,'Ylim',[10^0,10^4]);
set(gca,'Layer','top')
f=get(gca,'Children');
legend([f(300),f(299),f(298)],'C-DEP = 300 mbar','C-DEP = 900 mbar','C-DEP = 1400 mbar');
text(letterloc1,letterloc2,'a','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on

subplot(2,4,2)
semilogy((4500 - c1{1}.times.t)/1000,c1{1}.pressures.n,'LineWidth', line_width, 'Color', plot1_color_o);
hold on
semilogy((4500 - c2{1}.times.t)/1000,c2{1}.pressures.n,'LineWidth', line_width, 'Color', plot2_color_o);
semilogy((4500 - c3{1}.times.t)/1000,c3{1}.pressures.n,'LineWidth', line_width, 'Color', plot3_color_o);
for i = 2:1:length(c1)
    semilogy((4500 - c1{i}.times.t)/1000,c1{i}.pressures.n,'LineWidth', line_width, 'Color', plot1_color);
    semilogy((4500 - c2{i}.times.t)/1000,c2{i}.pressures.n,'LineWidth', line_width, 'Color', plot2_color);
    semilogy((4500 - c3{i}.times.t)/1000,c3{i}.pressures.n,'LineWidth', line_width, 'Color', plot3_color);
end
ylabel('pN_{2} (mbar)','FontSize',font);
set(gca,'Xdir','reverse');
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
set(gca,'xtick',[0,.5:0.5:3.5,3.8],'Xlim',[0,3.8]);
set(gca,'Layer','top')
text(0.1,letterloc2,'b','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on

subplot(2,4,3)
semilogy((4500 - c1{1}.times.t)/1000,c1{1}.pressures.ar40,'LineWidth', line_width, 'Color', plot1_color_o);
hold on
semilogy((4500 - c2{1}.times.t)/1000,c2{1}.pressures.ar40,'LineWidth', line_width, 'Color', plot2_color_o);
semilogy((4500 - c3{1}.times.t)/1000,c3{1}.pressures.ar40,'LineWidth', line_width, 'Color', plot3_color_o);
for i = 2:1:length(c1)
    semilogy((4500 - c1{i}.times.t)/1000,c1{i}.pressures.ar40,'LineWidth', line_width, 'Color', plot1_color);
    semilogy((4500 - c2{i}.times.t)/1000,c2{i}.pressures.ar40,'LineWidth', line_width, 'Color', plot2_color);
    semilogy((4500 - c3{i}.times.t)/1000,c3{i}.pressures.ar40,'LineWidth', line_width, 'Color', plot3_color);
end
ylabel('pAr (mbar)','FontSize',font);
set(gca,'Xdir','reverse');
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
set(gca,'xtick',[0,.5:0.5:3.5,3.8],'Xlim',[0,3.8]);
set(gca,'ytick',[.1:0.1:1],'Ylim',[10^-1,10^0]);
set(gca,'Layer','top')
text(letterloc1,letterloc2,'c','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on

subplot(2,4,4)
plot((4500 - c1{1}.times.t)/1000,c1{1}.collapse,'LineWidth', line_width, 'Color', plot1_color_o);
hold on
plot((4500 - c2{1}.times.t)/1000,c2{1}.collapse,'LineWidth', line_width, 'Color', plot2_color_o);
plot((4500 - c3{1}.times.t)/1000,c3{1}.collapse,'LineWidth', line_width, 'Color', plot3_color_o);
for i = 2:1:length(c1)
    plot((4500 - c1{i}.times.t)/1000,c1{i}.collapse,'LineWidth', line_width, 'Color', plot1_color);
    plot((4500 - c2{i}.times.t)/1000,c2{i}.collapse,'LineWidth', line_width, 'Color', plot2_color);
    plot((4500 - c3{i}.times.t)/1000,c3{i}.collapse,'LineWidth', line_width, 'Color', plot3_color);
end
ylabel('f_{col}','FontSize',font);
set(gca,'Xdir','reverse');
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
set(gca,'xtick',[0,.5:0.5:3.5,3.8],'Xlim',[0,3.8]);
set(gca,'Ylim',[0,0.5]);
set(gca,'Layer','top')
text(letterloc1,letterloc2,'d','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on

subplot(2,4,5)
plot((4500 - c1{1}.times.t)/1000,(c1{1}.deltas.c - 1)*1000,'LineWidth', line_width, 'Color', plot1_color_o);
hold on
plot((4500 - c2{1}.times.t)/1000,(c2{1}.deltas.c - 1)*1000,'LineWidth', line_width, 'Color', plot2_color_o);
plot((4500 - c3{1}.times.t)/1000,(c3{1}.deltas.c - 1)*1000,'LineWidth', line_width, 'Color', plot3_color_o);
for i = 2:1:length(c1)
    plot((4500 - c1{i}.times.t)/1000,(c1{i}.deltas.c - 1)*1000,'LineWidth', line_width, 'Color', plot1_color);
    plot((4500 - c2{i}.times.t)/1000,(c2{i}.deltas.c - 1)*1000,'LineWidth', line_width, 'Color', plot2_color);
    plot((4500 - c3{i}.times.t)/1000,(c3{i}.deltas.c - 1)*1000,'LineWidth', line_width, 'Color', plot3_color);
end
ylabel('\delta^{13}C (per mil)','FontSize',font);
xlabel('Time before bresent (Gya)');
set(gca,'Xdir','reverse');
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
set(gca,'xtick',[0,.5:0.5:3.5,3.8],'Xlim',[0,3.8]);
set(gca,'Layer','top')
text(letterloc1,letterloc2,'e','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on

subplot(2,4,6)
plot((4500 - c1{1}.times.t)/1000,(c1{1}.deltas.n - 1)*1000,'LineWidth', line_width, 'Color', plot1_color_o);
hold on
plot((4500 - c2{1}.times.t)/1000,(c2{1}.deltas.n - 1)*1000,'LineWidth', line_width, 'Color', plot2_color_o);
plot((4500 - c3{1}.times.t)/1000,(c3{1}.deltas.n - 1)*1000,'LineWidth', line_width, 'Color', plot3_color_o);
for i = 2:1:length(c1)
    plot((4500 - c1{i}.times.t)/1000,(c1{i}.deltas.n - 1)*1000,'LineWidth', line_width, 'Color', plot1_color);
    plot((4500 - c2{i}.times.t)/1000,(c2{i}.deltas.n - 1)*1000,'LineWidth', line_width, 'Color', plot2_color);
    plot((4500 - c3{i}.times.t)/1000,(c3{i}.deltas.n - 1)*1000,'LineWidth', line_width, 'Color', plot3_color);
end
ylabel('\delta^{15}N (per mil)','FontSize',font);
xlabel('Time before bresent (Gya)');
set(gca,'Xdir','reverse');
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
set(gca,'xtick',[0,.5:0.5:3.5,3.8],'Xlim',[0,3.8]);
set(gca,'Layer','top')
text(letterloc1,letterloc2,'f','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on

subplot(2,4,7)
plot((4500 - c1{1}.times.t)/1000,(c1{1}.deltas.ar38 - 1)*1000,'LineWidth', line_width, 'Color', plot1_color_o);
hold on
plot((4500 - c2{1}.times.t)/1000,(c2{1}.deltas.ar38 - 1)*1000,'LineWidth', line_width, 'Color', plot2_color_o);
plot((4500 - c3{1}.times.t)/1000,(c3{1}.deltas.ar38 - 1)*1000,'LineWidth', line_width, 'Color', plot3_color_o);
for i = 2:1:length(c1)
    plot((4500 - c1{i}.times.t)/1000,(c1{i}.deltas.ar38 - 1)*1000,'LineWidth', line_width, 'Color', plot1_color);
    plot((4500 - c2{i}.times.t)/1000,(c2{i}.deltas.ar38 - 1)*1000,'LineWidth', line_width, 'Color', plot2_color);
    plot((4500 - c3{i}.times.t)/1000,(c3{i}.deltas.ar38 - 1)*1000,'LineWidth', line_width, 'Color', plot3_color);
end
ylabel('\delta^{38}Ar (per mil)','FontSize',font);
xlabel('Time before bresent (Gya)');
set(gca,'Xdir','reverse');
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
set(gca,'xtick',[0,.5:0.5:3.5,3.8],'Xlim',[0,3.8]);
set(gca,'Layer','top')
text(letterloc1,letterloc2,'g','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on

subplot(2,4,8)
plot((4500 - c1{1}.times.t)/1000,(c1{1}.deltas.ar40 - 1)*1000,'LineWidth', line_width, 'Color', plot1_color_o);
hold on
plot((4500 - c2{1}.times.t)/1000,(c2{1}.deltas.ar40 - 1)*1000,'LineWidth', line_width, 'Color', plot2_color_o);
plot((4500 - c3{1}.times.t)/1000,(c3{1}.deltas.ar40 - 1)*1000,'LineWidth', line_width, 'Color', plot3_color_o);
for i = 2:1:length(c1)
    plot((4500 - c1{i}.times.t)/1000,(c1{i}.deltas.ar40 - 1)*1000,'LineWidth', line_width, 'Color', plot1_color);
    plot((4500 - c2{i}.times.t)/1000,(c2{i}.deltas.ar40 - 1)*1000,'LineWidth', line_width, 'Color', plot2_color);
    plot((4500 - c3{i}.times.t)/1000,(c3{i}.deltas.ar40 - 1)*1000,'LineWidth', line_width, 'Color', plot3_color);
end
ylabel('\delta^{40}Ar (per mil)','FontSize',font);
xlabel('Time before bresent (Gya)');
set(gca,'Xdir','reverse');
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
set(gca,'xtick',[0,.5:0.5:3.5,3.8],'Xlim',[0,3.8]);
set(gca,'Layer','top')
text(letterloc1,letterloc2,'h','Units','normalized','FontSize',letter_fs,'FontWeight',letter_w);
box on

