
close all
clear all
restoredefaultpath
path = '/Users/tthomas/Documents/research/mars-canary/CANARY/';
addpath(genpath(path));

c1 = load('postsave_final_base300'); %300
c2 = load('postsave_final_base600'); %600
c3 = load('postsave_final_base900'); %900
c4 = load('postsave_final_base1200'); %1200
c5 = load('postsave_final_base1400'); %1400

param_labels  = {'f_{og}','f_{sp}','f_{pC}','f_{pN}','z/T','X^{m}_{CO2}','euv_{pl}','lym_{pl}','f_{ce}'};

c1_params = c1.out.sols_3sigma_params;
c1_pinits = [c1.out.sols_3sigma_pinits(:,1),c1.out.sols_3sigma_pinits(:,2),c1.out.sols_3sigma_pinits(:,3)+c1.out.sols_3sigma_pinits(:,4)+c1.out.sols_3sigma_pinits(:,5)];
c1_results = [c1.out.sols_3sigma_results(:,1),c1.out.sols_3sigma_results(:,2),c1.out.sols_3sigma_results(:,3)+c1.out.sols_3sigma_results(:,4)+c1.out.sols_3sigma_results(:,5),c1.out.sols_3sigma_results(:,6),c1.out.sols_3sigma_results(:,7),c1.out.sols_3sigma_results(:,8),c1.out.sols_3sigma_results(:,9)];
c1_results(:,4:7) = (c1_results(:,4:7) - 1)*1000;

c2_params = c2.out.sols_3sigma_params;
c2_pinits = [c2.out.sols_3sigma_pinits(:,1),c2.out.sols_3sigma_pinits(:,2),c2.out.sols_3sigma_pinits(:,3)+c2.out.sols_3sigma_pinits(:,4)+c2.out.sols_3sigma_pinits(:,5)];
c2_results = [c2.out.sols_3sigma_results(:,1),c2.out.sols_3sigma_results(:,2),c2.out.sols_3sigma_results(:,3)+c2.out.sols_3sigma_results(:,4)+c2.out.sols_3sigma_results(:,5),c2.out.sols_3sigma_results(:,6),c2.out.sols_3sigma_results(:,7),c2.out.sols_3sigma_results(:,8),c2.out.sols_3sigma_results(:,9)];
c2_results(:,4:7) = (c2_results(:,4:7) - 1)*1000;

c3_params = c3.out.sols_3sigma_params;
c3_pinits = [c3.out.sols_3sigma_pinits(:,1),c3.out.sols_3sigma_pinits(:,2),c3.out.sols_3sigma_pinits(:,3)+c3.out.sols_3sigma_pinits(:,4)+c3.out.sols_3sigma_pinits(:,5)];
c3_results = [c3.out.sols_3sigma_results(:,1),c3.out.sols_3sigma_results(:,2),c3.out.sols_3sigma_results(:,3)+c3.out.sols_3sigma_results(:,4)+c3.out.sols_3sigma_results(:,5),c3.out.sols_3sigma_results(:,6),c3.out.sols_3sigma_results(:,7),c3.out.sols_3sigma_results(:,8),c3.out.sols_3sigma_results(:,9)];
c3_results(:,4:7) = (c3_results(:,4:7) - 1)*1000;

c4_params = c4.out.sols_3sigma_params;
c4_pinits = [c4.out.sols_3sigma_pinits(:,1),c4.out.sols_3sigma_pinits(:,2),c4.out.sols_3sigma_pinits(:,3)+c4.out.sols_3sigma_pinits(:,4)+c4.out.sols_3sigma_pinits(:,5)];
c4_results = [c4.out.sols_3sigma_results(:,1),c4.out.sols_3sigma_results(:,2),c4.out.sols_3sigma_results(:,3)+c4.out.sols_3sigma_results(:,4)+c4.out.sols_3sigma_results(:,5),c4.out.sols_3sigma_results(:,6),c4.out.sols_3sigma_results(:,7),c4.out.sols_3sigma_results(:,8),c4.out.sols_3sigma_results(:,9)];
c4_results(:,4:7) = (c4_results(:,4:7) - 1)*1000;

c5_params = c5.out.sols_3sigma_params;
c5_pinits = [c5.out.sols_3sigma_pinits(:,1),c5.out.sols_3sigma_pinits(:,2),c5.out.sols_3sigma_pinits(:,3)+c5.out.sols_3sigma_pinits(:,4)+c5.out.sols_3sigma_pinits(:,5)];
c5_results = [c5.out.sols_3sigma_results(:,1),c5.out.sols_3sigma_results(:,2),c5.out.sols_3sigma_results(:,3)+c5.out.sols_3sigma_results(:,4)+c5.out.sols_3sigma_results(:,5),c5.out.sols_3sigma_results(:,6),c5.out.sols_3sigma_results(:,7),c5.out.sols_3sigma_results(:,8),c5.out.sols_3sigma_results(:,9)];
c5_results(:,4:7) = (c5_results(:,4:7) - 1)*1000;

c_tots = [300,600,900,1200,1400];

%Get medians and actual confidence intervals
idx = 1;
carbon_medians = [median(c1_pinits(:,idx)), median(c2_pinits(:,idx)), median(c3_pinits(:,idx)), median(c4_pinits(:,idx)), median(c5_pinits(:,idx))];
carbon_CI50 = [conf(c1_pinits(:,idx),0.25,0.75), conf(c2_pinits(:,idx),0.25,0.75), conf(c3_pinits(:,idx),0.25,0.75), conf(c4_pinits(:,idx),0.25,0.75), conf(c5_pinits(:,idx),0.25,0.75)];
carbon_CI95 = [conf(c1_pinits(:,idx),0.025,0.975), conf(c2_pinits(:,idx),0.025,0.975), conf(c3_pinits(:,idx),0.025,0.975), conf(c4_pinits(:,idx),0.025,0.975), conf(c5_pinits(:,idx),0.025,0.975)];
lowc_CI50 = [carbon_CI50(1),carbon_CI50(3),carbon_CI50(5),carbon_CI50(7),carbon_CI50(9)];
highc_CI50 = [carbon_CI50(2),carbon_CI50(4),carbon_CI50(6),carbon_CI50(8),carbon_CI50(10)];
lowc_CI95 = [carbon_CI95(1),carbon_CI95(3),carbon_CI95(5),carbon_CI95(7),carbon_CI95(9)];
highc_CI95 = [carbon_CI95(2),carbon_CI95(4),carbon_CI95(6),carbon_CI95(8),carbon_CI95(10)];

idx = 2;
nitrogen_medians = [median(c1_pinits(:,idx)), median(c2_pinits(:,idx)), median(c3_pinits(:,idx)), median(c4_pinits(:,idx)), median(c5_pinits(:,idx))];
nitrogen_CI50 = [conf(c1_pinits(:,idx),0.25,0.75), conf(c2_pinits(:,idx),0.25,0.75), conf(c3_pinits(:,idx),0.25,0.75), conf(c4_pinits(:,idx),0.25,0.75), conf(c5_pinits(:,idx),0.25,0.75)];
nitrogen_CI95 = [conf(c1_pinits(:,idx),0.025,0.975), conf(c2_pinits(:,idx),0.025,0.975), conf(c3_pinits(:,idx),0.025,0.975), conf(c4_pinits(:,idx),0.025,0.975), conf(c5_pinits(:,idx),0.025,0.975)];
lown_CI50 = [nitrogen_CI50(1),nitrogen_CI50(3),nitrogen_CI50(5),nitrogen_CI50(7),nitrogen_CI50(9)];
highn_CI50 = [nitrogen_CI50(2),nitrogen_CI50(4),nitrogen_CI50(6),nitrogen_CI50(8),nitrogen_CI50(10)];
lown_CI95 = [nitrogen_CI95(1),nitrogen_CI95(3),nitrogen_CI95(5),nitrogen_CI95(7),nitrogen_CI95(9)];
highn_CI95 = [nitrogen_CI95(2),nitrogen_CI95(4),nitrogen_CI95(6),nitrogen_CI95(8),nitrogen_CI95(10)];

idx = 3;
argon_medians = [median(c1_pinits(:,idx)), median(c2_pinits(:,idx)), median(c3_pinits(:,idx)), median(c4_pinits(:,idx)), median(c5_pinits(:,idx))];
argon_CI50 = [conf(c1_pinits(:,idx),0.25,0.75), conf(c2_pinits(:,idx),0.25,0.75), conf(c3_pinits(:,idx),0.25,0.75), conf(c4_pinits(:,idx),0.25,0.75), conf(c5_pinits(:,idx),0.25,0.75)];
argon_CI95 = [conf(c1_pinits(:,idx),0.025,0.975), conf(c2_pinits(:,idx),0.025,0.975), conf(c3_pinits(:,idx),0.025,0.975), conf(c4_pinits(:,idx),0.025,0.975), conf(c5_pinits(:,idx),0.025,0.975)];
lowa_CI50 = [argon_CI50(1),argon_CI50(3),argon_CI50(5),argon_CI50(7),argon_CI50(9)];
higha_CI50 = [argon_CI50(2),argon_CI50(4),argon_CI50(6),argon_CI50(8),argon_CI50(10)];
lowa_CI95 = [argon_CI95(1),argon_CI95(3),argon_CI95(5),argon_CI95(7),argon_CI95(9)];
higha_CI95 = [argon_CI95(2),argon_CI95(4),argon_CI95(6),argon_CI95(8),argon_CI95(10)];

%Total pressure
c1_sum = sum(c1_pinits,2);
c2_sum = sum(c2_pinits,2);
c3_sum = sum(c3_pinits,2);
c4_sum = sum(c4_pinits,2);
c5_sum = sum(c5_pinits,2);
total_medians = [median(c1_sum),median(c2_sum),median(c3_sum),median(c4_sum),median(c5_sum)];
total_CI50 = [conf(c1_sum,0.25,0.75),conf(c2_sum,0.25,0.75),conf(c3_sum,0.25,0.75),conf(c4_sum,0.25,0.75),conf(c5_sum,0.25,0.75),];
total_CI95 = [conf(c1_sum,0.025,0.975), conf(c2_sum,0.025,0.975), conf(c3_sum,0.025,0.975), conf(c4_sum,0.025,0.975), conf(c5_sum,0.025,0.975)];
lowt_CI50 = [total_CI50(1),total_CI50(3),total_CI50(5),total_CI50(7),total_CI50(9)];
hight_CI50 = [total_CI50(2),total_CI50(4),total_CI50(6),total_CI50(8),total_CI50(10)];
lowt_CI95 = [total_CI95(1),total_CI95(3),total_CI95(5),total_CI95(7),total_CI95(9)];
hight_CI95 = [total_CI95(2),total_CI95(4),total_CI95(6),total_CI95(8),total_CI95(10)];


yellow = [0.9290 0.6940 0.1250];
green  = [0.4660 0.6740 0.1880];
blue   = [0 0.4470 0.7410];
purple = [199 111 214]/255;
orange = [0.8500 0.3250 0.0980];
dgreen = [0 0.4 0];
dblue = [0 0 0.7410];
dpurple = [135 67 148]/255;

blue0 = [203, 221, 247]/255;
blue1 = [158, 194, 255]/255;
blue2 = [68, 117, 201]/255;
blue3 = [7, 59, 148]/255;

font = 30;
ticks_font_size = 20;

fig_length = 1800;
fig_scale  = .45;

subplot = @(m,n,p) subtightplot (m, n, p, [0.05 0.06], [0.1 0.01], [0.1 0.01]);

f1 = figure('Renderer', 'painters', 'Position', [10 10 fig_length fig_length*fig_scale]);

lw = 3;
subplot(2,2,1);
hold on
patch([c_tots fliplr(c_tots)], [lowc_CI95 fliplr(highc_CI95)], blue0, 'EdgeColor', blue0);
patch([c_tots fliplr(c_tots)], [lowc_CI50 fliplr(highc_CI50)], blue1, 'EdgeColor', blue1);
plot(c_tots,carbon_medians,'-ok','Color',blue3,'MarkerSize',7,'MarkerFaceColor',blue3,'LineWidth',lw);
set(gca,'Xlim',[285,1415]);
%xlabel('C_{3Ga} (mbar)','FontSize',font);
ylabel('pCO_{2} at 3.8 Ga (mbar)','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
xticks([300,600,900,1200,1400]);
%xticklabels({})
box on
hold off

subplot(2,2,2);
hold on
patch([c_tots fliplr(c_tots)], [lown_CI95 fliplr(highn_CI95)], blue0, 'EdgeColor', blue0);
patch([c_tots fliplr(c_tots)], [lown_CI50 fliplr(highn_CI50)], blue1, 'EdgeColor', blue1);
plot(c_tots,nitrogen_medians,'-ok','Color',blue3,'MarkerSize',7,'MarkerFaceColor',blue3,'LineWidth',lw);
set(gca,'Xlim',[285,1415]);
%xlabel('C_{3Ga} (mbar)','FontSize',font);
ylabel('pN_{2} at 3.8 Ga (mbar)','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
xticks([300,600,900,1200,1400]);
%xticklabels({});
box on
hold off

subplot(2,2,3);
hold on
patch([c_tots fliplr(c_tots)], [lowa_CI95 fliplr(higha_CI95)], blue0, 'EdgeColor', blue0);
patch([c_tots fliplr(c_tots)], [lowa_CI50 fliplr(higha_CI50)], blue1, 'EdgeColor', blue1);
plot(c_tots,argon_medians,'-ok','Color',blue3,'MarkerSize',7,'MarkerFaceColor',blue3,'LineWidth',lw);
set(gca,'Xlim',[285,1415]);
xlabel('C-DEP (mbar)','FontSize',font);
ylabel('pAr at 3.8 Ga (mbar)','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
xticks([300,600,900,1200,1400]);
box on
hold off

subplot(2,2,4);
hold on
patch([c_tots fliplr(c_tots)], [lowt_CI95 fliplr(hight_CI95)], blue0, 'EdgeColor', blue0);
patch([c_tots fliplr(c_tots)], [lowt_CI50 fliplr(hight_CI50)], blue1, 'EdgeColor', blue1);
plot(c_tots,total_medians,'-ok','Color',blue3,'MarkerSize',7,'MarkerFaceColor',blue3,'LineWidth',lw);
set(gca,'Xlim',[285,1415]);
xlabel('C-DEP (mbar)','FontSize',font);
ylabel('pTOT at 3.8 Ga (mbar)','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
xticks([300,600,900,1200,1400]);
box on
hold off

AddLetters2Plots(f1)

