
clear all
close all

restoredefaultpath
path = '/Users/tthomas/Documents/research/mars-canary/CANARY/'; % path to canary directory
addpath(genpath(path));

load('energyDist_CO2pd.mat')

x = solar_max_ap.eVscale; %Energy spectrum [eV]

avg_prod12 = mean([solar_max_ap.y(:,1), solar_min_ap.y(:,1),solar_max_peri.y(:,1),solar_min_peri.y(:,1)],2);
avg_prod13 = mean([solar_max_ap.y(:,2), solar_min_ap.y(:,2),solar_max_peri.y(:,2),solar_min_peri.y(:,2)],2);

norm_prod12 = avg_prod12/trapz(x,avg_prod12);
norm_prod13 = avg_prod13/trapz(x,avg_prod13);

alt = 1000*mean([solar_max_ap.alt, solar_min_ap.alt,solar_max_peri.alt,solar_min_peri.alt]); %[Average escape altitude]
% ^^ multiply by 1000 to go from km to m

mars_r = 3.39E6; %[m]
mars_m = 6.39E23; %[kg]
exobase = alt+mars_r; %[m]

amu = 1.66e-27; %[kg]
G = 6.67E-11; %[SI]
ev = 6.24E18; %[J -> eV]

esc12 = ev*G*mars_m*12*amu/exobase; %escape energy [eV]
esc13 = ev*G*mars_m*13*amu/exobase;

energy_above_escape12 = x(find(x>esc12));
norm_prod_above_escape12 = norm_prod12(find(x>esc12));

energy_above_escape13 = x(find(x>esc13));
norm_prod_above_escape13 = norm_prod13(find(x>esc13));

fraction_of_escape12 = trapz(energy_above_escape12, norm_prod_above_escape12);
fraction_of_escape13 = trapz(energy_above_escape13, norm_prod_above_escape13);

fractionation_factor = fraction_of_escape13/fraction_of_escape12;

blue   = [0 0.4470 0.7410];
red    = [0.6350 0.0780 0.1840];
green  = [0.4660 0.6740 0.1880];
yellow = [0.9290 0.6940 0.1250];
orange = [0.8500 0.3250 0.0980];
black  = [0,0,0];

line_width = 2;
font = 30;
ticks_font_size = 18;
legend_font_size = 18;


figure
hold on  
set(gca,'YScale','log')
set(gca, 'Ylim',[1E-3,5E0])
plot(x, norm_prod12, 'Color', blue, 'LineWidth',line_width);
plot(x, norm_prod13, 'Color', red, 'LineWidth',line_width);
area(energy_above_escape12,norm_prod12(find(x>esc12)),'FaceColor', blue,'EdgeColor', blue, 'LineWidth',1);
area(energy_above_escape13,norm_prod13(find(x>esc13)),'FaceColor', red, 'EdgeColor', red, 'LineWidth',1);
line([esc12, esc12], [1E-15,1E15],'LineStyle','--', 'Color', blue, 'LineWidth',3);
line([esc13, esc13], [1E-15,1E15],'LineStyle','--', 'Color', red, 'LineWidth',3);
xlabel('Kinetic Energy of Carbon (eV)','FontSize',font);
ylabel('Normalized Production Rate','FontSize',font);
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
legend('Carbon 12','Carbon 13')
box on

% disp('Fraction of escaping C = (amount of escaping C)/(total production of C)');
% disp('Fractionation factor = (fraction of escaping 13C)/(fraction of escaping 12C)');




