
%Clear everything
close all
clear all

%Set Path
restoredefaultpath
canary_path = '/Users/tthomas/Documents/research/mars-canary/CANARY/'; %Path to the CANARY directory
addpath(genpath(canary_path)); %Add all subdirectories to path


%% Calculate emplacement rate profile

t_start = 700;
t_end = 4500;

og_totals = 10^6 * [74,168,148,150,81,20]; % ext:int = 8.5:1, from Greeley and Schneid 2001
chron_ivan = t_end - 1000*[3.86,3.74,3.65,3.46,1.45,0.387];
chron_hart = t_end - 1000*[3.85,3.57,3.40,3.00,0.880,0.235];

og_smooth = 0.2;

og_profile = smooth_profile(og_totals,chron_hart,t_start,t_end,og_smooth); %km^3/Myr
og_profile = grottify(og_profile,t_start);

og_profile2 = smooth_profile(og_totals,chron_ivan,t_start,t_end,og_smooth); %km^3/Myr
og_profile2 = grottify(og_profile2,t_start);

%% Calculate H2:H2O ratios in the melt

T = 1450; %K
P = 5*0.987; %atm

%Oxygen fugacities
fO2_QFM = 10^-8.5; %ramirez paper
fO2_IW = 10^(-(27215/T) + 6.570 + ((0.0552*(P-1))/T)); %equation from catling book
fO2_IWm1 = fO2_IW/10;
fO2_IWp1 = fO2_IW*10;


%R = ratio of H2 to H2O [molar]
%equation from ramirez and catling book
K1 = 1.8e-12; %atm
R_QFM = (K1/fO2_QFM)^0.5;
R_IW = (K1/fO2_IW)^0.5;
R_IWm1 = (K1/fO2_IWm1)^0.5;
R_IWp1 = (K1/fO2_IWp1)^0.5;

%% Get molar ratios according to mass balance of H2O

%Convert h2o concentrations by mass to by volume
h2o_conc_mole_high = (2000*10^-6)/18; % mol(h2o)/g magma
h2o_conc_mole_low = (100*10^-6)/18; % mol(h2o)/g magma

%Calculate high H2 estimate with IW-1 and 1000 ppmw h2o
h2_conc_mole_high = h2o_conc_mole_high/(1+(1/R_IWm1)); % mol(h2)/g magma
h2_conc_weight_high = 2*10^6*h2_conc_mole_high; % ppm g(h2)/g(magma)

%Calculate low H2 estimate with IW and 100 ppmw h2o
h2_conc_mole_low = h2o_conc_mole_low/(1+(1/R_IW)); % mol(h2)/g magma
h2_conc_weight_low = 2*10^6*h2_conc_mole_low; % ppm g(h2)/g(magma)

%% Get H2O outgassing rate

crust_density = 2900; %kg/m^3
av = 6.02e23; % avogadro's number
sa_mars = 1.4437e8 * (10^10); % surface area of Mars [cm2]

%og_profile starts with units km^3/Myr
og_profile(1,:) = og_profile(1,:)*10^9; %m^3/Myr
og_profile(1,:) = og_profile(1,:)*crust_density; %kg(total)/Myr
og_profile(1,:) = og_profile(1,:)*10^-6; %kg(total)/Yr
og_profile(1,:) = og_profile(1,:)*3.17e-8; %kg(total)/s
og_profile(1,:) = og_profile(1,:)/sa_mars; %kg(total)/cm2/s
og_profile(1,:) = og_profile(1,:)*1000; %g(total)/cm2/s

h2_rate_IWm1_2000ppm = og_profile;
h2_rate_IWm1_2000ppm(1,:) = h2_rate_IWm1_2000ppm(1,:)*h2_conc_mole_high*av; %molecules H2/cm2/s

h2_rate_IW_100ppm = og_profile;
h2_rate_IW_100ppm(1,:) = h2_rate_IW_100ppm(1,:)*h2_conc_mole_low*av; %molecules H2/cm2/s

%og_profile2 starts with units km^3/Myr
og_profile2(1,:) = og_profile2(1,:)*10^9; %m^3/Myr
og_profile2(1,:) = og_profile2(1,:)*crust_density; %kg(total)/Myr
og_profile2(1,:) = og_profile2(1,:)*10^-6; %kg(total)/Yr
og_profile2(1,:) = og_profile2(1,:)*3.17e-8; %kg(total)/s
og_profile2(1,:) = og_profile2(1,:)/sa_mars; %kg(total)/cm2/s
og_profile2(1,:) = og_profile2(1,:)*1000; %g(total)/cm2/s

h2_rate_IWm1_2000ppm_var = og_profile2;
h2_rate_IWm1_2000ppm_var(1,:) = h2_rate_IWm1_2000ppm_var(1,:)*h2_conc_mole_high*av; %molecules H2/cm2/s

h2_rate_IW_100ppm_var = og_profile2;
h2_rate_IW_100ppm_var(1,:) = h2_rate_IW_100ppm_var(1,:)*h2_conc_mole_low*av; %molecules H2/cm2/s

time = 4.5 - (og_profile(2,:)/1000);

%Sanity check for testing the conversion between Tmol/yr and cm-2s-1
sa_earth = 510072000*(10^10);
s2yr = 3.17e-8;
test = 1e12*(1/sa_earth)*s2yr*av;

%% Plot

font = 26;
ticks_font_size = 22;
legend_font_size = 18;
line_width = 3;

ca = [86,180,233]/255;
cb = [0,158,115]/255;
cc = [240,228,66]/255;
cd = [204,121,167]/255;
ce = [213,94,0]/255;

%multiply by 2 and 0.5 to account for volcanic outgassing multiplier range
fg = figure('Renderer', 'painters', 'Position', [10 10 1000 600]);
semilogy(time,h2_rate_IWm1_2000ppm(1,:)*2,'LineWidth', line_width, 'Color', ca);
hold on
semilogy(time,h2_rate_IWm1_2000ppm_var(1,:)*2,'LineWidth', line_width, 'Color', cb);
semilogy(time,h2_rate_IW_100ppm(1,:)*0.5,'LineWidth', line_width, 'Color', cc);
semilogy(time,h2_rate_IW_100ppm_var(1,:)*0.5,'LineWidth', line_width, 'Color', ce);
xlabel('Time before present (Ga)','FontSize',font);
ylabel('H_{2} Outgassing Rate (cm^{-2} s^{-1})','FontSize',font);
set(gca,'Xdir','reverse');
set(gca,'FontSize',ticks_font_size,'XMinorTick','on','YMinorTick','on');
set(gca,'xtick',[0,.5:0.5:3.5,3.8],'Xlim',[0,3.8],'Ylim',[10^(6),10^11]);
box on
legend({'f_{O2} = IW-1, [H_{2}O]_{mag} = 2000 ppm, f_{og} = 2, Hartmann (2005)','f_{O2} = IW-1, [H_{2}O]_{mag} = 2000 ppm, f_{og} = 2, Ivanov (2001)','f_{O2} = IW, [H_{2}O]_{mag} = 100 ppm, f_{og} = 0.5, Hartmann (2005)','f_{O2} = IW, [H_{2}O]_{mag} = 100 ppm, f_{og} = 0.5, Ivanov (2001)'},'FontSize',legend_font_size);
hold off
