#!/bin/bash
##SBATCH --time=00:10:00
#SBATCH --time=18:00:00
#SBATCH --nodes=9
#SBATCH --tasks-per-node=100
#SBATCH --cpus-per-task=1
#SBATCH --partition=standard
##SBATCH --qos=short
#SBATCH --qos=standard
#SBATCH --chdir=../run

# record queueing time and start run timer
TIMER_Q_END="$(date +%s)"
TIMER_Q_ELAPSED="$(expr $TIMER_Q_END - $TIMER_Q_START)"
echo Queue-time seconds $TIMER_Q_ELAPSED >> times
TIMER_R_START="$(date +%s)"

# prevent any threaded system libraries from automatically using threading
export OMP_NUM_THREADS=1

# choose maximum clock speed for cores
export SLURM_CPU_FREQ_REQ=2250000

# set scratch directory
export TMPDIR=/work/n02/n02/`whoami`/SCRATCH

# run the job 
srun --distribution=block:block --hint=nomultithread ./mitgcmuv

# save a copy of final stdout/stderr from the master node
cp STDERR.0000 stderr_9999999999
cp STDOUT.0000 stdout_9999999999

# record run time
TIMER_R_END="$(date +%s)"
TIMER_R_ELAPSED="$(expr $TIMER_R_END - $TIMER_R_START)"
echo Run-time seconds $TIMER_R_ELAPSED >> times

