@license{
  Copyright (c) 2009-2020 CWI
  All rights reserved. This program and the accompanying materials
  are made available under the terms of the Eclipse Public License v1.0
  which accompanies this distribution, and is available at
  http://www.eclipse.org/legal/epl-v10.html
}
module lang::rascal::tests::basic::Booleans

import Boolean;
import Exception;
// Operators

test bool sanity() = true != false;

test bool or(bool b) { if (true || b == true, b || true == true, false || false == false) return true; else return false; }  
  
test bool and(bool b) { if ((false && b) == false, (b && false) == false, (true && true) == true) return true; else return false; }

test bool not1(bool b) = !!b == b;

test bool not2() = (!true == false) && (!false == true);

test bool equiv(bool b1, bool b2) = (b1 <==> b2) <==> (!b1 && !b2 || b1 && b2);

test bool impl(bool b1, bool b2) = (b1 ==> b2) <==> !(b1 && !b2);

test bool assignAnd(bool b1, bool b2) { 
    int n = b1 && b2 ? 10 : 20;
    if(b1 && b2) return n == 10; else return n == 20;
}

test bool assignOr(bool b1, bool b2) { 
    int n = b1 || b2 ? 10 : 20;
    if(b1 || b2) return n == 10; else return n == 20;
}

// Library functions

test bool tstArbBool() { b = arbBool() ; return b == true || b == false; }

test bool fromString1() = fromString("true") == true && fromString("false") == false;

@expected{IllegalArgument}
test bool fromString2(str s) = fromString(s); // will fail in the rare situation that "true" or "false" are passed as argument.

test bool tstToInt() = toInt(false) == 0 && toInt(true) == 1;

test bool tstToReal() = toReal(false) == 0.0 && toInt(true) == 1.0;

test bool tstToString() = toString(false) == "false" && toString(true) == "true";

test bool shortCircuiting() { 
	try { return false ==> (1/0 == 0) && true || (1/0 == 0) && !(false && (1/0 == 0)); }
	catch ArithmeticException(str _): { return false; }
	}

test bool matchAnonymous(){
    b = [_] := [1];
    return b;
}

test bool matchAnonymousReturn(){
    return [_] := [1];
}   

test bool matchTypedAnonymous(){
    b = [int _] := [1];
    return b;
}

test bool matchTypedAnonymousReturn(){
    return [int _] := [1];
}

test bool matchVar(){
    b = [_] := [1];
    return b;
}

test bool matchVarReturn(){
    return [_] := [1];
}

test bool matchTypedVar(){
    b = [int _] := [1];
    return b;
}

test bool matchTypedVarReturn(){
    return [int _] := [1];
}

test bool matchAnonymousListVar1(){
    b = [*_] := [1];
    return b;
}
  
test bool matchAnonymousListVar1Return(){
    return [*_] := [1];
}

test bool matchAnonymousListVar2(){
    b = [*_] := [1];
    return b;
}

test bool matchAnonymousListVar2Return(){
    return [*_] := [1];
}

test bool matchTypedAnonymousListVar(){
    b = [*int _] := [1];
    return b;
}

test bool matchTypedAnonymousListVarReturn(){
    return [*int _] := [1];
}

test bool matchListVar1(){
    b = [*_] := [1];
    return b;
}

test bool matchListVar1Return(){
    return [*_] := [1];
}

test bool matchListVar2(){
    b = [*_] := [1];
    return b;
}

test bool matchListVar2Return(){
    return [*_] := [1];
}

test bool matchTypedListVar(){
    b = [*int _] := [1];
    return b;
}

test bool matchTypedListVarReturn(){
    return [*int _] := [1];
}

test bool matchTypedVarAndTrue(){
    ten = 10;
    b = [int _] := [1] && ten > 9;
    return b;
}

test bool matchTypedVarAndFalse(){
    ten = 10;
    b = [int _] := [1] && 9 > ten;
    return !b;
}

test bool matchTypedListVarAnd(){
    ten = 10;
    b = [*int _] := [1] && ten > 9;
    return b;
}

test bool matchTypedListVarAndFalse(){
    ten = 10;
    b = [*int _] := [1] && 9 > ten;
    return !b;
}

test bool compositeAnd() {
    ten = 10;
    b = [*int _, int  _, *int _] := [1,2,3] && ten > 9;
    return b;
}

test bool compositeAndFalse() {
    ten = 10;
    b = [*int _, int  _, *int _] := [1,2,3] && 9 > ten;
    return !b;
}

test bool compositeAndCnt() {
    n = 0;
    ten = 10;
    if( [*int _, int  _, *int _] := [1,2,3] && ten > 9 )  {
        n = n + 1;
        fail;
    }
    return n == 3;
}

test bool compositeAndCommaCnt() {
    n = 0;
    ten = 10;
    if( [*int _, int  _, *int _] := [1,2,3] , ten > 9 )  {
        n = n + 1;
        fail;
    }
    return n == 3;
}

test bool compositeAndBTLast() {
    ten = 10;
    return ten > 9 && [*int _, int  _, *int _] := [1,2,3];
}

test bool compositeAndCntBTLast() {
    n = 0;
    ten = 10;
    if( ten > 9 && [*int _, int  _, *int _] := [1,2,3] )  {
        n = n + 1;
        fail;
    }
    return n == 3;
}

test bool compositeAndBothBT() {
    return [*int _, int  _, *int _] := [1,2,3] && [*int _, int  _, *int _] := [4, 5, 6];
}

test bool compositeAndBothBTCnt() {
    n = 0;
    if( [*int _, int  _, *int _] := [1,2,3] && [*int _, int  _, *int _] := [4, 5, 6] )  {
        n = n + 1;
        fail;
    }
    return n == 9;
}

test bool compositeOrCntBTLast() {
    n = 0;
    if( int _ := 3 || ([*int _,*int _] := [4,5,6]) )  {
        n = n + 1;
        fail;
    }
    return n == 5;
}   

test bool compositeOrCntBTFirst() {
    n = 0;
    if( [*int _,*int _] := [4,5,6] || int _ := 3)  {
        n = n + 1;
        fail;
    }
    return n == 5;
}    

test bool compositeAndOrCnt() {
    n = 0;
    if( ([*int _,*int _] := [1,2,3] && int _ := 3) || ([*int _,*int _] := [4,5,6] && int _ := 4) )  {
        n = n + 1;
        fail;
    }
    return n == 8;
}

// implies ==>

@ignoreCompiler{Backtracking in arguments of ==>}
test bool compositeImplTrue(){
  ten = 10;
  b = [*int _, int  _, *int _] := [1,2,3] ==> ten > 9;
  return b;
}

@ignoreCompiler{Backtracking in arguments of ==>}
test bool compositeImplFalse(){
  ten = 10;
  b = [*int _, int  _, *int _] := [1,2,3] ==> 9 > ten;
  return !b;
}

@ignoreCompiler{Backtracking in arguments of ==>}
test bool compositeImplBTLast1(){
  ten = 10;
  b = 9 > ten ==> [*int _, int  _, *int _] := [1,2,3];
  return b;
}

@ignoreCompiler{Backtracking in arguments of ==>}
test bool compositeImplBTLast2(){
  ten = 10;
  b = ten > 9 ==> [*int _, int  _, *int _] := [1,2,3];
  return b;
}

@ignoreCompiler{Backtracking in arguments of ==>}
test bool compositeImplVarBothBT(){
  ten = 10;
  b = [*int _, int  _, *int _] := [1,2,3] ==> ([*int _, *int _] := [4,5,6] && int _ := 4);
  return b;
}

@ignoreCompiler{Backtracking in arguments of ==>}
test bool compositeImplCnt() {
    n = 0;
    ten = 10;
    if( [*int _, int  _, *int _] := [1,2,3] ==> ten > 9 )  {
        n = n + 1;
        fail;
    }
    return n == 1;
}

@ignoreCompiler{Backtracking in arguments of ==>}
test bool compositeImplCntBTLast1() {
    ten = 10;
    return ten > 9 ==> [*int _, int  _, *int _] := [1,2,3];
}

@ignoreCompiler{Backtracking in arguments of ==>}
test bool compositeImplCntBTLast2() {
    n = 0;
    ten = 10;
    if( ten > 9 ==> [*int _, int  _, *int _] := [1,2,3] )  {
        n = n + 1;
        fail;
    }
    return n == 3;
}

@ignoreCompiler{Backtracking in arguments of ==>}
test bool compositeImplReturnBothBT() {
    return [*int _, int  _, *int _] := [1,2,3] ==> [*int _, int  _, *int _] := [4, 5, 6];
}

@ignoreCompiler{Backtracking in arguments of ==>}
test bool compositeImplBothBTCnt() {
    n = 0;
    if( [*int _, int  _, *int _] := [1,2,3] ==> [*int _, int  _, *int _] := [4, 5, 6] )  {
        n = n + 1;
        fail;
    }
    return n == 3;
}


// equivalent <==>

@ignoreCompiler{Backtracking in arguments of <==>}
test bool compositeEquivTrue(){
  ten = 10;
  b = [*int _, int  _, *int _] := [1,2,3] <==> ten > 9;
  return b;
}

@ignoreCompiler{Backtracking in arguments of <==>}
test bool compositeEquivFalse(){
  ten = 10;
  b = [*int _, int  _, *int _] := [1,2,3]<==> 9 > ten;
  return !b;
}

@ignoreCompiler{Backtracking in arguments of <==>}
test bool compositeEquivBTLast1(){
  ten = 10;
  b = 9 > ten <==> [*int _, int  _, *int _] := [1,2,3];
  return !b;
}

@ignoreCompiler{Backtracking in arguments of <==>}
test bool compositeEquivBTLast2(){
  ten = 10;
  b = ten > 9 <==> [*int _, int  _, *int _] := [1,2,3];
  return b;
}

@ignoreCompiler{Backtracking in arguments of <==>}
test bool compositeEquivVarBothBT(){
  ten = 10;
  b = [*int _, int  _, *int _] := [1,2,3] <==> ([*int _, *int _] := [4,5,6] && int _ := 4);
  return b;
}

@ignoreCompiler{Backtracking in arguments of <==>}
test bool compositeEquivCnt() {
    n = 0;
    ten = 10;
    if( [*int _, int  _, *int _] := [1,2,3] <==> ten > 9 )  {
        n = n + 1;
        fail;
    }
    return n == 3;
}

@ignoreCompiler{Backtracking in arguments of <==>}
test bool compositeEquivCntBTLast1() {
    ten = 10;
    return ten > 9 <==> [*int _, int  _, *int _] := [1,2,3];
}

@ignoreCompiler{Backtracking in arguments of <==>}
test bool compositeEquivCntBTLast2() {
    n = 0;
    ten = 10;
    if( ten > 9 <==> [*int _, int  _, *int _] := [1,2,3] )  {
        n = n + 1;
        fail;
    }
    return n == 3;
}

@ignoreCompiler{Backtracking in arguments of <==>}
test bool compositeEquivReturnBothBT() {
    return [*int _, int  _, *int _] := [1,2,3] <==> [*int _, int  _, *int _] := [4, 5, 6];
}

@ignoreCompiler{Backtracking in arguments of <==>}
test bool compositeEquivBothBTCnt() {
    n = 0;
    if( [*int _, int  _, *int _] := [1,2,3] <==> [*int _, int  _, *int _] := [4, 5, 6] )  {
        n = n + 1;
        fail;
    }
    return n == 3;
}

////

data AnotherAndData = a();

anno list[int] AnotherAndData@l;

test bool anotherAnd() {
    v = a()[@l = [1,2,3]];
    list[list[int]] res = [];
    if(v@l? && [*int x,*int y] := v@l) {
       res = res + [ x, y ];
       fail;
    }
    return res ==  [[],
  					[1,2,3],
  					[1],
  					[2,3],
  					[1,2],
  					[3],
  					[1,2,3],
  					[]
					];
}
@ignoreCompiler{"too slow for now}
test bool nestedOr() {
    res = for( ( ( ([*int x1,*int y1] := [1,2] || [*int x1,*int y1] := [3,4]) && ([*int x2,*int y2] := [5,6] || [*int x2,*int y2] := [7,8]) ) 
                 || ( ([*int x1,*int y1] := [9,10] || [*int x1,*int y1] := [11,12]) && ([*int x2,*int y2] := [13,14] || [*int x2,*int y2] := [15,16]) ) )
               &&  ( ( ([*int x3,*int y3] := [17,18] || [*int x3,*int y3] := [19,20]) && ([*int x4,*int y4] := [21,22] || [*int x4,*int y4] := [23,24]) ) 
                     || ( ([*int x3,*int y3] := [25,26] || [*int x3,*int y3] := [27,28]) && ([*int x4,*int y4] := [29,30] || [*int x4,*int y4] := [31,32]) ) ) ) {
              append <x1,x2,x3,x4,y1,y2,y3,y4>;
          }
    return res ==
    [
  <[],[],[],[],[1,2],[5,6],[17,18],[21,22]>,
  <[],[],[],[21],[1,2],[5,6],[17,18],[22]>,
  <[],[],[],[21,22],[1,2],[5,6],[17,18],[]>,
  <[],[],[],[],[1,2],[5,6],[17,18],[23,24]>,
  <[],[],[],[23],[1,2],[5,6],[17,18],[24]>,
  <[],[],[],[23,24],[1,2],[5,6],[17,18],[]>,
  <[],[],[17],[],[1,2],[5,6],[18],[21,22]>,
  <[],[],[17],[21],[1,2],[5,6],[18],[22]>,
  <[],[],[17],[21,22],[1,2],[5,6],[18],[]>,
  <[],[],[17],[],[1,2],[5,6],[18],[23,24]>,
  <[],[],[17],[23],[1,2],[5,6],[18],[24]>,
  <[],[],[17],[23,24],[1,2],[5,6],[18],[]>,
  <[],[],[17,18],[],[1,2],[5,6],[],[21,22]>,
  <[],[],[17,18],[21],[1,2],[5,6],[],[22]>,
  <[],[],[17,18],[21,22],[1,2],[5,6],[],[]>,
  <[],[],[17,18],[],[1,2],[5,6],[],[23,24]>,
  <[],[],[17,18],[23],[1,2],[5,6],[],[24]>,
  <[],[],[17,18],[23,24],[1,2],[5,6],[],[]>,
  <[],[],[],[],[1,2],[5,6],[19,20],[21,22]>,
  <[],[],[],[21],[1,2],[5,6],[19,20],[22]>,
  <[],[],[],[21,22],[1,2],[5,6],[19,20],[]>,
  <[],[],[],[],[1,2],[5,6],[19,20],[23,24]>,
  <[],[],[],[23],[1,2],[5,6],[19,20],[24]>,
  <[],[],[],[23,24],[1,2],[5,6],[19,20],[]>,
  <[],[],[19],[],[1,2],[5,6],[20],[21,22]>,
  <[],[],[19],[21],[1,2],[5,6],[20],[22]>,
  <[],[],[19],[21,22],[1,2],[5,6],[20],[]>,
  <[],[],[19],[],[1,2],[5,6],[20],[23,24]>,
  <[],[],[19],[23],[1,2],[5,6],[20],[24]>,
  <[],[],[19],[23,24],[1,2],[5,6],[20],[]>,
  <[],[],[19,20],[],[1,2],[5,6],[],[21,22]>,
  <[],[],[19,20],[21],[1,2],[5,6],[],[22]>,
  <[],[],[19,20],[21,22],[1,2],[5,6],[],[]>,
  <[],[],[19,20],[],[1,2],[5,6],[],[23,24]>,
  <[],[],[19,20],[23],[1,2],[5,6],[],[24]>,
  <[],[],[19,20],[23,24],[1,2],[5,6],[],[]>,
  <[],[],[],[],[1,2],[5,6],[25,26],[29,30]>,
  <[],[],[],[29],[1,2],[5,6],[25,26],[30]>,
  <[],[],[],[29,30],[1,2],[5,6],[25,26],[]>,
  <[],[],[],[],[1,2],[5,6],[25,26],[31,32]>,
  <[],[],[],[31],[1,2],[5,6],[25,26],[32]>,
  <[],[],[],[31,32],[1,2],[5,6],[25,26],[]>,
  <[],[],[25],[],[1,2],[5,6],[26],[29,30]>,
  <[],[],[25],[29],[1,2],[5,6],[26],[30]>,
  <[],[],[25],[29,30],[1,2],[5,6],[26],[]>,
  <[],[],[25],[],[1,2],[5,6],[26],[31,32]>,
  <[],[],[25],[31],[1,2],[5,6],[26],[32]>,
  <[],[],[25],[31,32],[1,2],[5,6],[26],[]>,
  <[],[],[25,26],[],[1,2],[5,6],[],[29,30]>,
  <[],[],[25,26],[29],[1,2],[5,6],[],[30]>,
  <[],[],[25,26],[29,30],[1,2],[5,6],[],[]>,
  <[],[],[25,26],[],[1,2],[5,6],[],[31,32]>,
  <[],[],[25,26],[31],[1,2],[5,6],[],[32]>,
  <[],[],[25,26],[31,32],[1,2],[5,6],[],[]>,
  <[],[],[],[],[1,2],[5,6],[27,28],[29,30]>,
  <[],[],[],[29],[1,2],[5,6],[27,28],[30]>,
  <[],[],[],[29,30],[1,2],[5,6],[27,28],[]>,
  <[],[],[],[],[1,2],[5,6],[27,28],[31,32]>,
  <[],[],[],[31],[1,2],[5,6],[27,28],[32]>,
  <[],[],[],[31,32],[1,2],[5,6],[27,28],[]>,
  <[],[],[27],[],[1,2],[5,6],[28],[29,30]>,
  <[],[],[27],[29],[1,2],[5,6],[28],[30]>,
  <[],[],[27],[29,30],[1,2],[5,6],[28],[]>,
  <[],[],[27],[],[1,2],[5,6],[28],[31,32]>,
  <[],[],[27],[31],[1,2],[5,6],[28],[32]>,
  <[],[],[27],[31,32],[1,2],[5,6],[28],[]>,
  <[],[],[27,28],[],[1,2],[5,6],[],[29,30]>,
  <[],[],[27,28],[29],[1,2],[5,6],[],[30]>,
  <[],[],[27,28],[29,30],[1,2],[5,6],[],[]>,
  <[],[],[27,28],[],[1,2],[5,6],[],[31,32]>,
  <[],[],[27,28],[31],[1,2],[5,6],[],[32]>,
  <[],[],[27,28],[31,32],[1,2],[5,6],[],[]>,
  <[],[5],[],[],[1,2],[6],[17,18],[21,22]>,
  <[],[5],[],[21],[1,2],[6],[17,18],[22]>,
  <[],[5],[],[21,22],[1,2],[6],[17,18],[]>,
  <[],[5],[],[],[1,2],[6],[17,18],[23,24]>,
  <[],[5],[],[23],[1,2],[6],[17,18],[24]>,
  <[],[5],[],[23,24],[1,2],[6],[17,18],[]>,
  <[],[5],[17],[],[1,2],[6],[18],[21,22]>,
  <[],[5],[17],[21],[1,2],[6],[18],[22]>,
  <[],[5],[17],[21,22],[1,2],[6],[18],[]>,
  <[],[5],[17],[],[1,2],[6],[18],[23,24]>,
  <[],[5],[17],[23],[1,2],[6],[18],[24]>,
  <[],[5],[17],[23,24],[1,2],[6],[18],[]>,
  <[],[5],[17,18],[],[1,2],[6],[],[21,22]>,
  <[],[5],[17,18],[21],[1,2],[6],[],[22]>,
  <[],[5],[17,18],[21,22],[1,2],[6],[],[]>,
  <[],[5],[17,18],[],[1,2],[6],[],[23,24]>,
  <[],[5],[17,18],[23],[1,2],[6],[],[24]>,
  <[],[5],[17,18],[23,24],[1,2],[6],[],[]>,
  <[],[5],[],[],[1,2],[6],[19,20],[21,22]>,
  <[],[5],[],[21],[1,2],[6],[19,20],[22]>,
  <[],[5],[],[21,22],[1,2],[6],[19,20],[]>,
  <[],[5],[],[],[1,2],[6],[19,20],[23,24]>,
  <[],[5],[],[23],[1,2],[6],[19,20],[24]>,
  <[],[5],[],[23,24],[1,2],[6],[19,20],[]>,
  <[],[5],[19],[],[1,2],[6],[20],[21,22]>,
  <[],[5],[19],[21],[1,2],[6],[20],[22]>,
  <[],[5],[19],[21,22],[1,2],[6],[20],[]>,
  <[],[5],[19],[],[1,2],[6],[20],[23,24]>,
  <[],[5],[19],[23],[1,2],[6],[20],[24]>,
  <[],[5],[19],[23,24],[1,2],[6],[20],[]>,
  <[],[5],[19,20],[],[1,2],[6],[],[21,22]>,
  <[],[5],[19,20],[21],[1,2],[6],[],[22]>,
  <[],[5],[19,20],[21,22],[1,2],[6],[],[]>,
  <[],[5],[19,20],[],[1,2],[6],[],[23,24]>,
  <[],[5],[19,20],[23],[1,2],[6],[],[24]>,
  <[],[5],[19,20],[23,24],[1,2],[6],[],[]>,
  <[],[5],[],[],[1,2],[6],[25,26],[29,30]>,
  <[],[5],[],[29],[1,2],[6],[25,26],[30]>,
  <[],[5],[],[29,30],[1,2],[6],[25,26],[]>,
  <[],[5],[],[],[1,2],[6],[25,26],[31,32]>,
  <[],[5],[],[31],[1,2],[6],[25,26],[32]>,
  <[],[5],[],[31,32],[1,2],[6],[25,26],[]>,
  <[],[5],[25],[],[1,2],[6],[26],[29,30]>,
  <[],[5],[25],[29],[1,2],[6],[26],[30]>,
  <[],[5],[25],[29,30],[1,2],[6],[26],[]>,
  <[],[5],[25],[],[1,2],[6],[26],[31,32]>,
  <[],[5],[25],[31],[1,2],[6],[26],[32]>,
  <[],[5],[25],[31,32],[1,2],[6],[26],[]>,
  <[],[5],[25,26],[],[1,2],[6],[],[29,30]>,
  <[],[5],[25,26],[29],[1,2],[6],[],[30]>,
  <[],[5],[25,26],[29,30],[1,2],[6],[],[]>,
  <[],[5],[25,26],[],[1,2],[6],[],[31,32]>,
  <[],[5],[25,26],[31],[1,2],[6],[],[32]>,
  <[],[5],[25,26],[31,32],[1,2],[6],[],[]>,
  <[],[5],[],[],[1,2],[6],[27,28],[29,30]>,
  <[],[5],[],[29],[1,2],[6],[27,28],[30]>,
  <[],[5],[],[29,30],[1,2],[6],[27,28],[]>,
  <[],[5],[],[],[1,2],[6],[27,28],[31,32]>,
  <[],[5],[],[31],[1,2],[6],[27,28],[32]>,
  <[],[5],[],[31,32],[1,2],[6],[27,28],[]>,
  <[],[5],[27],[],[1,2],[6],[28],[29,30]>,
  <[],[5],[27],[29],[1,2],[6],[28],[30]>,
  <[],[5],[27],[29,30],[1,2],[6],[28],[]>,
  <[],[5],[27],[],[1,2],[6],[28],[31,32]>,
  <[],[5],[27],[31],[1,2],[6],[28],[32]>,
  <[],[5],[27],[31,32],[1,2],[6],[28],[]>,
  <[],[5],[27,28],[],[1,2],[6],[],[29,30]>,
  <[],[5],[27,28],[29],[1,2],[6],[],[30]>,
  <[],[5],[27,28],[29,30],[1,2],[6],[],[]>,
  <[],[5],[27,28],[],[1,2],[6],[],[31,32]>,
  <[],[5],[27,28],[31],[1,2],[6],[],[32]>,
  <[],[5],[27,28],[31,32],[1,2],[6],[],[]>,
  <[],[5,6],[],[],[1,2],[],[17,18],[21,22]>,
  <[],[5,6],[],[21],[1,2],[],[17,18],[22]>,
  <[],[5,6],[],[21,22],[1,2],[],[17,18],[]>,
  <[],[5,6],[],[],[1,2],[],[17,18],[23,24]>,
  <[],[5,6],[],[23],[1,2],[],[17,18],[24]>,
  <[],[5,6],[],[23,24],[1,2],[],[17,18],[]>,
  <[],[5,6],[17],[],[1,2],[],[18],[21,22]>,
  <[],[5,6],[17],[21],[1,2],[],[18],[22]>,
  <[],[5,6],[17],[21,22],[1,2],[],[18],[]>,
  <[],[5,6],[17],[],[1,2],[],[18],[23,24]>,
  <[],[5,6],[17],[23],[1,2],[],[18],[24]>,
  <[],[5,6],[17],[23,24],[1,2],[],[18],[]>,
  <[],[5,6],[17,18],[],[1,2],[],[],[21,22]>,
  <[],[5,6],[17,18],[21],[1,2],[],[],[22]>,
  <[],[5,6],[17,18],[21,22],[1,2],[],[],[]>,
  <[],[5,6],[17,18],[],[1,2],[],[],[23,24]>,
  <[],[5,6],[17,18],[23],[1,2],[],[],[24]>,
  <[],[5,6],[17,18],[23,24],[1,2],[],[],[]>,
  <[],[5,6],[],[],[1,2],[],[19,20],[21,22]>,
  <[],[5,6],[],[21],[1,2],[],[19,20],[22]>,
  <[],[5,6],[],[21,22],[1,2],[],[19,20],[]>,
  <[],[5,6],[],[],[1,2],[],[19,20],[23,24]>,
  <[],[5,6],[],[23],[1,2],[],[19,20],[24]>,
  <[],[5,6],[],[23,24],[1,2],[],[19,20],[]>,
  <[],[5,6],[19],[],[1,2],[],[20],[21,22]>,
  <[],[5,6],[19],[21],[1,2],[],[20],[22]>,
  <[],[5,6],[19],[21,22],[1,2],[],[20],[]>,
  <[],[5,6],[19],[],[1,2],[],[20],[23,24]>,
  <[],[5,6],[19],[23],[1,2],[],[20],[24]>,
  <[],[5,6],[19],[23,24],[1,2],[],[20],[]>,
  <[],[5,6],[19,20],[],[1,2],[],[],[21,22]>,
  <[],[5,6],[19,20],[21],[1,2],[],[],[22]>,
  <[],[5,6],[19,20],[21,22],[1,2],[],[],[]>,
  <[],[5,6],[19,20],[],[1,2],[],[],[23,24]>,
  <[],[5,6],[19,20],[23],[1,2],[],[],[24]>,
  <[],[5,6],[19,20],[23,24],[1,2],[],[],[]>,
  <[],[5,6],[],[],[1,2],[],[25,26],[29,30]>,
  <[],[5,6],[],[29],[1,2],[],[25,26],[30]>,
  <[],[5,6],[],[29,30],[1,2],[],[25,26],[]>,
  <[],[5,6],[],[],[1,2],[],[25,26],[31,32]>,
  <[],[5,6],[],[31],[1,2],[],[25,26],[32]>,
  <[],[5,6],[],[31,32],[1,2],[],[25,26],[]>,
  <[],[5,6],[25],[],[1,2],[],[26],[29,30]>,
  <[],[5,6],[25],[29],[1,2],[],[26],[30]>,
  <[],[5,6],[25],[29,30],[1,2],[],[26],[]>,
  <[],[5,6],[25],[],[1,2],[],[26],[31,32]>,
  <[],[5,6],[25],[31],[1,2],[],[26],[32]>,
  <[],[5,6],[25],[31,32],[1,2],[],[26],[]>,
  <[],[5,6],[25,26],[],[1,2],[],[],[29,30]>,
  <[],[5,6],[25,26],[29],[1,2],[],[],[30]>,
  <[],[5,6],[25,26],[29,30],[1,2],[],[],[]>,
  <[],[5,6],[25,26],[],[1,2],[],[],[31,32]>,
  <[],[5,6],[25,26],[31],[1,2],[],[],[32]>,
  <[],[5,6],[25,26],[31,32],[1,2],[],[],[]>,
  <[],[5,6],[],[],[1,2],[],[27,28],[29,30]>,
  <[],[5,6],[],[29],[1,2],[],[27,28],[30]>,
  <[],[5,6],[],[29,30],[1,2],[],[27,28],[]>,
  <[],[5,6],[],[],[1,2],[],[27,28],[31,32]>,
  <[],[5,6],[],[31],[1,2],[],[27,28],[32]>,
  <[],[5,6],[],[31,32],[1,2],[],[27,28],[]>,
  <[],[5,6],[27],[],[1,2],[],[28],[29,30]>,
  <[],[5,6],[27],[29],[1,2],[],[28],[30]>,
  <[],[5,6],[27],[29,30],[1,2],[],[28],[]>,
  <[],[5,6],[27],[],[1,2],[],[28],[31,32]>,
  <[],[5,6],[27],[31],[1,2],[],[28],[32]>,
  <[],[5,6],[27],[31,32],[1,2],[],[28],[]>,
  <[],[5,6],[27,28],[],[1,2],[],[],[29,30]>,
  <[],[5,6],[27,28],[29],[1,2],[],[],[30]>,
  <[],[5,6],[27,28],[29,30],[1,2],[],[],[]>,
  <[],[5,6],[27,28],[],[1,2],[],[],[31,32]>,
  <[],[5,6],[27,28],[31],[1,2],[],[],[32]>,
  <[],[5,6],[27,28],[31,32],[1,2],[],[],[]>,
  <[],[],[],[],[1,2],[7,8],[17,18],[21,22]>,
  <[],[],[],[21],[1,2],[7,8],[17,18],[22]>,
  <[],[],[],[21,22],[1,2],[7,8],[17,18],[]>,
  <[],[],[],[],[1,2],[7,8],[17,18],[23,24]>,
  <[],[],[],[23],[1,2],[7,8],[17,18],[24]>,
  <[],[],[],[23,24],[1,2],[7,8],[17,18],[]>,
  <[],[],[17],[],[1,2],[7,8],[18],[21,22]>,
  <[],[],[17],[21],[1,2],[7,8],[18],[22]>,
  <[],[],[17],[21,22],[1,2],[7,8],[18],[]>,
  <[],[],[17],[],[1,2],[7,8],[18],[23,24]>,
  <[],[],[17],[23],[1,2],[7,8],[18],[24]>,
  <[],[],[17],[23,24],[1,2],[7,8],[18],[]>,
  <[],[],[17,18],[],[1,2],[7,8],[],[21,22]>,
  <[],[],[17,18],[21],[1,2],[7,8],[],[22]>,
  <[],[],[17,18],[21,22],[1,2],[7,8],[],[]>,
  <[],[],[17,18],[],[1,2],[7,8],[],[23,24]>,
  <[],[],[17,18],[23],[1,2],[7,8],[],[24]>,
  <[],[],[17,18],[23,24],[1,2],[7,8],[],[]>,
  <[],[],[],[],[1,2],[7,8],[19,20],[21,22]>,
  <[],[],[],[21],[1,2],[7,8],[19,20],[22]>,
  <[],[],[],[21,22],[1,2],[7,8],[19,20],[]>,
  <[],[],[],[],[1,2],[7,8],[19,20],[23,24]>,
  <[],[],[],[23],[1,2],[7,8],[19,20],[24]>,
  <[],[],[],[23,24],[1,2],[7,8],[19,20],[]>,
  <[],[],[19],[],[1,2],[7,8],[20],[21,22]>,
  <[],[],[19],[21],[1,2],[7,8],[20],[22]>,
  <[],[],[19],[21,22],[1,2],[7,8],[20],[]>,
  <[],[],[19],[],[1,2],[7,8],[20],[23,24]>,
  <[],[],[19],[23],[1,2],[7,8],[20],[24]>,
  <[],[],[19],[23,24],[1,2],[7,8],[20],[]>,
  <[],[],[19,20],[],[1,2],[7,8],[],[21,22]>,
  <[],[],[19,20],[21],[1,2],[7,8],[],[22]>,
  <[],[],[19,20],[21,22],[1,2],[7,8],[],[]>,
  <[],[],[19,20],[],[1,2],[7,8],[],[23,24]>,
  <[],[],[19,20],[23],[1,2],[7,8],[],[24]>,
  <[],[],[19,20],[23,24],[1,2],[7,8],[],[]>,
  <[],[],[],[],[1,2],[7,8],[25,26],[29,30]>,
  <[],[],[],[29],[1,2],[7,8],[25,26],[30]>,
  <[],[],[],[29,30],[1,2],[7,8],[25,26],[]>,
  <[],[],[],[],[1,2],[7,8],[25,26],[31,32]>,
  <[],[],[],[31],[1,2],[7,8],[25,26],[32]>,
  <[],[],[],[31,32],[1,2],[7,8],[25,26],[]>,
  <[],[],[25],[],[1,2],[7,8],[26],[29,30]>,
  <[],[],[25],[29],[1,2],[7,8],[26],[30]>,
  <[],[],[25],[29,30],[1,2],[7,8],[26],[]>,
  <[],[],[25],[],[1,2],[7,8],[26],[31,32]>,
  <[],[],[25],[31],[1,2],[7,8],[26],[32]>,
  <[],[],[25],[31,32],[1,2],[7,8],[26],[]>,
  <[],[],[25,26],[],[1,2],[7,8],[],[29,30]>,
  <[],[],[25,26],[29],[1,2],[7,8],[],[30]>,
  <[],[],[25,26],[29,30],[1,2],[7,8],[],[]>,
  <[],[],[25,26],[],[1,2],[7,8],[],[31,32]>,
  <[],[],[25,26],[31],[1,2],[7,8],[],[32]>,
  <[],[],[25,26],[31,32],[1,2],[7,8],[],[]>,
  <[],[],[],[],[1,2],[7,8],[27,28],[29,30]>,
  <[],[],[],[29],[1,2],[7,8],[27,28],[30]>,
  <[],[],[],[29,30],[1,2],[7,8],[27,28],[]>,
  <[],[],[],[],[1,2],[7,8],[27,28],[31,32]>,
  <[],[],[],[31],[1,2],[7,8],[27,28],[32]>,
  <[],[],[],[31,32],[1,2],[7,8],[27,28],[]>,
  <[],[],[27],[],[1,2],[7,8],[28],[29,30]>,
  <[],[],[27],[29],[1,2],[7,8],[28],[30]>,
  <[],[],[27],[29,30],[1,2],[7,8],[28],[]>,
  <[],[],[27],[],[1,2],[7,8],[28],[31,32]>,
  <[],[],[27],[31],[1,2],[7,8],[28],[32]>,
  <[],[],[27],[31,32],[1,2],[7,8],[28],[]>,
  <[],[],[27,28],[],[1,2],[7,8],[],[29,30]>,
  <[],[],[27,28],[29],[1,2],[7,8],[],[30]>,
  <[],[],[27,28],[29,30],[1,2],[7,8],[],[]>,
  <[],[],[27,28],[],[1,2],[7,8],[],[31,32]>,
  <[],[],[27,28],[31],[1,2],[7,8],[],[32]>,
  <[],[],[27,28],[31,32],[1,2],[7,8],[],[]>,
  <[],[7],[],[],[1,2],[8],[17,18],[21,22]>,
  <[],[7],[],[21],[1,2],[8],[17,18],[22]>,
  <[],[7],[],[21,22],[1,2],[8],[17,18],[]>,
  <[],[7],[],[],[1,2],[8],[17,18],[23,24]>,
  <[],[7],[],[23],[1,2],[8],[17,18],[24]>,
  <[],[7],[],[23,24],[1,2],[8],[17,18],[]>,
  <[],[7],[17],[],[1,2],[8],[18],[21,22]>,
  <[],[7],[17],[21],[1,2],[8],[18],[22]>,
  <[],[7],[17],[21,22],[1,2],[8],[18],[]>,
  <[],[7],[17],[],[1,2],[8],[18],[23,24]>,
  <[],[7],[17],[23],[1,2],[8],[18],[24]>,
  <[],[7],[17],[23,24],[1,2],[8],[18],[]>,
  <[],[7],[17,18],[],[1,2],[8],[],[21,22]>,
  <[],[7],[17,18],[21],[1,2],[8],[],[22]>,
  <[],[7],[17,18],[21,22],[1,2],[8],[],[]>,
  <[],[7],[17,18],[],[1,2],[8],[],[23,24]>,
  <[],[7],[17,18],[23],[1,2],[8],[],[24]>,
  <[],[7],[17,18],[23,24],[1,2],[8],[],[]>,
  <[],[7],[],[],[1,2],[8],[19,20],[21,22]>,
  <[],[7],[],[21],[1,2],[8],[19,20],[22]>,
  <[],[7],[],[21,22],[1,2],[8],[19,20],[]>,
  <[],[7],[],[],[1,2],[8],[19,20],[23,24]>,
  <[],[7],[],[23],[1,2],[8],[19,20],[24]>,
  <[],[7],[],[23,24],[1,2],[8],[19,20],[]>,
  <[],[7],[19],[],[1,2],[8],[20],[21,22]>,
  <[],[7],[19],[21],[1,2],[8],[20],[22]>,
  <[],[7],[19],[21,22],[1,2],[8],[20],[]>,
  <[],[7],[19],[],[1,2],[8],[20],[23,24]>,
  <[],[7],[19],[23],[1,2],[8],[20],[24]>,
  <[],[7],[19],[23,24],[1,2],[8],[20],[]>,
  <[],[7],[19,20],[],[1,2],[8],[],[21,22]>,
  <[],[7],[19,20],[21],[1,2],[8],[],[22]>,
  <[],[7],[19,20],[21,22],[1,2],[8],[],[]>,
  <[],[7],[19,20],[],[1,2],[8],[],[23,24]>,
  <[],[7],[19,20],[23],[1,2],[8],[],[24]>,
  <[],[7],[19,20],[23,24],[1,2],[8],[],[]>,
  <[],[7],[],[],[1,2],[8],[25,26],[29,30]>,
  <[],[7],[],[29],[1,2],[8],[25,26],[30]>,
  <[],[7],[],[29,30],[1,2],[8],[25,26],[]>,
  <[],[7],[],[],[1,2],[8],[25,26],[31,32]>,
  <[],[7],[],[31],[1,2],[8],[25,26],[32]>,
  <[],[7],[],[31,32],[1,2],[8],[25,26],[]>,
  <[],[7],[25],[],[1,2],[8],[26],[29,30]>,
  <[],[7],[25],[29],[1,2],[8],[26],[30]>,
  <[],[7],[25],[29,30],[1,2],[8],[26],[]>,
  <[],[7],[25],[],[1,2],[8],[26],[31,32]>,
  <[],[7],[25],[31],[1,2],[8],[26],[32]>,
  <[],[7],[25],[31,32],[1,2],[8],[26],[]>,
  <[],[7],[25,26],[],[1,2],[8],[],[29,30]>,
  <[],[7],[25,26],[29],[1,2],[8],[],[30]>,
  <[],[7],[25,26],[29,30],[1,2],[8],[],[]>,
  <[],[7],[25,26],[],[1,2],[8],[],[31,32]>,
  <[],[7],[25,26],[31],[1,2],[8],[],[32]>,
  <[],[7],[25,26],[31,32],[1,2],[8],[],[]>,
  <[],[7],[],[],[1,2],[8],[27,28],[29,30]>,
  <[],[7],[],[29],[1,2],[8],[27,28],[30]>,
  <[],[7],[],[29,30],[1,2],[8],[27,28],[]>,
  <[],[7],[],[],[1,2],[8],[27,28],[31,32]>,
  <[],[7],[],[31],[1,2],[8],[27,28],[32]>,
  <[],[7],[],[31,32],[1,2],[8],[27,28],[]>,
  <[],[7],[27],[],[1,2],[8],[28],[29,30]>,
  <[],[7],[27],[29],[1,2],[8],[28],[30]>,
  <[],[7],[27],[29,30],[1,2],[8],[28],[]>,
  <[],[7],[27],[],[1,2],[8],[28],[31,32]>,
  <[],[7],[27],[31],[1,2],[8],[28],[32]>,
  <[],[7],[27],[31,32],[1,2],[8],[28],[]>,
  <[],[7],[27,28],[],[1,2],[8],[],[29,30]>,
  <[],[7],[27,28],[29],[1,2],[8],[],[30]>,
  <[],[7],[27,28],[29,30],[1,2],[8],[],[]>,
  <[],[7],[27,28],[],[1,2],[8],[],[31,32]>,
  <[],[7],[27,28],[31],[1,2],[8],[],[32]>,
  <[],[7],[27,28],[31,32],[1,2],[8],[],[]>,
  <[],[7,8],[],[],[1,2],[],[17,18],[21,22]>,
  <[],[7,8],[],[21],[1,2],[],[17,18],[22]>,
  <[],[7,8],[],[21,22],[1,2],[],[17,18],[]>,
  <[],[7,8],[],[],[1,2],[],[17,18],[23,24]>,
  <[],[7,8],[],[23],[1,2],[],[17,18],[24]>,
  <[],[7,8],[],[23,24],[1,2],[],[17,18],[]>,
  <[],[7,8],[17],[],[1,2],[],[18],[21,22]>,
  <[],[7,8],[17],[21],[1,2],[],[18],[22]>,
  <[],[7,8],[17],[21,22],[1,2],[],[18],[]>,
  <[],[7,8],[17],[],[1,2],[],[18],[23,24]>,
  <[],[7,8],[17],[23],[1,2],[],[18],[24]>,
  <[],[7,8],[17],[23,24],[1,2],[],[18],[]>,
  <[],[7,8],[17,18],[],[1,2],[],[],[21,22]>,
  <[],[7,8],[17,18],[21],[1,2],[],[],[22]>,
  <[],[7,8],[17,18],[21,22],[1,2],[],[],[]>,
  <[],[7,8],[17,18],[],[1,2],[],[],[23,24]>,
  <[],[7,8],[17,18],[23],[1,2],[],[],[24]>,
  <[],[7,8],[17,18],[23,24],[1,2],[],[],[]>,
  <[],[7,8],[],[],[1,2],[],[19,20],[21,22]>,
  <[],[7,8],[],[21],[1,2],[],[19,20],[22]>,
  <[],[7,8],[],[21,22],[1,2],[],[19,20],[]>,
  <[],[7,8],[],[],[1,2],[],[19,20],[23,24]>,
  <[],[7,8],[],[23],[1,2],[],[19,20],[24]>,
  <[],[7,8],[],[23,24],[1,2],[],[19,20],[]>,
  <[],[7,8],[19],[],[1,2],[],[20],[21,22]>,
  <[],[7,8],[19],[21],[1,2],[],[20],[22]>,
  <[],[7,8],[19],[21,22],[1,2],[],[20],[]>,
  <[],[7,8],[19],[],[1,2],[],[20],[23,24]>,
  <[],[7,8],[19],[23],[1,2],[],[20],[24]>,
  <[],[7,8],[19],[23,24],[1,2],[],[20],[]>,
  <[],[7,8],[19,20],[],[1,2],[],[],[21,22]>,
  <[],[7,8],[19,20],[21],[1,2],[],[],[22]>,
  <[],[7,8],[19,20],[21,22],[1,2],[],[],[]>,
  <[],[7,8],[19,20],[],[1,2],[],[],[23,24]>,
  <[],[7,8],[19,20],[23],[1,2],[],[],[24]>,
  <[],[7,8],[19,20],[23,24],[1,2],[],[],[]>,
  <[],[7,8],[],[],[1,2],[],[25,26],[29,30]>,
  <[],[7,8],[],[29],[1,2],[],[25,26],[30]>,
  <[],[7,8],[],[29,30],[1,2],[],[25,26],[]>,
  <[],[7,8],[],[],[1,2],[],[25,26],[31,32]>,
  <[],[7,8],[],[31],[1,2],[],[25,26],[32]>,
  <[],[7,8],[],[31,32],[1,2],[],[25,26],[]>,
  <[],[7,8],[25],[],[1,2],[],[26],[29,30]>,
  <[],[7,8],[25],[29],[1,2],[],[26],[30]>,
  <[],[7,8],[25],[29,30],[1,2],[],[26],[]>,
  <[],[7,8],[25],[],[1,2],[],[26],[31,32]>,
  <[],[7,8],[25],[31],[1,2],[],[26],[32]>,
  <[],[7,8],[25],[31,32],[1,2],[],[26],[]>,
  <[],[7,8],[25,26],[],[1,2],[],[],[29,30]>,
  <[],[7,8],[25,26],[29],[1,2],[],[],[30]>,
  <[],[7,8],[25,26],[29,30],[1,2],[],[],[]>,
  <[],[7,8],[25,26],[],[1,2],[],[],[31,32]>,
  <[],[7,8],[25,26],[31],[1,2],[],[],[32]>,
  <[],[7,8],[25,26],[31,32],[1,2],[],[],[]>,
  <[],[7,8],[],[],[1,2],[],[27,28],[29,30]>,
  <[],[7,8],[],[29],[1,2],[],[27,28],[30]>,
  <[],[7,8],[],[29,30],[1,2],[],[27,28],[]>,
  <[],[7,8],[],[],[1,2],[],[27,28],[31,32]>,
  <[],[7,8],[],[31],[1,2],[],[27,28],[32]>,
  <[],[7,8],[],[31,32],[1,2],[],[27,28],[]>,
  <[],[7,8],[27],[],[1,2],[],[28],[29,30]>,
  <[],[7,8],[27],[29],[1,2],[],[28],[30]>,
  <[],[7,8],[27],[29,30],[1,2],[],[28],[]>,
  <[],[7,8],[27],[],[1,2],[],[28],[31,32]>,
  <[],[7,8],[27],[31],[1,2],[],[28],[32]>,
  <[],[7,8],[27],[31,32],[1,2],[],[28],[]>,
  <[],[7,8],[27,28],[],[1,2],[],[],[29,30]>,
  <[],[7,8],[27,28],[29],[1,2],[],[],[30]>,
  <[],[7,8],[27,28],[29,30],[1,2],[],[],[]>,
  <[],[7,8],[27,28],[],[1,2],[],[],[31,32]>,
  <[],[7,8],[27,28],[31],[1,2],[],[],[32]>,
  <[],[7,8],[27,28],[31,32],[1,2],[],[],[]>,
  <[1],[],[],[],[2],[5,6],[17,18],[21,22]>,
  <[1],[],[],[21],[2],[5,6],[17,18],[22]>,
  <[1],[],[],[21,22],[2],[5,6],[17,18],[]>,
  <[1],[],[],[],[2],[5,6],[17,18],[23,24]>,
  <[1],[],[],[23],[2],[5,6],[17,18],[24]>,
  <[1],[],[],[23,24],[2],[5,6],[17,18],[]>,
  <[1],[],[17],[],[2],[5,6],[18],[21,22]>,
  <[1],[],[17],[21],[2],[5,6],[18],[22]>,
  <[1],[],[17],[21,22],[2],[5,6],[18],[]>,
  <[1],[],[17],[],[2],[5,6],[18],[23,24]>,
  <[1],[],[17],[23],[2],[5,6],[18],[24]>,
  <[1],[],[17],[23,24],[2],[5,6],[18],[]>,
  <[1],[],[17,18],[],[2],[5,6],[],[21,22]>,
  <[1],[],[17,18],[21],[2],[5,6],[],[22]>,
  <[1],[],[17,18],[21,22],[2],[5,6],[],[]>,
  <[1],[],[17,18],[],[2],[5,6],[],[23,24]>,
  <[1],[],[17,18],[23],[2],[5,6],[],[24]>,
  <[1],[],[17,18],[23,24],[2],[5,6],[],[]>,
  <[1],[],[],[],[2],[5,6],[19,20],[21,22]>,
  <[1],[],[],[21],[2],[5,6],[19,20],[22]>,
  <[1],[],[],[21,22],[2],[5,6],[19,20],[]>,
  <[1],[],[],[],[2],[5,6],[19,20],[23,24]>,
  <[1],[],[],[23],[2],[5,6],[19,20],[24]>,
  <[1],[],[],[23,24],[2],[5,6],[19,20],[]>,
  <[1],[],[19],[],[2],[5,6],[20],[21,22]>,
  <[1],[],[19],[21],[2],[5,6],[20],[22]>,
  <[1],[],[19],[21,22],[2],[5,6],[20],[]>,
  <[1],[],[19],[],[2],[5,6],[20],[23,24]>,
  <[1],[],[19],[23],[2],[5,6],[20],[24]>,
  <[1],[],[19],[23,24],[2],[5,6],[20],[]>,
  <[1],[],[19,20],[],[2],[5,6],[],[21,22]>,
  <[1],[],[19,20],[21],[2],[5,6],[],[22]>,
  <[1],[],[19,20],[21,22],[2],[5,6],[],[]>,
  <[1],[],[19,20],[],[2],[5,6],[],[23,24]>,
  <[1],[],[19,20],[23],[2],[5,6],[],[24]>,
  <[1],[],[19,20],[23,24],[2],[5,6],[],[]>,
  <[1],[],[],[],[2],[5,6],[25,26],[29,30]>,
  <[1],[],[],[29],[2],[5,6],[25,26],[30]>,
  <[1],[],[],[29,30],[2],[5,6],[25,26],[]>,
  <[1],[],[],[],[2],[5,6],[25,26],[31,32]>,
  <[1],[],[],[31],[2],[5,6],[25,26],[32]>,
  <[1],[],[],[31,32],[2],[5,6],[25,26],[]>,
  <[1],[],[25],[],[2],[5,6],[26],[29,30]>,
  <[1],[],[25],[29],[2],[5,6],[26],[30]>,
  <[1],[],[25],[29,30],[2],[5,6],[26],[]>,
  <[1],[],[25],[],[2],[5,6],[26],[31,32]>,
  <[1],[],[25],[31],[2],[5,6],[26],[32]>,
  <[1],[],[25],[31,32],[2],[5,6],[26],[]>,
  <[1],[],[25,26],[],[2],[5,6],[],[29,30]>,
  <[1],[],[25,26],[29],[2],[5,6],[],[30]>,
  <[1],[],[25,26],[29,30],[2],[5,6],[],[]>,
  <[1],[],[25,26],[],[2],[5,6],[],[31,32]>,
  <[1],[],[25,26],[31],[2],[5,6],[],[32]>,
  <[1],[],[25,26],[31,32],[2],[5,6],[],[]>,
  <[1],[],[],[],[2],[5,6],[27,28],[29,30]>,
  <[1],[],[],[29],[2],[5,6],[27,28],[30]>,
  <[1],[],[],[29,30],[2],[5,6],[27,28],[]>,
  <[1],[],[],[],[2],[5,6],[27,28],[31,32]>,
  <[1],[],[],[31],[2],[5,6],[27,28],[32]>,
  <[1],[],[],[31,32],[2],[5,6],[27,28],[]>,
  <[1],[],[27],[],[2],[5,6],[28],[29,30]>,
  <[1],[],[27],[29],[2],[5,6],[28],[30]>,
  <[1],[],[27],[29,30],[2],[5,6],[28],[]>,
  <[1],[],[27],[],[2],[5,6],[28],[31,32]>,
  <[1],[],[27],[31],[2],[5,6],[28],[32]>,
  <[1],[],[27],[31,32],[2],[5,6],[28],[]>,
  <[1],[],[27,28],[],[2],[5,6],[],[29,30]>,
  <[1],[],[27,28],[29],[2],[5,6],[],[30]>,
  <[1],[],[27,28],[29,30],[2],[5,6],[],[]>,
  <[1],[],[27,28],[],[2],[5,6],[],[31,32]>,
  <[1],[],[27,28],[31],[2],[5,6],[],[32]>,
  <[1],[],[27,28],[31,32],[2],[5,6],[],[]>,
  <[1],[5],[],[],[2],[6],[17,18],[21,22]>,
  <[1],[5],[],[21],[2],[6],[17,18],[22]>,
  <[1],[5],[],[21,22],[2],[6],[17,18],[]>,
  <[1],[5],[],[],[2],[6],[17,18],[23,24]>,
  <[1],[5],[],[23],[2],[6],[17,18],[24]>,
  <[1],[5],[],[23,24],[2],[6],[17,18],[]>,
  <[1],[5],[17],[],[2],[6],[18],[21,22]>,
  <[1],[5],[17],[21],[2],[6],[18],[22]>,
  <[1],[5],[17],[21,22],[2],[6],[18],[]>,
  <[1],[5],[17],[],[2],[6],[18],[23,24]>,
  <[1],[5],[17],[23],[2],[6],[18],[24]>,
  <[1],[5],[17],[23,24],[2],[6],[18],[]>,
  <[1],[5],[17,18],[],[2],[6],[],[21,22]>,
  <[1],[5],[17,18],[21],[2],[6],[],[22]>,
  <[1],[5],[17,18],[21,22],[2],[6],[],[]>,
  <[1],[5],[17,18],[],[2],[6],[],[23,24]>,
  <[1],[5],[17,18],[23],[2],[6],[],[24]>,
  <[1],[5],[17,18],[23,24],[2],[6],[],[]>,
  <[1],[5],[],[],[2],[6],[19,20],[21,22]>,
  <[1],[5],[],[21],[2],[6],[19,20],[22]>,
  <[1],[5],[],[21,22],[2],[6],[19,20],[]>,
  <[1],[5],[],[],[2],[6],[19,20],[23,24]>,
  <[1],[5],[],[23],[2],[6],[19,20],[24]>,
  <[1],[5],[],[23,24],[2],[6],[19,20],[]>,
  <[1],[5],[19],[],[2],[6],[20],[21,22]>,
  <[1],[5],[19],[21],[2],[6],[20],[22]>,
  <[1],[5],[19],[21,22],[2],[6],[20],[]>,
  <[1],[5],[19],[],[2],[6],[20],[23,24]>,
  <[1],[5],[19],[23],[2],[6],[20],[24]>,
  <[1],[5],[19],[23,24],[2],[6],[20],[]>,
  <[1],[5],[19,20],[],[2],[6],[],[21,22]>,
  <[1],[5],[19,20],[21],[2],[6],[],[22]>,
  <[1],[5],[19,20],[21,22],[2],[6],[],[]>,
  <[1],[5],[19,20],[],[2],[6],[],[23,24]>,
  <[1],[5],[19,20],[23],[2],[6],[],[24]>,
  <[1],[5],[19,20],[23,24],[2],[6],[],[]>,
  <[1],[5],[],[],[2],[6],[25,26],[29,30]>,
  <[1],[5],[],[29],[2],[6],[25,26],[30]>,
  <[1],[5],[],[29,30],[2],[6],[25,26],[]>,
  <[1],[5],[],[],[2],[6],[25,26],[31,32]>,
  <[1],[5],[],[31],[2],[6],[25,26],[32]>,
  <[1],[5],[],[31,32],[2],[6],[25,26],[]>,
  <[1],[5],[25],[],[2],[6],[26],[29,30]>,
  <[1],[5],[25],[29],[2],[6],[26],[30]>,
  <[1],[5],[25],[29,30],[2],[6],[26],[]>,
  <[1],[5],[25],[],[2],[6],[26],[31,32]>,
  <[1],[5],[25],[31],[2],[6],[26],[32]>,
  <[1],[5],[25],[31,32],[2],[6],[26],[]>,
  <[1],[5],[25,26],[],[2],[6],[],[29,30]>,
  <[1],[5],[25,26],[29],[2],[6],[],[30]>,
  <[1],[5],[25,26],[29,30],[2],[6],[],[]>,
  <[1],[5],[25,26],[],[2],[6],[],[31,32]>,
  <[1],[5],[25,26],[31],[2],[6],[],[32]>,
  <[1],[5],[25,26],[31,32],[2],[6],[],[]>,
  <[1],[5],[],[],[2],[6],[27,28],[29,30]>,
  <[1],[5],[],[29],[2],[6],[27,28],[30]>,
  <[1],[5],[],[29,30],[2],[6],[27,28],[]>,
  <[1],[5],[],[],[2],[6],[27,28],[31,32]>,
  <[1],[5],[],[31],[2],[6],[27,28],[32]>,
  <[1],[5],[],[31,32],[2],[6],[27,28],[]>,
  <[1],[5],[27],[],[2],[6],[28],[29,30]>,
  <[1],[5],[27],[29],[2],[6],[28],[30]>,
  <[1],[5],[27],[29,30],[2],[6],[28],[]>,
  <[1],[5],[27],[],[2],[6],[28],[31,32]>,
  <[1],[5],[27],[31],[2],[6],[28],[32]>,
  <[1],[5],[27],[31,32],[2],[6],[28],[]>,
  <[1],[5],[27,28],[],[2],[6],[],[29,30]>,
  <[1],[5],[27,28],[29],[2],[6],[],[30]>,
  <[1],[5],[27,28],[29,30],[2],[6],[],[]>,
  <[1],[5],[27,28],[],[2],[6],[],[31,32]>,
  <[1],[5],[27,28],[31],[2],[6],[],[32]>,
  <[1],[5],[27,28],[31,32],[2],[6],[],[]>,
  <[1],[5,6],[],[],[2],[],[17,18],[21,22]>,
  <[1],[5,6],[],[21],[2],[],[17,18],[22]>,
  <[1],[5,6],[],[21,22],[2],[],[17,18],[]>,
  <[1],[5,6],[],[],[2],[],[17,18],[23,24]>,
  <[1],[5,6],[],[23],[2],[],[17,18],[24]>,
  <[1],[5,6],[],[23,24],[2],[],[17,18],[]>,
  <[1],[5,6],[17],[],[2],[],[18],[21,22]>,
  <[1],[5,6],[17],[21],[2],[],[18],[22]>,
  <[1],[5,6],[17],[21,22],[2],[],[18],[]>,
  <[1],[5,6],[17],[],[2],[],[18],[23,24]>,
  <[1],[5,6],[17],[23],[2],[],[18],[24]>,
  <[1],[5,6],[17],[23,24],[2],[],[18],[]>,
  <[1],[5,6],[17,18],[],[2],[],[],[21,22]>,
  <[1],[5,6],[17,18],[21],[2],[],[],[22]>,
  <[1],[5,6],[17,18],[21,22],[2],[],[],[]>,
  <[1],[5,6],[17,18],[],[2],[],[],[23,24]>,
  <[1],[5,6],[17,18],[23],[2],[],[],[24]>,
  <[1],[5,6],[17,18],[23,24],[2],[],[],[]>,
  <[1],[5,6],[],[],[2],[],[19,20],[21,22]>,
  <[1],[5,6],[],[21],[2],[],[19,20],[22]>,
  <[1],[5,6],[],[21,22],[2],[],[19,20],[]>,
  <[1],[5,6],[],[],[2],[],[19,20],[23,24]>,
  <[1],[5,6],[],[23],[2],[],[19,20],[24]>,
  <[1],[5,6],[],[23,24],[2],[],[19,20],[]>,
  <[1],[5,6],[19],[],[2],[],[20],[21,22]>,
  <[1],[5,6],[19],[21],[2],[],[20],[22]>,
  <[1],[5,6],[19],[21,22],[2],[],[20],[]>,
  <[1],[5,6],[19],[],[2],[],[20],[23,24]>,
  <[1],[5,6],[19],[23],[2],[],[20],[24]>,
  <[1],[5,6],[19],[23,24],[2],[],[20],[]>,
  <[1],[5,6],[19,20],[],[2],[],[],[21,22]>,
  <[1],[5,6],[19,20],[21],[2],[],[],[22]>,
  <[1],[5,6],[19,20],[21,22],[2],[],[],[]>,
  <[1],[5,6],[19,20],[],[2],[],[],[23,24]>,
  <[1],[5,6],[19,20],[23],[2],[],[],[24]>,
  <[1],[5,6],[19,20],[23,24],[2],[],[],[]>,
  <[1],[5,6],[],[],[2],[],[25,26],[29,30]>,
  <[1],[5,6],[],[29],[2],[],[25,26],[30]>,
  <[1],[5,6],[],[29,30],[2],[],[25,26],[]>,
  <[1],[5,6],[],[],[2],[],[25,26],[31,32]>,
  <[1],[5,6],[],[31],[2],[],[25,26],[32]>,
  <[1],[5,6],[],[31,32],[2],[],[25,26],[]>,
  <[1],[5,6],[25],[],[2],[],[26],[29,30]>,
  <[1],[5,6],[25],[29],[2],[],[26],[30]>,
  <[1],[5,6],[25],[29,30],[2],[],[26],[]>,
  <[1],[5,6],[25],[],[2],[],[26],[31,32]>,
  <[1],[5,6],[25],[31],[2],[],[26],[32]>,
  <[1],[5,6],[25],[31,32],[2],[],[26],[]>,
  <[1],[5,6],[25,26],[],[2],[],[],[29,30]>,
  <[1],[5,6],[25,26],[29],[2],[],[],[30]>,
  <[1],[5,6],[25,26],[29,30],[2],[],[],[]>,
  <[1],[5,6],[25,26],[],[2],[],[],[31,32]>,
  <[1],[5,6],[25,26],[31],[2],[],[],[32]>,
  <[1],[5,6],[25,26],[31,32],[2],[],[],[]>,
  <[1],[5,6],[],[],[2],[],[27,28],[29,30]>,
  <[1],[5,6],[],[29],[2],[],[27,28],[30]>,
  <[1],[5,6],[],[29,30],[2],[],[27,28],[]>,
  <[1],[5,6],[],[],[2],[],[27,28],[31,32]>,
  <[1],[5,6],[],[31],[2],[],[27,28],[32]>,
  <[1],[5,6],[],[31,32],[2],[],[27,28],[]>,
  <[1],[5,6],[27],[],[2],[],[28],[29,30]>,
  <[1],[5,6],[27],[29],[2],[],[28],[30]>,
  <[1],[5,6],[27],[29,30],[2],[],[28],[]>,
  <[1],[5,6],[27],[],[2],[],[28],[31,32]>,
  <[1],[5,6],[27],[31],[2],[],[28],[32]>,
  <[1],[5,6],[27],[31,32],[2],[],[28],[]>,
  <[1],[5,6],[27,28],[],[2],[],[],[29,30]>,
  <[1],[5,6],[27,28],[29],[2],[],[],[30]>,
  <[1],[5,6],[27,28],[29,30],[2],[],[],[]>,
  <[1],[5,6],[27,28],[],[2],[],[],[31,32]>,
  <[1],[5,6],[27,28],[31],[2],[],[],[32]>,
  <[1],[5,6],[27,28],[31,32],[2],[],[],[]>,
  <[1],[],[],[],[2],[7,8],[17,18],[21,22]>,
  <[1],[],[],[21],[2],[7,8],[17,18],[22]>,
  <[1],[],[],[21,22],[2],[7,8],[17,18],[]>,
  <[1],[],[],[],[2],[7,8],[17,18],[23,24]>,
  <[1],[],[],[23],[2],[7,8],[17,18],[24]>,
  <[1],[],[],[23,24],[2],[7,8],[17,18],[]>,
  <[1],[],[17],[],[2],[7,8],[18],[21,22]>,
  <[1],[],[17],[21],[2],[7,8],[18],[22]>,
  <[1],[],[17],[21,22],[2],[7,8],[18],[]>,
  <[1],[],[17],[],[2],[7,8],[18],[23,24]>,
  <[1],[],[17],[23],[2],[7,8],[18],[24]>,
  <[1],[],[17],[23,24],[2],[7,8],[18],[]>,
  <[1],[],[17,18],[],[2],[7,8],[],[21,22]>,
  <[1],[],[17,18],[21],[2],[7,8],[],[22]>,
  <[1],[],[17,18],[21,22],[2],[7,8],[],[]>,
  <[1],[],[17,18],[],[2],[7,8],[],[23,24]>,
  <[1],[],[17,18],[23],[2],[7,8],[],[24]>,
  <[1],[],[17,18],[23,24],[2],[7,8],[],[]>,
  <[1],[],[],[],[2],[7,8],[19,20],[21,22]>,
  <[1],[],[],[21],[2],[7,8],[19,20],[22]>,
  <[1],[],[],[21,22],[2],[7,8],[19,20],[]>,
  <[1],[],[],[],[2],[7,8],[19,20],[23,24]>,
  <[1],[],[],[23],[2],[7,8],[19,20],[24]>,
  <[1],[],[],[23,24],[2],[7,8],[19,20],[]>,
  <[1],[],[19],[],[2],[7,8],[20],[21,22]>,
  <[1],[],[19],[21],[2],[7,8],[20],[22]>,
  <[1],[],[19],[21,22],[2],[7,8],[20],[]>,
  <[1],[],[19],[],[2],[7,8],[20],[23,24]>,
  <[1],[],[19],[23],[2],[7,8],[20],[24]>,
  <[1],[],[19],[23,24],[2],[7,8],[20],[]>,
  <[1],[],[19,20],[],[2],[7,8],[],[21,22]>,
  <[1],[],[19,20],[21],[2],[7,8],[],[22]>,
  <[1],[],[19,20],[21,22],[2],[7,8],[],[]>,
  <[1],[],[19,20],[],[2],[7,8],[],[23,24]>,
  <[1],[],[19,20],[23],[2],[7,8],[],[24]>,
  <[1],[],[19,20],[23,24],[2],[7,8],[],[]>,
  <[1],[],[],[],[2],[7,8],[25,26],[29,30]>,
  <[1],[],[],[29],[2],[7,8],[25,26],[30]>,
  <[1],[],[],[29,30],[2],[7,8],[25,26],[]>,
  <[1],[],[],[],[2],[7,8],[25,26],[31,32]>,
  <[1],[],[],[31],[2],[7,8],[25,26],[32]>,
  <[1],[],[],[31,32],[2],[7,8],[25,26],[]>,
  <[1],[],[25],[],[2],[7,8],[26],[29,30]>,
  <[1],[],[25],[29],[2],[7,8],[26],[30]>,
  <[1],[],[25],[29,30],[2],[7,8],[26],[]>,
  <[1],[],[25],[],[2],[7,8],[26],[31,32]>,
  <[1],[],[25],[31],[2],[7,8],[26],[32]>,
  <[1],[],[25],[31,32],[2],[7,8],[26],[]>,
  <[1],[],[25,26],[],[2],[7,8],[],[29,30]>,
  <[1],[],[25,26],[29],[2],[7,8],[],[30]>,
  <[1],[],[25,26],[29,30],[2],[7,8],[],[]>,
  <[1],[],[25,26],[],[2],[7,8],[],[31,32]>,
  <[1],[],[25,26],[31],[2],[7,8],[],[32]>,
  <[1],[],[25,26],[31,32],[2],[7,8],[],[]>,
  <[1],[],[],[],[2],[7,8],[27,28],[29,30]>,
  <[1],[],[],[29],[2],[7,8],[27,28],[30]>,
  <[1],[],[],[29,30],[2],[7,8],[27,28],[]>,
  <[1],[],[],[],[2],[7,8],[27,28],[31,32]>,
  <[1],[],[],[31],[2],[7,8],[27,28],[32]>,
  <[1],[],[],[31,32],[2],[7,8],[27,28],[]>,
  <[1],[],[27],[],[2],[7,8],[28],[29,30]>,
  <[1],[],[27],[29],[2],[7,8],[28],[30]>,
  <[1],[],[27],[29,30],[2],[7,8],[28],[]>,
  <[1],[],[27],[],[2],[7,8],[28],[31,32]>,
  <[1],[],[27],[31],[2],[7,8],[28],[32]>,
  <[1],[],[27],[31,32],[2],[7,8],[28],[]>,
  <[1],[],[27,28],[],[2],[7,8],[],[29,30]>,
  <[1],[],[27,28],[29],[2],[7,8],[],[30]>,
  <[1],[],[27,28],[29,30],[2],[7,8],[],[]>,
  <[1],[],[27,28],[],[2],[7,8],[],[31,32]>,
  <[1],[],[27,28],[31],[2],[7,8],[],[32]>,
  <[1],[],[27,28],[31,32],[2],[7,8],[],[]>,
  <[1],[7],[],[],[2],[8],[17,18],[21,22]>,
  <[1],[7],[],[21],[2],[8],[17,18],[22]>,
  <[1],[7],[],[21,22],[2],[8],[17,18],[]>,
  <[1],[7],[],[],[2],[8],[17,18],[23,24]>,
  <[1],[7],[],[23],[2],[8],[17,18],[24]>,
  <[1],[7],[],[23,24],[2],[8],[17,18],[]>,
  <[1],[7],[17],[],[2],[8],[18],[21,22]>,
  <[1],[7],[17],[21],[2],[8],[18],[22]>,
  <[1],[7],[17],[21,22],[2],[8],[18],[]>,
  <[1],[7],[17],[],[2],[8],[18],[23,24]>,
  <[1],[7],[17],[23],[2],[8],[18],[24]>,
  <[1],[7],[17],[23,24],[2],[8],[18],[]>,
  <[1],[7],[17,18],[],[2],[8],[],[21,22]>,
  <[1],[7],[17,18],[21],[2],[8],[],[22]>,
  <[1],[7],[17,18],[21,22],[2],[8],[],[]>,
  <[1],[7],[17,18],[],[2],[8],[],[23,24]>,
  <[1],[7],[17,18],[23],[2],[8],[],[24]>,
  <[1],[7],[17,18],[23,24],[2],[8],[],[]>,
  <[1],[7],[],[],[2],[8],[19,20],[21,22]>,
  <[1],[7],[],[21],[2],[8],[19,20],[22]>,
  <[1],[7],[],[21,22],[2],[8],[19,20],[]>,
  <[1],[7],[],[],[2],[8],[19,20],[23,24]>,
  <[1],[7],[],[23],[2],[8],[19,20],[24]>,
  <[1],[7],[],[23,24],[2],[8],[19,20],[]>,
  <[1],[7],[19],[],[2],[8],[20],[21,22]>,
  <[1],[7],[19],[21],[2],[8],[20],[22]>,
  <[1],[7],[19],[21,22],[2],[8],[20],[]>,
  <[1],[7],[19],[],[2],[8],[20],[23,24]>,
  <[1],[7],[19],[23],[2],[8],[20],[24]>,
  <[1],[7],[19],[23,24],[2],[8],[20],[]>,
  <[1],[7],[19,20],[],[2],[8],[],[21,22]>,
  <[1],[7],[19,20],[21],[2],[8],[],[22]>,
  <[1],[7],[19,20],[21,22],[2],[8],[],[]>,
  <[1],[7],[19,20],[],[2],[8],[],[23,24]>,
  <[1],[7],[19,20],[23],[2],[8],[],[24]>,
  <[1],[7],[19,20],[23,24],[2],[8],[],[]>,
  <[1],[7],[],[],[2],[8],[25,26],[29,30]>,
  <[1],[7],[],[29],[2],[8],[25,26],[30]>,
  <[1],[7],[],[29,30],[2],[8],[25,26],[]>,
  <[1],[7],[],[],[2],[8],[25,26],[31,32]>,
  <[1],[7],[],[31],[2],[8],[25,26],[32]>,
  <[1],[7],[],[31,32],[2],[8],[25,26],[]>,
  <[1],[7],[25],[],[2],[8],[26],[29,30]>,
  <[1],[7],[25],[29],[2],[8],[26],[30]>,
  <[1],[7],[25],[29,30],[2],[8],[26],[]>,
  <[1],[7],[25],[],[2],[8],[26],[31,32]>,
  <[1],[7],[25],[31],[2],[8],[26],[32]>,
  <[1],[7],[25],[31,32],[2],[8],[26],[]>,
  <[1],[7],[25,26],[],[2],[8],[],[29,30]>,
  <[1],[7],[25,26],[29],[2],[8],[],[30]>,
  <[1],[7],[25,26],[29,30],[2],[8],[],[]>,
  <[1],[7],[25,26],[],[2],[8],[],[31,32]>,
  <[1],[7],[25,26],[31],[2],[8],[],[32]>,
  <[1],[7],[25,26],[31,32],[2],[8],[],[]>,
  <[1],[7],[],[],[2],[8],[27,28],[29,30]>,
  <[1],[7],[],[29],[2],[8],[27,28],[30]>,
  <[1],[7],[],[29,30],[2],[8],[27,28],[]>,
  <[1],[7],[],[],[2],[8],[27,28],[31,32]>,
  <[1],[7],[],[31],[2],[8],[27,28],[32]>,
  <[1],[7],[],[31,32],[2],[8],[27,28],[]>,
  <[1],[7],[27],[],[2],[8],[28],[29,30]>,
  <[1],[7],[27],[29],[2],[8],[28],[30]>,
  <[1],[7],[27],[29,30],[2],[8],[28],[]>,
  <[1],[7],[27],[],[2],[8],[28],[31,32]>,
  <[1],[7],[27],[31],[2],[8],[28],[32]>,
  <[1],[7],[27],[31,32],[2],[8],[28],[]>,
  <[1],[7],[27,28],[],[2],[8],[],[29,30]>,
  <[1],[7],[27,28],[29],[2],[8],[],[30]>,
  <[1],[7],[27,28],[29,30],[2],[8],[],[]>,
  <[1],[7],[27,28],[],[2],[8],[],[31,32]>,
  <[1],[7],[27,28],[31],[2],[8],[],[32]>,
  <[1],[7],[27,28],[31,32],[2],[8],[],[]>,
  <[1],[7,8],[],[],[2],[],[17,18],[21,22]>,
  <[1],[7,8],[],[21],[2],[],[17,18],[22]>,
  <[1],[7,8],[],[21,22],[2],[],[17,18],[]>,
  <[1],[7,8],[],[],[2],[],[17,18],[23,24]>,
  <[1],[7,8],[],[23],[2],[],[17,18],[24]>,
  <[1],[7,8],[],[23,24],[2],[],[17,18],[]>,
  <[1],[7,8],[17],[],[2],[],[18],[21,22]>,
  <[1],[7,8],[17],[21],[2],[],[18],[22]>,
  <[1],[7,8],[17],[21,22],[2],[],[18],[]>,
  <[1],[7,8],[17],[],[2],[],[18],[23,24]>,
  <[1],[7,8],[17],[23],[2],[],[18],[24]>,
  <[1],[7,8],[17],[23,24],[2],[],[18],[]>,
  <[1],[7,8],[17,18],[],[2],[],[],[21,22]>,
  <[1],[7,8],[17,18],[21],[2],[],[],[22]>,
  <[1],[7,8],[17,18],[21,22],[2],[],[],[]>,
  <[1],[7,8],[17,18],[],[2],[],[],[23,24]>,
  <[1],[7,8],[17,18],[23],[2],[],[],[24]>,
  <[1],[7,8],[17,18],[23,24],[2],[],[],[]>,
  <[1],[7,8],[],[],[2],[],[19,20],[21,22]>,
  <[1],[7,8],[],[21],[2],[],[19,20],[22]>,
  <[1],[7,8],[],[21,22],[2],[],[19,20],[]>,
  <[1],[7,8],[],[],[2],[],[19,20],[23,24]>,
  <[1],[7,8],[],[23],[2],[],[19,20],[24]>,
  <[1],[7,8],[],[23,24],[2],[],[19,20],[]>,
  <[1],[7,8],[19],[],[2],[],[20],[21,22]>,
  <[1],[7,8],[19],[21],[2],[],[20],[22]>,
  <[1],[7,8],[19],[21,22],[2],[],[20],[]>,
  <[1],[7,8],[19],[],[2],[],[20],[23,24]>,
  <[1],[7,8],[19],[23],[2],[],[20],[24]>,
  <[1],[7,8],[19],[23,24],[2],[],[20],[]>,
  <[1],[7,8],[19,20],[],[2],[],[],[21,22]>,
  <[1],[7,8],[19,20],[21],[2],[],[],[22]>,
  <[1],[7,8],[19,20],[21,22],[2],[],[],[]>,
  <[1],[7,8],[19,20],[],[2],[],[],[23,24]>,
  <[1],[7,8],[19,20],[23],[2],[],[],[24]>,
  <[1],[7,8],[19,20],[23,24],[2],[],[],[]>,
  <[1],[7,8],[],[],[2],[],[25,26],[29,30]>,
  <[1],[7,8],[],[29],[2],[],[25,26],[30]>,
  <[1],[7,8],[],[29,30],[2],[],[25,26],[]>,
  <[1],[7,8],[],[],[2],[],[25,26],[31,32]>,
  <[1],[7,8],[],[31],[2],[],[25,26],[32]>,
  <[1],[7,8],[],[31,32],[2],[],[25,26],[]>,
  <[1],[7,8],[25],[],[2],[],[26],[29,30]>,
  <[1],[7,8],[25],[29],[2],[],[26],[30]>,
  <[1],[7,8],[25],[29,30],[2],[],[26],[]>,
  <[1],[7,8],[25],[],[2],[],[26],[31,32]>,
  <[1],[7,8],[25],[31],[2],[],[26],[32]>,
  <[1],[7,8],[25],[31,32],[2],[],[26],[]>,
  <[1],[7,8],[25,26],[],[2],[],[],[29,30]>,
  <[1],[7,8],[25,26],[29],[2],[],[],[30]>,
  <[1],[7,8],[25,26],[29,30],[2],[],[],[]>,
  <[1],[7,8],[25,26],[],[2],[],[],[31,32]>,
  <[1],[7,8],[25,26],[31],[2],[],[],[32]>,
  <[1],[7,8],[25,26],[31,32],[2],[],[],[]>,
  <[1],[7,8],[],[],[2],[],[27,28],[29,30]>,
  <[1],[7,8],[],[29],[2],[],[27,28],[30]>,
  <[1],[7,8],[],[29,30],[2],[],[27,28],[]>,
  <[1],[7,8],[],[],[2],[],[27,28],[31,32]>,
  <[1],[7,8],[],[31],[2],[],[27,28],[32]>,
  <[1],[7,8],[],[31,32],[2],[],[27,28],[]>,
  <[1],[7,8],[27],[],[2],[],[28],[29,30]>,
  <[1],[7,8],[27],[29],[2],[],[28],[30]>,
  <[1],[7,8],[27],[29,30],[2],[],[28],[]>,
  <[1],[7,8],[27],[],[2],[],[28],[31,32]>,
  <[1],[7,8],[27],[31],[2],[],[28],[32]>,
  <[1],[7,8],[27],[31,32],[2],[],[28],[]>,
  <[1],[7,8],[27,28],[],[2],[],[],[29,30]>,
  <[1],[7,8],[27,28],[29],[2],[],[],[30]>,
  <[1],[7,8],[27,28],[29,30],[2],[],[],[]>,
  <[1],[7,8],[27,28],[],[2],[],[],[31,32]>,
  <[1],[7,8],[27,28],[31],[2],[],[],[32]>,
  <[1],[7,8],[27,28],[31,32],[2],[],[],[]>,
  <[1,2],[],[],[],[],[5,6],[17,18],[21,22]>,
  <[1,2],[],[],[21],[],[5,6],[17,18],[22]>,
  <[1,2],[],[],[21,22],[],[5,6],[17,18],[]>,
  <[1,2],[],[],[],[],[5,6],[17,18],[23,24]>,
  <[1,2],[],[],[23],[],[5,6],[17,18],[24]>,
  <[1,2],[],[],[23,24],[],[5,6],[17,18],[]>,
  <[1,2],[],[17],[],[],[5,6],[18],[21,22]>,
  <[1,2],[],[17],[21],[],[5,6],[18],[22]>,
  <[1,2],[],[17],[21,22],[],[5,6],[18],[]>,
  <[1,2],[],[17],[],[],[5,6],[18],[23,24]>,
  <[1,2],[],[17],[23],[],[5,6],[18],[24]>,
  <[1,2],[],[17],[23,24],[],[5,6],[18],[]>,
  <[1,2],[],[17,18],[],[],[5,6],[],[21,22]>,
  <[1,2],[],[17,18],[21],[],[5,6],[],[22]>,
  <[1,2],[],[17,18],[21,22],[],[5,6],[],[]>,
  <[1,2],[],[17,18],[],[],[5,6],[],[23,24]>,
  <[1,2],[],[17,18],[23],[],[5,6],[],[24]>,
  <[1,2],[],[17,18],[23,24],[],[5,6],[],[]>,
  <[1,2],[],[],[],[],[5,6],[19,20],[21,22]>,
  <[1,2],[],[],[21],[],[5,6],[19,20],[22]>,
  <[1,2],[],[],[21,22],[],[5,6],[19,20],[]>,
  <[1,2],[],[],[],[],[5,6],[19,20],[23,24]>,
  <[1,2],[],[],[23],[],[5,6],[19,20],[24]>,
  <[1,2],[],[],[23,24],[],[5,6],[19,20],[]>,
  <[1,2],[],[19],[],[],[5,6],[20],[21,22]>,
  <[1,2],[],[19],[21],[],[5,6],[20],[22]>,
  <[1,2],[],[19],[21,22],[],[5,6],[20],[]>,
  <[1,2],[],[19],[],[],[5,6],[20],[23,24]>,
  <[1,2],[],[19],[23],[],[5,6],[20],[24]>,
  <[1,2],[],[19],[23,24],[],[5,6],[20],[]>,
  <[1,2],[],[19,20],[],[],[5,6],[],[21,22]>,
  <[1,2],[],[19,20],[21],[],[5,6],[],[22]>,
  <[1,2],[],[19,20],[21,22],[],[5,6],[],[]>,
  <[1,2],[],[19,20],[],[],[5,6],[],[23,24]>,
  <[1,2],[],[19,20],[23],[],[5,6],[],[24]>,
  <[1,2],[],[19,20],[23,24],[],[5,6],[],[]>,
  <[1,2],[],[],[],[],[5,6],[25,26],[29,30]>,
  <[1,2],[],[],[29],[],[5,6],[25,26],[30]>,
  <[1,2],[],[],[29,30],[],[5,6],[25,26],[]>,
  <[1,2],[],[],[],[],[5,6],[25,26],[31,32]>,
  <[1,2],[],[],[31],[],[5,6],[25,26],[32]>,
  <[1,2],[],[],[31,32],[],[5,6],[25,26],[]>,
  <[1,2],[],[25],[],[],[5,6],[26],[29,30]>,
  <[1,2],[],[25],[29],[],[5,6],[26],[30]>,
  <[1,2],[],[25],[29,30],[],[5,6],[26],[]>,
  <[1,2],[],[25],[],[],[5,6],[26],[31,32]>,
  <[1,2],[],[25],[31],[],[5,6],[26],[32]>,
  <[1,2],[],[25],[31,32],[],[5,6],[26],[]>,
  <[1,2],[],[25,26],[],[],[5,6],[],[29,30]>,
  <[1,2],[],[25,26],[29],[],[5,6],[],[30]>,
  <[1,2],[],[25,26],[29,30],[],[5,6],[],[]>,
  <[1,2],[],[25,26],[],[],[5,6],[],[31,32]>,
  <[1,2],[],[25,26],[31],[],[5,6],[],[32]>,
  <[1,2],[],[25,26],[31,32],[],[5,6],[],[]>,
  <[1,2],[],[],[],[],[5,6],[27,28],[29,30]>,
  <[1,2],[],[],[29],[],[5,6],[27,28],[30]>,
  <[1,2],[],[],[29,30],[],[5,6],[27,28],[]>,
  <[1,2],[],[],[],[],[5,6],[27,28],[31,32]>,
  <[1,2],[],[],[31],[],[5,6],[27,28],[32]>,
  <[1,2],[],[],[31,32],[],[5,6],[27,28],[]>,
  <[1,2],[],[27],[],[],[5,6],[28],[29,30]>,
  <[1,2],[],[27],[29],[],[5,6],[28],[30]>,
  <[1,2],[],[27],[29,30],[],[5,6],[28],[]>,
  <[1,2],[],[27],[],[],[5,6],[28],[31,32]>,
  <[1,2],[],[27],[31],[],[5,6],[28],[32]>,
  <[1,2],[],[27],[31,32],[],[5,6],[28],[]>,
  <[1,2],[],[27,28],[],[],[5,6],[],[29,30]>,
  <[1,2],[],[27,28],[29],[],[5,6],[],[30]>,
  <[1,2],[],[27,28],[29,30],[],[5,6],[],[]>,
  <[1,2],[],[27,28],[],[],[5,6],[],[31,32]>,
  <[1,2],[],[27,28],[31],[],[5,6],[],[32]>,
  <[1,2],[],[27,28],[31,32],[],[5,6],[],[]>,
  <[1,2],[5],[],[],[],[6],[17,18],[21,22]>,
  <[1,2],[5],[],[21],[],[6],[17,18],[22]>,
  <[1,2],[5],[],[21,22],[],[6],[17,18],[]>,
  <[1,2],[5],[],[],[],[6],[17,18],[23,24]>,
  <[1,2],[5],[],[23],[],[6],[17,18],[24]>,
  <[1,2],[5],[],[23,24],[],[6],[17,18],[]>,
  <[1,2],[5],[17],[],[],[6],[18],[21,22]>,
  <[1,2],[5],[17],[21],[],[6],[18],[22]>,
  <[1,2],[5],[17],[21,22],[],[6],[18],[]>,
  <[1,2],[5],[17],[],[],[6],[18],[23,24]>,
  <[1,2],[5],[17],[23],[],[6],[18],[24]>,
  <[1,2],[5],[17],[23,24],[],[6],[18],[]>,
  <[1,2],[5],[17,18],[],[],[6],[],[21,22]>,
  <[1,2],[5],[17,18],[21],[],[6],[],[22]>,
  <[1,2],[5],[17,18],[21,22],[],[6],[],[]>,
  <[1,2],[5],[17,18],[],[],[6],[],[23,24]>,
  <[1,2],[5],[17,18],[23],[],[6],[],[24]>,
  <[1,2],[5],[17,18],[23,24],[],[6],[],[]>,
  <[1,2],[5],[],[],[],[6],[19,20],[21,22]>,
  <[1,2],[5],[],[21],[],[6],[19,20],[22]>,
  <[1,2],[5],[],[21,22],[],[6],[19,20],[]>,
  <[1,2],[5],[],[],[],[6],[19,20],[23,24]>,
  <[1,2],[5],[],[23],[],[6],[19,20],[24]>,
  <[1,2],[5],[],[23,24],[],[6],[19,20],[]>,
  <[1,2],[5],[19],[],[],[6],[20],[21,22]>,
  <[1,2],[5],[19],[21],[],[6],[20],[22]>,
  <[1,2],[5],[19],[21,22],[],[6],[20],[]>,
  <[1,2],[5],[19],[],[],[6],[20],[23,24]>,
  <[1,2],[5],[19],[23],[],[6],[20],[24]>,
  <[1,2],[5],[19],[23,24],[],[6],[20],[]>,
  <[1,2],[5],[19,20],[],[],[6],[],[21,22]>,
  <[1,2],[5],[19,20],[21],[],[6],[],[22]>,
  <[1,2],[5],[19,20],[21,22],[],[6],[],[]>,
  <[1,2],[5],[19,20],[],[],[6],[],[23,24]>,
  <[1,2],[5],[19,20],[23],[],[6],[],[24]>,
  <[1,2],[5],[19,20],[23,24],[],[6],[],[]>,
  <[1,2],[5],[],[],[],[6],[25,26],[29,30]>,
  <[1,2],[5],[],[29],[],[6],[25,26],[30]>,
  <[1,2],[5],[],[29,30],[],[6],[25,26],[]>,
  <[1,2],[5],[],[],[],[6],[25,26],[31,32]>,
  <[1,2],[5],[],[31],[],[6],[25,26],[32]>,
  <[1,2],[5],[],[31,32],[],[6],[25,26],[]>,
  <[1,2],[5],[25],[],[],[6],[26],[29,30]>,
  <[1,2],[5],[25],[29],[],[6],[26],[30]>,
  <[1,2],[5],[25],[29,30],[],[6],[26],[]>,
  <[1,2],[5],[25],[],[],[6],[26],[31,32]>,
  <[1,2],[5],[25],[31],[],[6],[26],[32]>,
  <[1,2],[5],[25],[31,32],[],[6],[26],[]>,
  <[1,2],[5],[25,26],[],[],[6],[],[29,30]>,
  <[1,2],[5],[25,26],[29],[],[6],[],[30]>,
  <[1,2],[5],[25,26],[29,30],[],[6],[],[]>,
  <[1,2],[5],[25,26],[],[],[6],[],[31,32]>,
  <[1,2],[5],[25,26],[31],[],[6],[],[32]>,
  <[1,2],[5],[25,26],[31,32],[],[6],[],[]>,
  <[1,2],[5],[],[],[],[6],[27,28],[29,30]>,
  <[1,2],[5],[],[29],[],[6],[27,28],[30]>,
  <[1,2],[5],[],[29,30],[],[6],[27,28],[]>,
  <[1,2],[5],[],[],[],[6],[27,28],[31,32]>,
  <[1,2],[5],[],[31],[],[6],[27,28],[32]>,
  <[1,2],[5],[],[31,32],[],[6],[27,28],[]>,
  <[1,2],[5],[27],[],[],[6],[28],[29,30]>,
  <[1,2],[5],[27],[29],[],[6],[28],[30]>,
  <[1,2],[5],[27],[29,30],[],[6],[28],[]>,
  <[1,2],[5],[27],[],[],[6],[28],[31,32]>,
  <[1,2],[5],[27],[31],[],[6],[28],[32]>,
  <[1,2],[5],[27],[31,32],[],[6],[28],[]>,
  <[1,2],[5],[27,28],[],[],[6],[],[29,30]>,
  <[1,2],[5],[27,28],[29],[],[6],[],[30]>,
  <[1,2],[5],[27,28],[29,30],[],[6],[],[]>,
  <[1,2],[5],[27,28],[],[],[6],[],[31,32]>,
  <[1,2],[5],[27,28],[31],[],[6],[],[32]>,
  <[1,2],[5],[27,28],[31,32],[],[6],[],[]>,
  <[1,2],[5,6],[],[],[],[],[17,18],[21,22]>,
  <[1,2],[5,6],[],[21],[],[],[17,18],[22]>,
  <[1,2],[5,6],[],[21,22],[],[],[17,18],[]>,
  <[1,2],[5,6],[],[],[],[],[17,18],[23,24]>,
  <[1,2],[5,6],[],[23],[],[],[17,18],[24]>,
  <[1,2],[5,6],[],[23,24],[],[],[17,18],[]>,
  <[1,2],[5,6],[17],[],[],[],[18],[21,22]>,
  <[1,2],[5,6],[17],[21],[],[],[18],[22]>,
  <[1,2],[5,6],[17],[21,22],[],[],[18],[]>,
  <[1,2],[5,6],[17],[],[],[],[18],[23,24]>,
  <[1,2],[5,6],[17],[23],[],[],[18],[24]>,
  <[1,2],[5,6],[17],[23,24],[],[],[18],[]>,
  <[1,2],[5,6],[17,18],[],[],[],[],[21,22]>,
  <[1,2],[5,6],[17,18],[21],[],[],[],[22]>,
  <[1,2],[5,6],[17,18],[21,22],[],[],[],[]>,
  <[1,2],[5,6],[17,18],[],[],[],[],[23,24]>,
  <[1,2],[5,6],[17,18],[23],[],[],[],[24]>,
  <[1,2],[5,6],[17,18],[23,24],[],[],[],[]>,
  <[1,2],[5,6],[],[],[],[],[19,20],[21,22]>,
  <[1,2],[5,6],[],[21],[],[],[19,20],[22]>,
  <[1,2],[5,6],[],[21,22],[],[],[19,20],[]>,
  <[1,2],[5,6],[],[],[],[],[19,20],[23,24]>,
  <[1,2],[5,6],[],[23],[],[],[19,20],[24]>,
  <[1,2],[5,6],[],[23,24],[],[],[19,20],[]>,
  <[1,2],[5,6],[19],[],[],[],[20],[21,22]>,
  <[1,2],[5,6],[19],[21],[],[],[20],[22]>,
  <[1,2],[5,6],[19],[21,22],[],[],[20],[]>,
  <[1,2],[5,6],[19],[],[],[],[20],[23,24]>,
  <[1,2],[5,6],[19],[23],[],[],[20],[24]>,
  <[1,2],[5,6],[19],[23,24],[],[],[20],[]>,
  <[1,2],[5,6],[19,20],[],[],[],[],[21,22]>,
  <[1,2],[5,6],[19,20],[21],[],[],[],[22]>,
  <[1,2],[5,6],[19,20],[21,22],[],[],[],[]>,
  <[1,2],[5,6],[19,20],[],[],[],[],[23,24]>,
  <[1,2],[5,6],[19,20],[23],[],[],[],[24]>,
  <[1,2],[5,6],[19,20],[23,24],[],[],[],[]>,
  <[1,2],[5,6],[],[],[],[],[25,26],[29,30]>,
  <[1,2],[5,6],[],[29],[],[],[25,26],[30]>,
  <[1,2],[5,6],[],[29,30],[],[],[25,26],[]>,
  <[1,2],[5,6],[],[],[],[],[25,26],[31,32]>,
  <[1,2],[5,6],[],[31],[],[],[25,26],[32]>,
  <[1,2],[5,6],[],[31,32],[],[],[25,26],[]>,
  <[1,2],[5,6],[25],[],[],[],[26],[29,30]>,
  <[1,2],[5,6],[25],[29],[],[],[26],[30]>,
  <[1,2],[5,6],[25],[29,30],[],[],[26],[]>,
  <[1,2],[5,6],[25],[],[],[],[26],[31,32]>,
  <[1,2],[5,6],[25],[31],[],[],[26],[32]>,
  <[1,2],[5,6],[25],[31,32],[],[],[26],[]>,
  <[1,2],[5,6],[25,26],[],[],[],[],[29,30]>,
  <[1,2],[5,6],[25,26],[29],[],[],[],[30]>,
  <[1,2],[5,6],[25,26],[29,30],[],[],[],[]>,
  <[1,2],[5,6],[25,26],[],[],[],[],[31,32]>,
  <[1,2],[5,6],[25,26],[31],[],[],[],[32]>,
  <[1,2],[5,6],[25,26],[31,32],[],[],[],[]>,
  <[1,2],[5,6],[],[],[],[],[27,28],[29,30]>,
  <[1,2],[5,6],[],[29],[],[],[27,28],[30]>,
  <[1,2],[5,6],[],[29,30],[],[],[27,28],[]>,
  <[1,2],[5,6],[],[],[],[],[27,28],[31,32]>,
  <[1,2],[5,6],[],[31],[],[],[27,28],[32]>,
  <[1,2],[5,6],[],[31,32],[],[],[27,28],[]>,
  <[1,2],[5,6],[27],[],[],[],[28],[29,30]>,
  <[1,2],[5,6],[27],[29],[],[],[28],[30]>,
  <[1,2],[5,6],[27],[29,30],[],[],[28],[]>,
  <[1,2],[5,6],[27],[],[],[],[28],[31,32]>,
  <[1,2],[5,6],[27],[31],[],[],[28],[32]>,
  <[1,2],[5,6],[27],[31,32],[],[],[28],[]>,
  <[1,2],[5,6],[27,28],[],[],[],[],[29,30]>,
  <[1,2],[5,6],[27,28],[29],[],[],[],[30]>,
  <[1,2],[5,6],[27,28],[29,30],[],[],[],[]>,
  <[1,2],[5,6],[27,28],[],[],[],[],[31,32]>,
  <[1,2],[5,6],[27,28],[31],[],[],[],[32]>,
  <[1,2],[5,6],[27,28],[31,32],[],[],[],[]>,
  <[1,2],[],[],[],[],[7,8],[17,18],[21,22]>,
  <[1,2],[],[],[21],[],[7,8],[17,18],[22]>,
  <[1,2],[],[],[21,22],[],[7,8],[17,18],[]>,
  <[1,2],[],[],[],[],[7,8],[17,18],[23,24]>,
  <[1,2],[],[],[23],[],[7,8],[17,18],[24]>,
  <[1,2],[],[],[23,24],[],[7,8],[17,18],[]>,
  <[1,2],[],[17],[],[],[7,8],[18],[21,22]>,
  <[1,2],[],[17],[21],[],[7,8],[18],[22]>,
  <[1,2],[],[17],[21,22],[],[7,8],[18],[]>,
  <[1,2],[],[17],[],[],[7,8],[18],[23,24]>,
  <[1,2],[],[17],[23],[],[7,8],[18],[24]>,
  <[1,2],[],[17],[23,24],[],[7,8],[18],[]>,
  <[1,2],[],[17,18],[],[],[7,8],[],[21,22]>,
  <[1,2],[],[17,18],[21],[],[7,8],[],[22]>,
  <[1,2],[],[17,18],[21,22],[],[7,8],[],[]>,
  <[1,2],[],[17,18],[],[],[7,8],[],[23,24]>,
  <[1,2],[],[17,18],[23],[],[7,8],[],[24]>,
  <[1,2],[],[17,18],[23,24],[],[7,8],[],[]>,
  <[1,2],[],[],[],[],[7,8],[19,20],[21,22]>,
  <[1,2],[],[],[21],[],[7,8],[19,20],[22]>,
  <[1,2],[],[],[21,22],[],[7,8],[19,20],[]>,
  <[1,2],[],[],[],[],[7,8],[19,20],[23,24]>,
  <[1,2],[],[],[23],[],[7,8],[19,20],[24]>,
  <[1,2],[],[],[23,24],[],[7,8],[19,20],[]>,
  <[1,2],[],[19],[],[],[7,8],[20],[21,22]>,
  <[1,2],[],[19],[21],[],[7,8],[20],[22]>,
  <[1,2],[],[19],[21,22],[],[7,8],[20],[]>,
  <[1,2],[],[19],[],[],[7,8],[20],[23,24]>,
  <[1,2],[],[19],[23],[],[7,8],[20],[24]>,
  <[1,2],[],[19],[23,24],[],[7,8],[20],[]>,
  <[1,2],[],[19,20],[],[],[7,8],[],[21,22]>,
  <[1,2],[],[19,20],[21],[],[7,8],[],[22]>,
  <[1,2],[],[19,20],[21,22],[],[7,8],[],[]>,
  <[1,2],[],[19,20],[],[],[7,8],[],[23,24]>,
  <[1,2],[],[19,20],[23],[],[7,8],[],[24]>,
  <[1,2],[],[19,20],[23,24],[],[7,8],[],[]>,
  <[1,2],[],[],[],[],[7,8],[25,26],[29,30]>,
  <[1,2],[],[],[29],[],[7,8],[25,26],[30]>,
  <[1,2],[],[],[29,30],[],[7,8],[25,26],[]>,
  <[1,2],[],[],[],[],[7,8],[25,26],[31,32]>,
  <[1,2],[],[],[31],[],[7,8],[25,26],[32]>,
  <[1,2],[],[],[31,32],[],[7,8],[25,26],[]>,
  <[1,2],[],[25],[],[],[7,8],[26],[29,30]>,
  <[1,2],[],[25],[29],[],[7,8],[26],[30]>,
  <[1,2],[],[25],[29,30],[],[7,8],[26],[]>,
  <[1,2],[],[25],[],[],[7,8],[26],[31,32]>,
  <[1,2],[],[25],[31],[],[7,8],[26],[32]>,
  <[1,2],[],[25],[31,32],[],[7,8],[26],[]>,
  <[1,2],[],[25,26],[],[],[7,8],[],[29,30]>,
  <[1,2],[],[25,26],[29],[],[7,8],[],[30]>,
  <[1,2],[],[25,26],[29,30],[],[7,8],[],[]>,
  <[1,2],[],[25,26],[],[],[7,8],[],[31,32]>,
  <[1,2],[],[25,26],[31],[],[7,8],[],[32]>,
  <[1,2],[],[25,26],[31,32],[],[7,8],[],[]>,
  <[1,2],[],[],[],[],[7,8],[27,28],[29,30]>,
  <[1,2],[],[],[29],[],[7,8],[27,28],[30]>,
  <[1,2],[],[],[29,30],[],[7,8],[27,28],[]>,
  <[1,2],[],[],[],[],[7,8],[27,28],[31,32]>,
  <[1,2],[],[],[31],[],[7,8],[27,28],[32]>,
  <[1,2],[],[],[31,32],[],[7,8],[27,28],[]>,
  <[1,2],[],[27],[],[],[7,8],[28],[29,30]>,
  <[1,2],[],[27],[29],[],[7,8],[28],[30]>,
  <[1,2],[],[27],[29,30],[],[7,8],[28],[]>,
  <[1,2],[],[27],[],[],[7,8],[28],[31,32]>,
  <[1,2],[],[27],[31],[],[7,8],[28],[32]>,
  <[1,2],[],[27],[31,32],[],[7,8],[28],[]>,
  <[1,2],[],[27,28],[],[],[7,8],[],[29,30]>,
  <[1,2],[],[27,28],[29],[],[7,8],[],[30]>,
  <[1,2],[],[27,28],[29,30],[],[7,8],[],[]>,
  <[1,2],[],[27,28],[],[],[7,8],[],[31,32]>,
  <[1,2],[],[27,28],[31],[],[7,8],[],[32]>,
  <[1,2],[],[27,28],[31,32],[],[7,8],[],[]>,
  <[1,2],[7],[],[],[],[8],[17,18],[21,22]>,
  <[1,2],[7],[],[21],[],[8],[17,18],[22]>,
  <[1,2],[7],[],[21,22],[],[8],[17,18],[]>,
  <[1,2],[7],[],[],[],[8],[17,18],[23,24]>,
  <[1,2],[7],[],[23],[],[8],[17,18],[24]>,
  <[1,2],[7],[],[23,24],[],[8],[17,18],[]>,
  <[1,2],[7],[17],[],[],[8],[18],[21,22]>,
  <[1,2],[7],[17],[21],[],[8],[18],[22]>,
  <[1,2],[7],[17],[21,22],[],[8],[18],[]>,
  <[1,2],[7],[17],[],[],[8],[18],[23,24]>,
  <[1,2],[7],[17],[23],[],[8],[18],[24]>,
  <[1,2],[7],[17],[23,24],[],[8],[18],[]>,
  <[1,2],[7],[17,18],[],[],[8],[],[21,22]>,
  <[1,2],[7],[17,18],[21],[],[8],[],[22]>,
  <[1,2],[7],[17,18],[21,22],[],[8],[],[]>,
  <[1,2],[7],[17,18],[],[],[8],[],[23,24]>,
  <[1,2],[7],[17,18],[23],[],[8],[],[24]>,
  <[1,2],[7],[17,18],[23,24],[],[8],[],[]>,
  <[1,2],[7],[],[],[],[8],[19,20],[21,22]>,
  <[1,2],[7],[],[21],[],[8],[19,20],[22]>,
  <[1,2],[7],[],[21,22],[],[8],[19,20],[]>,
  <[1,2],[7],[],[],[],[8],[19,20],[23,24]>,
  <[1,2],[7],[],[23],[],[8],[19,20],[24]>,
  <[1,2],[7],[],[23,24],[],[8],[19,20],[]>,
  <[1,2],[7],[19],[],[],[8],[20],[21,22]>,
  <[1,2],[7],[19],[21],[],[8],[20],[22]>,
  <[1,2],[7],[19],[21,22],[],[8],[20],[]>,
  <[1,2],[7],[19],[],[],[8],[20],[23,24]>,
  <[1,2],[7],[19],[23],[],[8],[20],[24]>,
  <[1,2],[7],[19],[23,24],[],[8],[20],[]>,
  <[1,2],[7],[19,20],[],[],[8],[],[21,22]>,
  <[1,2],[7],[19,20],[21],[],[8],[],[22]>,
  <[1,2],[7],[19,20],[21,22],[],[8],[],[]>,
  <[1,2],[7],[19,20],[],[],[8],[],[23,24]>,
  <[1,2],[7],[19,20],[23],[],[8],[],[24]>,
  <[1,2],[7],[19,20],[23,24],[],[8],[],[]>,
  <[1,2],[7],[],[],[],[8],[25,26],[29,30]>,
  <[1,2],[7],[],[29],[],[8],[25,26],[30]>,
  <[1,2],[7],[],[29,30],[],[8],[25,26],[]>,
  <[1,2],[7],[],[],[],[8],[25,26],[31,32]>,
  <[1,2],[7],[],[31],[],[8],[25,26],[32]>,
  <[1,2],[7],[],[31,32],[],[8],[25,26],[]>,
  <[1,2],[7],[25],[],[],[8],[26],[29,30]>,
  <[1,2],[7],[25],[29],[],[8],[26],[30]>,
  <[1,2],[7],[25],[29,30],[],[8],[26],[]>,
  <[1,2],[7],[25],[],[],[8],[26],[31,32]>,
  <[1,2],[7],[25],[31],[],[8],[26],[32]>,
  <[1,2],[7],[25],[31,32],[],[8],[26],[]>,
  <[1,2],[7],[25,26],[],[],[8],[],[29,30]>,
  <[1,2],[7],[25,26],[29],[],[8],[],[30]>,
  <[1,2],[7],[25,26],[29,30],[],[8],[],[]>,
  <[1,2],[7],[25,26],[],[],[8],[],[31,32]>,
  <[1,2],[7],[25,26],[31],[],[8],[],[32]>,
  <[1,2],[7],[25,26],[31,32],[],[8],[],[]>,
  <[1,2],[7],[],[],[],[8],[27,28],[29,30]>,
  <[1,2],[7],[],[29],[],[8],[27,28],[30]>,
  <[1,2],[7],[],[29,30],[],[8],[27,28],[]>,
  <[1,2],[7],[],[],[],[8],[27,28],[31,32]>,
  <[1,2],[7],[],[31],[],[8],[27,28],[32]>,
  <[1,2],[7],[],[31,32],[],[8],[27,28],[]>,
  <[1,2],[7],[27],[],[],[8],[28],[29,30]>,
  <[1,2],[7],[27],[29],[],[8],[28],[30]>,
  <[1,2],[7],[27],[29,30],[],[8],[28],[]>,
  <[1,2],[7],[27],[],[],[8],[28],[31,32]>,
  <[1,2],[7],[27],[31],[],[8],[28],[32]>,
  <[1,2],[7],[27],[31,32],[],[8],[28],[]>,
  <[1,2],[7],[27,28],[],[],[8],[],[29,30]>,
  <[1,2],[7],[27,28],[29],[],[8],[],[30]>,
  <[1,2],[7],[27,28],[29,30],[],[8],[],[]>,
  <[1,2],[7],[27,28],[],[],[8],[],[31,32]>,
  <[1,2],[7],[27,28],[31],[],[8],[],[32]>,
  <[1,2],[7],[27,28],[31,32],[],[8],[],[]>,
  <[1,2],[7,8],[],[],[],[],[17,18],[21,22]>,
  <[1,2],[7,8],[],[21],[],[],[17,18],[22]>,
  <[1,2],[7,8],[],[21,22],[],[],[17,18],[]>,
  <[1,2],[7,8],[],[],[],[],[17,18],[23,24]>,
  <[1,2],[7,8],[],[23],[],[],[17,18],[24]>,
  <[1,2],[7,8],[],[23,24],[],[],[17,18],[]>,
  <[1,2],[7,8],[17],[],[],[],[18],[21,22]>,
  <[1,2],[7,8],[17],[21],[],[],[18],[22]>,
  <[1,2],[7,8],[17],[21,22],[],[],[18],[]>,
  <[1,2],[7,8],[17],[],[],[],[18],[23,24]>,
  <[1,2],[7,8],[17],[23],[],[],[18],[24]>,
  <[1,2],[7,8],[17],[23,24],[],[],[18],[]>,
  <[1,2],[7,8],[17,18],[],[],[],[],[21,22]>,
  <[1,2],[7,8],[17,18],[21],[],[],[],[22]>,
  <[1,2],[7,8],[17,18],[21,22],[],[],[],[]>,
  <[1,2],[7,8],[17,18],[],[],[],[],[23,24]>,
  <[1,2],[7,8],[17,18],[23],[],[],[],[24]>,
  <[1,2],[7,8],[17,18],[23,24],[],[],[],[]>,
  <[1,2],[7,8],[],[],[],[],[19,20],[21,22]>,
  <[1,2],[7,8],[],[21],[],[],[19,20],[22]>,
  <[1,2],[7,8],[],[21,22],[],[],[19,20],[]>,
  <[1,2],[7,8],[],[],[],[],[19,20],[23,24]>,
  <[1,2],[7,8],[],[23],[],[],[19,20],[24]>,
  <[1,2],[7,8],[],[23,24],[],[],[19,20],[]>,
  <[1,2],[7,8],[19],[],[],[],[20],[21,22]>,
  <[1,2],[7,8],[19],[21],[],[],[20],[22]>,
  <[1,2],[7,8],[19],[21,22],[],[],[20],[]>,
  <[1,2],[7,8],[19],[],[],[],[20],[23,24]>,
  <[1,2],[7,8],[19],[23],[],[],[20],[24]>,
  <[1,2],[7,8],[19],[23,24],[],[],[20],[]>,
  <[1,2],[7,8],[19,20],[],[],[],[],[21,22]>,
  <[1,2],[7,8],[19,20],[21],[],[],[],[22]>,
  <[1,2],[7,8],[19,20],[21,22],[],[],[],[]>,
  <[1,2],[7,8],[19,20],[],[],[],[],[23,24]>,
  <[1,2],[7,8],[19,20],[23],[],[],[],[24]>,
  <[1,2],[7,8],[19,20],[23,24],[],[],[],[]>,
  <[1,2],[7,8],[],[],[],[],[25,26],[29,30]>,
  <[1,2],[7,8],[],[29],[],[],[25,26],[30]>,
  <[1,2],[7,8],[],[29,30],[],[],[25,26],[]>,
  <[1,2],[7,8],[],[],[],[],[25,26],[31,32]>,
  <[1,2],[7,8],[],[31],[],[],[25,26],[32]>,
  <[1,2],[7,8],[],[31,32],[],[],[25,26],[]>,
  <[1,2],[7,8],[25],[],[],[],[26],[29,30]>,
  <[1,2],[7,8],[25],[29],[],[],[26],[30]>,
  <[1,2],[7,8],[25],[29,30],[],[],[26],[]>,
  <[1,2],[7,8],[25],[],[],[],[26],[31,32]>,
  <[1,2],[7,8],[25],[31],[],[],[26],[32]>,
  <[1,2],[7,8],[25],[31,32],[],[],[26],[]>,
  <[1,2],[7,8],[25,26],[],[],[],[],[29,30]>,
  <[1,2],[7,8],[25,26],[29],[],[],[],[30]>,
  <[1,2],[7,8],[25,26],[29,30],[],[],[],[]>,
  <[1,2],[7,8],[25,26],[],[],[],[],[31,32]>,
  <[1,2],[7,8],[25,26],[31],[],[],[],[32]>,
  <[1,2],[7,8],[25,26],[31,32],[],[],[],[]>,
  <[1,2],[7,8],[],[],[],[],[27,28],[29,30]>,
  <[1,2],[7,8],[],[29],[],[],[27,28],[30]>,
  <[1,2],[7,8],[],[29,30],[],[],[27,28],[]>,
  <[1,2],[7,8],[],[],[],[],[27,28],[31,32]>,
  <[1,2],[7,8],[],[31],[],[],[27,28],[32]>,
  <[1,2],[7,8],[],[31,32],[],[],[27,28],[]>,
  <[1,2],[7,8],[27],[],[],[],[28],[29,30]>,
  <[1,2],[7,8],[27],[29],[],[],[28],[30]>,
  <[1,2],[7,8],[27],[29,30],[],[],[28],[]>,
  <[1,2],[7,8],[27],[],[],[],[28],[31,32]>,
  <[1,2],[7,8],[27],[31],[],[],[28],[32]>,
  <[1,2],[7,8],[27],[31,32],[],[],[28],[]>,
  <[1,2],[7,8],[27,28],[],[],[],[],[29,30]>,
  <[1,2],[7,8],[27,28],[29],[],[],[],[30]>,
  <[1,2],[7,8],[27,28],[29,30],[],[],[],[]>,
  <[1,2],[7,8],[27,28],[],[],[],[],[31,32]>,
  <[1,2],[7,8],[27,28],[31],[],[],[],[32]>,
  <[1,2],[7,8],[27,28],[31,32],[],[],[],[]>,
  <[],[],[],[],[3,4],[5,6],[17,18],[21,22]>,
  <[],[],[],[21],[3,4],[5,6],[17,18],[22]>,
  <[],[],[],[21,22],[3,4],[5,6],[17,18],[]>,
  <[],[],[],[],[3,4],[5,6],[17,18],[23,24]>,
  <[],[],[],[23],[3,4],[5,6],[17,18],[24]>,
  <[],[],[],[23,24],[3,4],[5,6],[17,18],[]>,
  <[],[],[17],[],[3,4],[5,6],[18],[21,22]>,
  <[],[],[17],[21],[3,4],[5,6],[18],[22]>,
  <[],[],[17],[21,22],[3,4],[5,6],[18],[]>,
  <[],[],[17],[],[3,4],[5,6],[18],[23,24]>,
  <[],[],[17],[23],[3,4],[5,6],[18],[24]>,
  <[],[],[17],[23,24],[3,4],[5,6],[18],[]>,
  <[],[],[17,18],[],[3,4],[5,6],[],[21,22]>,
  <[],[],[17,18],[21],[3,4],[5,6],[],[22]>,
  <[],[],[17,18],[21,22],[3,4],[5,6],[],[]>,
  <[],[],[17,18],[],[3,4],[5,6],[],[23,24]>,
  <[],[],[17,18],[23],[3,4],[5,6],[],[24]>,
  <[],[],[17,18],[23,24],[3,4],[5,6],[],[]>,
  <[],[],[],[],[3,4],[5,6],[19,20],[21,22]>,
  <[],[],[],[21],[3,4],[5,6],[19,20],[22]>,
  <[],[],[],[21,22],[3,4],[5,6],[19,20],[]>,
  <[],[],[],[],[3,4],[5,6],[19,20],[23,24]>,
  <[],[],[],[23],[3,4],[5,6],[19,20],[24]>,
  <[],[],[],[23,24],[3,4],[5,6],[19,20],[]>,
  <[],[],[19],[],[3,4],[5,6],[20],[21,22]>,
  <[],[],[19],[21],[3,4],[5,6],[20],[22]>,
  <[],[],[19],[21,22],[3,4],[5,6],[20],[]>,
  <[],[],[19],[],[3,4],[5,6],[20],[23,24]>,
  <[],[],[19],[23],[3,4],[5,6],[20],[24]>,
  <[],[],[19],[23,24],[3,4],[5,6],[20],[]>,
  <[],[],[19,20],[],[3,4],[5,6],[],[21,22]>,
  <[],[],[19,20],[21],[3,4],[5,6],[],[22]>,
  <[],[],[19,20],[21,22],[3,4],[5,6],[],[]>,
  <[],[],[19,20],[],[3,4],[5,6],[],[23,24]>,
  <[],[],[19,20],[23],[3,4],[5,6],[],[24]>,
  <[],[],[19,20],[23,24],[3,4],[5,6],[],[]>,
  <[],[],[],[],[3,4],[5,6],[25,26],[29,30]>,
  <[],[],[],[29],[3,4],[5,6],[25,26],[30]>,
  <[],[],[],[29,30],[3,4],[5,6],[25,26],[]>,
  <[],[],[],[],[3,4],[5,6],[25,26],[31,32]>,
  <[],[],[],[31],[3,4],[5,6],[25,26],[32]>,
  <[],[],[],[31,32],[3,4],[5,6],[25,26],[]>,
  <[],[],[25],[],[3,4],[5,6],[26],[29,30]>,
  <[],[],[25],[29],[3,4],[5,6],[26],[30]>,
  <[],[],[25],[29,30],[3,4],[5,6],[26],[]>,
  <[],[],[25],[],[3,4],[5,6],[26],[31,32]>,
  <[],[],[25],[31],[3,4],[5,6],[26],[32]>,
  <[],[],[25],[31,32],[3,4],[5,6],[26],[]>,
  <[],[],[25,26],[],[3,4],[5,6],[],[29,30]>,
  <[],[],[25,26],[29],[3,4],[5,6],[],[30]>,
  <[],[],[25,26],[29,30],[3,4],[5,6],[],[]>,
  <[],[],[25,26],[],[3,4],[5,6],[],[31,32]>,
  <[],[],[25,26],[31],[3,4],[5,6],[],[32]>,
  <[],[],[25,26],[31,32],[3,4],[5,6],[],[]>,
  <[],[],[],[],[3,4],[5,6],[27,28],[29,30]>,
  <[],[],[],[29],[3,4],[5,6],[27,28],[30]>,
  <[],[],[],[29,30],[3,4],[5,6],[27,28],[]>,
  <[],[],[],[],[3,4],[5,6],[27,28],[31,32]>,
  <[],[],[],[31],[3,4],[5,6],[27,28],[32]>,
  <[],[],[],[31,32],[3,4],[5,6],[27,28],[]>,
  <[],[],[27],[],[3,4],[5,6],[28],[29,30]>,
  <[],[],[27],[29],[3,4],[5,6],[28],[30]>,
  <[],[],[27],[29,30],[3,4],[5,6],[28],[]>,
  <[],[],[27],[],[3,4],[5,6],[28],[31,32]>,
  <[],[],[27],[31],[3,4],[5,6],[28],[32]>,
  <[],[],[27],[31,32],[3,4],[5,6],[28],[]>,
  <[],[],[27,28],[],[3,4],[5,6],[],[29,30]>,
  <[],[],[27,28],[29],[3,4],[5,6],[],[30]>,
  <[],[],[27,28],[29,30],[3,4],[5,6],[],[]>,
  <[],[],[27,28],[],[3,4],[5,6],[],[31,32]>,
  <[],[],[27,28],[31],[3,4],[5,6],[],[32]>,
  <[],[],[27,28],[31,32],[3,4],[5,6],[],[]>,
  <[],[5],[],[],[3,4],[6],[17,18],[21,22]>,
  <[],[5],[],[21],[3,4],[6],[17,18],[22]>,
  <[],[5],[],[21,22],[3,4],[6],[17,18],[]>,
  <[],[5],[],[],[3,4],[6],[17,18],[23,24]>,
  <[],[5],[],[23],[3,4],[6],[17,18],[24]>,
  <[],[5],[],[23,24],[3,4],[6],[17,18],[]>,
  <[],[5],[17],[],[3,4],[6],[18],[21,22]>,
  <[],[5],[17],[21],[3,4],[6],[18],[22]>,
  <[],[5],[17],[21,22],[3,4],[6],[18],[]>,
  <[],[5],[17],[],[3,4],[6],[18],[23,24]>,
  <[],[5],[17],[23],[3,4],[6],[18],[24]>,
  <[],[5],[17],[23,24],[3,4],[6],[18],[]>,
  <[],[5],[17,18],[],[3,4],[6],[],[21,22]>,
  <[],[5],[17,18],[21],[3,4],[6],[],[22]>,
  <[],[5],[17,18],[21,22],[3,4],[6],[],[]>,
  <[],[5],[17,18],[],[3,4],[6],[],[23,24]>,
  <[],[5],[17,18],[23],[3,4],[6],[],[24]>,
  <[],[5],[17,18],[23,24],[3,4],[6],[],[]>,
  <[],[5],[],[],[3,4],[6],[19,20],[21,22]>,
  <[],[5],[],[21],[3,4],[6],[19,20],[22]>,
  <[],[5],[],[21,22],[3,4],[6],[19,20],[]>,
  <[],[5],[],[],[3,4],[6],[19,20],[23,24]>,
  <[],[5],[],[23],[3,4],[6],[19,20],[24]>,
  <[],[5],[],[23,24],[3,4],[6],[19,20],[]>,
  <[],[5],[19],[],[3,4],[6],[20],[21,22]>,
  <[],[5],[19],[21],[3,4],[6],[20],[22]>,
  <[],[5],[19],[21,22],[3,4],[6],[20],[]>,
  <[],[5],[19],[],[3,4],[6],[20],[23,24]>,
  <[],[5],[19],[23],[3,4],[6],[20],[24]>,
  <[],[5],[19],[23,24],[3,4],[6],[20],[]>,
  <[],[5],[19,20],[],[3,4],[6],[],[21,22]>,
  <[],[5],[19,20],[21],[3,4],[6],[],[22]>,
  <[],[5],[19,20],[21,22],[3,4],[6],[],[]>,
  <[],[5],[19,20],[],[3,4],[6],[],[23,24]>,
  <[],[5],[19,20],[23],[3,4],[6],[],[24]>,
  <[],[5],[19,20],[23,24],[3,4],[6],[],[]>,
  <[],[5],[],[],[3,4],[6],[25,26],[29,30]>,
  <[],[5],[],[29],[3,4],[6],[25,26],[30]>,
  <[],[5],[],[29,30],[3,4],[6],[25,26],[]>,
  <[],[5],[],[],[3,4],[6],[25,26],[31,32]>,
  <[],[5],[],[31],[3,4],[6],[25,26],[32]>,
  <[],[5],[],[31,32],[3,4],[6],[25,26],[]>,
  <[],[5],[25],[],[3,4],[6],[26],[29,30]>,
  <[],[5],[25],[29],[3,4],[6],[26],[30]>,
  <[],[5],[25],[29,30],[3,4],[6],[26],[]>,
  <[],[5],[25],[],[3,4],[6],[26],[31,32]>,
  <[],[5],[25],[31],[3,4],[6],[26],[32]>,
  <[],[5],[25],[31,32],[3,4],[6],[26],[]>,
  <[],[5],[25,26],[],[3,4],[6],[],[29,30]>,
  <[],[5],[25,26],[29],[3,4],[6],[],[30]>,
  <[],[5],[25,26],[29,30],[3,4],[6],[],[]>,
  <[],[5],[25,26],[],[3,4],[6],[],[31,32]>,
  <[],[5],[25,26],[31],[3,4],[6],[],[32]>,
  <[],[5],[25,26],[31,32],[3,4],[6],[],[]>,
  <[],[5],[],[],[3,4],[6],[27,28],[29,30]>,
  <[],[5],[],[29],[3,4],[6],[27,28],[30]>,
  <[],[5],[],[29,30],[3,4],[6],[27,28],[]>,
  <[],[5],[],[],[3,4],[6],[27,28],[31,32]>,
  <[],[5],[],[31],[3,4],[6],[27,28],[32]>,
  <[],[5],[],[31,32],[3,4],[6],[27,28],[]>,
  <[],[5],[27],[],[3,4],[6],[28],[29,30]>,
  <[],[5],[27],[29],[3,4],[6],[28],[30]>,
  <[],[5],[27],[29,30],[3,4],[6],[28],[]>,
  <[],[5],[27],[],[3,4],[6],[28],[31,32]>,
  <[],[5],[27],[31],[3,4],[6],[28],[32]>,
  <[],[5],[27],[31,32],[3,4],[6],[28],[]>,
  <[],[5],[27,28],[],[3,4],[6],[],[29,30]>,
  <[],[5],[27,28],[29],[3,4],[6],[],[30]>,
  <[],[5],[27,28],[29,30],[3,4],[6],[],[]>,
  <[],[5],[27,28],[],[3,4],[6],[],[31,32]>,
  <[],[5],[27,28],[31],[3,4],[6],[],[32]>,
  <[],[5],[27,28],[31,32],[3,4],[6],[],[]>,
  <[],[5,6],[],[],[3,4],[],[17,18],[21,22]>,
  <[],[5,6],[],[21],[3,4],[],[17,18],[22]>,
  <[],[5,6],[],[21,22],[3,4],[],[17,18],[]>,
  <[],[5,6],[],[],[3,4],[],[17,18],[23,24]>,
  <[],[5,6],[],[23],[3,4],[],[17,18],[24]>,
  <[],[5,6],[],[23,24],[3,4],[],[17,18],[]>,
  <[],[5,6],[17],[],[3,4],[],[18],[21,22]>,
  <[],[5,6],[17],[21],[3,4],[],[18],[22]>,
  <[],[5,6],[17],[21,22],[3,4],[],[18],[]>,
  <[],[5,6],[17],[],[3,4],[],[18],[23,24]>,
  <[],[5,6],[17],[23],[3,4],[],[18],[24]>,
  <[],[5,6],[17],[23,24],[3,4],[],[18],[]>,
  <[],[5,6],[17,18],[],[3,4],[],[],[21,22]>,
  <[],[5,6],[17,18],[21],[3,4],[],[],[22]>,
  <[],[5,6],[17,18],[21,22],[3,4],[],[],[]>,
  <[],[5,6],[17,18],[],[3,4],[],[],[23,24]>,
  <[],[5,6],[17,18],[23],[3,4],[],[],[24]>,
  <[],[5,6],[17,18],[23,24],[3,4],[],[],[]>,
  <[],[5,6],[],[],[3,4],[],[19,20],[21,22]>,
  <[],[5,6],[],[21],[3,4],[],[19,20],[22]>,
  <[],[5,6],[],[21,22],[3,4],[],[19,20],[]>,
  <[],[5,6],[],[],[3,4],[],[19,20],[23,24]>,
  <[],[5,6],[],[23],[3,4],[],[19,20],[24]>,
  <[],[5,6],[],[23,24],[3,4],[],[19,20],[]>,
  <[],[5,6],[19],[],[3,4],[],[20],[21,22]>,
  <[],[5,6],[19],[21],[3,4],[],[20],[22]>,
  <[],[5,6],[19],[21,22],[3,4],[],[20],[]>,
  <[],[5,6],[19],[],[3,4],[],[20],[23,24]>,
  <[],[5,6],[19],[23],[3,4],[],[20],[24]>,
  <[],[5,6],[19],[23,24],[3,4],[],[20],[]>,
  <[],[5,6],[19,20],[],[3,4],[],[],[21,22]>,
  <[],[5,6],[19,20],[21],[3,4],[],[],[22]>,
  <[],[5,6],[19,20],[21,22],[3,4],[],[],[]>,
  <[],[5,6],[19,20],[],[3,4],[],[],[23,24]>,
  <[],[5,6],[19,20],[23],[3,4],[],[],[24]>,
  <[],[5,6],[19,20],[23,24],[3,4],[],[],[]>,
  <[],[5,6],[],[],[3,4],[],[25,26],[29,30]>,
  <[],[5,6],[],[29],[3,4],[],[25,26],[30]>,
  <[],[5,6],[],[29,30],[3,4],[],[25,26],[]>,
  <[],[5,6],[],[],[3,4],[],[25,26],[31,32]>,
  <[],[5,6],[],[31],[3,4],[],[25,26],[32]>,
  <[],[5,6],[],[31,32],[3,4],[],[25,26],[]>,
  <[],[5,6],[25],[],[3,4],[],[26],[29,30]>,
  <[],[5,6],[25],[29],[3,4],[],[26],[30]>,
  <[],[5,6],[25],[29,30],[3,4],[],[26],[]>,
  <[],[5,6],[25],[],[3,4],[],[26],[31,32]>,
  <[],[5,6],[25],[31],[3,4],[],[26],[32]>,
  <[],[5,6],[25],[31,32],[3,4],[],[26],[]>,
  <[],[5,6],[25,26],[],[3,4],[],[],[29,30]>,
  <[],[5,6],[25,26],[29],[3,4],[],[],[30]>,
  <[],[5,6],[25,26],[29,30],[3,4],[],[],[]>,
  <[],[5,6],[25,26],[],[3,4],[],[],[31,32]>,
  <[],[5,6],[25,26],[31],[3,4],[],[],[32]>,
  <[],[5,6],[25,26],[31,32],[3,4],[],[],[]>,
  <[],[5,6],[],[],[3,4],[],[27,28],[29,30]>,
  <[],[5,6],[],[29],[3,4],[],[27,28],[30]>,
  <[],[5,6],[],[29,30],[3,4],[],[27,28],[]>,
  <[],[5,6],[],[],[3,4],[],[27,28],[31,32]>,
  <[],[5,6],[],[31],[3,4],[],[27,28],[32]>,
  <[],[5,6],[],[31,32],[3,4],[],[27,28],[]>,
  <[],[5,6],[27],[],[3,4],[],[28],[29,30]>,
  <[],[5,6],[27],[29],[3,4],[],[28],[30]>,
  <[],[5,6],[27],[29,30],[3,4],[],[28],[]>,
  <[],[5,6],[27],[],[3,4],[],[28],[31,32]>,
  <[],[5,6],[27],[31],[3,4],[],[28],[32]>,
  <[],[5,6],[27],[31,32],[3,4],[],[28],[]>,
  <[],[5,6],[27,28],[],[3,4],[],[],[29,30]>,
  <[],[5,6],[27,28],[29],[3,4],[],[],[30]>,
  <[],[5,6],[27,28],[29,30],[3,4],[],[],[]>,
  <[],[5,6],[27,28],[],[3,4],[],[],[31,32]>,
  <[],[5,6],[27,28],[31],[3,4],[],[],[32]>,
  <[],[5,6],[27,28],[31,32],[3,4],[],[],[]>,
  <[],[],[],[],[3,4],[7,8],[17,18],[21,22]>,
  <[],[],[],[21],[3,4],[7,8],[17,18],[22]>,
  <[],[],[],[21,22],[3,4],[7,8],[17,18],[]>,
  <[],[],[],[],[3,4],[7,8],[17,18],[23,24]>,
  <[],[],[],[23],[3,4],[7,8],[17,18],[24]>,
  <[],[],[],[23,24],[3,4],[7,8],[17,18],[]>,
  <[],[],[17],[],[3,4],[7,8],[18],[21,22]>,
  <[],[],[17],[21],[3,4],[7,8],[18],[22]>,
  <[],[],[17],[21,22],[3,4],[7,8],[18],[]>,
  <[],[],[17],[],[3,4],[7,8],[18],[23,24]>,
  <[],[],[17],[23],[3,4],[7,8],[18],[24]>,
  <[],[],[17],[23,24],[3,4],[7,8],[18],[]>,
  <[],[],[17,18],[],[3,4],[7,8],[],[21,22]>,
  <[],[],[17,18],[21],[3,4],[7,8],[],[22]>,
  <[],[],[17,18],[21,22],[3,4],[7,8],[],[]>,
  <[],[],[17,18],[],[3,4],[7,8],[],[23,24]>,
  <[],[],[17,18],[23],[3,4],[7,8],[],[24]>,
  <[],[],[17,18],[23,24],[3,4],[7,8],[],[]>,
  <[],[],[],[],[3,4],[7,8],[19,20],[21,22]>,
  <[],[],[],[21],[3,4],[7,8],[19,20],[22]>,
  <[],[],[],[21,22],[3,4],[7,8],[19,20],[]>,
  <[],[],[],[],[3,4],[7,8],[19,20],[23,24]>,
  <[],[],[],[23],[3,4],[7,8],[19,20],[24]>,
  <[],[],[],[23,24],[3,4],[7,8],[19,20],[]>,
  <[],[],[19],[],[3,4],[7,8],[20],[21,22]>,
  <[],[],[19],[21],[3,4],[7,8],[20],[22]>,
  <[],[],[19],[21,22],[3,4],[7,8],[20],[]>,
  <[],[],[19],[],[3,4],[7,8],[20],[23,24]>,
  <[],[],[19],[23],[3,4],[7,8],[20],[24]>,
  <[],[],[19],[23,24],[3,4],[7,8],[20],[]>,
  <[],[],[19,20],[],[3,4],[7,8],[],[21,22]>,
  <[],[],[19,20],[21],[3,4],[7,8],[],[22]>,
  <[],[],[19,20],[21,22],[3,4],[7,8],[],[]>,
  <[],[],[19,20],[],[3,4],[7,8],[],[23,24]>,
  <[],[],[19,20],[23],[3,4],[7,8],[],[24]>,
  <[],[],[19,20],[23,24],[3,4],[7,8],[],[]>,
  <[],[],[],[],[3,4],[7,8],[25,26],[29,30]>,
  <[],[],[],[29],[3,4],[7,8],[25,26],[30]>,
  <[],[],[],[29,30],[3,4],[7,8],[25,26],[]>,
  <[],[],[],[],[3,4],[7,8],[25,26],[31,32]>,
  <[],[],[],[31],[3,4],[7,8],[25,26],[32]>,
  <[],[],[],[31,32],[3,4],[7,8],[25,26],[]>,
  <[],[],[25],[],[3,4],[7,8],[26],[29,30]>,
  <[],[],[25],[29],[3,4],[7,8],[26],[30]>,
  <[],[],[25],[29,30],[3,4],[7,8],[26],[]>,
  <[],[],[25],[],[3,4],[7,8],[26],[31,32]>,
  <[],[],[25],[31],[3,4],[7,8],[26],[32]>,
  <[],[],[25],[31,32],[3,4],[7,8],[26],[]>,
  <[],[],[25,26],[],[3,4],[7,8],[],[29,30]>,
  <[],[],[25,26],[29],[3,4],[7,8],[],[30]>,
  <[],[],[25,26],[29,30],[3,4],[7,8],[],[]>,
  <[],[],[25,26],[],[3,4],[7,8],[],[31,32]>,
  <[],[],[25,26],[31],[3,4],[7,8],[],[32]>,
  <[],[],[25,26],[31,32],[3,4],[7,8],[],[]>,
  <[],[],[],[],[3,4],[7,8],[27,28],[29,30]>,
  <[],[],[],[29],[3,4],[7,8],[27,28],[30]>,
  <[],[],[],[29,30],[3,4],[7,8],[27,28],[]>,
  <[],[],[],[],[3,4],[7,8],[27,28],[31,32]>,
  <[],[],[],[31],[3,4],[7,8],[27,28],[32]>,
  <[],[],[],[31,32],[3,4],[7,8],[27,28],[]>,
  <[],[],[27],[],[3,4],[7,8],[28],[29,30]>,
  <[],[],[27],[29],[3,4],[7,8],[28],[30]>,
  <[],[],[27],[29,30],[3,4],[7,8],[28],[]>,
  <[],[],[27],[],[3,4],[7,8],[28],[31,32]>,
  <[],[],[27],[31],[3,4],[7,8],[28],[32]>,
  <[],[],[27],[31,32],[3,4],[7,8],[28],[]>,
  <[],[],[27,28],[],[3,4],[7,8],[],[29,30]>,
  <[],[],[27,28],[29],[3,4],[7,8],[],[30]>,
  <[],[],[27,28],[29,30],[3,4],[7,8],[],[]>,
  <[],[],[27,28],[],[3,4],[7,8],[],[31,32]>,
  <[],[],[27,28],[31],[3,4],[7,8],[],[32]>,
  <[],[],[27,28],[31,32],[3,4],[7,8],[],[]>,
  <[],[7],[],[],[3,4],[8],[17,18],[21,22]>,
  <[],[7],[],[21],[3,4],[8],[17,18],[22]>,
  <[],[7],[],[21,22],[3,4],[8],[17,18],[]>,
  <[],[7],[],[],[3,4],[8],[17,18],[23,24]>,
  <[],[7],[],[23],[3,4],[8],[17,18],[24]>,
  <[],[7],[],[23,24],[3,4],[8],[17,18],[]>,
  <[],[7],[17],[],[3,4],[8],[18],[21,22]>,
  <[],[7],[17],[21],[3,4],[8],[18],[22]>,
  <[],[7],[17],[21,22],[3,4],[8],[18],[]>,
  <[],[7],[17],[],[3,4],[8],[18],[23,24]>,
  <[],[7],[17],[23],[3,4],[8],[18],[24]>,
  <[],[7],[17],[23,24],[3,4],[8],[18],[]>,
  <[],[7],[17,18],[],[3,4],[8],[],[21,22]>,
  <[],[7],[17,18],[21],[3,4],[8],[],[22]>,
  <[],[7],[17,18],[21,22],[3,4],[8],[],[]>,
  <[],[7],[17,18],[],[3,4],[8],[],[23,24]>,
  <[],[7],[17,18],[23],[3,4],[8],[],[24]>,
  <[],[7],[17,18],[23,24],[3,4],[8],[],[]>,
  <[],[7],[],[],[3,4],[8],[19,20],[21,22]>,
  <[],[7],[],[21],[3,4],[8],[19,20],[22]>,
  <[],[7],[],[21,22],[3,4],[8],[19,20],[]>,
  <[],[7],[],[],[3,4],[8],[19,20],[23,24]>,
  <[],[7],[],[23],[3,4],[8],[19,20],[24]>,
  <[],[7],[],[23,24],[3,4],[8],[19,20],[]>,
  <[],[7],[19],[],[3,4],[8],[20],[21,22]>,
  <[],[7],[19],[21],[3,4],[8],[20],[22]>,
  <[],[7],[19],[21,22],[3,4],[8],[20],[]>,
  <[],[7],[19],[],[3,4],[8],[20],[23,24]>,
  <[],[7],[19],[23],[3,4],[8],[20],[24]>,
  <[],[7],[19],[23,24],[3,4],[8],[20],[]>,
  <[],[7],[19,20],[],[3,4],[8],[],[21,22]>,
  <[],[7],[19,20],[21],[3,4],[8],[],[22]>,
  <[],[7],[19,20],[21,22],[3,4],[8],[],[]>,
  <[],[7],[19,20],[],[3,4],[8],[],[23,24]>,
  <[],[7],[19,20],[23],[3,4],[8],[],[24]>,
  <[],[7],[19,20],[23,24],[3,4],[8],[],[]>,
  <[],[7],[],[],[3,4],[8],[25,26],[29,30]>,
  <[],[7],[],[29],[3,4],[8],[25,26],[30]>,
  <[],[7],[],[29,30],[3,4],[8],[25,26],[]>,
  <[],[7],[],[],[3,4],[8],[25,26],[31,32]>,
  <[],[7],[],[31],[3,4],[8],[25,26],[32]>,
  <[],[7],[],[31,32],[3,4],[8],[25,26],[]>,
  <[],[7],[25],[],[3,4],[8],[26],[29,30]>,
  <[],[7],[25],[29],[3,4],[8],[26],[30]>,
  <[],[7],[25],[29,30],[3,4],[8],[26],[]>,
  <[],[7],[25],[],[3,4],[8],[26],[31,32]>,
  <[],[7],[25],[31],[3,4],[8],[26],[32]>,
  <[],[7],[25],[31,32],[3,4],[8],[26],[]>,
  <[],[7],[25,26],[],[3,4],[8],[],[29,30]>,
  <[],[7],[25,26],[29],[3,4],[8],[],[30]>,
  <[],[7],[25,26],[29,30],[3,4],[8],[],[]>,
  <[],[7],[25,26],[],[3,4],[8],[],[31,32]>,
  <[],[7],[25,26],[31],[3,4],[8],[],[32]>,
  <[],[7],[25,26],[31,32],[3,4],[8],[],[]>,
  <[],[7],[],[],[3,4],[8],[27,28],[29,30]>,
  <[],[7],[],[29],[3,4],[8],[27,28],[30]>,
  <[],[7],[],[29,30],[3,4],[8],[27,28],[]>,
  <[],[7],[],[],[3,4],[8],[27,28],[31,32]>,
  <[],[7],[],[31],[3,4],[8],[27,28],[32]>,
  <[],[7],[],[31,32],[3,4],[8],[27,28],[]>,
  <[],[7],[27],[],[3,4],[8],[28],[29,30]>,
  <[],[7],[27],[29],[3,4],[8],[28],[30]>,
  <[],[7],[27],[29,30],[3,4],[8],[28],[]>,
  <[],[7],[27],[],[3,4],[8],[28],[31,32]>,
  <[],[7],[27],[31],[3,4],[8],[28],[32]>,
  <[],[7],[27],[31,32],[3,4],[8],[28],[]>,
  <[],[7],[27,28],[],[3,4],[8],[],[29,30]>,
  <[],[7],[27,28],[29],[3,4],[8],[],[30]>,
  <[],[7],[27,28],[29,30],[3,4],[8],[],[]>,
  <[],[7],[27,28],[],[3,4],[8],[],[31,32]>,
  <[],[7],[27,28],[31],[3,4],[8],[],[32]>,
  <[],[7],[27,28],[31,32],[3,4],[8],[],[]>,
  <[],[7,8],[],[],[3,4],[],[17,18],[21,22]>,
  <[],[7,8],[],[21],[3,4],[],[17,18],[22]>,
  <[],[7,8],[],[21,22],[3,4],[],[17,18],[]>,
  <[],[7,8],[],[],[3,4],[],[17,18],[23,24]>,
  <[],[7,8],[],[23],[3,4],[],[17,18],[24]>,
  <[],[7,8],[],[23,24],[3,4],[],[17,18],[]>,
  <[],[7,8],[17],[],[3,4],[],[18],[21,22]>,
  <[],[7,8],[17],[21],[3,4],[],[18],[22]>,
  <[],[7,8],[17],[21,22],[3,4],[],[18],[]>,
  <[],[7,8],[17],[],[3,4],[],[18],[23,24]>,
  <[],[7,8],[17],[23],[3,4],[],[18],[24]>,
  <[],[7,8],[17],[23,24],[3,4],[],[18],[]>,
  <[],[7,8],[17,18],[],[3,4],[],[],[21,22]>,
  <[],[7,8],[17,18],[21],[3,4],[],[],[22]>,
  <[],[7,8],[17,18],[21,22],[3,4],[],[],[]>,
  <[],[7,8],[17,18],[],[3,4],[],[],[23,24]>,
  <[],[7,8],[17,18],[23],[3,4],[],[],[24]>,
  <[],[7,8],[17,18],[23,24],[3,4],[],[],[]>,
  <[],[7,8],[],[],[3,4],[],[19,20],[21,22]>,
  <[],[7,8],[],[21],[3,4],[],[19,20],[22]>,
  <[],[7,8],[],[21,22],[3,4],[],[19,20],[]>,
  <[],[7,8],[],[],[3,4],[],[19,20],[23,24]>,
  <[],[7,8],[],[23],[3,4],[],[19,20],[24]>,
  <[],[7,8],[],[23,24],[3,4],[],[19,20],[]>,
  <[],[7,8],[19],[],[3,4],[],[20],[21,22]>,
  <[],[7,8],[19],[21],[3,4],[],[20],[22]>,
  <[],[7,8],[19],[21,22],[3,4],[],[20],[]>,
  <[],[7,8],[19],[],[3,4],[],[20],[23,24]>,
  <[],[7,8],[19],[23],[3,4],[],[20],[24]>,
  <[],[7,8],[19],[23,24],[3,4],[],[20],[]>,
  <[],[7,8],[19,20],[],[3,4],[],[],[21,22]>,
  <[],[7,8],[19,20],[21],[3,4],[],[],[22]>,
  <[],[7,8],[19,20],[21,22],[3,4],[],[],[]>,
  <[],[7,8],[19,20],[],[3,4],[],[],[23,24]>,
  <[],[7,8],[19,20],[23],[3,4],[],[],[24]>,
  <[],[7,8],[19,20],[23,24],[3,4],[],[],[]>,
  <[],[7,8],[],[],[3,4],[],[25,26],[29,30]>,
  <[],[7,8],[],[29],[3,4],[],[25,26],[30]>,
  <[],[7,8],[],[29,30],[3,4],[],[25,26],[]>,
  <[],[7,8],[],[],[3,4],[],[25,26],[31,32]>,
  <[],[7,8],[],[31],[3,4],[],[25,26],[32]>,
  <[],[7,8],[],[31,32],[3,4],[],[25,26],[]>,
  <[],[7,8],[25],[],[3,4],[],[26],[29,30]>,
  <[],[7,8],[25],[29],[3,4],[],[26],[30]>,
  <[],[7,8],[25],[29,30],[3,4],[],[26],[]>,
  <[],[7,8],[25],[],[3,4],[],[26],[31,32]>,
  <[],[7,8],[25],[31],[3,4],[],[26],[32]>,
  <[],[7,8],[25],[31,32],[3,4],[],[26],[]>,
  <[],[7,8],[25,26],[],[3,4],[],[],[29,30]>,
  <[],[7,8],[25,26],[29],[3,4],[],[],[30]>,
  <[],[7,8],[25,26],[29,30],[3,4],[],[],[]>,
  <[],[7,8],[25,26],[],[3,4],[],[],[31,32]>,
  <[],[7,8],[25,26],[31],[3,4],[],[],[32]>,
  <[],[7,8],[25,26],[31,32],[3,4],[],[],[]>,
  <[],[7,8],[],[],[3,4],[],[27,28],[29,30]>,
  <[],[7,8],[],[29],[3,4],[],[27,28],[30]>,
  <[],[7,8],[],[29,30],[3,4],[],[27,28],[]>,
  <[],[7,8],[],[],[3,4],[],[27,28],[31,32]>,
  <[],[7,8],[],[31],[3,4],[],[27,28],[32]>,
  <[],[7,8],[],[31,32],[3,4],[],[27,28],[]>,
  <[],[7,8],[27],[],[3,4],[],[28],[29,30]>,
  <[],[7,8],[27],[29],[3,4],[],[28],[30]>,
  <[],[7,8],[27],[29,30],[3,4],[],[28],[]>,
  <[],[7,8],[27],[],[3,4],[],[28],[31,32]>,
  <[],[7,8],[27],[31],[3,4],[],[28],[32]>,
  <[],[7,8],[27],[31,32],[3,4],[],[28],[]>,
  <[],[7,8],[27,28],[],[3,4],[],[],[29,30]>,
  <[],[7,8],[27,28],[29],[3,4],[],[],[30]>,
  <[],[7,8],[27,28],[29,30],[3,4],[],[],[]>,
  <[],[7,8],[27,28],[],[3,4],[],[],[31,32]>,
  <[],[7,8],[27,28],[31],[3,4],[],[],[32]>,
  <[],[7,8],[27,28],[31,32],[3,4],[],[],[]>,
  <[3],[],[],[],[4],[5,6],[17,18],[21,22]>,
  <[3],[],[],[21],[4],[5,6],[17,18],[22]>,
  <[3],[],[],[21,22],[4],[5,6],[17,18],[]>,
  <[3],[],[],[],[4],[5,6],[17,18],[23,24]>,
  <[3],[],[],[23],[4],[5,6],[17,18],[24]>,
  <[3],[],[],[23,24],[4],[5,6],[17,18],[]>,
  <[3],[],[17],[],[4],[5,6],[18],[21,22]>,
  <[3],[],[17],[21],[4],[5,6],[18],[22]>,
  <[3],[],[17],[21,22],[4],[5,6],[18],[]>,
  <[3],[],[17],[],[4],[5,6],[18],[23,24]>,
  <[3],[],[17],[23],[4],[5,6],[18],[24]>,
  <[3],[],[17],[23,24],[4],[5,6],[18],[]>,
  <[3],[],[17,18],[],[4],[5,6],[],[21,22]>,
  <[3],[],[17,18],[21],[4],[5,6],[],[22]>,
  <[3],[],[17,18],[21,22],[4],[5,6],[],[]>,
  <[3],[],[17,18],[],[4],[5,6],[],[23,24]>,
  <[3],[],[17,18],[23],[4],[5,6],[],[24]>,
  <[3],[],[17,18],[23,24],[4],[5,6],[],[]>,
  <[3],[],[],[],[4],[5,6],[19,20],[21,22]>,
  <[3],[],[],[21],[4],[5,6],[19,20],[22]>,
  <[3],[],[],[21,22],[4],[5,6],[19,20],[]>,
  <[3],[],[],[],[4],[5,6],[19,20],[23,24]>,
  <[3],[],[],[23],[4],[5,6],[19,20],[24]>,
  <[3],[],[],[23,24],[4],[5,6],[19,20],[]>,
  <[3],[],[19],[],[4],[5,6],[20],[21,22]>,
  <[3],[],[19],[21],[4],[5,6],[20],[22]>,
  <[3],[],[19],[21,22],[4],[5,6],[20],[]>,
  <[3],[],[19],[],[4],[5,6],[20],[23,24]>,
  <[3],[],[19],[23],[4],[5,6],[20],[24]>,
  <[3],[],[19],[23,24],[4],[5,6],[20],[]>,
  <[3],[],[19,20],[],[4],[5,6],[],[21,22]>,
  <[3],[],[19,20],[21],[4],[5,6],[],[22]>,
  <[3],[],[19,20],[21,22],[4],[5,6],[],[]>,
  <[3],[],[19,20],[],[4],[5,6],[],[23,24]>,
  <[3],[],[19,20],[23],[4],[5,6],[],[24]>,
  <[3],[],[19,20],[23,24],[4],[5,6],[],[]>,
  <[3],[],[],[],[4],[5,6],[25,26],[29,30]>,
  <[3],[],[],[29],[4],[5,6],[25,26],[30]>,
  <[3],[],[],[29,30],[4],[5,6],[25,26],[]>,
  <[3],[],[],[],[4],[5,6],[25,26],[31,32]>,
  <[3],[],[],[31],[4],[5,6],[25,26],[32]>,
  <[3],[],[],[31,32],[4],[5,6],[25,26],[]>,
  <[3],[],[25],[],[4],[5,6],[26],[29,30]>,
  <[3],[],[25],[29],[4],[5,6],[26],[30]>,
  <[3],[],[25],[29,30],[4],[5,6],[26],[]>,
  <[3],[],[25],[],[4],[5,6],[26],[31,32]>,
  <[3],[],[25],[31],[4],[5,6],[26],[32]>,
  <[3],[],[25],[31,32],[4],[5,6],[26],[]>,
  <[3],[],[25,26],[],[4],[5,6],[],[29,30]>,
  <[3],[],[25,26],[29],[4],[5,6],[],[30]>,
  <[3],[],[25,26],[29,30],[4],[5,6],[],[]>,
  <[3],[],[25,26],[],[4],[5,6],[],[31,32]>,
  <[3],[],[25,26],[31],[4],[5,6],[],[32]>,
  <[3],[],[25,26],[31,32],[4],[5,6],[],[]>,
  <[3],[],[],[],[4],[5,6],[27,28],[29,30]>,
  <[3],[],[],[29],[4],[5,6],[27,28],[30]>,
  <[3],[],[],[29,30],[4],[5,6],[27,28],[]>,
  <[3],[],[],[],[4],[5,6],[27,28],[31,32]>,
  <[3],[],[],[31],[4],[5,6],[27,28],[32]>,
  <[3],[],[],[31,32],[4],[5,6],[27,28],[]>,
  <[3],[],[27],[],[4],[5,6],[28],[29,30]>,
  <[3],[],[27],[29],[4],[5,6],[28],[30]>,
  <[3],[],[27],[29,30],[4],[5,6],[28],[]>,
  <[3],[],[27],[],[4],[5,6],[28],[31,32]>,
  <[3],[],[27],[31],[4],[5,6],[28],[32]>,
  <[3],[],[27],[31,32],[4],[5,6],[28],[]>,
  <[3],[],[27,28],[],[4],[5,6],[],[29,30]>,
  <[3],[],[27,28],[29],[4],[5,6],[],[30]>,
  <[3],[],[27,28],[29,30],[4],[5,6],[],[]>,
  <[3],[],[27,28],[],[4],[5,6],[],[31,32]>,
  <[3],[],[27,28],[31],[4],[5,6],[],[32]>,
  <[3],[],[27,28],[31,32],[4],[5,6],[],[]>,
  <[3],[5],[],[],[4],[6],[17,18],[21,22]>,
  <[3],[5],[],[21],[4],[6],[17,18],[22]>,
  <[3],[5],[],[21,22],[4],[6],[17,18],[]>,
  <[3],[5],[],[],[4],[6],[17,18],[23,24]>,
  <[3],[5],[],[23],[4],[6],[17,18],[24]>,
  <[3],[5],[],[23,24],[4],[6],[17,18],[]>,
  <[3],[5],[17],[],[4],[6],[18],[21,22]>,
  <[3],[5],[17],[21],[4],[6],[18],[22]>,
  <[3],[5],[17],[21,22],[4],[6],[18],[]>,
  <[3],[5],[17],[],[4],[6],[18],[23,24]>,
  <[3],[5],[17],[23],[4],[6],[18],[24]>,
  <[3],[5],[17],[23,24],[4],[6],[18],[]>,
  <[3],[5],[17,18],[],[4],[6],[],[21,22]>,
  <[3],[5],[17,18],[21],[4],[6],[],[22]>,
  <[3],[5],[17,18],[21,22],[4],[6],[],[]>,
  <[3],[5],[17,18],[],[4],[6],[],[23,24]>,
  <[3],[5],[17,18],[23],[4],[6],[],[24]>,
  <[3],[5],[17,18],[23,24],[4],[6],[],[]>,
  <[3],[5],[],[],[4],[6],[19,20],[21,22]>,
  <[3],[5],[],[21],[4],[6],[19,20],[22]>,
  <[3],[5],[],[21,22],[4],[6],[19,20],[]>,
  <[3],[5],[],[],[4],[6],[19,20],[23,24]>,
  <[3],[5],[],[23],[4],[6],[19,20],[24]>,
  <[3],[5],[],[23,24],[4],[6],[19,20],[]>,
  <[3],[5],[19],[],[4],[6],[20],[21,22]>,
  <[3],[5],[19],[21],[4],[6],[20],[22]>,
  <[3],[5],[19],[21,22],[4],[6],[20],[]>,
  <[3],[5],[19],[],[4],[6],[20],[23,24]>,
  <[3],[5],[19],[23],[4],[6],[20],[24]>,
  <[3],[5],[19],[23,24],[4],[6],[20],[]>,
  <[3],[5],[19,20],[],[4],[6],[],[21,22]>,
  <[3],[5],[19,20],[21],[4],[6],[],[22]>,
  <[3],[5],[19,20],[21,22],[4],[6],[],[]>,
  <[3],[5],[19,20],[],[4],[6],[],[23,24]>,
  <[3],[5],[19,20],[23],[4],[6],[],[24]>,
  <[3],[5],[19,20],[23,24],[4],[6],[],[]>,
  <[3],[5],[],[],[4],[6],[25,26],[29,30]>,
  <[3],[5],[],[29],[4],[6],[25,26],[30]>,
  <[3],[5],[],[29,30],[4],[6],[25,26],[]>,
  <[3],[5],[],[],[4],[6],[25,26],[31,32]>,
  <[3],[5],[],[31],[4],[6],[25,26],[32]>,
  <[3],[5],[],[31,32],[4],[6],[25,26],[]>,
  <[3],[5],[25],[],[4],[6],[26],[29,30]>,
  <[3],[5],[25],[29],[4],[6],[26],[30]>,
  <[3],[5],[25],[29,30],[4],[6],[26],[]>,
  <[3],[5],[25],[],[4],[6],[26],[31,32]>,
  <[3],[5],[25],[31],[4],[6],[26],[32]>,
  <[3],[5],[25],[31,32],[4],[6],[26],[]>,
  <[3],[5],[25,26],[],[4],[6],[],[29,30]>,
  <[3],[5],[25,26],[29],[4],[6],[],[30]>,
  <[3],[5],[25,26],[29,30],[4],[6],[],[]>,
  <[3],[5],[25,26],[],[4],[6],[],[31,32]>,
  <[3],[5],[25,26],[31],[4],[6],[],[32]>,
  <[3],[5],[25,26],[31,32],[4],[6],[],[]>,
  <[3],[5],[],[],[4],[6],[27,28],[29,30]>,
  <[3],[5],[],[29],[4],[6],[27,28],[30]>,
  <[3],[5],[],[29,30],[4],[6],[27,28],[]>,
  <[3],[5],[],[],[4],[6],[27,28],[31,32]>,
  <[3],[5],[],[31],[4],[6],[27,28],[32]>,
  <[3],[5],[],[31,32],[4],[6],[27,28],[]>,
  <[3],[5],[27],[],[4],[6],[28],[29,30]>,
  <[3],[5],[27],[29],[4],[6],[28],[30]>,
  <[3],[5],[27],[29,30],[4],[6],[28],[]>,
  <[3],[5],[27],[],[4],[6],[28],[31,32]>,
  <[3],[5],[27],[31],[4],[6],[28],[32]>,
  <[3],[5],[27],[31,32],[4],[6],[28],[]>,
  <[3],[5],[27,28],[],[4],[6],[],[29,30]>,
  <[3],[5],[27,28],[29],[4],[6],[],[30]>,
  <[3],[5],[27,28],[29,30],[4],[6],[],[]>,
  <[3],[5],[27,28],[],[4],[6],[],[31,32]>,
  <[3],[5],[27,28],[31],[4],[6],[],[32]>,
  <[3],[5],[27,28],[31,32],[4],[6],[],[]>,
  <[3],[5,6],[],[],[4],[],[17,18],[21,22]>,
  <[3],[5,6],[],[21],[4],[],[17,18],[22]>,
  <[3],[5,6],[],[21,22],[4],[],[17,18],[]>,
  <[3],[5,6],[],[],[4],[],[17,18],[23,24]>,
  <[3],[5,6],[],[23],[4],[],[17,18],[24]>,
  <[3],[5,6],[],[23,24],[4],[],[17,18],[]>,
  <[3],[5,6],[17],[],[4],[],[18],[21,22]>,
  <[3],[5,6],[17],[21],[4],[],[18],[22]>,
  <[3],[5,6],[17],[21,22],[4],[],[18],[]>,
  <[3],[5,6],[17],[],[4],[],[18],[23,24]>,
  <[3],[5,6],[17],[23],[4],[],[18],[24]>,
  <[3],[5,6],[17],[23,24],[4],[],[18],[]>,
  <[3],[5,6],[17,18],[],[4],[],[],[21,22]>,
  <[3],[5,6],[17,18],[21],[4],[],[],[22]>,
  <[3],[5,6],[17,18],[21,22],[4],[],[],[]>,
  <[3],[5,6],[17,18],[],[4],[],[],[23,24]>,
  <[3],[5,6],[17,18],[23],[4],[],[],[24]>,
  <[3],[5,6],[17,18],[23,24],[4],[],[],[]>,
  <[3],[5,6],[],[],[4],[],[19,20],[21,22]>,
  <[3],[5,6],[],[21],[4],[],[19,20],[22]>,
  <[3],[5,6],[],[21,22],[4],[],[19,20],[]>,
  <[3],[5,6],[],[],[4],[],[19,20],[23,24]>,
  <[3],[5,6],[],[23],[4],[],[19,20],[24]>,
  <[3],[5,6],[],[23,24],[4],[],[19,20],[]>,
  <[3],[5,6],[19],[],[4],[],[20],[21,22]>,
  <[3],[5,6],[19],[21],[4],[],[20],[22]>,
  <[3],[5,6],[19],[21,22],[4],[],[20],[]>,
  <[3],[5,6],[19],[],[4],[],[20],[23,24]>,
  <[3],[5,6],[19],[23],[4],[],[20],[24]>,
  <[3],[5,6],[19],[23,24],[4],[],[20],[]>,
  <[3],[5,6],[19,20],[],[4],[],[],[21,22]>,
  <[3],[5,6],[19,20],[21],[4],[],[],[22]>,
  <[3],[5,6],[19,20],[21,22],[4],[],[],[]>,
  <[3],[5,6],[19,20],[],[4],[],[],[23,24]>,
  <[3],[5,6],[19,20],[23],[4],[],[],[24]>,
  <[3],[5,6],[19,20],[23,24],[4],[],[],[]>,
  <[3],[5,6],[],[],[4],[],[25,26],[29,30]>,
  <[3],[5,6],[],[29],[4],[],[25,26],[30]>,
  <[3],[5,6],[],[29,30],[4],[],[25,26],[]>,
  <[3],[5,6],[],[],[4],[],[25,26],[31,32]>,
  <[3],[5,6],[],[31],[4],[],[25,26],[32]>,
  <[3],[5,6],[],[31,32],[4],[],[25,26],[]>,
  <[3],[5,6],[25],[],[4],[],[26],[29,30]>,
  <[3],[5,6],[25],[29],[4],[],[26],[30]>,
  <[3],[5,6],[25],[29,30],[4],[],[26],[]>,
  <[3],[5,6],[25],[],[4],[],[26],[31,32]>,
  <[3],[5,6],[25],[31],[4],[],[26],[32]>,
  <[3],[5,6],[25],[31,32],[4],[],[26],[]>,
  <[3],[5,6],[25,26],[],[4],[],[],[29,30]>,
  <[3],[5,6],[25,26],[29],[4],[],[],[30]>,
  <[3],[5,6],[25,26],[29,30],[4],[],[],[]>,
  <[3],[5,6],[25,26],[],[4],[],[],[31,32]>,
  <[3],[5,6],[25,26],[31],[4],[],[],[32]>,
  <[3],[5,6],[25,26],[31,32],[4],[],[],[]>,
  <[3],[5,6],[],[],[4],[],[27,28],[29,30]>,
  <[3],[5,6],[],[29],[4],[],[27,28],[30]>,
  <[3],[5,6],[],[29,30],[4],[],[27,28],[]>,
  <[3],[5,6],[],[],[4],[],[27,28],[31,32]>,
  <[3],[5,6],[],[31],[4],[],[27,28],[32]>,
  <[3],[5,6],[],[31,32],[4],[],[27,28],[]>,
  <[3],[5,6],[27],[],[4],[],[28],[29,30]>,
  <[3],[5,6],[27],[29],[4],[],[28],[30]>,
  <[3],[5,6],[27],[29,30],[4],[],[28],[]>,
  <[3],[5,6],[27],[],[4],[],[28],[31,32]>,
  <[3],[5,6],[27],[31],[4],[],[28],[32]>,
  <[3],[5,6],[27],[31,32],[4],[],[28],[]>,
  <[3],[5,6],[27,28],[],[4],[],[],[29,30]>,
  <[3],[5,6],[27,28],[29],[4],[],[],[30]>,
  <[3],[5,6],[27,28],[29,30],[4],[],[],[]>,
  <[3],[5,6],[27,28],[],[4],[],[],[31,32]>,
  <[3],[5,6],[27,28],[31],[4],[],[],[32]>,
  <[3],[5,6],[27,28],[31,32],[4],[],[],[]>,
  <[3],[],[],[],[4],[7,8],[17,18],[21,22]>,
  <[3],[],[],[21],[4],[7,8],[17,18],[22]>,
  <[3],[],[],[21,22],[4],[7,8],[17,18],[]>,
  <[3],[],[],[],[4],[7,8],[17,18],[23,24]>,
  <[3],[],[],[23],[4],[7,8],[17,18],[24]>,
  <[3],[],[],[23,24],[4],[7,8],[17,18],[]>,
  <[3],[],[17],[],[4],[7,8],[18],[21,22]>,
  <[3],[],[17],[21],[4],[7,8],[18],[22]>,
  <[3],[],[17],[21,22],[4],[7,8],[18],[]>,
  <[3],[],[17],[],[4],[7,8],[18],[23,24]>,
  <[3],[],[17],[23],[4],[7,8],[18],[24]>,
  <[3],[],[17],[23,24],[4],[7,8],[18],[]>,
  <[3],[],[17,18],[],[4],[7,8],[],[21,22]>,
  <[3],[],[17,18],[21],[4],[7,8],[],[22]>,
  <[3],[],[17,18],[21,22],[4],[7,8],[],[]>,
  <[3],[],[17,18],[],[4],[7,8],[],[23,24]>,
  <[3],[],[17,18],[23],[4],[7,8],[],[24]>,
  <[3],[],[17,18],[23,24],[4],[7,8],[],[]>,
  <[3],[],[],[],[4],[7,8],[19,20],[21,22]>,
  <[3],[],[],[21],[4],[7,8],[19,20],[22]>,
  <[3],[],[],[21,22],[4],[7,8],[19,20],[]>,
  <[3],[],[],[],[4],[7,8],[19,20],[23,24]>,
  <[3],[],[],[23],[4],[7,8],[19,20],[24]>,
  <[3],[],[],[23,24],[4],[7,8],[19,20],[]>,
  <[3],[],[19],[],[4],[7,8],[20],[21,22]>,
  <[3],[],[19],[21],[4],[7,8],[20],[22]>,
  <[3],[],[19],[21,22],[4],[7,8],[20],[]>,
  <[3],[],[19],[],[4],[7,8],[20],[23,24]>,
  <[3],[],[19],[23],[4],[7,8],[20],[24]>,
  <[3],[],[19],[23,24],[4],[7,8],[20],[]>,
  <[3],[],[19,20],[],[4],[7,8],[],[21,22]>,
  <[3],[],[19,20],[21],[4],[7,8],[],[22]>,
  <[3],[],[19,20],[21,22],[4],[7,8],[],[]>,
  <[3],[],[19,20],[],[4],[7,8],[],[23,24]>,
  <[3],[],[19,20],[23],[4],[7,8],[],[24]>,
  <[3],[],[19,20],[23,24],[4],[7,8],[],[]>,
  <[3],[],[],[],[4],[7,8],[25,26],[29,30]>,
  <[3],[],[],[29],[4],[7,8],[25,26],[30]>,
  <[3],[],[],[29,30],[4],[7,8],[25,26],[]>,
  <[3],[],[],[],[4],[7,8],[25,26],[31,32]>,
  <[3],[],[],[31],[4],[7,8],[25,26],[32]>,
  <[3],[],[],[31,32],[4],[7,8],[25,26],[]>,
  <[3],[],[25],[],[4],[7,8],[26],[29,30]>,
  <[3],[],[25],[29],[4],[7,8],[26],[30]>,
  <[3],[],[25],[29,30],[4],[7,8],[26],[]>,
  <[3],[],[25],[],[4],[7,8],[26],[31,32]>,
  <[3],[],[25],[31],[4],[7,8],[26],[32]>,
  <[3],[],[25],[31,32],[4],[7,8],[26],[]>,
  <[3],[],[25,26],[],[4],[7,8],[],[29,30]>,
  <[3],[],[25,26],[29],[4],[7,8],[],[30]>,
  <[3],[],[25,26],[29,30],[4],[7,8],[],[]>,
  <[3],[],[25,26],[],[4],[7,8],[],[31,32]>,
  <[3],[],[25,26],[31],[4],[7,8],[],[32]>,
  <[3],[],[25,26],[31,32],[4],[7,8],[],[]>,
  <[3],[],[],[],[4],[7,8],[27,28],[29,30]>,
  <[3],[],[],[29],[4],[7,8],[27,28],[30]>,
  <[3],[],[],[29,30],[4],[7,8],[27,28],[]>,
  <[3],[],[],[],[4],[7,8],[27,28],[31,32]>,
  <[3],[],[],[31],[4],[7,8],[27,28],[32]>,
  <[3],[],[],[31,32],[4],[7,8],[27,28],[]>,
  <[3],[],[27],[],[4],[7,8],[28],[29,30]>,
  <[3],[],[27],[29],[4],[7,8],[28],[30]>,
  <[3],[],[27],[29,30],[4],[7,8],[28],[]>,
  <[3],[],[27],[],[4],[7,8],[28],[31,32]>,
  <[3],[],[27],[31],[4],[7,8],[28],[32]>,
  <[3],[],[27],[31,32],[4],[7,8],[28],[]>,
  <[3],[],[27,28],[],[4],[7,8],[],[29,30]>,
  <[3],[],[27,28],[29],[4],[7,8],[],[30]>,
  <[3],[],[27,28],[29,30],[4],[7,8],[],[]>,
  <[3],[],[27,28],[],[4],[7,8],[],[31,32]>,
  <[3],[],[27,28],[31],[4],[7,8],[],[32]>,
  <[3],[],[27,28],[31,32],[4],[7,8],[],[]>,
  <[3],[7],[],[],[4],[8],[17,18],[21,22]>,
  <[3],[7],[],[21],[4],[8],[17,18],[22]>,
  <[3],[7],[],[21,22],[4],[8],[17,18],[]>,
  <[3],[7],[],[],[4],[8],[17,18],[23,24]>,
  <[3],[7],[],[23],[4],[8],[17,18],[24]>,
  <[3],[7],[],[23,24],[4],[8],[17,18],[]>,
  <[3],[7],[17],[],[4],[8],[18],[21,22]>,
  <[3],[7],[17],[21],[4],[8],[18],[22]>,
  <[3],[7],[17],[21,22],[4],[8],[18],[]>,
  <[3],[7],[17],[],[4],[8],[18],[23,24]>,
  <[3],[7],[17],[23],[4],[8],[18],[24]>,
  <[3],[7],[17],[23,24],[4],[8],[18],[]>,
  <[3],[7],[17,18],[],[4],[8],[],[21,22]>,
  <[3],[7],[17,18],[21],[4],[8],[],[22]>,
  <[3],[7],[17,18],[21,22],[4],[8],[],[]>,
  <[3],[7],[17,18],[],[4],[8],[],[23,24]>,
  <[3],[7],[17,18],[23],[4],[8],[],[24]>,
  <[3],[7],[17,18],[23,24],[4],[8],[],[]>,
  <[3],[7],[],[],[4],[8],[19,20],[21,22]>,
  <[3],[7],[],[21],[4],[8],[19,20],[22]>,
  <[3],[7],[],[21,22],[4],[8],[19,20],[]>,
  <[3],[7],[],[],[4],[8],[19,20],[23,24]>,
  <[3],[7],[],[23],[4],[8],[19,20],[24]>,
  <[3],[7],[],[23,24],[4],[8],[19,20],[]>,
  <[3],[7],[19],[],[4],[8],[20],[21,22]>,
  <[3],[7],[19],[21],[4],[8],[20],[22]>,
  <[3],[7],[19],[21,22],[4],[8],[20],[]>,
  <[3],[7],[19],[],[4],[8],[20],[23,24]>,
  <[3],[7],[19],[23],[4],[8],[20],[24]>,
  <[3],[7],[19],[23,24],[4],[8],[20],[]>,
  <[3],[7],[19,20],[],[4],[8],[],[21,22]>,
  <[3],[7],[19,20],[21],[4],[8],[],[22]>,
  <[3],[7],[19,20],[21,22],[4],[8],[],[]>,
  <[3],[7],[19,20],[],[4],[8],[],[23,24]>,
  <[3],[7],[19,20],[23],[4],[8],[],[24]>,
  <[3],[7],[19,20],[23,24],[4],[8],[],[]>,
  <[3],[7],[],[],[4],[8],[25,26],[29,30]>,
  <[3],[7],[],[29],[4],[8],[25,26],[30]>,
  <[3],[7],[],[29,30],[4],[8],[25,26],[]>,
  <[3],[7],[],[],[4],[8],[25,26],[31,32]>,
  <[3],[7],[],[31],[4],[8],[25,26],[32]>,
  <[3],[7],[],[31,32],[4],[8],[25,26],[]>,
  <[3],[7],[25],[],[4],[8],[26],[29,30]>,
  <[3],[7],[25],[29],[4],[8],[26],[30]>,
  <[3],[7],[25],[29,30],[4],[8],[26],[]>,
  <[3],[7],[25],[],[4],[8],[26],[31,32]>,
  <[3],[7],[25],[31],[4],[8],[26],[32]>,
  <[3],[7],[25],[31,32],[4],[8],[26],[]>,
  <[3],[7],[25,26],[],[4],[8],[],[29,30]>,
  <[3],[7],[25,26],[29],[4],[8],[],[30]>,
  <[3],[7],[25,26],[29,30],[4],[8],[],[]>,
  <[3],[7],[25,26],[],[4],[8],[],[31,32]>,
  <[3],[7],[25,26],[31],[4],[8],[],[32]>,
  <[3],[7],[25,26],[31,32],[4],[8],[],[]>,
  <[3],[7],[],[],[4],[8],[27,28],[29,30]>,
  <[3],[7],[],[29],[4],[8],[27,28],[30]>,
  <[3],[7],[],[29,30],[4],[8],[27,28],[]>,
  <[3],[7],[],[],[4],[8],[27,28],[31,32]>,
  <[3],[7],[],[31],[4],[8],[27,28],[32]>,
  <[3],[7],[],[31,32],[4],[8],[27,28],[]>,
  <[3],[7],[27],[],[4],[8],[28],[29,30]>,
  <[3],[7],[27],[29],[4],[8],[28],[30]>,
  <[3],[7],[27],[29,30],[4],[8],[28],[]>,
  <[3],[7],[27],[],[4],[8],[28],[31,32]>,
  <[3],[7],[27],[31],[4],[8],[28],[32]>,
  <[3],[7],[27],[31,32],[4],[8],[28],[]>,
  <[3],[7],[27,28],[],[4],[8],[],[29,30]>,
  <[3],[7],[27,28],[29],[4],[8],[],[30]>,
  <[3],[7],[27,28],[29,30],[4],[8],[],[]>,
  <[3],[7],[27,28],[],[4],[8],[],[31,32]>,
  <[3],[7],[27,28],[31],[4],[8],[],[32]>,
  <[3],[7],[27,28],[31,32],[4],[8],[],[]>,
  <[3],[7,8],[],[],[4],[],[17,18],[21,22]>,
  <[3],[7,8],[],[21],[4],[],[17,18],[22]>,
  <[3],[7,8],[],[21,22],[4],[],[17,18],[]>,
  <[3],[7,8],[],[],[4],[],[17,18],[23,24]>,
  <[3],[7,8],[],[23],[4],[],[17,18],[24]>,
  <[3],[7,8],[],[23,24],[4],[],[17,18],[]>,
  <[3],[7,8],[17],[],[4],[],[18],[21,22]>,
  <[3],[7,8],[17],[21],[4],[],[18],[22]>,
  <[3],[7,8],[17],[21,22],[4],[],[18],[]>,
  <[3],[7,8],[17],[],[4],[],[18],[23,24]>,
  <[3],[7,8],[17],[23],[4],[],[18],[24]>,
  <[3],[7,8],[17],[23,24],[4],[],[18],[]>,
  <[3],[7,8],[17,18],[],[4],[],[],[21,22]>,
  <[3],[7,8],[17,18],[21],[4],[],[],[22]>,
  <[3],[7,8],[17,18],[21,22],[4],[],[],[]>,
  <[3],[7,8],[17,18],[],[4],[],[],[23,24]>,
  <[3],[7,8],[17,18],[23],[4],[],[],[24]>,
  <[3],[7,8],[17,18],[23,24],[4],[],[],[]>,
  <[3],[7,8],[],[],[4],[],[19,20],[21,22]>,
  <[3],[7,8],[],[21],[4],[],[19,20],[22]>,
  <[3],[7,8],[],[21,22],[4],[],[19,20],[]>,
  <[3],[7,8],[],[],[4],[],[19,20],[23,24]>,
  <[3],[7,8],[],[23],[4],[],[19,20],[24]>,
  <[3],[7,8],[],[23,24],[4],[],[19,20],[]>,
  <[3],[7,8],[19],[],[4],[],[20],[21,22]>,
  <[3],[7,8],[19],[21],[4],[],[20],[22]>,
  <[3],[7,8],[19],[21,22],[4],[],[20],[]>,
  <[3],[7,8],[19],[],[4],[],[20],[23,24]>,
  <[3],[7,8],[19],[23],[4],[],[20],[24]>,
  <[3],[7,8],[19],[23,24],[4],[],[20],[]>,
  <[3],[7,8],[19,20],[],[4],[],[],[21,22]>,
  <[3],[7,8],[19,20],[21],[4],[],[],[22]>,
  <[3],[7,8],[19,20],[21,22],[4],[],[],[]>,
  <[3],[7,8],[19,20],[],[4],[],[],[23,24]>,
  <[3],[7,8],[19,20],[23],[4],[],[],[24]>,
  <[3],[7,8],[19,20],[23,24],[4],[],[],[]>,
  <[3],[7,8],[],[],[4],[],[25,26],[29,30]>,
  <[3],[7,8],[],[29],[4],[],[25,26],[30]>,
  <[3],[7,8],[],[29,30],[4],[],[25,26],[]>,
  <[3],[7,8],[],[],[4],[],[25,26],[31,32]>,
  <[3],[7,8],[],[31],[4],[],[25,26],[32]>,
  <[3],[7,8],[],[31,32],[4],[],[25,26],[]>,
  <[3],[7,8],[25],[],[4],[],[26],[29,30]>,
  <[3],[7,8],[25],[29],[4],[],[26],[30]>,
  <[3],[7,8],[25],[29,30],[4],[],[26],[]>,
  <[3],[7,8],[25],[],[4],[],[26],[31,32]>,
  <[3],[7,8],[25],[31],[4],[],[26],[32]>,
  <[3],[7,8],[25],[31,32],[4],[],[26],[]>,
  <[3],[7,8],[25,26],[],[4],[],[],[29,30]>,
  <[3],[7,8],[25,26],[29],[4],[],[],[30]>,
  <[3],[7,8],[25,26],[29,30],[4],[],[],[]>,
  <[3],[7,8],[25,26],[],[4],[],[],[31,32]>,
  <[3],[7,8],[25,26],[31],[4],[],[],[32]>,
  <[3],[7,8],[25,26],[31,32],[4],[],[],[]>,
  <[3],[7,8],[],[],[4],[],[27,28],[29,30]>,
  <[3],[7,8],[],[29],[4],[],[27,28],[30]>,
  <[3],[7,8],[],[29,30],[4],[],[27,28],[]>,
  <[3],[7,8],[],[],[4],[],[27,28],[31,32]>,
  <[3],[7,8],[],[31],[4],[],[27,28],[32]>,
  <[3],[7,8],[],[31,32],[4],[],[27,28],[]>,
  <[3],[7,8],[27],[],[4],[],[28],[29,30]>,
  <[3],[7,8],[27],[29],[4],[],[28],[30]>,
  <[3],[7,8],[27],[29,30],[4],[],[28],[]>,
  <[3],[7,8],[27],[],[4],[],[28],[31,32]>,
  <[3],[7,8],[27],[31],[4],[],[28],[32]>,
  <[3],[7,8],[27],[31,32],[4],[],[28],[]>,
  <[3],[7,8],[27,28],[],[4],[],[],[29,30]>,
  <[3],[7,8],[27,28],[29],[4],[],[],[30]>,
  <[3],[7,8],[27,28],[29,30],[4],[],[],[]>,
  <[3],[7,8],[27,28],[],[4],[],[],[31,32]>,
  <[3],[7,8],[27,28],[31],[4],[],[],[32]>,
  <[3],[7,8],[27,28],[31,32],[4],[],[],[]>,
  <[3,4],[],[],[],[],[5,6],[17,18],[21,22]>,
  <[3,4],[],[],[21],[],[5,6],[17,18],[22]>,
  <[3,4],[],[],[21,22],[],[5,6],[17,18],[]>,
  <[3,4],[],[],[],[],[5,6],[17,18],[23,24]>,
  <[3,4],[],[],[23],[],[5,6],[17,18],[24]>,
  <[3,4],[],[],[23,24],[],[5,6],[17,18],[]>,
  <[3,4],[],[17],[],[],[5,6],[18],[21,22]>,
  <[3,4],[],[17],[21],[],[5,6],[18],[22]>,
  <[3,4],[],[17],[21,22],[],[5,6],[18],[]>,
  <[3,4],[],[17],[],[],[5,6],[18],[23,24]>,
  <[3,4],[],[17],[23],[],[5,6],[18],[24]>,
  <[3,4],[],[17],[23,24],[],[5,6],[18],[]>,
  <[3,4],[],[17,18],[],[],[5,6],[],[21,22]>,
  <[3,4],[],[17,18],[21],[],[5,6],[],[22]>,
  <[3,4],[],[17,18],[21,22],[],[5,6],[],[]>,
  <[3,4],[],[17,18],[],[],[5,6],[],[23,24]>,
  <[3,4],[],[17,18],[23],[],[5,6],[],[24]>,
  <[3,4],[],[17,18],[23,24],[],[5,6],[],[]>,
  <[3,4],[],[],[],[],[5,6],[19,20],[21,22]>,
  <[3,4],[],[],[21],[],[5,6],[19,20],[22]>,
  <[3,4],[],[],[21,22],[],[5,6],[19,20],[]>,
  <[3,4],[],[],[],[],[5,6],[19,20],[23,24]>,
  <[3,4],[],[],[23],[],[5,6],[19,20],[24]>,
  <[3,4],[],[],[23,24],[],[5,6],[19,20],[]>,
  <[3,4],[],[19],[],[],[5,6],[20],[21,22]>,
  <[3,4],[],[19],[21],[],[5,6],[20],[22]>,
  <[3,4],[],[19],[21,22],[],[5,6],[20],[]>,
  <[3,4],[],[19],[],[],[5,6],[20],[23,24]>,
  <[3,4],[],[19],[23],[],[5,6],[20],[24]>,
  <[3,4],[],[19],[23,24],[],[5,6],[20],[]>,
  <[3,4],[],[19,20],[],[],[5,6],[],[21,22]>,
  <[3,4],[],[19,20],[21],[],[5,6],[],[22]>,
  <[3,4],[],[19,20],[21,22],[],[5,6],[],[]>,
  <[3,4],[],[19,20],[],[],[5,6],[],[23,24]>,
  <[3,4],[],[19,20],[23],[],[5,6],[],[24]>,
  <[3,4],[],[19,20],[23,24],[],[5,6],[],[]>,
  <[3,4],[],[],[],[],[5,6],[25,26],[29,30]>,
  <[3,4],[],[],[29],[],[5,6],[25,26],[30]>,
  <[3,4],[],[],[29,30],[],[5,6],[25,26],[]>,
  <[3,4],[],[],[],[],[5,6],[25,26],[31,32]>,
  <[3,4],[],[],[31],[],[5,6],[25,26],[32]>,
  <[3,4],[],[],[31,32],[],[5,6],[25,26],[]>,
  <[3,4],[],[25],[],[],[5,6],[26],[29,30]>,
  <[3,4],[],[25],[29],[],[5,6],[26],[30]>,
  <[3,4],[],[25],[29,30],[],[5,6],[26],[]>,
  <[3,4],[],[25],[],[],[5,6],[26],[31,32]>,
  <[3,4],[],[25],[31],[],[5,6],[26],[32]>,
  <[3,4],[],[25],[31,32],[],[5,6],[26],[]>,
  <[3,4],[],[25,26],[],[],[5,6],[],[29,30]>,
  <[3,4],[],[25,26],[29],[],[5,6],[],[30]>,
  <[3,4],[],[25,26],[29,30],[],[5,6],[],[]>,
  <[3,4],[],[25,26],[],[],[5,6],[],[31,32]>,
  <[3,4],[],[25,26],[31],[],[5,6],[],[32]>,
  <[3,4],[],[25,26],[31,32],[],[5,6],[],[]>,
  <[3,4],[],[],[],[],[5,6],[27,28],[29,30]>,
  <[3,4],[],[],[29],[],[5,6],[27,28],[30]>,
  <[3,4],[],[],[29,30],[],[5,6],[27,28],[]>,
  <[3,4],[],[],[],[],[5,6],[27,28],[31,32]>,
  <[3,4],[],[],[31],[],[5,6],[27,28],[32]>,
  <[3,4],[],[],[31,32],[],[5,6],[27,28],[]>,
  <[3,4],[],[27],[],[],[5,6],[28],[29,30]>,
  <[3,4],[],[27],[29],[],[5,6],[28],[30]>,
  <[3,4],[],[27],[29,30],[],[5,6],[28],[]>,
  <[3,4],[],[27],[],[],[5,6],[28],[31,32]>,
  <[3,4],[],[27],[31],[],[5,6],[28],[32]>,
  <[3,4],[],[27],[31,32],[],[5,6],[28],[]>,
  <[3,4],[],[27,28],[],[],[5,6],[],[29,30]>,
  <[3,4],[],[27,28],[29],[],[5,6],[],[30]>,
  <[3,4],[],[27,28],[29,30],[],[5,6],[],[]>,
  <[3,4],[],[27,28],[],[],[5,6],[],[31,32]>,
  <[3,4],[],[27,28],[31],[],[5,6],[],[32]>,
  <[3,4],[],[27,28],[31,32],[],[5,6],[],[]>,
  <[3,4],[5],[],[],[],[6],[17,18],[21,22]>,
  <[3,4],[5],[],[21],[],[6],[17,18],[22]>,
  <[3,4],[5],[],[21,22],[],[6],[17,18],[]>,
  <[3,4],[5],[],[],[],[6],[17,18],[23,24]>,
  <[3,4],[5],[],[23],[],[6],[17,18],[24]>,
  <[3,4],[5],[],[23,24],[],[6],[17,18],[]>,
  <[3,4],[5],[17],[],[],[6],[18],[21,22]>,
  <[3,4],[5],[17],[21],[],[6],[18],[22]>,
  <[3,4],[5],[17],[21,22],[],[6],[18],[]>,
  <[3,4],[5],[17],[],[],[6],[18],[23,24]>,
  <[3,4],[5],[17],[23],[],[6],[18],[24]>,
  <[3,4],[5],[17],[23,24],[],[6],[18],[]>,
  <[3,4],[5],[17,18],[],[],[6],[],[21,22]>,
  <[3,4],[5],[17,18],[21],[],[6],[],[22]>,
  <[3,4],[5],[17,18],[21,22],[],[6],[],[]>,
  <[3,4],[5],[17,18],[],[],[6],[],[23,24]>,
  <[3,4],[5],[17,18],[23],[],[6],[],[24]>,
  <[3,4],[5],[17,18],[23,24],[],[6],[],[]>,
  <[3,4],[5],[],[],[],[6],[19,20],[21,22]>,
  <[3,4],[5],[],[21],[],[6],[19,20],[22]>,
  <[3,4],[5],[],[21,22],[],[6],[19,20],[]>,
  <[3,4],[5],[],[],[],[6],[19,20],[23,24]>,
  <[3,4],[5],[],[23],[],[6],[19,20],[24]>,
  <[3,4],[5],[],[23,24],[],[6],[19,20],[]>,
  <[3,4],[5],[19],[],[],[6],[20],[21,22]>,
  <[3,4],[5],[19],[21],[],[6],[20],[22]>,
  <[3,4],[5],[19],[21,22],[],[6],[20],[]>,
  <[3,4],[5],[19],[],[],[6],[20],[23,24]>,
  <[3,4],[5],[19],[23],[],[6],[20],[24]>,
  <[3,4],[5],[19],[23,24],[],[6],[20],[]>,
  <[3,4],[5],[19,20],[],[],[6],[],[21,22]>,
  <[3,4],[5],[19,20],[21],[],[6],[],[22]>,
  <[3,4],[5],[19,20],[21,22],[],[6],[],[]>,
  <[3,4],[5],[19,20],[],[],[6],[],[23,24]>,
  <[3,4],[5],[19,20],[23],[],[6],[],[24]>,
  <[3,4],[5],[19,20],[23,24],[],[6],[],[]>,
  <[3,4],[5],[],[],[],[6],[25,26],[29,30]>,
  <[3,4],[5],[],[29],[],[6],[25,26],[30]>,
  <[3,4],[5],[],[29,30],[],[6],[25,26],[]>,
  <[3,4],[5],[],[],[],[6],[25,26],[31,32]>,
  <[3,4],[5],[],[31],[],[6],[25,26],[32]>,
  <[3,4],[5],[],[31,32],[],[6],[25,26],[]>,
  <[3,4],[5],[25],[],[],[6],[26],[29,30]>,
  <[3,4],[5],[25],[29],[],[6],[26],[30]>,
  <[3,4],[5],[25],[29,30],[],[6],[26],[]>,
  <[3,4],[5],[25],[],[],[6],[26],[31,32]>,
  <[3,4],[5],[25],[31],[],[6],[26],[32]>,
  <[3,4],[5],[25],[31,32],[],[6],[26],[]>,
  <[3,4],[5],[25,26],[],[],[6],[],[29,30]>,
  <[3,4],[5],[25,26],[29],[],[6],[],[30]>,
  <[3,4],[5],[25,26],[29,30],[],[6],[],[]>,
  <[3,4],[5],[25,26],[],[],[6],[],[31,32]>,
  <[3,4],[5],[25,26],[31],[],[6],[],[32]>,
  <[3,4],[5],[25,26],[31,32],[],[6],[],[]>,
  <[3,4],[5],[],[],[],[6],[27,28],[29,30]>,
  <[3,4],[5],[],[29],[],[6],[27,28],[30]>,
  <[3,4],[5],[],[29,30],[],[6],[27,28],[]>,
  <[3,4],[5],[],[],[],[6],[27,28],[31,32]>,
  <[3,4],[5],[],[31],[],[6],[27,28],[32]>,
  <[3,4],[5],[],[31,32],[],[6],[27,28],[]>,
  <[3,4],[5],[27],[],[],[6],[28],[29,30]>,
  <[3,4],[5],[27],[29],[],[6],[28],[30]>,
  <[3,4],[5],[27],[29,30],[],[6],[28],[]>,
  <[3,4],[5],[27],[],[],[6],[28],[31,32]>,
  <[3,4],[5],[27],[31],[],[6],[28],[32]>,
  <[3,4],[5],[27],[31,32],[],[6],[28],[]>,
  <[3,4],[5],[27,28],[],[],[6],[],[29,30]>,
  <[3,4],[5],[27,28],[29],[],[6],[],[30]>,
  <[3,4],[5],[27,28],[29,30],[],[6],[],[]>,
  <[3,4],[5],[27,28],[],[],[6],[],[31,32]>,
  <[3,4],[5],[27,28],[31],[],[6],[],[32]>,
  <[3,4],[5],[27,28],[31,32],[],[6],[],[]>,
  <[3,4],[5,6],[],[],[],[],[17,18],[21,22]>,
  <[3,4],[5,6],[],[21],[],[],[17,18],[22]>,
  <[3,4],[5,6],[],[21,22],[],[],[17,18],[]>,
  <[3,4],[5,6],[],[],[],[],[17,18],[23,24]>,
  <[3,4],[5,6],[],[23],[],[],[17,18],[24]>,
  <[3,4],[5,6],[],[23,24],[],[],[17,18],[]>,
  <[3,4],[5,6],[17],[],[],[],[18],[21,22]>,
  <[3,4],[5,6],[17],[21],[],[],[18],[22]>,
  <[3,4],[5,6],[17],[21,22],[],[],[18],[]>,
  <[3,4],[5,6],[17],[],[],[],[18],[23,24]>,
  <[3,4],[5,6],[17],[23],[],[],[18],[24]>,
  <[3,4],[5,6],[17],[23,24],[],[],[18],[]>,
  <[3,4],[5,6],[17,18],[],[],[],[],[21,22]>,
  <[3,4],[5,6],[17,18],[21],[],[],[],[22]>,
  <[3,4],[5,6],[17,18],[21,22],[],[],[],[]>,
  <[3,4],[5,6],[17,18],[],[],[],[],[23,24]>,
  <[3,4],[5,6],[17,18],[23],[],[],[],[24]>,
  <[3,4],[5,6],[17,18],[23,24],[],[],[],[]>,
  <[3,4],[5,6],[],[],[],[],[19,20],[21,22]>,
  <[3,4],[5,6],[],[21],[],[],[19,20],[22]>,
  <[3,4],[5,6],[],[21,22],[],[],[19,20],[]>,
  <[3,4],[5,6],[],[],[],[],[19,20],[23,24]>,
  <[3,4],[5,6],[],[23],[],[],[19,20],[24]>,
  <[3,4],[5,6],[],[23,24],[],[],[19,20],[]>,
  <[3,4],[5,6],[19],[],[],[],[20],[21,22]>,
  <[3,4],[5,6],[19],[21],[],[],[20],[22]>,
  <[3,4],[5,6],[19],[21,22],[],[],[20],[]>,
  <[3,4],[5,6],[19],[],[],[],[20],[23,24]>,
  <[3,4],[5,6],[19],[23],[],[],[20],[24]>,
  <[3,4],[5,6],[19],[23,24],[],[],[20],[]>,
  <[3,4],[5,6],[19,20],[],[],[],[],[21,22]>,
  <[3,4],[5,6],[19,20],[21],[],[],[],[22]>,
  <[3,4],[5,6],[19,20],[21,22],[],[],[],[]>,
  <[3,4],[5,6],[19,20],[],[],[],[],[23,24]>,
  <[3,4],[5,6],[19,20],[23],[],[],[],[24]>,
  <[3,4],[5,6],[19,20],[23,24],[],[],[],[]>,
  <[3,4],[5,6],[],[],[],[],[25,26],[29,30]>,
  <[3,4],[5,6],[],[29],[],[],[25,26],[30]>,
  <[3,4],[5,6],[],[29,30],[],[],[25,26],[]>,
  <[3,4],[5,6],[],[],[],[],[25,26],[31,32]>,
  <[3,4],[5,6],[],[31],[],[],[25,26],[32]>,
  <[3,4],[5,6],[],[31,32],[],[],[25,26],[]>,
  <[3,4],[5,6],[25],[],[],[],[26],[29,30]>,
  <[3,4],[5,6],[25],[29],[],[],[26],[30]>,
  <[3,4],[5,6],[25],[29,30],[],[],[26],[]>,
  <[3,4],[5,6],[25],[],[],[],[26],[31,32]>,
  <[3,4],[5,6],[25],[31],[],[],[26],[32]>,
  <[3,4],[5,6],[25],[31,32],[],[],[26],[]>,
  <[3,4],[5,6],[25,26],[],[],[],[],[29,30]>,
  <[3,4],[5,6],[25,26],[29],[],[],[],[30]>,
  <[3,4],[5,6],[25,26],[29,30],[],[],[],[]>,
  <[3,4],[5,6],[25,26],[],[],[],[],[31,32]>,
  <[3,4],[5,6],[25,26],[31],[],[],[],[32]>,
  <[3,4],[5,6],[25,26],[31,32],[],[],[],[]>,
  <[3,4],[5,6],[],[],[],[],[27,28],[29,30]>,
  <[3,4],[5,6],[],[29],[],[],[27,28],[30]>,
  <[3,4],[5,6],[],[29,30],[],[],[27,28],[]>,
  <[3,4],[5,6],[],[],[],[],[27,28],[31,32]>,
  <[3,4],[5,6],[],[31],[],[],[27,28],[32]>,
  <[3,4],[5,6],[],[31,32],[],[],[27,28],[]>,
  <[3,4],[5,6],[27],[],[],[],[28],[29,30]>,
  <[3,4],[5,6],[27],[29],[],[],[28],[30]>,
  <[3,4],[5,6],[27],[29,30],[],[],[28],[]>,
  <[3,4],[5,6],[27],[],[],[],[28],[31,32]>,
  <[3,4],[5,6],[27],[31],[],[],[28],[32]>,
  <[3,4],[5,6],[27],[31,32],[],[],[28],[]>,
  <[3,4],[5,6],[27,28],[],[],[],[],[29,30]>,
  <[3,4],[5,6],[27,28],[29],[],[],[],[30]>,
  <[3,4],[5,6],[27,28],[29,30],[],[],[],[]>,
  <[3,4],[5,6],[27,28],[],[],[],[],[31,32]>,
  <[3,4],[5,6],[27,28],[31],[],[],[],[32]>,
  <[3,4],[5,6],[27,28],[31,32],[],[],[],[]>,
  <[3,4],[],[],[],[],[7,8],[17,18],[21,22]>,
  <[3,4],[],[],[21],[],[7,8],[17,18],[22]>,
  <[3,4],[],[],[21,22],[],[7,8],[17,18],[]>,
  <[3,4],[],[],[],[],[7,8],[17,18],[23,24]>,
  <[3,4],[],[],[23],[],[7,8],[17,18],[24]>,
  <[3,4],[],[],[23,24],[],[7,8],[17,18],[]>,
  <[3,4],[],[17],[],[],[7,8],[18],[21,22]>,
  <[3,4],[],[17],[21],[],[7,8],[18],[22]>,
  <[3,4],[],[17],[21,22],[],[7,8],[18],[]>,
  <[3,4],[],[17],[],[],[7,8],[18],[23,24]>,
  <[3,4],[],[17],[23],[],[7,8],[18],[24]>,
  <[3,4],[],[17],[23,24],[],[7,8],[18],[]>,
  <[3,4],[],[17,18],[],[],[7,8],[],[21,22]>,
  <[3,4],[],[17,18],[21],[],[7,8],[],[22]>,
  <[3,4],[],[17,18],[21,22],[],[7,8],[],[]>,
  <[3,4],[],[17,18],[],[],[7,8],[],[23,24]>,
  <[3,4],[],[17,18],[23],[],[7,8],[],[24]>,
  <[3,4],[],[17,18],[23,24],[],[7,8],[],[]>,
  <[3,4],[],[],[],[],[7,8],[19,20],[21,22]>,
  <[3,4],[],[],[21],[],[7,8],[19,20],[22]>,
  <[3,4],[],[],[21,22],[],[7,8],[19,20],[]>,
  <[3,4],[],[],[],[],[7,8],[19,20],[23,24]>,
  <[3,4],[],[],[23],[],[7,8],[19,20],[24]>,
  <[3,4],[],[],[23,24],[],[7,8],[19,20],[]>,
  <[3,4],[],[19],[],[],[7,8],[20],[21,22]>,
  <[3,4],[],[19],[21],[],[7,8],[20],[22]>,
  <[3,4],[],[19],[21,22],[],[7,8],[20],[]>,
  <[3,4],[],[19],[],[],[7,8],[20],[23,24]>,
  <[3,4],[],[19],[23],[],[7,8],[20],[24]>,
  <[3,4],[],[19],[23,24],[],[7,8],[20],[]>,
  <[3,4],[],[19,20],[],[],[7,8],[],[21,22]>,
  <[3,4],[],[19,20],[21],[],[7,8],[],[22]>,
  <[3,4],[],[19,20],[21,22],[],[7,8],[],[]>,
  <[3,4],[],[19,20],[],[],[7,8],[],[23,24]>,
  <[3,4],[],[19,20],[23],[],[7,8],[],[24]>,
  <[3,4],[],[19,20],[23,24],[],[7,8],[],[]>,
  <[3,4],[],[],[],[],[7,8],[25,26],[29,30]>,
  <[3,4],[],[],[29],[],[7,8],[25,26],[30]>,
  <[3,4],[],[],[29,30],[],[7,8],[25,26],[]>,
  <[3,4],[],[],[],[],[7,8],[25,26],[31,32]>,
  <[3,4],[],[],[31],[],[7,8],[25,26],[32]>,
  <[3,4],[],[],[31,32],[],[7,8],[25,26],[]>,
  <[3,4],[],[25],[],[],[7,8],[26],[29,30]>,
  <[3,4],[],[25],[29],[],[7,8],[26],[30]>,
  <[3,4],[],[25],[29,30],[],[7,8],[26],[]>,
  <[3,4],[],[25],[],[],[7,8],[26],[31,32]>,
  <[3,4],[],[25],[31],[],[7,8],[26],[32]>,
  <[3,4],[],[25],[31,32],[],[7,8],[26],[]>,
  <[3,4],[],[25,26],[],[],[7,8],[],[29,30]>,
  <[3,4],[],[25,26],[29],[],[7,8],[],[30]>,
  <[3,4],[],[25,26],[29,30],[],[7,8],[],[]>,
  <[3,4],[],[25,26],[],[],[7,8],[],[31,32]>,
  <[3,4],[],[25,26],[31],[],[7,8],[],[32]>,
  <[3,4],[],[25,26],[31,32],[],[7,8],[],[]>,
  <[3,4],[],[],[],[],[7,8],[27,28],[29,30]>,
  <[3,4],[],[],[29],[],[7,8],[27,28],[30]>,
  <[3,4],[],[],[29,30],[],[7,8],[27,28],[]>,
  <[3,4],[],[],[],[],[7,8],[27,28],[31,32]>,
  <[3,4],[],[],[31],[],[7,8],[27,28],[32]>,
  <[3,4],[],[],[31,32],[],[7,8],[27,28],[]>,
  <[3,4],[],[27],[],[],[7,8],[28],[29,30]>,
  <[3,4],[],[27],[29],[],[7,8],[28],[30]>,
  <[3,4],[],[27],[29,30],[],[7,8],[28],[]>,
  <[3,4],[],[27],[],[],[7,8],[28],[31,32]>,
  <[3,4],[],[27],[31],[],[7,8],[28],[32]>,
  <[3,4],[],[27],[31,32],[],[7,8],[28],[]>,
  <[3,4],[],[27,28],[],[],[7,8],[],[29,30]>,
  <[3,4],[],[27,28],[29],[],[7,8],[],[30]>,
  <[3,4],[],[27,28],[29,30],[],[7,8],[],[]>,
  <[3,4],[],[27,28],[],[],[7,8],[],[31,32]>,
  <[3,4],[],[27,28],[31],[],[7,8],[],[32]>,
  <[3,4],[],[27,28],[31,32],[],[7,8],[],[]>,
  <[3,4],[7],[],[],[],[8],[17,18],[21,22]>,
  <[3,4],[7],[],[21],[],[8],[17,18],[22]>,
  <[3,4],[7],[],[21,22],[],[8],[17,18],[]>,
  <[3,4],[7],[],[],[],[8],[17,18],[23,24]>,
  <[3,4],[7],[],[23],[],[8],[17,18],[24]>,
  <[3,4],[7],[],[23,24],[],[8],[17,18],[]>,
  <[3,4],[7],[17],[],[],[8],[18],[21,22]>,
  <[3,4],[7],[17],[21],[],[8],[18],[22]>,
  <[3,4],[7],[17],[21,22],[],[8],[18],[]>,
  <[3,4],[7],[17],[],[],[8],[18],[23,24]>,
  <[3,4],[7],[17],[23],[],[8],[18],[24]>,
  <[3,4],[7],[17],[23,24],[],[8],[18],[]>,
  <[3,4],[7],[17,18],[],[],[8],[],[21,22]>,
  <[3,4],[7],[17,18],[21],[],[8],[],[22]>,
  <[3,4],[7],[17,18],[21,22],[],[8],[],[]>,
  <[3,4],[7],[17,18],[],[],[8],[],[23,24]>,
  <[3,4],[7],[17,18],[23],[],[8],[],[24]>,
  <[3,4],[7],[17,18],[23,24],[],[8],[],[]>,
  <[3,4],[7],[],[],[],[8],[19,20],[21,22]>,
  <[3,4],[7],[],[21],[],[8],[19,20],[22]>,
  <[3,4],[7],[],[21,22],[],[8],[19,20],[]>,
  <[3,4],[7],[],[],[],[8],[19,20],[23,24]>,
  <[3,4],[7],[],[23],[],[8],[19,20],[24]>,
  <[3,4],[7],[],[23,24],[],[8],[19,20],[]>,
  <[3,4],[7],[19],[],[],[8],[20],[21,22]>,
  <[3,4],[7],[19],[21],[],[8],[20],[22]>,
  <[3,4],[7],[19],[21,22],[],[8],[20],[]>,
  <[3,4],[7],[19],[],[],[8],[20],[23,24]>,
  <[3,4],[7],[19],[23],[],[8],[20],[24]>,
  <[3,4],[7],[19],[23,24],[],[8],[20],[]>,
  <[3,4],[7],[19,20],[],[],[8],[],[21,22]>,
  <[3,4],[7],[19,20],[21],[],[8],[],[22]>,
  <[3,4],[7],[19,20],[21,22],[],[8],[],[]>,
  <[3,4],[7],[19,20],[],[],[8],[],[23,24]>,
  <[3,4],[7],[19,20],[23],[],[8],[],[24]>,
  <[3,4],[7],[19,20],[23,24],[],[8],[],[]>,
  <[3,4],[7],[],[],[],[8],[25,26],[29,30]>,
  <[3,4],[7],[],[29],[],[8],[25,26],[30]>,
  <[3,4],[7],[],[29,30],[],[8],[25,26],[]>,
  <[3,4],[7],[],[],[],[8],[25,26],[31,32]>,
  <[3,4],[7],[],[31],[],[8],[25,26],[32]>,
  <[3,4],[7],[],[31,32],[],[8],[25,26],[]>,
  <[3,4],[7],[25],[],[],[8],[26],[29,30]>,
  <[3,4],[7],[25],[29],[],[8],[26],[30]>,
  <[3,4],[7],[25],[29,30],[],[8],[26],[]>,
  <[3,4],[7],[25],[],[],[8],[26],[31,32]>,
  <[3,4],[7],[25],[31],[],[8],[26],[32]>,
  <[3,4],[7],[25],[31,32],[],[8],[26],[]>,
  <[3,4],[7],[25,26],[],[],[8],[],[29,30]>,
  <[3,4],[7],[25,26],[29],[],[8],[],[30]>,
  <[3,4],[7],[25,26],[29,30],[],[8],[],[]>,
  <[3,4],[7],[25,26],[],[],[8],[],[31,32]>,
  <[3,4],[7],[25,26],[31],[],[8],[],[32]>,
  <[3,4],[7],[25,26],[31,32],[],[8],[],[]>,
  <[3,4],[7],[],[],[],[8],[27,28],[29,30]>,
  <[3,4],[7],[],[29],[],[8],[27,28],[30]>,
  <[3,4],[7],[],[29,30],[],[8],[27,28],[]>,
  <[3,4],[7],[],[],[],[8],[27,28],[31,32]>,
  <[3,4],[7],[],[31],[],[8],[27,28],[32]>,
  <[3,4],[7],[],[31,32],[],[8],[27,28],[]>,
  <[3,4],[7],[27],[],[],[8],[28],[29,30]>,
  <[3,4],[7],[27],[29],[],[8],[28],[30]>,
  <[3,4],[7],[27],[29,30],[],[8],[28],[]>,
  <[3,4],[7],[27],[],[],[8],[28],[31,32]>,
  <[3,4],[7],[27],[31],[],[8],[28],[32]>,
  <[3,4],[7],[27],[31,32],[],[8],[28],[]>,
  <[3,4],[7],[27,28],[],[],[8],[],[29,30]>,
  <[3,4],[7],[27,28],[29],[],[8],[],[30]>,
  <[3,4],[7],[27,28],[29,30],[],[8],[],[]>,
  <[3,4],[7],[27,28],[],[],[8],[],[31,32]>,
  <[3,4],[7],[27,28],[31],[],[8],[],[32]>,
  <[3,4],[7],[27,28],[31,32],[],[8],[],[]>,
  <[3,4],[7,8],[],[],[],[],[17,18],[21,22]>,
  <[3,4],[7,8],[],[21],[],[],[17,18],[22]>,
  <[3,4],[7,8],[],[21,22],[],[],[17,18],[]>,
  <[3,4],[7,8],[],[],[],[],[17,18],[23,24]>,
  <[3,4],[7,8],[],[23],[],[],[17,18],[24]>,
  <[3,4],[7,8],[],[23,24],[],[],[17,18],[]>,
  <[3,4],[7,8],[17],[],[],[],[18],[21,22]>,
  <[3,4],[7,8],[17],[21],[],[],[18],[22]>,
  <[3,4],[7,8],[17],[21,22],[],[],[18],[]>,
  <[3,4],[7,8],[17],[],[],[],[18],[23,24]>,
  <[3,4],[7,8],[17],[23],[],[],[18],[24]>,
  <[3,4],[7,8],[17],[23,24],[],[],[18],[]>,
  <[3,4],[7,8],[17,18],[],[],[],[],[21,22]>,
  <[3,4],[7,8],[17,18],[21],[],[],[],[22]>,
  <[3,4],[7,8],[17,18],[21,22],[],[],[],[]>,
  <[3,4],[7,8],[17,18],[],[],[],[],[23,24]>,
  <[3,4],[7,8],[17,18],[23],[],[],[],[24]>,
  <[3,4],[7,8],[17,18],[23,24],[],[],[],[]>,
  <[3,4],[7,8],[],[],[],[],[19,20],[21,22]>,
  <[3,4],[7,8],[],[21],[],[],[19,20],[22]>,
  <[3,4],[7,8],[],[21,22],[],[],[19,20],[]>,
  <[3,4],[7,8],[],[],[],[],[19,20],[23,24]>,
  <[3,4],[7,8],[],[23],[],[],[19,20],[24]>,
  <[3,4],[7,8],[],[23,24],[],[],[19,20],[]>,
  <[3,4],[7,8],[19],[],[],[],[20],[21,22]>,
  <[3,4],[7,8],[19],[21],[],[],[20],[22]>,
  <[3,4],[7,8],[19],[21,22],[],[],[20],[]>,
  <[3,4],[7,8],[19],[],[],[],[20],[23,24]>,
  <[3,4],[7,8],[19],[23],[],[],[20],[24]>,
  <[3,4],[7,8],[19],[23,24],[],[],[20],[]>,
  <[3,4],[7,8],[19,20],[],[],[],[],[21,22]>,
  <[3,4],[7,8],[19,20],[21],[],[],[],[22]>,
  <[3,4],[7,8],[19,20],[21,22],[],[],[],[]>,
  <[3,4],[7,8],[19,20],[],[],[],[],[23,24]>,
  <[3,4],[7,8],[19,20],[23],[],[],[],[24]>,
  <[3,4],[7,8],[19,20],[23,24],[],[],[],[]>,
  <[3,4],[7,8],[],[],[],[],[25,26],[29,30]>,
  <[3,4],[7,8],[],[29],[],[],[25,26],[30]>,
  <[3,4],[7,8],[],[29,30],[],[],[25,26],[]>,
  <[3,4],[7,8],[],[],[],[],[25,26],[31,32]>,
  <[3,4],[7,8],[],[31],[],[],[25,26],[32]>,
  <[3,4],[7,8],[],[31,32],[],[],[25,26],[]>,
  <[3,4],[7,8],[25],[],[],[],[26],[29,30]>,
  <[3,4],[7,8],[25],[29],[],[],[26],[30]>,
  <[3,4],[7,8],[25],[29,30],[],[],[26],[]>,
  <[3,4],[7,8],[25],[],[],[],[26],[31,32]>,
  <[3,4],[7,8],[25],[31],[],[],[26],[32]>,
  <[3,4],[7,8],[25],[31,32],[],[],[26],[]>,
  <[3,4],[7,8],[25,26],[],[],[],[],[29,30]>,
  <[3,4],[7,8],[25,26],[29],[],[],[],[30]>,
  <[3,4],[7,8],[25,26],[29,30],[],[],[],[]>,
  <[3,4],[7,8],[25,26],[],[],[],[],[31,32]>,
  <[3,4],[7,8],[25,26],[31],[],[],[],[32]>,
  <[3,4],[7,8],[25,26],[31,32],[],[],[],[]>,
  <[3,4],[7,8],[],[],[],[],[27,28],[29,30]>,
  <[3,4],[7,8],[],[29],[],[],[27,28],[30]>,
  <[3,4],[7,8],[],[29,30],[],[],[27,28],[]>,
  <[3,4],[7,8],[],[],[],[],[27,28],[31,32]>,
  <[3,4],[7,8],[],[31],[],[],[27,28],[32]>,
  <[3,4],[7,8],[],[31,32],[],[],[27,28],[]>,
  <[3,4],[7,8],[27],[],[],[],[28],[29,30]>,
  <[3,4],[7,8],[27],[29],[],[],[28],[30]>,
  <[3,4],[7,8],[27],[29,30],[],[],[28],[]>,
  <[3,4],[7,8],[27],[],[],[],[28],[31,32]>,
  <[3,4],[7,8],[27],[31],[],[],[28],[32]>,
  <[3,4],[7,8],[27],[31,32],[],[],[28],[]>,
  <[3,4],[7,8],[27,28],[],[],[],[],[29,30]>,
  <[3,4],[7,8],[27,28],[29],[],[],[],[30]>,
  <[3,4],[7,8],[27,28],[29,30],[],[],[],[]>,
  <[3,4],[7,8],[27,28],[],[],[],[],[31,32]>,
  <[3,4],[7,8],[27,28],[31],[],[],[],[32]>,
  <[3,4],[7,8],[27,28],[31,32],[],[],[],[]>,
  <[],[],[],[],[9,10],[13,14],[17,18],[21,22]>,
  <[],[],[],[21],[9,10],[13,14],[17,18],[22]>,
  <[],[],[],[21,22],[9,10],[13,14],[17,18],[]>,
  <[],[],[],[],[9,10],[13,14],[17,18],[23,24]>,
  <[],[],[],[23],[9,10],[13,14],[17,18],[24]>,
  <[],[],[],[23,24],[9,10],[13,14],[17,18],[]>,
  <[],[],[17],[],[9,10],[13,14],[18],[21,22]>,
  <[],[],[17],[21],[9,10],[13,14],[18],[22]>,
  <[],[],[17],[21,22],[9,10],[13,14],[18],[]>,
  <[],[],[17],[],[9,10],[13,14],[18],[23,24]>,
  <[],[],[17],[23],[9,10],[13,14],[18],[24]>,
  <[],[],[17],[23,24],[9,10],[13,14],[18],[]>,
  <[],[],[17,18],[],[9,10],[13,14],[],[21,22]>,
  <[],[],[17,18],[21],[9,10],[13,14],[],[22]>,
  <[],[],[17,18],[21,22],[9,10],[13,14],[],[]>,
  <[],[],[17,18],[],[9,10],[13,14],[],[23,24]>,
  <[],[],[17,18],[23],[9,10],[13,14],[],[24]>,
  <[],[],[17,18],[23,24],[9,10],[13,14],[],[]>,
  <[],[],[],[],[9,10],[13,14],[19,20],[21,22]>,
  <[],[],[],[21],[9,10],[13,14],[19,20],[22]>,
  <[],[],[],[21,22],[9,10],[13,14],[19,20],[]>,
  <[],[],[],[],[9,10],[13,14],[19,20],[23,24]>,
  <[],[],[],[23],[9,10],[13,14],[19,20],[24]>,
  <[],[],[],[23,24],[9,10],[13,14],[19,20],[]>,
  <[],[],[19],[],[9,10],[13,14],[20],[21,22]>,
  <[],[],[19],[21],[9,10],[13,14],[20],[22]>,
  <[],[],[19],[21,22],[9,10],[13,14],[20],[]>,
  <[],[],[19],[],[9,10],[13,14],[20],[23,24]>,
  <[],[],[19],[23],[9,10],[13,14],[20],[24]>,
  <[],[],[19],[23,24],[9,10],[13,14],[20],[]>,
  <[],[],[19,20],[],[9,10],[13,14],[],[21,22]>,
  <[],[],[19,20],[21],[9,10],[13,14],[],[22]>,
  <[],[],[19,20],[21,22],[9,10],[13,14],[],[]>,
  <[],[],[19,20],[],[9,10],[13,14],[],[23,24]>,
  <[],[],[19,20],[23],[9,10],[13,14],[],[24]>,
  <[],[],[19,20],[23,24],[9,10],[13,14],[],[]>,
  <[],[],[],[],[9,10],[13,14],[25,26],[29,30]>,
  <[],[],[],[29],[9,10],[13,14],[25,26],[30]>,
  <[],[],[],[29,30],[9,10],[13,14],[25,26],[]>,
  <[],[],[],[],[9,10],[13,14],[25,26],[31,32]>,
  <[],[],[],[31],[9,10],[13,14],[25,26],[32]>,
  <[],[],[],[31,32],[9,10],[13,14],[25,26],[]>,
  <[],[],[25],[],[9,10],[13,14],[26],[29,30]>,
  <[],[],[25],[29],[9,10],[13,14],[26],[30]>,
  <[],[],[25],[29,30],[9,10],[13,14],[26],[]>,
  <[],[],[25],[],[9,10],[13,14],[26],[31,32]>,
  <[],[],[25],[31],[9,10],[13,14],[26],[32]>,
  <[],[],[25],[31,32],[9,10],[13,14],[26],[]>,
  <[],[],[25,26],[],[9,10],[13,14],[],[29,30]>,
  <[],[],[25,26],[29],[9,10],[13,14],[],[30]>,
  <[],[],[25,26],[29,30],[9,10],[13,14],[],[]>,
  <[],[],[25,26],[],[9,10],[13,14],[],[31,32]>,
  <[],[],[25,26],[31],[9,10],[13,14],[],[32]>,
  <[],[],[25,26],[31,32],[9,10],[13,14],[],[]>,
  <[],[],[],[],[9,10],[13,14],[27,28],[29,30]>,
  <[],[],[],[29],[9,10],[13,14],[27,28],[30]>,
  <[],[],[],[29,30],[9,10],[13,14],[27,28],[]>,
  <[],[],[],[],[9,10],[13,14],[27,28],[31,32]>,
  <[],[],[],[31],[9,10],[13,14],[27,28],[32]>,
  <[],[],[],[31,32],[9,10],[13,14],[27,28],[]>,
  <[],[],[27],[],[9,10],[13,14],[28],[29,30]>,
  <[],[],[27],[29],[9,10],[13,14],[28],[30]>,
  <[],[],[27],[29,30],[9,10],[13,14],[28],[]>,
  <[],[],[27],[],[9,10],[13,14],[28],[31,32]>,
  <[],[],[27],[31],[9,10],[13,14],[28],[32]>,
  <[],[],[27],[31,32],[9,10],[13,14],[28],[]>,
  <[],[],[27,28],[],[9,10],[13,14],[],[29,30]>,
  <[],[],[27,28],[29],[9,10],[13,14],[],[30]>,
  <[],[],[27,28],[29,30],[9,10],[13,14],[],[]>,
  <[],[],[27,28],[],[9,10],[13,14],[],[31,32]>,
  <[],[],[27,28],[31],[9,10],[13,14],[],[32]>,
  <[],[],[27,28],[31,32],[9,10],[13,14],[],[]>,
  <[],[13],[],[],[9,10],[14],[17,18],[21,22]>,
  <[],[13],[],[21],[9,10],[14],[17,18],[22]>,
  <[],[13],[],[21,22],[9,10],[14],[17,18],[]>,
  <[],[13],[],[],[9,10],[14],[17,18],[23,24]>,
  <[],[13],[],[23],[9,10],[14],[17,18],[24]>,
  <[],[13],[],[23,24],[9,10],[14],[17,18],[]>,
  <[],[13],[17],[],[9,10],[14],[18],[21,22]>,
  <[],[13],[17],[21],[9,10],[14],[18],[22]>,
  <[],[13],[17],[21,22],[9,10],[14],[18],[]>,
  <[],[13],[17],[],[9,10],[14],[18],[23,24]>,
  <[],[13],[17],[23],[9,10],[14],[18],[24]>,
  <[],[13],[17],[23,24],[9,10],[14],[18],[]>,
  <[],[13],[17,18],[],[9,10],[14],[],[21,22]>,
  <[],[13],[17,18],[21],[9,10],[14],[],[22]>,
  <[],[13],[17,18],[21,22],[9,10],[14],[],[]>,
  <[],[13],[17,18],[],[9,10],[14],[],[23,24]>,
  <[],[13],[17,18],[23],[9,10],[14],[],[24]>,
  <[],[13],[17,18],[23,24],[9,10],[14],[],[]>,
  <[],[13],[],[],[9,10],[14],[19,20],[21,22]>,
  <[],[13],[],[21],[9,10],[14],[19,20],[22]>,
  <[],[13],[],[21,22],[9,10],[14],[19,20],[]>,
  <[],[13],[],[],[9,10],[14],[19,20],[23,24]>,
  <[],[13],[],[23],[9,10],[14],[19,20],[24]>,
  <[],[13],[],[23,24],[9,10],[14],[19,20],[]>,
  <[],[13],[19],[],[9,10],[14],[20],[21,22]>,
  <[],[13],[19],[21],[9,10],[14],[20],[22]>,
  <[],[13],[19],[21,22],[9,10],[14],[20],[]>,
  <[],[13],[19],[],[9,10],[14],[20],[23,24]>,
  <[],[13],[19],[23],[9,10],[14],[20],[24]>,
  <[],[13],[19],[23,24],[9,10],[14],[20],[]>,
  <[],[13],[19,20],[],[9,10],[14],[],[21,22]>,
  <[],[13],[19,20],[21],[9,10],[14],[],[22]>,
  <[],[13],[19,20],[21,22],[9,10],[14],[],[]>,
  <[],[13],[19,20],[],[9,10],[14],[],[23,24]>,
  <[],[13],[19,20],[23],[9,10],[14],[],[24]>,
  <[],[13],[19,20],[23,24],[9,10],[14],[],[]>,
  <[],[13],[],[],[9,10],[14],[25,26],[29,30]>,
  <[],[13],[],[29],[9,10],[14],[25,26],[30]>,
  <[],[13],[],[29,30],[9,10],[14],[25,26],[]>,
  <[],[13],[],[],[9,10],[14],[25,26],[31,32]>,
  <[],[13],[],[31],[9,10],[14],[25,26],[32]>,
  <[],[13],[],[31,32],[9,10],[14],[25,26],[]>,
  <[],[13],[25],[],[9,10],[14],[26],[29,30]>,
  <[],[13],[25],[29],[9,10],[14],[26],[30]>,
  <[],[13],[25],[29,30],[9,10],[14],[26],[]>,
  <[],[13],[25],[],[9,10],[14],[26],[31,32]>,
  <[],[13],[25],[31],[9,10],[14],[26],[32]>,
  <[],[13],[25],[31,32],[9,10],[14],[26],[]>,
  <[],[13],[25,26],[],[9,10],[14],[],[29,30]>,
  <[],[13],[25,26],[29],[9,10],[14],[],[30]>,
  <[],[13],[25,26],[29,30],[9,10],[14],[],[]>,
  <[],[13],[25,26],[],[9,10],[14],[],[31,32]>,
  <[],[13],[25,26],[31],[9,10],[14],[],[32]>,
  <[],[13],[25,26],[31,32],[9,10],[14],[],[]>,
  <[],[13],[],[],[9,10],[14],[27,28],[29,30]>,
  <[],[13],[],[29],[9,10],[14],[27,28],[30]>,
  <[],[13],[],[29,30],[9,10],[14],[27,28],[]>,
  <[],[13],[],[],[9,10],[14],[27,28],[31,32]>,
  <[],[13],[],[31],[9,10],[14],[27,28],[32]>,
  <[],[13],[],[31,32],[9,10],[14],[27,28],[]>,
  <[],[13],[27],[],[9,10],[14],[28],[29,30]>,
  <[],[13],[27],[29],[9,10],[14],[28],[30]>,
  <[],[13],[27],[29,30],[9,10],[14],[28],[]>,
  <[],[13],[27],[],[9,10],[14],[28],[31,32]>,
  <[],[13],[27],[31],[9,10],[14],[28],[32]>,
  <[],[13],[27],[31,32],[9,10],[14],[28],[]>,
  <[],[13],[27,28],[],[9,10],[14],[],[29,30]>,
  <[],[13],[27,28],[29],[9,10],[14],[],[30]>,
  <[],[13],[27,28],[29,30],[9,10],[14],[],[]>,
  <[],[13],[27,28],[],[9,10],[14],[],[31,32]>,
  <[],[13],[27,28],[31],[9,10],[14],[],[32]>,
  <[],[13],[27,28],[31,32],[9,10],[14],[],[]>,
  <[],[13,14],[],[],[9,10],[],[17,18],[21,22]>,
  <[],[13,14],[],[21],[9,10],[],[17,18],[22]>,
  <[],[13,14],[],[21,22],[9,10],[],[17,18],[]>,
  <[],[13,14],[],[],[9,10],[],[17,18],[23,24]>,
  <[],[13,14],[],[23],[9,10],[],[17,18],[24]>,
  <[],[13,14],[],[23,24],[9,10],[],[17,18],[]>,
  <[],[13,14],[17],[],[9,10],[],[18],[21,22]>,
  <[],[13,14],[17],[21],[9,10],[],[18],[22]>,
  <[],[13,14],[17],[21,22],[9,10],[],[18],[]>,
  <[],[13,14],[17],[],[9,10],[],[18],[23,24]>,
  <[],[13,14],[17],[23],[9,10],[],[18],[24]>,
  <[],[13,14],[17],[23,24],[9,10],[],[18],[]>,
  <[],[13,14],[17,18],[],[9,10],[],[],[21,22]>,
  <[],[13,14],[17,18],[21],[9,10],[],[],[22]>,
  <[],[13,14],[17,18],[21,22],[9,10],[],[],[]>,
  <[],[13,14],[17,18],[],[9,10],[],[],[23,24]>,
  <[],[13,14],[17,18],[23],[9,10],[],[],[24]>,
  <[],[13,14],[17,18],[23,24],[9,10],[],[],[]>,
  <[],[13,14],[],[],[9,10],[],[19,20],[21,22]>,
  <[],[13,14],[],[21],[9,10],[],[19,20],[22]>,
  <[],[13,14],[],[21,22],[9,10],[],[19,20],[]>,
  <[],[13,14],[],[],[9,10],[],[19,20],[23,24]>,
  <[],[13,14],[],[23],[9,10],[],[19,20],[24]>,
  <[],[13,14],[],[23,24],[9,10],[],[19,20],[]>,
  <[],[13,14],[19],[],[9,10],[],[20],[21,22]>,
  <[],[13,14],[19],[21],[9,10],[],[20],[22]>,
  <[],[13,14],[19],[21,22],[9,10],[],[20],[]>,
  <[],[13,14],[19],[],[9,10],[],[20],[23,24]>,
  <[],[13,14],[19],[23],[9,10],[],[20],[24]>,
  <[],[13,14],[19],[23,24],[9,10],[],[20],[]>,
  <[],[13,14],[19,20],[],[9,10],[],[],[21,22]>,
  <[],[13,14],[19,20],[21],[9,10],[],[],[22]>,
  <[],[13,14],[19,20],[21,22],[9,10],[],[],[]>,
  <[],[13,14],[19,20],[],[9,10],[],[],[23,24]>,
  <[],[13,14],[19,20],[23],[9,10],[],[],[24]>,
  <[],[13,14],[19,20],[23,24],[9,10],[],[],[]>,
  <[],[13,14],[],[],[9,10],[],[25,26],[29,30]>,
  <[],[13,14],[],[29],[9,10],[],[25,26],[30]>,
  <[],[13,14],[],[29,30],[9,10],[],[25,26],[]>,
  <[],[13,14],[],[],[9,10],[],[25,26],[31,32]>,
  <[],[13,14],[],[31],[9,10],[],[25,26],[32]>,
  <[],[13,14],[],[31,32],[9,10],[],[25,26],[]>,
  <[],[13,14],[25],[],[9,10],[],[26],[29,30]>,
  <[],[13,14],[25],[29],[9,10],[],[26],[30]>,
  <[],[13,14],[25],[29,30],[9,10],[],[26],[]>,
  <[],[13,14],[25],[],[9,10],[],[26],[31,32]>,
  <[],[13,14],[25],[31],[9,10],[],[26],[32]>,
  <[],[13,14],[25],[31,32],[9,10],[],[26],[]>,
  <[],[13,14],[25,26],[],[9,10],[],[],[29,30]>,
  <[],[13,14],[25,26],[29],[9,10],[],[],[30]>,
  <[],[13,14],[25,26],[29,30],[9,10],[],[],[]>,
  <[],[13,14],[25,26],[],[9,10],[],[],[31,32]>,
  <[],[13,14],[25,26],[31],[9,10],[],[],[32]>,
  <[],[13,14],[25,26],[31,32],[9,10],[],[],[]>,
  <[],[13,14],[],[],[9,10],[],[27,28],[29,30]>,
  <[],[13,14],[],[29],[9,10],[],[27,28],[30]>,
  <[],[13,14],[],[29,30],[9,10],[],[27,28],[]>,
  <[],[13,14],[],[],[9,10],[],[27,28],[31,32]>,
  <[],[13,14],[],[31],[9,10],[],[27,28],[32]>,
  <[],[13,14],[],[31,32],[9,10],[],[27,28],[]>,
  <[],[13,14],[27],[],[9,10],[],[28],[29,30]>,
  <[],[13,14],[27],[29],[9,10],[],[28],[30]>,
  <[],[13,14],[27],[29,30],[9,10],[],[28],[]>,
  <[],[13,14],[27],[],[9,10],[],[28],[31,32]>,
  <[],[13,14],[27],[31],[9,10],[],[28],[32]>,
  <[],[13,14],[27],[31,32],[9,10],[],[28],[]>,
  <[],[13,14],[27,28],[],[9,10],[],[],[29,30]>,
  <[],[13,14],[27,28],[29],[9,10],[],[],[30]>,
  <[],[13,14],[27,28],[29,30],[9,10],[],[],[]>,
  <[],[13,14],[27,28],[],[9,10],[],[],[31,32]>,
  <[],[13,14],[27,28],[31],[9,10],[],[],[32]>,
  <[],[13,14],[27,28],[31,32],[9,10],[],[],[]>,
  <[],[],[],[],[9,10],[15,16],[17,18],[21,22]>,
  <[],[],[],[21],[9,10],[15,16],[17,18],[22]>,
  <[],[],[],[21,22],[9,10],[15,16],[17,18],[]>,
  <[],[],[],[],[9,10],[15,16],[17,18],[23,24]>,
  <[],[],[],[23],[9,10],[15,16],[17,18],[24]>,
  <[],[],[],[23,24],[9,10],[15,16],[17,18],[]>,
  <[],[],[17],[],[9,10],[15,16],[18],[21,22]>,
  <[],[],[17],[21],[9,10],[15,16],[18],[22]>,
  <[],[],[17],[21,22],[9,10],[15,16],[18],[]>,
  <[],[],[17],[],[9,10],[15,16],[18],[23,24]>,
  <[],[],[17],[23],[9,10],[15,16],[18],[24]>,
  <[],[],[17],[23,24],[9,10],[15,16],[18],[]>,
  <[],[],[17,18],[],[9,10],[15,16],[],[21,22]>,
  <[],[],[17,18],[21],[9,10],[15,16],[],[22]>,
  <[],[],[17,18],[21,22],[9,10],[15,16],[],[]>,
  <[],[],[17,18],[],[9,10],[15,16],[],[23,24]>,
  <[],[],[17,18],[23],[9,10],[15,16],[],[24]>,
  <[],[],[17,18],[23,24],[9,10],[15,16],[],[]>,
  <[],[],[],[],[9,10],[15,16],[19,20],[21,22]>,
  <[],[],[],[21],[9,10],[15,16],[19,20],[22]>,
  <[],[],[],[21,22],[9,10],[15,16],[19,20],[]>,
  <[],[],[],[],[9,10],[15,16],[19,20],[23,24]>,
  <[],[],[],[23],[9,10],[15,16],[19,20],[24]>,
  <[],[],[],[23,24],[9,10],[15,16],[19,20],[]>,
  <[],[],[19],[],[9,10],[15,16],[20],[21,22]>,
  <[],[],[19],[21],[9,10],[15,16],[20],[22]>,
  <[],[],[19],[21,22],[9,10],[15,16],[20],[]>,
  <[],[],[19],[],[9,10],[15,16],[20],[23,24]>,
  <[],[],[19],[23],[9,10],[15,16],[20],[24]>,
  <[],[],[19],[23,24],[9,10],[15,16],[20],[]>,
  <[],[],[19,20],[],[9,10],[15,16],[],[21,22]>,
  <[],[],[19,20],[21],[9,10],[15,16],[],[22]>,
  <[],[],[19,20],[21,22],[9,10],[15,16],[],[]>,
  <[],[],[19,20],[],[9,10],[15,16],[],[23,24]>,
  <[],[],[19,20],[23],[9,10],[15,16],[],[24]>,
  <[],[],[19,20],[23,24],[9,10],[15,16],[],[]>,
  <[],[],[],[],[9,10],[15,16],[25,26],[29,30]>,
  <[],[],[],[29],[9,10],[15,16],[25,26],[30]>,
  <[],[],[],[29,30],[9,10],[15,16],[25,26],[]>,
  <[],[],[],[],[9,10],[15,16],[25,26],[31,32]>,
  <[],[],[],[31],[9,10],[15,16],[25,26],[32]>,
  <[],[],[],[31,32],[9,10],[15,16],[25,26],[]>,
  <[],[],[25],[],[9,10],[15,16],[26],[29,30]>,
  <[],[],[25],[29],[9,10],[15,16],[26],[30]>,
  <[],[],[25],[29,30],[9,10],[15,16],[26],[]>,
  <[],[],[25],[],[9,10],[15,16],[26],[31,32]>,
  <[],[],[25],[31],[9,10],[15,16],[26],[32]>,
  <[],[],[25],[31,32],[9,10],[15,16],[26],[]>,
  <[],[],[25,26],[],[9,10],[15,16],[],[29,30]>,
  <[],[],[25,26],[29],[9,10],[15,16],[],[30]>,
  <[],[],[25,26],[29,30],[9,10],[15,16],[],[]>,
  <[],[],[25,26],[],[9,10],[15,16],[],[31,32]>,
  <[],[],[25,26],[31],[9,10],[15,16],[],[32]>,
  <[],[],[25,26],[31,32],[9,10],[15,16],[],[]>,
  <[],[],[],[],[9,10],[15,16],[27,28],[29,30]>,
  <[],[],[],[29],[9,10],[15,16],[27,28],[30]>,
  <[],[],[],[29,30],[9,10],[15,16],[27,28],[]>,
  <[],[],[],[],[9,10],[15,16],[27,28],[31,32]>,
  <[],[],[],[31],[9,10],[15,16],[27,28],[32]>,
  <[],[],[],[31,32],[9,10],[15,16],[27,28],[]>,
  <[],[],[27],[],[9,10],[15,16],[28],[29,30]>,
  <[],[],[27],[29],[9,10],[15,16],[28],[30]>,
  <[],[],[27],[29,30],[9,10],[15,16],[28],[]>,
  <[],[],[27],[],[9,10],[15,16],[28],[31,32]>,
  <[],[],[27],[31],[9,10],[15,16],[28],[32]>,
  <[],[],[27],[31,32],[9,10],[15,16],[28],[]>,
  <[],[],[27,28],[],[9,10],[15,16],[],[29,30]>,
  <[],[],[27,28],[29],[9,10],[15,16],[],[30]>,
  <[],[],[27,28],[29,30],[9,10],[15,16],[],[]>,
  <[],[],[27,28],[],[9,10],[15,16],[],[31,32]>,
  <[],[],[27,28],[31],[9,10],[15,16],[],[32]>,
  <[],[],[27,28],[31,32],[9,10],[15,16],[],[]>,
  <[],[15],[],[],[9,10],[16],[17,18],[21,22]>,
  <[],[15],[],[21],[9,10],[16],[17,18],[22]>,
  <[],[15],[],[21,22],[9,10],[16],[17,18],[]>,
  <[],[15],[],[],[9,10],[16],[17,18],[23,24]>,
  <[],[15],[],[23],[9,10],[16],[17,18],[24]>,
  <[],[15],[],[23,24],[9,10],[16],[17,18],[]>,
  <[],[15],[17],[],[9,10],[16],[18],[21,22]>,
  <[],[15],[17],[21],[9,10],[16],[18],[22]>,
  <[],[15],[17],[21,22],[9,10],[16],[18],[]>,
  <[],[15],[17],[],[9,10],[16],[18],[23,24]>,
  <[],[15],[17],[23],[9,10],[16],[18],[24]>,
  <[],[15],[17],[23,24],[9,10],[16],[18],[]>,
  <[],[15],[17,18],[],[9,10],[16],[],[21,22]>,
  <[],[15],[17,18],[21],[9,10],[16],[],[22]>,
  <[],[15],[17,18],[21,22],[9,10],[16],[],[]>,
  <[],[15],[17,18],[],[9,10],[16],[],[23,24]>,
  <[],[15],[17,18],[23],[9,10],[16],[],[24]>,
  <[],[15],[17,18],[23,24],[9,10],[16],[],[]>,
  <[],[15],[],[],[9,10],[16],[19,20],[21,22]>,
  <[],[15],[],[21],[9,10],[16],[19,20],[22]>,
  <[],[15],[],[21,22],[9,10],[16],[19,20],[]>,
  <[],[15],[],[],[9,10],[16],[19,20],[23,24]>,
  <[],[15],[],[23],[9,10],[16],[19,20],[24]>,
  <[],[15],[],[23,24],[9,10],[16],[19,20],[]>,
  <[],[15],[19],[],[9,10],[16],[20],[21,22]>,
  <[],[15],[19],[21],[9,10],[16],[20],[22]>,
  <[],[15],[19],[21,22],[9,10],[16],[20],[]>,
  <[],[15],[19],[],[9,10],[16],[20],[23,24]>,
  <[],[15],[19],[23],[9,10],[16],[20],[24]>,
  <[],[15],[19],[23,24],[9,10],[16],[20],[]>,
  <[],[15],[19,20],[],[9,10],[16],[],[21,22]>,
  <[],[15],[19,20],[21],[9,10],[16],[],[22]>,
  <[],[15],[19,20],[21,22],[9,10],[16],[],[]>,
  <[],[15],[19,20],[],[9,10],[16],[],[23,24]>,
  <[],[15],[19,20],[23],[9,10],[16],[],[24]>,
  <[],[15],[19,20],[23,24],[9,10],[16],[],[]>,
  <[],[15],[],[],[9,10],[16],[25,26],[29,30]>,
  <[],[15],[],[29],[9,10],[16],[25,26],[30]>,
  <[],[15],[],[29,30],[9,10],[16],[25,26],[]>,
  <[],[15],[],[],[9,10],[16],[25,26],[31,32]>,
  <[],[15],[],[31],[9,10],[16],[25,26],[32]>,
  <[],[15],[],[31,32],[9,10],[16],[25,26],[]>,
  <[],[15],[25],[],[9,10],[16],[26],[29,30]>,
  <[],[15],[25],[29],[9,10],[16],[26],[30]>,
  <[],[15],[25],[29,30],[9,10],[16],[26],[]>,
  <[],[15],[25],[],[9,10],[16],[26],[31,32]>,
  <[],[15],[25],[31],[9,10],[16],[26],[32]>,
  <[],[15],[25],[31,32],[9,10],[16],[26],[]>,
  <[],[15],[25,26],[],[9,10],[16],[],[29,30]>,
  <[],[15],[25,26],[29],[9,10],[16],[],[30]>,
  <[],[15],[25,26],[29,30],[9,10],[16],[],[]>,
  <[],[15],[25,26],[],[9,10],[16],[],[31,32]>,
  <[],[15],[25,26],[31],[9,10],[16],[],[32]>,
  <[],[15],[25,26],[31,32],[9,10],[16],[],[]>,
  <[],[15],[],[],[9,10],[16],[27,28],[29,30]>,
  <[],[15],[],[29],[9,10],[16],[27,28],[30]>,
  <[],[15],[],[29,30],[9,10],[16],[27,28],[]>,
  <[],[15],[],[],[9,10],[16],[27,28],[31,32]>,
  <[],[15],[],[31],[9,10],[16],[27,28],[32]>,
  <[],[15],[],[31,32],[9,10],[16],[27,28],[]>,
  <[],[15],[27],[],[9,10],[16],[28],[29,30]>,
  <[],[15],[27],[29],[9,10],[16],[28],[30]>,
  <[],[15],[27],[29,30],[9,10],[16],[28],[]>,
  <[],[15],[27],[],[9,10],[16],[28],[31,32]>,
  <[],[15],[27],[31],[9,10],[16],[28],[32]>,
  <[],[15],[27],[31,32],[9,10],[16],[28],[]>,
  <[],[15],[27,28],[],[9,10],[16],[],[29,30]>,
  <[],[15],[27,28],[29],[9,10],[16],[],[30]>,
  <[],[15],[27,28],[29,30],[9,10],[16],[],[]>,
  <[],[15],[27,28],[],[9,10],[16],[],[31,32]>,
  <[],[15],[27,28],[31],[9,10],[16],[],[32]>,
  <[],[15],[27,28],[31,32],[9,10],[16],[],[]>,
  <[],[15,16],[],[],[9,10],[],[17,18],[21,22]>,
  <[],[15,16],[],[21],[9,10],[],[17,18],[22]>,
  <[],[15,16],[],[21,22],[9,10],[],[17,18],[]>,
  <[],[15,16],[],[],[9,10],[],[17,18],[23,24]>,
  <[],[15,16],[],[23],[9,10],[],[17,18],[24]>,
  <[],[15,16],[],[23,24],[9,10],[],[17,18],[]>,
  <[],[15,16],[17],[],[9,10],[],[18],[21,22]>,
  <[],[15,16],[17],[21],[9,10],[],[18],[22]>,
  <[],[15,16],[17],[21,22],[9,10],[],[18],[]>,
  <[],[15,16],[17],[],[9,10],[],[18],[23,24]>,
  <[],[15,16],[17],[23],[9,10],[],[18],[24]>,
  <[],[15,16],[17],[23,24],[9,10],[],[18],[]>,
  <[],[15,16],[17,18],[],[9,10],[],[],[21,22]>,
  <[],[15,16],[17,18],[21],[9,10],[],[],[22]>,
  <[],[15,16],[17,18],[21,22],[9,10],[],[],[]>,
  <[],[15,16],[17,18],[],[9,10],[],[],[23,24]>,
  <[],[15,16],[17,18],[23],[9,10],[],[],[24]>,
  <[],[15,16],[17,18],[23,24],[9,10],[],[],[]>,
  <[],[15,16],[],[],[9,10],[],[19,20],[21,22]>,
  <[],[15,16],[],[21],[9,10],[],[19,20],[22]>,
  <[],[15,16],[],[21,22],[9,10],[],[19,20],[]>,
  <[],[15,16],[],[],[9,10],[],[19,20],[23,24]>,
  <[],[15,16],[],[23],[9,10],[],[19,20],[24]>,
  <[],[15,16],[],[23,24],[9,10],[],[19,20],[]>,
  <[],[15,16],[19],[],[9,10],[],[20],[21,22]>,
  <[],[15,16],[19],[21],[9,10],[],[20],[22]>,
  <[],[15,16],[19],[21,22],[9,10],[],[20],[]>,
  <[],[15,16],[19],[],[9,10],[],[20],[23,24]>,
  <[],[15,16],[19],[23],[9,10],[],[20],[24]>,
  <[],[15,16],[19],[23,24],[9,10],[],[20],[]>,
  <[],[15,16],[19,20],[],[9,10],[],[],[21,22]>,
  <[],[15,16],[19,20],[21],[9,10],[],[],[22]>,
  <[],[15,16],[19,20],[21,22],[9,10],[],[],[]>,
  <[],[15,16],[19,20],[],[9,10],[],[],[23,24]>,
  <[],[15,16],[19,20],[23],[9,10],[],[],[24]>,
  <[],[15,16],[19,20],[23,24],[9,10],[],[],[]>,
  <[],[15,16],[],[],[9,10],[],[25,26],[29,30]>,
  <[],[15,16],[],[29],[9,10],[],[25,26],[30]>,
  <[],[15,16],[],[29,30],[9,10],[],[25,26],[]>,
  <[],[15,16],[],[],[9,10],[],[25,26],[31,32]>,
  <[],[15,16],[],[31],[9,10],[],[25,26],[32]>,
  <[],[15,16],[],[31,32],[9,10],[],[25,26],[]>,
  <[],[15,16],[25],[],[9,10],[],[26],[29,30]>,
  <[],[15,16],[25],[29],[9,10],[],[26],[30]>,
  <[],[15,16],[25],[29,30],[9,10],[],[26],[]>,
  <[],[15,16],[25],[],[9,10],[],[26],[31,32]>,
  <[],[15,16],[25],[31],[9,10],[],[26],[32]>,
  <[],[15,16],[25],[31,32],[9,10],[],[26],[]>,
  <[],[15,16],[25,26],[],[9,10],[],[],[29,30]>,
  <[],[15,16],[25,26],[29],[9,10],[],[],[30]>,
  <[],[15,16],[25,26],[29,30],[9,10],[],[],[]>,
  <[],[15,16],[25,26],[],[9,10],[],[],[31,32]>,
  <[],[15,16],[25,26],[31],[9,10],[],[],[32]>,
  <[],[15,16],[25,26],[31,32],[9,10],[],[],[]>,
  <[],[15,16],[],[],[9,10],[],[27,28],[29,30]>,
  <[],[15,16],[],[29],[9,10],[],[27,28],[30]>,
  <[],[15,16],[],[29,30],[9,10],[],[27,28],[]>,
  <[],[15,16],[],[],[9,10],[],[27,28],[31,32]>,
  <[],[15,16],[],[31],[9,10],[],[27,28],[32]>,
  <[],[15,16],[],[31,32],[9,10],[],[27,28],[]>,
  <[],[15,16],[27],[],[9,10],[],[28],[29,30]>,
  <[],[15,16],[27],[29],[9,10],[],[28],[30]>,
  <[],[15,16],[27],[29,30],[9,10],[],[28],[]>,
  <[],[15,16],[27],[],[9,10],[],[28],[31,32]>,
  <[],[15,16],[27],[31],[9,10],[],[28],[32]>,
  <[],[15,16],[27],[31,32],[9,10],[],[28],[]>,
  <[],[15,16],[27,28],[],[9,10],[],[],[29,30]>,
  <[],[15,16],[27,28],[29],[9,10],[],[],[30]>,
  <[],[15,16],[27,28],[29,30],[9,10],[],[],[]>,
  <[],[15,16],[27,28],[],[9,10],[],[],[31,32]>,
  <[],[15,16],[27,28],[31],[9,10],[],[],[32]>,
  <[],[15,16],[27,28],[31,32],[9,10],[],[],[]>,
  <[9],[],[],[],[10],[13,14],[17,18],[21,22]>,
  <[9],[],[],[21],[10],[13,14],[17,18],[22]>,
  <[9],[],[],[21,22],[10],[13,14],[17,18],[]>,
  <[9],[],[],[],[10],[13,14],[17,18],[23,24]>,
  <[9],[],[],[23],[10],[13,14],[17,18],[24]>,
  <[9],[],[],[23,24],[10],[13,14],[17,18],[]>,
  <[9],[],[17],[],[10],[13,14],[18],[21,22]>,
  <[9],[],[17],[21],[10],[13,14],[18],[22]>,
  <[9],[],[17],[21,22],[10],[13,14],[18],[]>,
  <[9],[],[17],[],[10],[13,14],[18],[23,24]>,
  <[9],[],[17],[23],[10],[13,14],[18],[24]>,
  <[9],[],[17],[23,24],[10],[13,14],[18],[]>,
  <[9],[],[17,18],[],[10],[13,14],[],[21,22]>,
  <[9],[],[17,18],[21],[10],[13,14],[],[22]>,
  <[9],[],[17,18],[21,22],[10],[13,14],[],[]>,
  <[9],[],[17,18],[],[10],[13,14],[],[23,24]>,
  <[9],[],[17,18],[23],[10],[13,14],[],[24]>,
  <[9],[],[17,18],[23,24],[10],[13,14],[],[]>,
  <[9],[],[],[],[10],[13,14],[19,20],[21,22]>,
  <[9],[],[],[21],[10],[13,14],[19,20],[22]>,
  <[9],[],[],[21,22],[10],[13,14],[19,20],[]>,
  <[9],[],[],[],[10],[13,14],[19,20],[23,24]>,
  <[9],[],[],[23],[10],[13,14],[19,20],[24]>,
  <[9],[],[],[23,24],[10],[13,14],[19,20],[]>,
  <[9],[],[19],[],[10],[13,14],[20],[21,22]>,
  <[9],[],[19],[21],[10],[13,14],[20],[22]>,
  <[9],[],[19],[21,22],[10],[13,14],[20],[]>,
  <[9],[],[19],[],[10],[13,14],[20],[23,24]>,
  <[9],[],[19],[23],[10],[13,14],[20],[24]>,
  <[9],[],[19],[23,24],[10],[13,14],[20],[]>,
  <[9],[],[19,20],[],[10],[13,14],[],[21,22]>,
  <[9],[],[19,20],[21],[10],[13,14],[],[22]>,
  <[9],[],[19,20],[21,22],[10],[13,14],[],[]>,
  <[9],[],[19,20],[],[10],[13,14],[],[23,24]>,
  <[9],[],[19,20],[23],[10],[13,14],[],[24]>,
  <[9],[],[19,20],[23,24],[10],[13,14],[],[]>,
  <[9],[],[],[],[10],[13,14],[25,26],[29,30]>,
  <[9],[],[],[29],[10],[13,14],[25,26],[30]>,
  <[9],[],[],[29,30],[10],[13,14],[25,26],[]>,
  <[9],[],[],[],[10],[13,14],[25,26],[31,32]>,
  <[9],[],[],[31],[10],[13,14],[25,26],[32]>,
  <[9],[],[],[31,32],[10],[13,14],[25,26],[]>,
  <[9],[],[25],[],[10],[13,14],[26],[29,30]>,
  <[9],[],[25],[29],[10],[13,14],[26],[30]>,
  <[9],[],[25],[29,30],[10],[13,14],[26],[]>,
  <[9],[],[25],[],[10],[13,14],[26],[31,32]>,
  <[9],[],[25],[31],[10],[13,14],[26],[32]>,
  <[9],[],[25],[31,32],[10],[13,14],[26],[]>,
  <[9],[],[25,26],[],[10],[13,14],[],[29,30]>,
  <[9],[],[25,26],[29],[10],[13,14],[],[30]>,
  <[9],[],[25,26],[29,30],[10],[13,14],[],[]>,
  <[9],[],[25,26],[],[10],[13,14],[],[31,32]>,
  <[9],[],[25,26],[31],[10],[13,14],[],[32]>,
  <[9],[],[25,26],[31,32],[10],[13,14],[],[]>,
  <[9],[],[],[],[10],[13,14],[27,28],[29,30]>,
  <[9],[],[],[29],[10],[13,14],[27,28],[30]>,
  <[9],[],[],[29,30],[10],[13,14],[27,28],[]>,
  <[9],[],[],[],[10],[13,14],[27,28],[31,32]>,
  <[9],[],[],[31],[10],[13,14],[27,28],[32]>,
  <[9],[],[],[31,32],[10],[13,14],[27,28],[]>,
  <[9],[],[27],[],[10],[13,14],[28],[29,30]>,
  <[9],[],[27],[29],[10],[13,14],[28],[30]>,
  <[9],[],[27],[29,30],[10],[13,14],[28],[]>,
  <[9],[],[27],[],[10],[13,14],[28],[31,32]>,
  <[9],[],[27],[31],[10],[13,14],[28],[32]>,
  <[9],[],[27],[31,32],[10],[13,14],[28],[]>,
  <[9],[],[27,28],[],[10],[13,14],[],[29,30]>,
  <[9],[],[27,28],[29],[10],[13,14],[],[30]>,
  <[9],[],[27,28],[29,30],[10],[13,14],[],[]>,
  <[9],[],[27,28],[],[10],[13,14],[],[31,32]>,
  <[9],[],[27,28],[31],[10],[13,14],[],[32]>,
  <[9],[],[27,28],[31,32],[10],[13,14],[],[]>,
  <[9],[13],[],[],[10],[14],[17,18],[21,22]>,
  <[9],[13],[],[21],[10],[14],[17,18],[22]>,
  <[9],[13],[],[21,22],[10],[14],[17,18],[]>,
  <[9],[13],[],[],[10],[14],[17,18],[23,24]>,
  <[9],[13],[],[23],[10],[14],[17,18],[24]>,
  <[9],[13],[],[23,24],[10],[14],[17,18],[]>,
  <[9],[13],[17],[],[10],[14],[18],[21,22]>,
  <[9],[13],[17],[21],[10],[14],[18],[22]>,
  <[9],[13],[17],[21,22],[10],[14],[18],[]>,
  <[9],[13],[17],[],[10],[14],[18],[23,24]>,
  <[9],[13],[17],[23],[10],[14],[18],[24]>,
  <[9],[13],[17],[23,24],[10],[14],[18],[]>,
  <[9],[13],[17,18],[],[10],[14],[],[21,22]>,
  <[9],[13],[17,18],[21],[10],[14],[],[22]>,
  <[9],[13],[17,18],[21,22],[10],[14],[],[]>,
  <[9],[13],[17,18],[],[10],[14],[],[23,24]>,
  <[9],[13],[17,18],[23],[10],[14],[],[24]>,
  <[9],[13],[17,18],[23,24],[10],[14],[],[]>,
  <[9],[13],[],[],[10],[14],[19,20],[21,22]>,
  <[9],[13],[],[21],[10],[14],[19,20],[22]>,
  <[9],[13],[],[21,22],[10],[14],[19,20],[]>,
  <[9],[13],[],[],[10],[14],[19,20],[23,24]>,
  <[9],[13],[],[23],[10],[14],[19,20],[24]>,
  <[9],[13],[],[23,24],[10],[14],[19,20],[]>,
  <[9],[13],[19],[],[10],[14],[20],[21,22]>,
  <[9],[13],[19],[21],[10],[14],[20],[22]>,
  <[9],[13],[19],[21,22],[10],[14],[20],[]>,
  <[9],[13],[19],[],[10],[14],[20],[23,24]>,
  <[9],[13],[19],[23],[10],[14],[20],[24]>,
  <[9],[13],[19],[23,24],[10],[14],[20],[]>,
  <[9],[13],[19,20],[],[10],[14],[],[21,22]>,
  <[9],[13],[19,20],[21],[10],[14],[],[22]>,
  <[9],[13],[19,20],[21,22],[10],[14],[],[]>,
  <[9],[13],[19,20],[],[10],[14],[],[23,24]>,
  <[9],[13],[19,20],[23],[10],[14],[],[24]>,
  <[9],[13],[19,20],[23,24],[10],[14],[],[]>,
  <[9],[13],[],[],[10],[14],[25,26],[29,30]>,
  <[9],[13],[],[29],[10],[14],[25,26],[30]>,
  <[9],[13],[],[29,30],[10],[14],[25,26],[]>,
  <[9],[13],[],[],[10],[14],[25,26],[31,32]>,
  <[9],[13],[],[31],[10],[14],[25,26],[32]>,
  <[9],[13],[],[31,32],[10],[14],[25,26],[]>,
  <[9],[13],[25],[],[10],[14],[26],[29,30]>,
  <[9],[13],[25],[29],[10],[14],[26],[30]>,
  <[9],[13],[25],[29,30],[10],[14],[26],[]>,
  <[9],[13],[25],[],[10],[14],[26],[31,32]>,
  <[9],[13],[25],[31],[10],[14],[26],[32]>,
  <[9],[13],[25],[31,32],[10],[14],[26],[]>,
  <[9],[13],[25,26],[],[10],[14],[],[29,30]>,
  <[9],[13],[25,26],[29],[10],[14],[],[30]>,
  <[9],[13],[25,26],[29,30],[10],[14],[],[]>,
  <[9],[13],[25,26],[],[10],[14],[],[31,32]>,
  <[9],[13],[25,26],[31],[10],[14],[],[32]>,
  <[9],[13],[25,26],[31,32],[10],[14],[],[]>,
  <[9],[13],[],[],[10],[14],[27,28],[29,30]>,
  <[9],[13],[],[29],[10],[14],[27,28],[30]>,
  <[9],[13],[],[29,30],[10],[14],[27,28],[]>,
  <[9],[13],[],[],[10],[14],[27,28],[31,32]>,
  <[9],[13],[],[31],[10],[14],[27,28],[32]>,
  <[9],[13],[],[31,32],[10],[14],[27,28],[]>,
  <[9],[13],[27],[],[10],[14],[28],[29,30]>,
  <[9],[13],[27],[29],[10],[14],[28],[30]>,
  <[9],[13],[27],[29,30],[10],[14],[28],[]>,
  <[9],[13],[27],[],[10],[14],[28],[31,32]>,
  <[9],[13],[27],[31],[10],[14],[28],[32]>,
  <[9],[13],[27],[31,32],[10],[14],[28],[]>,
  <[9],[13],[27,28],[],[10],[14],[],[29,30]>,
  <[9],[13],[27,28],[29],[10],[14],[],[30]>,
  <[9],[13],[27,28],[29,30],[10],[14],[],[]>,
  <[9],[13],[27,28],[],[10],[14],[],[31,32]>,
  <[9],[13],[27,28],[31],[10],[14],[],[32]>,
  <[9],[13],[27,28],[31,32],[10],[14],[],[]>,
  <[9],[13,14],[],[],[10],[],[17,18],[21,22]>,
  <[9],[13,14],[],[21],[10],[],[17,18],[22]>,
  <[9],[13,14],[],[21,22],[10],[],[17,18],[]>,
  <[9],[13,14],[],[],[10],[],[17,18],[23,24]>,
  <[9],[13,14],[],[23],[10],[],[17,18],[24]>,
  <[9],[13,14],[],[23,24],[10],[],[17,18],[]>,
  <[9],[13,14],[17],[],[10],[],[18],[21,22]>,
  <[9],[13,14],[17],[21],[10],[],[18],[22]>,
  <[9],[13,14],[17],[21,22],[10],[],[18],[]>,
  <[9],[13,14],[17],[],[10],[],[18],[23,24]>,
  <[9],[13,14],[17],[23],[10],[],[18],[24]>,
  <[9],[13,14],[17],[23,24],[10],[],[18],[]>,
  <[9],[13,14],[17,18],[],[10],[],[],[21,22]>,
  <[9],[13,14],[17,18],[21],[10],[],[],[22]>,
  <[9],[13,14],[17,18],[21,22],[10],[],[],[]>,
  <[9],[13,14],[17,18],[],[10],[],[],[23,24]>,
  <[9],[13,14],[17,18],[23],[10],[],[],[24]>,
  <[9],[13,14],[17,18],[23,24],[10],[],[],[]>,
  <[9],[13,14],[],[],[10],[],[19,20],[21,22]>,
  <[9],[13,14],[],[21],[10],[],[19,20],[22]>,
  <[9],[13,14],[],[21,22],[10],[],[19,20],[]>,
  <[9],[13,14],[],[],[10],[],[19,20],[23,24]>,
  <[9],[13,14],[],[23],[10],[],[19,20],[24]>,
  <[9],[13,14],[],[23,24],[10],[],[19,20],[]>,
  <[9],[13,14],[19],[],[10],[],[20],[21,22]>,
  <[9],[13,14],[19],[21],[10],[],[20],[22]>,
  <[9],[13,14],[19],[21,22],[10],[],[20],[]>,
  <[9],[13,14],[19],[],[10],[],[20],[23,24]>,
  <[9],[13,14],[19],[23],[10],[],[20],[24]>,
  <[9],[13,14],[19],[23,24],[10],[],[20],[]>,
  <[9],[13,14],[19,20],[],[10],[],[],[21,22]>,
  <[9],[13,14],[19,20],[21],[10],[],[],[22]>,
  <[9],[13,14],[19,20],[21,22],[10],[],[],[]>,
  <[9],[13,14],[19,20],[],[10],[],[],[23,24]>,
  <[9],[13,14],[19,20],[23],[10],[],[],[24]>,
  <[9],[13,14],[19,20],[23,24],[10],[],[],[]>,
  <[9],[13,14],[],[],[10],[],[25,26],[29,30]>,
  <[9],[13,14],[],[29],[10],[],[25,26],[30]>,
  <[9],[13,14],[],[29,30],[10],[],[25,26],[]>,
  <[9],[13,14],[],[],[10],[],[25,26],[31,32]>,
  <[9],[13,14],[],[31],[10],[],[25,26],[32]>,
  <[9],[13,14],[],[31,32],[10],[],[25,26],[]>,
  <[9],[13,14],[25],[],[10],[],[26],[29,30]>,
  <[9],[13,14],[25],[29],[10],[],[26],[30]>,
  <[9],[13,14],[25],[29,30],[10],[],[26],[]>,
  <[9],[13,14],[25],[],[10],[],[26],[31,32]>,
  <[9],[13,14],[25],[31],[10],[],[26],[32]>,
  <[9],[13,14],[25],[31,32],[10],[],[26],[]>,
  <[9],[13,14],[25,26],[],[10],[],[],[29,30]>,
  <[9],[13,14],[25,26],[29],[10],[],[],[30]>,
  <[9],[13,14],[25,26],[29,30],[10],[],[],[]>,
  <[9],[13,14],[25,26],[],[10],[],[],[31,32]>,
  <[9],[13,14],[25,26],[31],[10],[],[],[32]>,
  <[9],[13,14],[25,26],[31,32],[10],[],[],[]>,
  <[9],[13,14],[],[],[10],[],[27,28],[29,30]>,
  <[9],[13,14],[],[29],[10],[],[27,28],[30]>,
  <[9],[13,14],[],[29,30],[10],[],[27,28],[]>,
  <[9],[13,14],[],[],[10],[],[27,28],[31,32]>,
  <[9],[13,14],[],[31],[10],[],[27,28],[32]>,
  <[9],[13,14],[],[31,32],[10],[],[27,28],[]>,
  <[9],[13,14],[27],[],[10],[],[28],[29,30]>,
  <[9],[13,14],[27],[29],[10],[],[28],[30]>,
  <[9],[13,14],[27],[29,30],[10],[],[28],[]>,
  <[9],[13,14],[27],[],[10],[],[28],[31,32]>,
  <[9],[13,14],[27],[31],[10],[],[28],[32]>,
  <[9],[13,14],[27],[31,32],[10],[],[28],[]>,
  <[9],[13,14],[27,28],[],[10],[],[],[29,30]>,
  <[9],[13,14],[27,28],[29],[10],[],[],[30]>,
  <[9],[13,14],[27,28],[29,30],[10],[],[],[]>,
  <[9],[13,14],[27,28],[],[10],[],[],[31,32]>,
  <[9],[13,14],[27,28],[31],[10],[],[],[32]>,
  <[9],[13,14],[27,28],[31,32],[10],[],[],[]>,
  <[9],[],[],[],[10],[15,16],[17,18],[21,22]>,
  <[9],[],[],[21],[10],[15,16],[17,18],[22]>,
  <[9],[],[],[21,22],[10],[15,16],[17,18],[]>,
  <[9],[],[],[],[10],[15,16],[17,18],[23,24]>,
  <[9],[],[],[23],[10],[15,16],[17,18],[24]>,
  <[9],[],[],[23,24],[10],[15,16],[17,18],[]>,
  <[9],[],[17],[],[10],[15,16],[18],[21,22]>,
  <[9],[],[17],[21],[10],[15,16],[18],[22]>,
  <[9],[],[17],[21,22],[10],[15,16],[18],[]>,
  <[9],[],[17],[],[10],[15,16],[18],[23,24]>,
  <[9],[],[17],[23],[10],[15,16],[18],[24]>,
  <[9],[],[17],[23,24],[10],[15,16],[18],[]>,
  <[9],[],[17,18],[],[10],[15,16],[],[21,22]>,
  <[9],[],[17,18],[21],[10],[15,16],[],[22]>,
  <[9],[],[17,18],[21,22],[10],[15,16],[],[]>,
  <[9],[],[17,18],[],[10],[15,16],[],[23,24]>,
  <[9],[],[17,18],[23],[10],[15,16],[],[24]>,
  <[9],[],[17,18],[23,24],[10],[15,16],[],[]>,
  <[9],[],[],[],[10],[15,16],[19,20],[21,22]>,
  <[9],[],[],[21],[10],[15,16],[19,20],[22]>,
  <[9],[],[],[21,22],[10],[15,16],[19,20],[]>,
  <[9],[],[],[],[10],[15,16],[19,20],[23,24]>,
  <[9],[],[],[23],[10],[15,16],[19,20],[24]>,
  <[9],[],[],[23,24],[10],[15,16],[19,20],[]>,
  <[9],[],[19],[],[10],[15,16],[20],[21,22]>,
  <[9],[],[19],[21],[10],[15,16],[20],[22]>,
  <[9],[],[19],[21,22],[10],[15,16],[20],[]>,
  <[9],[],[19],[],[10],[15,16],[20],[23,24]>,
  <[9],[],[19],[23],[10],[15,16],[20],[24]>,
  <[9],[],[19],[23,24],[10],[15,16],[20],[]>,
  <[9],[],[19,20],[],[10],[15,16],[],[21,22]>,
  <[9],[],[19,20],[21],[10],[15,16],[],[22]>,
  <[9],[],[19,20],[21,22],[10],[15,16],[],[]>,
  <[9],[],[19,20],[],[10],[15,16],[],[23,24]>,
  <[9],[],[19,20],[23],[10],[15,16],[],[24]>,
  <[9],[],[19,20],[23,24],[10],[15,16],[],[]>,
  <[9],[],[],[],[10],[15,16],[25,26],[29,30]>,
  <[9],[],[],[29],[10],[15,16],[25,26],[30]>,
  <[9],[],[],[29,30],[10],[15,16],[25,26],[]>,
  <[9],[],[],[],[10],[15,16],[25,26],[31,32]>,
  <[9],[],[],[31],[10],[15,16],[25,26],[32]>,
  <[9],[],[],[31,32],[10],[15,16],[25,26],[]>,
  <[9],[],[25],[],[10],[15,16],[26],[29,30]>,
  <[9],[],[25],[29],[10],[15,16],[26],[30]>,
  <[9],[],[25],[29,30],[10],[15,16],[26],[]>,
  <[9],[],[25],[],[10],[15,16],[26],[31,32]>,
  <[9],[],[25],[31],[10],[15,16],[26],[32]>,
  <[9],[],[25],[31,32],[10],[15,16],[26],[]>,
  <[9],[],[25,26],[],[10],[15,16],[],[29,30]>,
  <[9],[],[25,26],[29],[10],[15,16],[],[30]>,
  <[9],[],[25,26],[29,30],[10],[15,16],[],[]>,
  <[9],[],[25,26],[],[10],[15,16],[],[31,32]>,
  <[9],[],[25,26],[31],[10],[15,16],[],[32]>,
  <[9],[],[25,26],[31,32],[10],[15,16],[],[]>,
  <[9],[],[],[],[10],[15,16],[27,28],[29,30]>,
  <[9],[],[],[29],[10],[15,16],[27,28],[30]>,
  <[9],[],[],[29,30],[10],[15,16],[27,28],[]>,
  <[9],[],[],[],[10],[15,16],[27,28],[31,32]>,
  <[9],[],[],[31],[10],[15,16],[27,28],[32]>,
  <[9],[],[],[31,32],[10],[15,16],[27,28],[]>,
  <[9],[],[27],[],[10],[15,16],[28],[29,30]>,
  <[9],[],[27],[29],[10],[15,16],[28],[30]>,
  <[9],[],[27],[29,30],[10],[15,16],[28],[]>,
  <[9],[],[27],[],[10],[15,16],[28],[31,32]>,
  <[9],[],[27],[31],[10],[15,16],[28],[32]>,
  <[9],[],[27],[31,32],[10],[15,16],[28],[]>,
  <[9],[],[27,28],[],[10],[15,16],[],[29,30]>,
  <[9],[],[27,28],[29],[10],[15,16],[],[30]>,
  <[9],[],[27,28],[29,30],[10],[15,16],[],[]>,
  <[9],[],[27,28],[],[10],[15,16],[],[31,32]>,
  <[9],[],[27,28],[31],[10],[15,16],[],[32]>,
  <[9],[],[27,28],[31,32],[10],[15,16],[],[]>,
  <[9],[15],[],[],[10],[16],[17,18],[21,22]>,
  <[9],[15],[],[21],[10],[16],[17,18],[22]>,
  <[9],[15],[],[21,22],[10],[16],[17,18],[]>,
  <[9],[15],[],[],[10],[16],[17,18],[23,24]>,
  <[9],[15],[],[23],[10],[16],[17,18],[24]>,
  <[9],[15],[],[23,24],[10],[16],[17,18],[]>,
  <[9],[15],[17],[],[10],[16],[18],[21,22]>,
  <[9],[15],[17],[21],[10],[16],[18],[22]>,
  <[9],[15],[17],[21,22],[10],[16],[18],[]>,
  <[9],[15],[17],[],[10],[16],[18],[23,24]>,
  <[9],[15],[17],[23],[10],[16],[18],[24]>,
  <[9],[15],[17],[23,24],[10],[16],[18],[]>,
  <[9],[15],[17,18],[],[10],[16],[],[21,22]>,
  <[9],[15],[17,18],[21],[10],[16],[],[22]>,
  <[9],[15],[17,18],[21,22],[10],[16],[],[]>,
  <[9],[15],[17,18],[],[10],[16],[],[23,24]>,
  <[9],[15],[17,18],[23],[10],[16],[],[24]>,
  <[9],[15],[17,18],[23,24],[10],[16],[],[]>,
  <[9],[15],[],[],[10],[16],[19,20],[21,22]>,
  <[9],[15],[],[21],[10],[16],[19,20],[22]>,
  <[9],[15],[],[21,22],[10],[16],[19,20],[]>,
  <[9],[15],[],[],[10],[16],[19,20],[23,24]>,
  <[9],[15],[],[23],[10],[16],[19,20],[24]>,
  <[9],[15],[],[23,24],[10],[16],[19,20],[]>,
  <[9],[15],[19],[],[10],[16],[20],[21,22]>,
  <[9],[15],[19],[21],[10],[16],[20],[22]>,
  <[9],[15],[19],[21,22],[10],[16],[20],[]>,
  <[9],[15],[19],[],[10],[16],[20],[23,24]>,
  <[9],[15],[19],[23],[10],[16],[20],[24]>,
  <[9],[15],[19],[23,24],[10],[16],[20],[]>,
  <[9],[15],[19,20],[],[10],[16],[],[21,22]>,
  <[9],[15],[19,20],[21],[10],[16],[],[22]>,
  <[9],[15],[19,20],[21,22],[10],[16],[],[]>,
  <[9],[15],[19,20],[],[10],[16],[],[23,24]>,
  <[9],[15],[19,20],[23],[10],[16],[],[24]>,
  <[9],[15],[19,20],[23,24],[10],[16],[],[]>,
  <[9],[15],[],[],[10],[16],[25,26],[29,30]>,
  <[9],[15],[],[29],[10],[16],[25,26],[30]>,
  <[9],[15],[],[29,30],[10],[16],[25,26],[]>,
  <[9],[15],[],[],[10],[16],[25,26],[31,32]>,
  <[9],[15],[],[31],[10],[16],[25,26],[32]>,
  <[9],[15],[],[31,32],[10],[16],[25,26],[]>,
  <[9],[15],[25],[],[10],[16],[26],[29,30]>,
  <[9],[15],[25],[29],[10],[16],[26],[30]>,
  <[9],[15],[25],[29,30],[10],[16],[26],[]>,
  <[9],[15],[25],[],[10],[16],[26],[31,32]>,
  <[9],[15],[25],[31],[10],[16],[26],[32]>,
  <[9],[15],[25],[31,32],[10],[16],[26],[]>,
  <[9],[15],[25,26],[],[10],[16],[],[29,30]>,
  <[9],[15],[25,26],[29],[10],[16],[],[30]>,
  <[9],[15],[25,26],[29,30],[10],[16],[],[]>,
  <[9],[15],[25,26],[],[10],[16],[],[31,32]>,
  <[9],[15],[25,26],[31],[10],[16],[],[32]>,
  <[9],[15],[25,26],[31,32],[10],[16],[],[]>,
  <[9],[15],[],[],[10],[16],[27,28],[29,30]>,
  <[9],[15],[],[29],[10],[16],[27,28],[30]>,
  <[9],[15],[],[29,30],[10],[16],[27,28],[]>,
  <[9],[15],[],[],[10],[16],[27,28],[31,32]>,
  <[9],[15],[],[31],[10],[16],[27,28],[32]>,
  <[9],[15],[],[31,32],[10],[16],[27,28],[]>,
  <[9],[15],[27],[],[10],[16],[28],[29,30]>,
  <[9],[15],[27],[29],[10],[16],[28],[30]>,
  <[9],[15],[27],[29,30],[10],[16],[28],[]>,
  <[9],[15],[27],[],[10],[16],[28],[31,32]>,
  <[9],[15],[27],[31],[10],[16],[28],[32]>,
  <[9],[15],[27],[31,32],[10],[16],[28],[]>,
  <[9],[15],[27,28],[],[10],[16],[],[29,30]>,
  <[9],[15],[27,28],[29],[10],[16],[],[30]>,
  <[9],[15],[27,28],[29,30],[10],[16],[],[]>,
  <[9],[15],[27,28],[],[10],[16],[],[31,32]>,
  <[9],[15],[27,28],[31],[10],[16],[],[32]>,
  <[9],[15],[27,28],[31,32],[10],[16],[],[]>,
  <[9],[15,16],[],[],[10],[],[17,18],[21,22]>,
  <[9],[15,16],[],[21],[10],[],[17,18],[22]>,
  <[9],[15,16],[],[21,22],[10],[],[17,18],[]>,
  <[9],[15,16],[],[],[10],[],[17,18],[23,24]>,
  <[9],[15,16],[],[23],[10],[],[17,18],[24]>,
  <[9],[15,16],[],[23,24],[10],[],[17,18],[]>,
  <[9],[15,16],[17],[],[10],[],[18],[21,22]>,
  <[9],[15,16],[17],[21],[10],[],[18],[22]>,
  <[9],[15,16],[17],[21,22],[10],[],[18],[]>,
  <[9],[15,16],[17],[],[10],[],[18],[23,24]>,
  <[9],[15,16],[17],[23],[10],[],[18],[24]>,
  <[9],[15,16],[17],[23,24],[10],[],[18],[]>,
  <[9],[15,16],[17,18],[],[10],[],[],[21,22]>,
  <[9],[15,16],[17,18],[21],[10],[],[],[22]>,
  <[9],[15,16],[17,18],[21,22],[10],[],[],[]>,
  <[9],[15,16],[17,18],[],[10],[],[],[23,24]>,
  <[9],[15,16],[17,18],[23],[10],[],[],[24]>,
  <[9],[15,16],[17,18],[23,24],[10],[],[],[]>,
  <[9],[15,16],[],[],[10],[],[19,20],[21,22]>,
  <[9],[15,16],[],[21],[10],[],[19,20],[22]>,
  <[9],[15,16],[],[21,22],[10],[],[19,20],[]>,
  <[9],[15,16],[],[],[10],[],[19,20],[23,24]>,
  <[9],[15,16],[],[23],[10],[],[19,20],[24]>,
  <[9],[15,16],[],[23,24],[10],[],[19,20],[]>,
  <[9],[15,16],[19],[],[10],[],[20],[21,22]>,
  <[9],[15,16],[19],[21],[10],[],[20],[22]>,
  <[9],[15,16],[19],[21,22],[10],[],[20],[]>,
  <[9],[15,16],[19],[],[10],[],[20],[23,24]>,
  <[9],[15,16],[19],[23],[10],[],[20],[24]>,
  <[9],[15,16],[19],[23,24],[10],[],[20],[]>,
  <[9],[15,16],[19,20],[],[10],[],[],[21,22]>,
  <[9],[15,16],[19,20],[21],[10],[],[],[22]>,
  <[9],[15,16],[19,20],[21,22],[10],[],[],[]>,
  <[9],[15,16],[19,20],[],[10],[],[],[23,24]>,
  <[9],[15,16],[19,20],[23],[10],[],[],[24]>,
  <[9],[15,16],[19,20],[23,24],[10],[],[],[]>,
  <[9],[15,16],[],[],[10],[],[25,26],[29,30]>,
  <[9],[15,16],[],[29],[10],[],[25,26],[30]>,
  <[9],[15,16],[],[29,30],[10],[],[25,26],[]>,
  <[9],[15,16],[],[],[10],[],[25,26],[31,32]>,
  <[9],[15,16],[],[31],[10],[],[25,26],[32]>,
  <[9],[15,16],[],[31,32],[10],[],[25,26],[]>,
  <[9],[15,16],[25],[],[10],[],[26],[29,30]>,
  <[9],[15,16],[25],[29],[10],[],[26],[30]>,
  <[9],[15,16],[25],[29,30],[10],[],[26],[]>,
  <[9],[15,16],[25],[],[10],[],[26],[31,32]>,
  <[9],[15,16],[25],[31],[10],[],[26],[32]>,
  <[9],[15,16],[25],[31,32],[10],[],[26],[]>,
  <[9],[15,16],[25,26],[],[10],[],[],[29,30]>,
  <[9],[15,16],[25,26],[29],[10],[],[],[30]>,
  <[9],[15,16],[25,26],[29,30],[10],[],[],[]>,
  <[9],[15,16],[25,26],[],[10],[],[],[31,32]>,
  <[9],[15,16],[25,26],[31],[10],[],[],[32]>,
  <[9],[15,16],[25,26],[31,32],[10],[],[],[]>,
  <[9],[15,16],[],[],[10],[],[27,28],[29,30]>,
  <[9],[15,16],[],[29],[10],[],[27,28],[30]>,
  <[9],[15,16],[],[29,30],[10],[],[27,28],[]>,
  <[9],[15,16],[],[],[10],[],[27,28],[31,32]>,
  <[9],[15,16],[],[31],[10],[],[27,28],[32]>,
  <[9],[15,16],[],[31,32],[10],[],[27,28],[]>,
  <[9],[15,16],[27],[],[10],[],[28],[29,30]>,
  <[9],[15,16],[27],[29],[10],[],[28],[30]>,
  <[9],[15,16],[27],[29,30],[10],[],[28],[]>,
  <[9],[15,16],[27],[],[10],[],[28],[31,32]>,
  <[9],[15,16],[27],[31],[10],[],[28],[32]>,
  <[9],[15,16],[27],[31,32],[10],[],[28],[]>,
  <[9],[15,16],[27,28],[],[10],[],[],[29,30]>,
  <[9],[15,16],[27,28],[29],[10],[],[],[30]>,
  <[9],[15,16],[27,28],[29,30],[10],[],[],[]>,
  <[9],[15,16],[27,28],[],[10],[],[],[31,32]>,
  <[9],[15,16],[27,28],[31],[10],[],[],[32]>,
  <[9],[15,16],[27,28],[31,32],[10],[],[],[]>,
  <[9,10],[],[],[],[],[13,14],[17,18],[21,22]>,
  <[9,10],[],[],[21],[],[13,14],[17,18],[22]>,
  <[9,10],[],[],[21,22],[],[13,14],[17,18],[]>,
  <[9,10],[],[],[],[],[13,14],[17,18],[23,24]>,
  <[9,10],[],[],[23],[],[13,14],[17,18],[24]>,
  <[9,10],[],[],[23,24],[],[13,14],[17,18],[]>,
  <[9,10],[],[17],[],[],[13,14],[18],[21,22]>,
  <[9,10],[],[17],[21],[],[13,14],[18],[22]>,
  <[9,10],[],[17],[21,22],[],[13,14],[18],[]>,
  <[9,10],[],[17],[],[],[13,14],[18],[23,24]>,
  <[9,10],[],[17],[23],[],[13,14],[18],[24]>,
  <[9,10],[],[17],[23,24],[],[13,14],[18],[]>,
  <[9,10],[],[17,18],[],[],[13,14],[],[21,22]>,
  <[9,10],[],[17,18],[21],[],[13,14],[],[22]>,
  <[9,10],[],[17,18],[21,22],[],[13,14],[],[]>,
  <[9,10],[],[17,18],[],[],[13,14],[],[23,24]>,
  <[9,10],[],[17,18],[23],[],[13,14],[],[24]>,
  <[9,10],[],[17,18],[23,24],[],[13,14],[],[]>,
  <[9,10],[],[],[],[],[13,14],[19,20],[21,22]>,
  <[9,10],[],[],[21],[],[13,14],[19,20],[22]>,
  <[9,10],[],[],[21,22],[],[13,14],[19,20],[]>,
  <[9,10],[],[],[],[],[13,14],[19,20],[23,24]>,
  <[9,10],[],[],[23],[],[13,14],[19,20],[24]>,
  <[9,10],[],[],[23,24],[],[13,14],[19,20],[]>,
  <[9,10],[],[19],[],[],[13,14],[20],[21,22]>,
  <[9,10],[],[19],[21],[],[13,14],[20],[22]>,
  <[9,10],[],[19],[21,22],[],[13,14],[20],[]>,
  <[9,10],[],[19],[],[],[13,14],[20],[23,24]>,
  <[9,10],[],[19],[23],[],[13,14],[20],[24]>,
  <[9,10],[],[19],[23,24],[],[13,14],[20],[]>,
  <[9,10],[],[19,20],[],[],[13,14],[],[21,22]>,
  <[9,10],[],[19,20],[21],[],[13,14],[],[22]>,
  <[9,10],[],[19,20],[21,22],[],[13,14],[],[]>,
  <[9,10],[],[19,20],[],[],[13,14],[],[23,24]>,
  <[9,10],[],[19,20],[23],[],[13,14],[],[24]>,
  <[9,10],[],[19,20],[23,24],[],[13,14],[],[]>,
  <[9,10],[],[],[],[],[13,14],[25,26],[29,30]>,
  <[9,10],[],[],[29],[],[13,14],[25,26],[30]>,
  <[9,10],[],[],[29,30],[],[13,14],[25,26],[]>,
  <[9,10],[],[],[],[],[13,14],[25,26],[31,32]>,
  <[9,10],[],[],[31],[],[13,14],[25,26],[32]>,
  <[9,10],[],[],[31,32],[],[13,14],[25,26],[]>,
  <[9,10],[],[25],[],[],[13,14],[26],[29,30]>,
  <[9,10],[],[25],[29],[],[13,14],[26],[30]>,
  <[9,10],[],[25],[29,30],[],[13,14],[26],[]>,
  <[9,10],[],[25],[],[],[13,14],[26],[31,32]>,
  <[9,10],[],[25],[31],[],[13,14],[26],[32]>,
  <[9,10],[],[25],[31,32],[],[13,14],[26],[]>,
  <[9,10],[],[25,26],[],[],[13,14],[],[29,30]>,
  <[9,10],[],[25,26],[29],[],[13,14],[],[30]>,
  <[9,10],[],[25,26],[29,30],[],[13,14],[],[]>,
  <[9,10],[],[25,26],[],[],[13,14],[],[31,32]>,
  <[9,10],[],[25,26],[31],[],[13,14],[],[32]>,
  <[9,10],[],[25,26],[31,32],[],[13,14],[],[]>,
  <[9,10],[],[],[],[],[13,14],[27,28],[29,30]>,
  <[9,10],[],[],[29],[],[13,14],[27,28],[30]>,
  <[9,10],[],[],[29,30],[],[13,14],[27,28],[]>,
  <[9,10],[],[],[],[],[13,14],[27,28],[31,32]>,
  <[9,10],[],[],[31],[],[13,14],[27,28],[32]>,
  <[9,10],[],[],[31,32],[],[13,14],[27,28],[]>,
  <[9,10],[],[27],[],[],[13,14],[28],[29,30]>,
  <[9,10],[],[27],[29],[],[13,14],[28],[30]>,
  <[9,10],[],[27],[29,30],[],[13,14],[28],[]>,
  <[9,10],[],[27],[],[],[13,14],[28],[31,32]>,
  <[9,10],[],[27],[31],[],[13,14],[28],[32]>,
  <[9,10],[],[27],[31,32],[],[13,14],[28],[]>,
  <[9,10],[],[27,28],[],[],[13,14],[],[29,30]>,
  <[9,10],[],[27,28],[29],[],[13,14],[],[30]>,
  <[9,10],[],[27,28],[29,30],[],[13,14],[],[]>,
  <[9,10],[],[27,28],[],[],[13,14],[],[31,32]>,
  <[9,10],[],[27,28],[31],[],[13,14],[],[32]>,
  <[9,10],[],[27,28],[31,32],[],[13,14],[],[]>,
  <[9,10],[13],[],[],[],[14],[17,18],[21,22]>,
  <[9,10],[13],[],[21],[],[14],[17,18],[22]>,
  <[9,10],[13],[],[21,22],[],[14],[17,18],[]>,
  <[9,10],[13],[],[],[],[14],[17,18],[23,24]>,
  <[9,10],[13],[],[23],[],[14],[17,18],[24]>,
  <[9,10],[13],[],[23,24],[],[14],[17,18],[]>,
  <[9,10],[13],[17],[],[],[14],[18],[21,22]>,
  <[9,10],[13],[17],[21],[],[14],[18],[22]>,
  <[9,10],[13],[17],[21,22],[],[14],[18],[]>,
  <[9,10],[13],[17],[],[],[14],[18],[23,24]>,
  <[9,10],[13],[17],[23],[],[14],[18],[24]>,
  <[9,10],[13],[17],[23,24],[],[14],[18],[]>,
  <[9,10],[13],[17,18],[],[],[14],[],[21,22]>,
  <[9,10],[13],[17,18],[21],[],[14],[],[22]>,
  <[9,10],[13],[17,18],[21,22],[],[14],[],[]>,
  <[9,10],[13],[17,18],[],[],[14],[],[23,24]>,
  <[9,10],[13],[17,18],[23],[],[14],[],[24]>,
  <[9,10],[13],[17,18],[23,24],[],[14],[],[]>,
  <[9,10],[13],[],[],[],[14],[19,20],[21,22]>,
  <[9,10],[13],[],[21],[],[14],[19,20],[22]>,
  <[9,10],[13],[],[21,22],[],[14],[19,20],[]>,
  <[9,10],[13],[],[],[],[14],[19,20],[23,24]>,
  <[9,10],[13],[],[23],[],[14],[19,20],[24]>,
  <[9,10],[13],[],[23,24],[],[14],[19,20],[]>,
  <[9,10],[13],[19],[],[],[14],[20],[21,22]>,
  <[9,10],[13],[19],[21],[],[14],[20],[22]>,
  <[9,10],[13],[19],[21,22],[],[14],[20],[]>,
  <[9,10],[13],[19],[],[],[14],[20],[23,24]>,
  <[9,10],[13],[19],[23],[],[14],[20],[24]>,
  <[9,10],[13],[19],[23,24],[],[14],[20],[]>,
  <[9,10],[13],[19,20],[],[],[14],[],[21,22]>,
  <[9,10],[13],[19,20],[21],[],[14],[],[22]>,
  <[9,10],[13],[19,20],[21,22],[],[14],[],[]>,
  <[9,10],[13],[19,20],[],[],[14],[],[23,24]>,
  <[9,10],[13],[19,20],[23],[],[14],[],[24]>,
  <[9,10],[13],[19,20],[23,24],[],[14],[],[]>,
  <[9,10],[13],[],[],[],[14],[25,26],[29,30]>,
  <[9,10],[13],[],[29],[],[14],[25,26],[30]>,
  <[9,10],[13],[],[29,30],[],[14],[25,26],[]>,
  <[9,10],[13],[],[],[],[14],[25,26],[31,32]>,
  <[9,10],[13],[],[31],[],[14],[25,26],[32]>,
  <[9,10],[13],[],[31,32],[],[14],[25,26],[]>,
  <[9,10],[13],[25],[],[],[14],[26],[29,30]>,
  <[9,10],[13],[25],[29],[],[14],[26],[30]>,
  <[9,10],[13],[25],[29,30],[],[14],[26],[]>,
  <[9,10],[13],[25],[],[],[14],[26],[31,32]>,
  <[9,10],[13],[25],[31],[],[14],[26],[32]>,
  <[9,10],[13],[25],[31,32],[],[14],[26],[]>,
  <[9,10],[13],[25,26],[],[],[14],[],[29,30]>,
  <[9,10],[13],[25,26],[29],[],[14],[],[30]>,
  <[9,10],[13],[25,26],[29,30],[],[14],[],[]>,
  <[9,10],[13],[25,26],[],[],[14],[],[31,32]>,
  <[9,10],[13],[25,26],[31],[],[14],[],[32]>,
  <[9,10],[13],[25,26],[31,32],[],[14],[],[]>,
  <[9,10],[13],[],[],[],[14],[27,28],[29,30]>,
  <[9,10],[13],[],[29],[],[14],[27,28],[30]>,
  <[9,10],[13],[],[29,30],[],[14],[27,28],[]>,
  <[9,10],[13],[],[],[],[14],[27,28],[31,32]>,
  <[9,10],[13],[],[31],[],[14],[27,28],[32]>,
  <[9,10],[13],[],[31,32],[],[14],[27,28],[]>,
  <[9,10],[13],[27],[],[],[14],[28],[29,30]>,
  <[9,10],[13],[27],[29],[],[14],[28],[30]>,
  <[9,10],[13],[27],[29,30],[],[14],[28],[]>,
  <[9,10],[13],[27],[],[],[14],[28],[31,32]>,
  <[9,10],[13],[27],[31],[],[14],[28],[32]>,
  <[9,10],[13],[27],[31,32],[],[14],[28],[]>,
  <[9,10],[13],[27,28],[],[],[14],[],[29,30]>,
  <[9,10],[13],[27,28],[29],[],[14],[],[30]>,
  <[9,10],[13],[27,28],[29,30],[],[14],[],[]>,
  <[9,10],[13],[27,28],[],[],[14],[],[31,32]>,
  <[9,10],[13],[27,28],[31],[],[14],[],[32]>,
  <[9,10],[13],[27,28],[31,32],[],[14],[],[]>,
  <[9,10],[13,14],[],[],[],[],[17,18],[21,22]>,
  <[9,10],[13,14],[],[21],[],[],[17,18],[22]>,
  <[9,10],[13,14],[],[21,22],[],[],[17,18],[]>,
  <[9,10],[13,14],[],[],[],[],[17,18],[23,24]>,
  <[9,10],[13,14],[],[23],[],[],[17,18],[24]>,
  <[9,10],[13,14],[],[23,24],[],[],[17,18],[]>,
  <[9,10],[13,14],[17],[],[],[],[18],[21,22]>,
  <[9,10],[13,14],[17],[21],[],[],[18],[22]>,
  <[9,10],[13,14],[17],[21,22],[],[],[18],[]>,
  <[9,10],[13,14],[17],[],[],[],[18],[23,24]>,
  <[9,10],[13,14],[17],[23],[],[],[18],[24]>,
  <[9,10],[13,14],[17],[23,24],[],[],[18],[]>,
  <[9,10],[13,14],[17,18],[],[],[],[],[21,22]>,
  <[9,10],[13,14],[17,18],[21],[],[],[],[22]>,
  <[9,10],[13,14],[17,18],[21,22],[],[],[],[]>,
  <[9,10],[13,14],[17,18],[],[],[],[],[23,24]>,
  <[9,10],[13,14],[17,18],[23],[],[],[],[24]>,
  <[9,10],[13,14],[17,18],[23,24],[],[],[],[]>,
  <[9,10],[13,14],[],[],[],[],[19,20],[21,22]>,
  <[9,10],[13,14],[],[21],[],[],[19,20],[22]>,
  <[9,10],[13,14],[],[21,22],[],[],[19,20],[]>,
  <[9,10],[13,14],[],[],[],[],[19,20],[23,24]>,
  <[9,10],[13,14],[],[23],[],[],[19,20],[24]>,
  <[9,10],[13,14],[],[23,24],[],[],[19,20],[]>,
  <[9,10],[13,14],[19],[],[],[],[20],[21,22]>,
  <[9,10],[13,14],[19],[21],[],[],[20],[22]>,
  <[9,10],[13,14],[19],[21,22],[],[],[20],[]>,
  <[9,10],[13,14],[19],[],[],[],[20],[23,24]>,
  <[9,10],[13,14],[19],[23],[],[],[20],[24]>,
  <[9,10],[13,14],[19],[23,24],[],[],[20],[]>,
  <[9,10],[13,14],[19,20],[],[],[],[],[21,22]>,
  <[9,10],[13,14],[19,20],[21],[],[],[],[22]>,
  <[9,10],[13,14],[19,20],[21,22],[],[],[],[]>,
  <[9,10],[13,14],[19,20],[],[],[],[],[23,24]>,
  <[9,10],[13,14],[19,20],[23],[],[],[],[24]>,
  <[9,10],[13,14],[19,20],[23,24],[],[],[],[]>,
  <[9,10],[13,14],[],[],[],[],[25,26],[29,30]>,
  <[9,10],[13,14],[],[29],[],[],[25,26],[30]>,
  <[9,10],[13,14],[],[29,30],[],[],[25,26],[]>,
  <[9,10],[13,14],[],[],[],[],[25,26],[31,32]>,
  <[9,10],[13,14],[],[31],[],[],[25,26],[32]>,
  <[9,10],[13,14],[],[31,32],[],[],[25,26],[]>,
  <[9,10],[13,14],[25],[],[],[],[26],[29,30]>,
  <[9,10],[13,14],[25],[29],[],[],[26],[30]>,
  <[9,10],[13,14],[25],[29,30],[],[],[26],[]>,
  <[9,10],[13,14],[25],[],[],[],[26],[31,32]>,
  <[9,10],[13,14],[25],[31],[],[],[26],[32]>,
  <[9,10],[13,14],[25],[31,32],[],[],[26],[]>,
  <[9,10],[13,14],[25,26],[],[],[],[],[29,30]>,
  <[9,10],[13,14],[25,26],[29],[],[],[],[30]>,
  <[9,10],[13,14],[25,26],[29,30],[],[],[],[]>,
  <[9,10],[13,14],[25,26],[],[],[],[],[31,32]>,
  <[9,10],[13,14],[25,26],[31],[],[],[],[32]>,
  <[9,10],[13,14],[25,26],[31,32],[],[],[],[]>,
  <[9,10],[13,14],[],[],[],[],[27,28],[29,30]>,
  <[9,10],[13,14],[],[29],[],[],[27,28],[30]>,
  <[9,10],[13,14],[],[29,30],[],[],[27,28],[]>,
  <[9,10],[13,14],[],[],[],[],[27,28],[31,32]>,
  <[9,10],[13,14],[],[31],[],[],[27,28],[32]>,
  <[9,10],[13,14],[],[31,32],[],[],[27,28],[]>,
  <[9,10],[13,14],[27],[],[],[],[28],[29,30]>,
  <[9,10],[13,14],[27],[29],[],[],[28],[30]>,
  <[9,10],[13,14],[27],[29,30],[],[],[28],[]>,
  <[9,10],[13,14],[27],[],[],[],[28],[31,32]>,
  <[9,10],[13,14],[27],[31],[],[],[28],[32]>,
  <[9,10],[13,14],[27],[31,32],[],[],[28],[]>,
  <[9,10],[13,14],[27,28],[],[],[],[],[29,30]>,
  <[9,10],[13,14],[27,28],[29],[],[],[],[30]>,
  <[9,10],[13,14],[27,28],[29,30],[],[],[],[]>,
  <[9,10],[13,14],[27,28],[],[],[],[],[31,32]>,
  <[9,10],[13,14],[27,28],[31],[],[],[],[32]>,
  <[9,10],[13,14],[27,28],[31,32],[],[],[],[]>,
  <[9,10],[],[],[],[],[15,16],[17,18],[21,22]>,
  <[9,10],[],[],[21],[],[15,16],[17,18],[22]>,
  <[9,10],[],[],[21,22],[],[15,16],[17,18],[]>,
  <[9,10],[],[],[],[],[15,16],[17,18],[23,24]>,
  <[9,10],[],[],[23],[],[15,16],[17,18],[24]>,
  <[9,10],[],[],[23,24],[],[15,16],[17,18],[]>,
  <[9,10],[],[17],[],[],[15,16],[18],[21,22]>,
  <[9,10],[],[17],[21],[],[15,16],[18],[22]>,
  <[9,10],[],[17],[21,22],[],[15,16],[18],[]>,
  <[9,10],[],[17],[],[],[15,16],[18],[23,24]>,
  <[9,10],[],[17],[23],[],[15,16],[18],[24]>,
  <[9,10],[],[17],[23,24],[],[15,16],[18],[]>,
  <[9,10],[],[17,18],[],[],[15,16],[],[21,22]>,
  <[9,10],[],[17,18],[21],[],[15,16],[],[22]>,
  <[9,10],[],[17,18],[21,22],[],[15,16],[],[]>,
  <[9,10],[],[17,18],[],[],[15,16],[],[23,24]>,
  <[9,10],[],[17,18],[23],[],[15,16],[],[24]>,
  <[9,10],[],[17,18],[23,24],[],[15,16],[],[]>,
  <[9,10],[],[],[],[],[15,16],[19,20],[21,22]>,
  <[9,10],[],[],[21],[],[15,16],[19,20],[22]>,
  <[9,10],[],[],[21,22],[],[15,16],[19,20],[]>,
  <[9,10],[],[],[],[],[15,16],[19,20],[23,24]>,
  <[9,10],[],[],[23],[],[15,16],[19,20],[24]>,
  <[9,10],[],[],[23,24],[],[15,16],[19,20],[]>,
  <[9,10],[],[19],[],[],[15,16],[20],[21,22]>,
  <[9,10],[],[19],[21],[],[15,16],[20],[22]>,
  <[9,10],[],[19],[21,22],[],[15,16],[20],[]>,
  <[9,10],[],[19],[],[],[15,16],[20],[23,24]>,
  <[9,10],[],[19],[23],[],[15,16],[20],[24]>,
  <[9,10],[],[19],[23,24],[],[15,16],[20],[]>,
  <[9,10],[],[19,20],[],[],[15,16],[],[21,22]>,
  <[9,10],[],[19,20],[21],[],[15,16],[],[22]>,
  <[9,10],[],[19,20],[21,22],[],[15,16],[],[]>,
  <[9,10],[],[19,20],[],[],[15,16],[],[23,24]>,
  <[9,10],[],[19,20],[23],[],[15,16],[],[24]>,
  <[9,10],[],[19,20],[23,24],[],[15,16],[],[]>,
  <[9,10],[],[],[],[],[15,16],[25,26],[29,30]>,
  <[9,10],[],[],[29],[],[15,16],[25,26],[30]>,
  <[9,10],[],[],[29,30],[],[15,16],[25,26],[]>,
  <[9,10],[],[],[],[],[15,16],[25,26],[31,32]>,
  <[9,10],[],[],[31],[],[15,16],[25,26],[32]>,
  <[9,10],[],[],[31,32],[],[15,16],[25,26],[]>,
  <[9,10],[],[25],[],[],[15,16],[26],[29,30]>,
  <[9,10],[],[25],[29],[],[15,16],[26],[30]>,
  <[9,10],[],[25],[29,30],[],[15,16],[26],[]>,
  <[9,10],[],[25],[],[],[15,16],[26],[31,32]>,
  <[9,10],[],[25],[31],[],[15,16],[26],[32]>,
  <[9,10],[],[25],[31,32],[],[15,16],[26],[]>,
  <[9,10],[],[25,26],[],[],[15,16],[],[29,30]>,
  <[9,10],[],[25,26],[29],[],[15,16],[],[30]>,
  <[9,10],[],[25,26],[29,30],[],[15,16],[],[]>,
  <[9,10],[],[25,26],[],[],[15,16],[],[31,32]>,
  <[9,10],[],[25,26],[31],[],[15,16],[],[32]>,
  <[9,10],[],[25,26],[31,32],[],[15,16],[],[]>,
  <[9,10],[],[],[],[],[15,16],[27,28],[29,30]>,
  <[9,10],[],[],[29],[],[15,16],[27,28],[30]>,
  <[9,10],[],[],[29,30],[],[15,16],[27,28],[]>,
  <[9,10],[],[],[],[],[15,16],[27,28],[31,32]>,
  <[9,10],[],[],[31],[],[15,16],[27,28],[32]>,
  <[9,10],[],[],[31,32],[],[15,16],[27,28],[]>,
  <[9,10],[],[27],[],[],[15,16],[28],[29,30]>,
  <[9,10],[],[27],[29],[],[15,16],[28],[30]>,
  <[9,10],[],[27],[29,30],[],[15,16],[28],[]>,
  <[9,10],[],[27],[],[],[15,16],[28],[31,32]>,
  <[9,10],[],[27],[31],[],[15,16],[28],[32]>,
  <[9,10],[],[27],[31,32],[],[15,16],[28],[]>,
  <[9,10],[],[27,28],[],[],[15,16],[],[29,30]>,
  <[9,10],[],[27,28],[29],[],[15,16],[],[30]>,
  <[9,10],[],[27,28],[29,30],[],[15,16],[],[]>,
  <[9,10],[],[27,28],[],[],[15,16],[],[31,32]>,
  <[9,10],[],[27,28],[31],[],[15,16],[],[32]>,
  <[9,10],[],[27,28],[31,32],[],[15,16],[],[]>,
  <[9,10],[15],[],[],[],[16],[17,18],[21,22]>,
  <[9,10],[15],[],[21],[],[16],[17,18],[22]>,
  <[9,10],[15],[],[21,22],[],[16],[17,18],[]>,
  <[9,10],[15],[],[],[],[16],[17,18],[23,24]>,
  <[9,10],[15],[],[23],[],[16],[17,18],[24]>,
  <[9,10],[15],[],[23,24],[],[16],[17,18],[]>,
  <[9,10],[15],[17],[],[],[16],[18],[21,22]>,
  <[9,10],[15],[17],[21],[],[16],[18],[22]>,
  <[9,10],[15],[17],[21,22],[],[16],[18],[]>,
  <[9,10],[15],[17],[],[],[16],[18],[23,24]>,
  <[9,10],[15],[17],[23],[],[16],[18],[24]>,
  <[9,10],[15],[17],[23,24],[],[16],[18],[]>,
  <[9,10],[15],[17,18],[],[],[16],[],[21,22]>,
  <[9,10],[15],[17,18],[21],[],[16],[],[22]>,
  <[9,10],[15],[17,18],[21,22],[],[16],[],[]>,
  <[9,10],[15],[17,18],[],[],[16],[],[23,24]>,
  <[9,10],[15],[17,18],[23],[],[16],[],[24]>,
  <[9,10],[15],[17,18],[23,24],[],[16],[],[]>,
  <[9,10],[15],[],[],[],[16],[19,20],[21,22]>,
  <[9,10],[15],[],[21],[],[16],[19,20],[22]>,
  <[9,10],[15],[],[21,22],[],[16],[19,20],[]>,
  <[9,10],[15],[],[],[],[16],[19,20],[23,24]>,
  <[9,10],[15],[],[23],[],[16],[19,20],[24]>,
  <[9,10],[15],[],[23,24],[],[16],[19,20],[]>,
  <[9,10],[15],[19],[],[],[16],[20],[21,22]>,
  <[9,10],[15],[19],[21],[],[16],[20],[22]>,
  <[9,10],[15],[19],[21,22],[],[16],[20],[]>,
  <[9,10],[15],[19],[],[],[16],[20],[23,24]>,
  <[9,10],[15],[19],[23],[],[16],[20],[24]>,
  <[9,10],[15],[19],[23,24],[],[16],[20],[]>,
  <[9,10],[15],[19,20],[],[],[16],[],[21,22]>,
  <[9,10],[15],[19,20],[21],[],[16],[],[22]>,
  <[9,10],[15],[19,20],[21,22],[],[16],[],[]>,
  <[9,10],[15],[19,20],[],[],[16],[],[23,24]>,
  <[9,10],[15],[19,20],[23],[],[16],[],[24]>,
  <[9,10],[15],[19,20],[23,24],[],[16],[],[]>,
  <[9,10],[15],[],[],[],[16],[25,26],[29,30]>,
  <[9,10],[15],[],[29],[],[16],[25,26],[30]>,
  <[9,10],[15],[],[29,30],[],[16],[25,26],[]>,
  <[9,10],[15],[],[],[],[16],[25,26],[31,32]>,
  <[9,10],[15],[],[31],[],[16],[25,26],[32]>,
  <[9,10],[15],[],[31,32],[],[16],[25,26],[]>,
  <[9,10],[15],[25],[],[],[16],[26],[29,30]>,
  <[9,10],[15],[25],[29],[],[16],[26],[30]>,
  <[9,10],[15],[25],[29,30],[],[16],[26],[]>,
  <[9,10],[15],[25],[],[],[16],[26],[31,32]>,
  <[9,10],[15],[25],[31],[],[16],[26],[32]>,
  <[9,10],[15],[25],[31,32],[],[16],[26],[]>,
  <[9,10],[15],[25,26],[],[],[16],[],[29,30]>,
  <[9,10],[15],[25,26],[29],[],[16],[],[30]>,
  <[9,10],[15],[25,26],[29,30],[],[16],[],[]>,
  <[9,10],[15],[25,26],[],[],[16],[],[31,32]>,
  <[9,10],[15],[25,26],[31],[],[16],[],[32]>,
  <[9,10],[15],[25,26],[31,32],[],[16],[],[]>,
  <[9,10],[15],[],[],[],[16],[27,28],[29,30]>,
  <[9,10],[15],[],[29],[],[16],[27,28],[30]>,
  <[9,10],[15],[],[29,30],[],[16],[27,28],[]>,
  <[9,10],[15],[],[],[],[16],[27,28],[31,32]>,
  <[9,10],[15],[],[31],[],[16],[27,28],[32]>,
  <[9,10],[15],[],[31,32],[],[16],[27,28],[]>,
  <[9,10],[15],[27],[],[],[16],[28],[29,30]>,
  <[9,10],[15],[27],[29],[],[16],[28],[30]>,
  <[9,10],[15],[27],[29,30],[],[16],[28],[]>,
  <[9,10],[15],[27],[],[],[16],[28],[31,32]>,
  <[9,10],[15],[27],[31],[],[16],[28],[32]>,
  <[9,10],[15],[27],[31,32],[],[16],[28],[]>,
  <[9,10],[15],[27,28],[],[],[16],[],[29,30]>,
  <[9,10],[15],[27,28],[29],[],[16],[],[30]>,
  <[9,10],[15],[27,28],[29,30],[],[16],[],[]>,
  <[9,10],[15],[27,28],[],[],[16],[],[31,32]>,
  <[9,10],[15],[27,28],[31],[],[16],[],[32]>,
  <[9,10],[15],[27,28],[31,32],[],[16],[],[]>,
  <[9,10],[15,16],[],[],[],[],[17,18],[21,22]>,
  <[9,10],[15,16],[],[21],[],[],[17,18],[22]>,
  <[9,10],[15,16],[],[21,22],[],[],[17,18],[]>,
  <[9,10],[15,16],[],[],[],[],[17,18],[23,24]>,
  <[9,10],[15,16],[],[23],[],[],[17,18],[24]>,
  <[9,10],[15,16],[],[23,24],[],[],[17,18],[]>,
  <[9,10],[15,16],[17],[],[],[],[18],[21,22]>,
  <[9,10],[15,16],[17],[21],[],[],[18],[22]>,
  <[9,10],[15,16],[17],[21,22],[],[],[18],[]>,
  <[9,10],[15,16],[17],[],[],[],[18],[23,24]>,
  <[9,10],[15,16],[17],[23],[],[],[18],[24]>,
  <[9,10],[15,16],[17],[23,24],[],[],[18],[]>,
  <[9,10],[15,16],[17,18],[],[],[],[],[21,22]>,
  <[9,10],[15,16],[17,18],[21],[],[],[],[22]>,
  <[9,10],[15,16],[17,18],[21,22],[],[],[],[]>,
  <[9,10],[15,16],[17,18],[],[],[],[],[23,24]>,
  <[9,10],[15,16],[17,18],[23],[],[],[],[24]>,
  <[9,10],[15,16],[17,18],[23,24],[],[],[],[]>,
  <[9,10],[15,16],[],[],[],[],[19,20],[21,22]>,
  <[9,10],[15,16],[],[21],[],[],[19,20],[22]>,
  <[9,10],[15,16],[],[21,22],[],[],[19,20],[]>,
  <[9,10],[15,16],[],[],[],[],[19,20],[23,24]>,
  <[9,10],[15,16],[],[23],[],[],[19,20],[24]>,
  <[9,10],[15,16],[],[23,24],[],[],[19,20],[]>,
  <[9,10],[15,16],[19],[],[],[],[20],[21,22]>,
  <[9,10],[15,16],[19],[21],[],[],[20],[22]>,
  <[9,10],[15,16],[19],[21,22],[],[],[20],[]>,
  <[9,10],[15,16],[19],[],[],[],[20],[23,24]>,
  <[9,10],[15,16],[19],[23],[],[],[20],[24]>,
  <[9,10],[15,16],[19],[23,24],[],[],[20],[]>,
  <[9,10],[15,16],[19,20],[],[],[],[],[21,22]>,
  <[9,10],[15,16],[19,20],[21],[],[],[],[22]>,
  <[9,10],[15,16],[19,20],[21,22],[],[],[],[]>,
  <[9,10],[15,16],[19,20],[],[],[],[],[23,24]>,
  <[9,10],[15,16],[19,20],[23],[],[],[],[24]>,
  <[9,10],[15,16],[19,20],[23,24],[],[],[],[]>,
  <[9,10],[15,16],[],[],[],[],[25,26],[29,30]>,
  <[9,10],[15,16],[],[29],[],[],[25,26],[30]>,
  <[9,10],[15,16],[],[29,30],[],[],[25,26],[]>,
  <[9,10],[15,16],[],[],[],[],[25,26],[31,32]>,
  <[9,10],[15,16],[],[31],[],[],[25,26],[32]>,
  <[9,10],[15,16],[],[31,32],[],[],[25,26],[]>,
  <[9,10],[15,16],[25],[],[],[],[26],[29,30]>,
  <[9,10],[15,16],[25],[29],[],[],[26],[30]>,
  <[9,10],[15,16],[25],[29,30],[],[],[26],[]>,
  <[9,10],[15,16],[25],[],[],[],[26],[31,32]>,
  <[9,10],[15,16],[25],[31],[],[],[26],[32]>,
  <[9,10],[15,16],[25],[31,32],[],[],[26],[]>,
  <[9,10],[15,16],[25,26],[],[],[],[],[29,30]>,
  <[9,10],[15,16],[25,26],[29],[],[],[],[30]>,
  <[9,10],[15,16],[25,26],[29,30],[],[],[],[]>,
  <[9,10],[15,16],[25,26],[],[],[],[],[31,32]>,
  <[9,10],[15,16],[25,26],[31],[],[],[],[32]>,
  <[9,10],[15,16],[25,26],[31,32],[],[],[],[]>,
  <[9,10],[15,16],[],[],[],[],[27,28],[29,30]>,
  <[9,10],[15,16],[],[29],[],[],[27,28],[30]>,
  <[9,10],[15,16],[],[29,30],[],[],[27,28],[]>,
  <[9,10],[15,16],[],[],[],[],[27,28],[31,32]>,
  <[9,10],[15,16],[],[31],[],[],[27,28],[32]>,
  <[9,10],[15,16],[],[31,32],[],[],[27,28],[]>,
  <[9,10],[15,16],[27],[],[],[],[28],[29,30]>,
  <[9,10],[15,16],[27],[29],[],[],[28],[30]>,
  <[9,10],[15,16],[27],[29,30],[],[],[28],[]>,
  <[9,10],[15,16],[27],[],[],[],[28],[31,32]>,
  <[9,10],[15,16],[27],[31],[],[],[28],[32]>,
  <[9,10],[15,16],[27],[31,32],[],[],[28],[]>,
  <[9,10],[15,16],[27,28],[],[],[],[],[29,30]>,
  <[9,10],[15,16],[27,28],[29],[],[],[],[30]>,
  <[9,10],[15,16],[27,28],[29,30],[],[],[],[]>,
  <[9,10],[15,16],[27,28],[],[],[],[],[31,32]>,
  <[9,10],[15,16],[27,28],[31],[],[],[],[32]>,
  <[9,10],[15,16],[27,28],[31,32],[],[],[],[]>,
  <[],[],[],[],[11,12],[13,14],[17,18],[21,22]>,
  <[],[],[],[21],[11,12],[13,14],[17,18],[22]>,
  <[],[],[],[21,22],[11,12],[13,14],[17,18],[]>,
  <[],[],[],[],[11,12],[13,14],[17,18],[23,24]>,
  <[],[],[],[23],[11,12],[13,14],[17,18],[24]>,
  <[],[],[],[23,24],[11,12],[13,14],[17,18],[]>,
  <[],[],[17],[],[11,12],[13,14],[18],[21,22]>,
  <[],[],[17],[21],[11,12],[13,14],[18],[22]>,
  <[],[],[17],[21,22],[11,12],[13,14],[18],[]>,
  <[],[],[17],[],[11,12],[13,14],[18],[23,24]>,
  <[],[],[17],[23],[11,12],[13,14],[18],[24]>,
  <[],[],[17],[23,24],[11,12],[13,14],[18],[]>,
  <[],[],[17,18],[],[11,12],[13,14],[],[21,22]>,
  <[],[],[17,18],[21],[11,12],[13,14],[],[22]>,
  <[],[],[17,18],[21,22],[11,12],[13,14],[],[]>,
  <[],[],[17,18],[],[11,12],[13,14],[],[23,24]>,
  <[],[],[17,18],[23],[11,12],[13,14],[],[24]>,
  <[],[],[17,18],[23,24],[11,12],[13,14],[],[]>,
  <[],[],[],[],[11,12],[13,14],[19,20],[21,22]>,
  <[],[],[],[21],[11,12],[13,14],[19,20],[22]>,
  <[],[],[],[21,22],[11,12],[13,14],[19,20],[]>,
  <[],[],[],[],[11,12],[13,14],[19,20],[23,24]>,
  <[],[],[],[23],[11,12],[13,14],[19,20],[24]>,
  <[],[],[],[23,24],[11,12],[13,14],[19,20],[]>,
  <[],[],[19],[],[11,12],[13,14],[20],[21,22]>,
  <[],[],[19],[21],[11,12],[13,14],[20],[22]>,
  <[],[],[19],[21,22],[11,12],[13,14],[20],[]>,
  <[],[],[19],[],[11,12],[13,14],[20],[23,24]>,
  <[],[],[19],[23],[11,12],[13,14],[20],[24]>,
  <[],[],[19],[23,24],[11,12],[13,14],[20],[]>,
  <[],[],[19,20],[],[11,12],[13,14],[],[21,22]>,
  <[],[],[19,20],[21],[11,12],[13,14],[],[22]>,
  <[],[],[19,20],[21,22],[11,12],[13,14],[],[]>,
  <[],[],[19,20],[],[11,12],[13,14],[],[23,24]>,
  <[],[],[19,20],[23],[11,12],[13,14],[],[24]>,
  <[],[],[19,20],[23,24],[11,12],[13,14],[],[]>,
  <[],[],[],[],[11,12],[13,14],[25,26],[29,30]>,
  <[],[],[],[29],[11,12],[13,14],[25,26],[30]>,
  <[],[],[],[29,30],[11,12],[13,14],[25,26],[]>,
  <[],[],[],[],[11,12],[13,14],[25,26],[31,32]>,
  <[],[],[],[31],[11,12],[13,14],[25,26],[32]>,
  <[],[],[],[31,32],[11,12],[13,14],[25,26],[]>,
  <[],[],[25],[],[11,12],[13,14],[26],[29,30]>,
  <[],[],[25],[29],[11,12],[13,14],[26],[30]>,
  <[],[],[25],[29,30],[11,12],[13,14],[26],[]>,
  <[],[],[25],[],[11,12],[13,14],[26],[31,32]>,
  <[],[],[25],[31],[11,12],[13,14],[26],[32]>,
  <[],[],[25],[31,32],[11,12],[13,14],[26],[]>,
  <[],[],[25,26],[],[11,12],[13,14],[],[29,30]>,
  <[],[],[25,26],[29],[11,12],[13,14],[],[30]>,
  <[],[],[25,26],[29,30],[11,12],[13,14],[],[]>,
  <[],[],[25,26],[],[11,12],[13,14],[],[31,32]>,
  <[],[],[25,26],[31],[11,12],[13,14],[],[32]>,
  <[],[],[25,26],[31,32],[11,12],[13,14],[],[]>,
  <[],[],[],[],[11,12],[13,14],[27,28],[29,30]>,
  <[],[],[],[29],[11,12],[13,14],[27,28],[30]>,
  <[],[],[],[29,30],[11,12],[13,14],[27,28],[]>,
  <[],[],[],[],[11,12],[13,14],[27,28],[31,32]>,
  <[],[],[],[31],[11,12],[13,14],[27,28],[32]>,
  <[],[],[],[31,32],[11,12],[13,14],[27,28],[]>,
  <[],[],[27],[],[11,12],[13,14],[28],[29,30]>,
  <[],[],[27],[29],[11,12],[13,14],[28],[30]>,
  <[],[],[27],[29,30],[11,12],[13,14],[28],[]>,
  <[],[],[27],[],[11,12],[13,14],[28],[31,32]>,
  <[],[],[27],[31],[11,12],[13,14],[28],[32]>,
  <[],[],[27],[31,32],[11,12],[13,14],[28],[]>,
  <[],[],[27,28],[],[11,12],[13,14],[],[29,30]>,
  <[],[],[27,28],[29],[11,12],[13,14],[],[30]>,
  <[],[],[27,28],[29,30],[11,12],[13,14],[],[]>,
  <[],[],[27,28],[],[11,12],[13,14],[],[31,32]>,
  <[],[],[27,28],[31],[11,12],[13,14],[],[32]>,
  <[],[],[27,28],[31,32],[11,12],[13,14],[],[]>,
  <[],[13],[],[],[11,12],[14],[17,18],[21,22]>,
  <[],[13],[],[21],[11,12],[14],[17,18],[22]>,
  <[],[13],[],[21,22],[11,12],[14],[17,18],[]>,
  <[],[13],[],[],[11,12],[14],[17,18],[23,24]>,
  <[],[13],[],[23],[11,12],[14],[17,18],[24]>,
  <[],[13],[],[23,24],[11,12],[14],[17,18],[]>,
  <[],[13],[17],[],[11,12],[14],[18],[21,22]>,
  <[],[13],[17],[21],[11,12],[14],[18],[22]>,
  <[],[13],[17],[21,22],[11,12],[14],[18],[]>,
  <[],[13],[17],[],[11,12],[14],[18],[23,24]>,
  <[],[13],[17],[23],[11,12],[14],[18],[24]>,
  <[],[13],[17],[23,24],[11,12],[14],[18],[]>,
  <[],[13],[17,18],[],[11,12],[14],[],[21,22]>,
  <[],[13],[17,18],[21],[11,12],[14],[],[22]>,
  <[],[13],[17,18],[21,22],[11,12],[14],[],[]>,
  <[],[13],[17,18],[],[11,12],[14],[],[23,24]>,
  <[],[13],[17,18],[23],[11,12],[14],[],[24]>,
  <[],[13],[17,18],[23,24],[11,12],[14],[],[]>,
  <[],[13],[],[],[11,12],[14],[19,20],[21,22]>,
  <[],[13],[],[21],[11,12],[14],[19,20],[22]>,
  <[],[13],[],[21,22],[11,12],[14],[19,20],[]>,
  <[],[13],[],[],[11,12],[14],[19,20],[23,24]>,
  <[],[13],[],[23],[11,12],[14],[19,20],[24]>,
  <[],[13],[],[23,24],[11,12],[14],[19,20],[]>,
  <[],[13],[19],[],[11,12],[14],[20],[21,22]>,
  <[],[13],[19],[21],[11,12],[14],[20],[22]>,
  <[],[13],[19],[21,22],[11,12],[14],[20],[]>,
  <[],[13],[19],[],[11,12],[14],[20],[23,24]>,
  <[],[13],[19],[23],[11,12],[14],[20],[24]>,
  <[],[13],[19],[23,24],[11,12],[14],[20],[]>,
  <[],[13],[19,20],[],[11,12],[14],[],[21,22]>,
  <[],[13],[19,20],[21],[11,12],[14],[],[22]>,
  <[],[13],[19,20],[21,22],[11,12],[14],[],[]>,
  <[],[13],[19,20],[],[11,12],[14],[],[23,24]>,
  <[],[13],[19,20],[23],[11,12],[14],[],[24]>,
  <[],[13],[19,20],[23,24],[11,12],[14],[],[]>,
  <[],[13],[],[],[11,12],[14],[25,26],[29,30]>,
  <[],[13],[],[29],[11,12],[14],[25,26],[30]>,
  <[],[13],[],[29,30],[11,12],[14],[25,26],[]>,
  <[],[13],[],[],[11,12],[14],[25,26],[31,32]>,
  <[],[13],[],[31],[11,12],[14],[25,26],[32]>,
  <[],[13],[],[31,32],[11,12],[14],[25,26],[]>,
  <[],[13],[25],[],[11,12],[14],[26],[29,30]>,
  <[],[13],[25],[29],[11,12],[14],[26],[30]>,
  <[],[13],[25],[29,30],[11,12],[14],[26],[]>,
  <[],[13],[25],[],[11,12],[14],[26],[31,32]>,
  <[],[13],[25],[31],[11,12],[14],[26],[32]>,
  <[],[13],[25],[31,32],[11,12],[14],[26],[]>,
  <[],[13],[25,26],[],[11,12],[14],[],[29,30]>,
  <[],[13],[25,26],[29],[11,12],[14],[],[30]>,
  <[],[13],[25,26],[29,30],[11,12],[14],[],[]>,
  <[],[13],[25,26],[],[11,12],[14],[],[31,32]>,
  <[],[13],[25,26],[31],[11,12],[14],[],[32]>,
  <[],[13],[25,26],[31,32],[11,12],[14],[],[]>,
  <[],[13],[],[],[11,12],[14],[27,28],[29,30]>,
  <[],[13],[],[29],[11,12],[14],[27,28],[30]>,
  <[],[13],[],[29,30],[11,12],[14],[27,28],[]>,
  <[],[13],[],[],[11,12],[14],[27,28],[31,32]>,
  <[],[13],[],[31],[11,12],[14],[27,28],[32]>,
  <[],[13],[],[31,32],[11,12],[14],[27,28],[]>,
  <[],[13],[27],[],[11,12],[14],[28],[29,30]>,
  <[],[13],[27],[29],[11,12],[14],[28],[30]>,
  <[],[13],[27],[29,30],[11,12],[14],[28],[]>,
  <[],[13],[27],[],[11,12],[14],[28],[31,32]>,
  <[],[13],[27],[31],[11,12],[14],[28],[32]>,
  <[],[13],[27],[31,32],[11,12],[14],[28],[]>,
  <[],[13],[27,28],[],[11,12],[14],[],[29,30]>,
  <[],[13],[27,28],[29],[11,12],[14],[],[30]>,
  <[],[13],[27,28],[29,30],[11,12],[14],[],[]>,
  <[],[13],[27,28],[],[11,12],[14],[],[31,32]>,
  <[],[13],[27,28],[31],[11,12],[14],[],[32]>,
  <[],[13],[27,28],[31,32],[11,12],[14],[],[]>,
  <[],[13,14],[],[],[11,12],[],[17,18],[21,22]>,
  <[],[13,14],[],[21],[11,12],[],[17,18],[22]>,
  <[],[13,14],[],[21,22],[11,12],[],[17,18],[]>,
  <[],[13,14],[],[],[11,12],[],[17,18],[23,24]>,
  <[],[13,14],[],[23],[11,12],[],[17,18],[24]>,
  <[],[13,14],[],[23,24],[11,12],[],[17,18],[]>,
  <[],[13,14],[17],[],[11,12],[],[18],[21,22]>,
  <[],[13,14],[17],[21],[11,12],[],[18],[22]>,
  <[],[13,14],[17],[21,22],[11,12],[],[18],[]>,
  <[],[13,14],[17],[],[11,12],[],[18],[23,24]>,
  <[],[13,14],[17],[23],[11,12],[],[18],[24]>,
  <[],[13,14],[17],[23,24],[11,12],[],[18],[]>,
  <[],[13,14],[17,18],[],[11,12],[],[],[21,22]>,
  <[],[13,14],[17,18],[21],[11,12],[],[],[22]>,
  <[],[13,14],[17,18],[21,22],[11,12],[],[],[]>,
  <[],[13,14],[17,18],[],[11,12],[],[],[23,24]>,
  <[],[13,14],[17,18],[23],[11,12],[],[],[24]>,
  <[],[13,14],[17,18],[23,24],[11,12],[],[],[]>,
  <[],[13,14],[],[],[11,12],[],[19,20],[21,22]>,
  <[],[13,14],[],[21],[11,12],[],[19,20],[22]>,
  <[],[13,14],[],[21,22],[11,12],[],[19,20],[]>,
  <[],[13,14],[],[],[11,12],[],[19,20],[23,24]>,
  <[],[13,14],[],[23],[11,12],[],[19,20],[24]>,
  <[],[13,14],[],[23,24],[11,12],[],[19,20],[]>,
  <[],[13,14],[19],[],[11,12],[],[20],[21,22]>,
  <[],[13,14],[19],[21],[11,12],[],[20],[22]>,
  <[],[13,14],[19],[21,22],[11,12],[],[20],[]>,
  <[],[13,14],[19],[],[11,12],[],[20],[23,24]>,
  <[],[13,14],[19],[23],[11,12],[],[20],[24]>,
  <[],[13,14],[19],[23,24],[11,12],[],[20],[]>,
  <[],[13,14],[19,20],[],[11,12],[],[],[21,22]>,
  <[],[13,14],[19,20],[21],[11,12],[],[],[22]>,
  <[],[13,14],[19,20],[21,22],[11,12],[],[],[]>,
  <[],[13,14],[19,20],[],[11,12],[],[],[23,24]>,
  <[],[13,14],[19,20],[23],[11,12],[],[],[24]>,
  <[],[13,14],[19,20],[23,24],[11,12],[],[],[]>,
  <[],[13,14],[],[],[11,12],[],[25,26],[29,30]>,
  <[],[13,14],[],[29],[11,12],[],[25,26],[30]>,
  <[],[13,14],[],[29,30],[11,12],[],[25,26],[]>,
  <[],[13,14],[],[],[11,12],[],[25,26],[31,32]>,
  <[],[13,14],[],[31],[11,12],[],[25,26],[32]>,
  <[],[13,14],[],[31,32],[11,12],[],[25,26],[]>,
  <[],[13,14],[25],[],[11,12],[],[26],[29,30]>,
  <[],[13,14],[25],[29],[11,12],[],[26],[30]>,
  <[],[13,14],[25],[29,30],[11,12],[],[26],[]>,
  <[],[13,14],[25],[],[11,12],[],[26],[31,32]>,
  <[],[13,14],[25],[31],[11,12],[],[26],[32]>,
  <[],[13,14],[25],[31,32],[11,12],[],[26],[]>,
  <[],[13,14],[25,26],[],[11,12],[],[],[29,30]>,
  <[],[13,14],[25,26],[29],[11,12],[],[],[30]>,
  <[],[13,14],[25,26],[29,30],[11,12],[],[],[]>,
  <[],[13,14],[25,26],[],[11,12],[],[],[31,32]>,
  <[],[13,14],[25,26],[31],[11,12],[],[],[32]>,
  <[],[13,14],[25,26],[31,32],[11,12],[],[],[]>,
  <[],[13,14],[],[],[11,12],[],[27,28],[29,30]>,
  <[],[13,14],[],[29],[11,12],[],[27,28],[30]>,
  <[],[13,14],[],[29,30],[11,12],[],[27,28],[]>,
  <[],[13,14],[],[],[11,12],[],[27,28],[31,32]>,
  <[],[13,14],[],[31],[11,12],[],[27,28],[32]>,
  <[],[13,14],[],[31,32],[11,12],[],[27,28],[]>,
  <[],[13,14],[27],[],[11,12],[],[28],[29,30]>,
  <[],[13,14],[27],[29],[11,12],[],[28],[30]>,
  <[],[13,14],[27],[29,30],[11,12],[],[28],[]>,
  <[],[13,14],[27],[],[11,12],[],[28],[31,32]>,
  <[],[13,14],[27],[31],[11,12],[],[28],[32]>,
  <[],[13,14],[27],[31,32],[11,12],[],[28],[]>,
  <[],[13,14],[27,28],[],[11,12],[],[],[29,30]>,
  <[],[13,14],[27,28],[29],[11,12],[],[],[30]>,
  <[],[13,14],[27,28],[29,30],[11,12],[],[],[]>,
  <[],[13,14],[27,28],[],[11,12],[],[],[31,32]>,
  <[],[13,14],[27,28],[31],[11,12],[],[],[32]>,
  <[],[13,14],[27,28],[31,32],[11,12],[],[],[]>,
  <[],[],[],[],[11,12],[15,16],[17,18],[21,22]>,
  <[],[],[],[21],[11,12],[15,16],[17,18],[22]>,
  <[],[],[],[21,22],[11,12],[15,16],[17,18],[]>,
  <[],[],[],[],[11,12],[15,16],[17,18],[23,24]>,
  <[],[],[],[23],[11,12],[15,16],[17,18],[24]>,
  <[],[],[],[23,24],[11,12],[15,16],[17,18],[]>,
  <[],[],[17],[],[11,12],[15,16],[18],[21,22]>,
  <[],[],[17],[21],[11,12],[15,16],[18],[22]>,
  <[],[],[17],[21,22],[11,12],[15,16],[18],[]>,
  <[],[],[17],[],[11,12],[15,16],[18],[23,24]>,
  <[],[],[17],[23],[11,12],[15,16],[18],[24]>,
  <[],[],[17],[23,24],[11,12],[15,16],[18],[]>,
  <[],[],[17,18],[],[11,12],[15,16],[],[21,22]>,
  <[],[],[17,18],[21],[11,12],[15,16],[],[22]>,
  <[],[],[17,18],[21,22],[11,12],[15,16],[],[]>,
  <[],[],[17,18],[],[11,12],[15,16],[],[23,24]>,
  <[],[],[17,18],[23],[11,12],[15,16],[],[24]>,
  <[],[],[17,18],[23,24],[11,12],[15,16],[],[]>,
  <[],[],[],[],[11,12],[15,16],[19,20],[21,22]>,
  <[],[],[],[21],[11,12],[15,16],[19,20],[22]>,
  <[],[],[],[21,22],[11,12],[15,16],[19,20],[]>,
  <[],[],[],[],[11,12],[15,16],[19,20],[23,24]>,
  <[],[],[],[23],[11,12],[15,16],[19,20],[24]>,
  <[],[],[],[23,24],[11,12],[15,16],[19,20],[]>,
  <[],[],[19],[],[11,12],[15,16],[20],[21,22]>,
  <[],[],[19],[21],[11,12],[15,16],[20],[22]>,
  <[],[],[19],[21,22],[11,12],[15,16],[20],[]>,
  <[],[],[19],[],[11,12],[15,16],[20],[23,24]>,
  <[],[],[19],[23],[11,12],[15,16],[20],[24]>,
  <[],[],[19],[23,24],[11,12],[15,16],[20],[]>,
  <[],[],[19,20],[],[11,12],[15,16],[],[21,22]>,
  <[],[],[19,20],[21],[11,12],[15,16],[],[22]>,
  <[],[],[19,20],[21,22],[11,12],[15,16],[],[]>,
  <[],[],[19,20],[],[11,12],[15,16],[],[23,24]>,
  <[],[],[19,20],[23],[11,12],[15,16],[],[24]>,
  <[],[],[19,20],[23,24],[11,12],[15,16],[],[]>,
  <[],[],[],[],[11,12],[15,16],[25,26],[29,30]>,
  <[],[],[],[29],[11,12],[15,16],[25,26],[30]>,
  <[],[],[],[29,30],[11,12],[15,16],[25,26],[]>,
  <[],[],[],[],[11,12],[15,16],[25,26],[31,32]>,
  <[],[],[],[31],[11,12],[15,16],[25,26],[32]>,
  <[],[],[],[31,32],[11,12],[15,16],[25,26],[]>,
  <[],[],[25],[],[11,12],[15,16],[26],[29,30]>,
  <[],[],[25],[29],[11,12],[15,16],[26],[30]>,
  <[],[],[25],[29,30],[11,12],[15,16],[26],[]>,
  <[],[],[25],[],[11,12],[15,16],[26],[31,32]>,
  <[],[],[25],[31],[11,12],[15,16],[26],[32]>,
  <[],[],[25],[31,32],[11,12],[15,16],[26],[]>,
  <[],[],[25,26],[],[11,12],[15,16],[],[29,30]>,
  <[],[],[25,26],[29],[11,12],[15,16],[],[30]>,
  <[],[],[25,26],[29,30],[11,12],[15,16],[],[]>,
  <[],[],[25,26],[],[11,12],[15,16],[],[31,32]>,
  <[],[],[25,26],[31],[11,12],[15,16],[],[32]>,
  <[],[],[25,26],[31,32],[11,12],[15,16],[],[]>,
  <[],[],[],[],[11,12],[15,16],[27,28],[29,30]>,
  <[],[],[],[29],[11,12],[15,16],[27,28],[30]>,
  <[],[],[],[29,30],[11,12],[15,16],[27,28],[]>,
  <[],[],[],[],[11,12],[15,16],[27,28],[31,32]>,
  <[],[],[],[31],[11,12],[15,16],[27,28],[32]>,
  <[],[],[],[31,32],[11,12],[15,16],[27,28],[]>,
  <[],[],[27],[],[11,12],[15,16],[28],[29,30]>,
  <[],[],[27],[29],[11,12],[15,16],[28],[30]>,
  <[],[],[27],[29,30],[11,12],[15,16],[28],[]>,
  <[],[],[27],[],[11,12],[15,16],[28],[31,32]>,
  <[],[],[27],[31],[11,12],[15,16],[28],[32]>,
  <[],[],[27],[31,32],[11,12],[15,16],[28],[]>,
  <[],[],[27,28],[],[11,12],[15,16],[],[29,30]>,
  <[],[],[27,28],[29],[11,12],[15,16],[],[30]>,
  <[],[],[27,28],[29,30],[11,12],[15,16],[],[]>,
  <[],[],[27,28],[],[11,12],[15,16],[],[31,32]>,
  <[],[],[27,28],[31],[11,12],[15,16],[],[32]>,
  <[],[],[27,28],[31,32],[11,12],[15,16],[],[]>,
  <[],[15],[],[],[11,12],[16],[17,18],[21,22]>,
  <[],[15],[],[21],[11,12],[16],[17,18],[22]>,
  <[],[15],[],[21,22],[11,12],[16],[17,18],[]>,
  <[],[15],[],[],[11,12],[16],[17,18],[23,24]>,
  <[],[15],[],[23],[11,12],[16],[17,18],[24]>,
  <[],[15],[],[23,24],[11,12],[16],[17,18],[]>,
  <[],[15],[17],[],[11,12],[16],[18],[21,22]>,
  <[],[15],[17],[21],[11,12],[16],[18],[22]>,
  <[],[15],[17],[21,22],[11,12],[16],[18],[]>,
  <[],[15],[17],[],[11,12],[16],[18],[23,24]>,
  <[],[15],[17],[23],[11,12],[16],[18],[24]>,
  <[],[15],[17],[23,24],[11,12],[16],[18],[]>,
  <[],[15],[17,18],[],[11,12],[16],[],[21,22]>,
  <[],[15],[17,18],[21],[11,12],[16],[],[22]>,
  <[],[15],[17,18],[21,22],[11,12],[16],[],[]>,
  <[],[15],[17,18],[],[11,12],[16],[],[23,24]>,
  <[],[15],[17,18],[23],[11,12],[16],[],[24]>,
  <[],[15],[17,18],[23,24],[11,12],[16],[],[]>,
  <[],[15],[],[],[11,12],[16],[19,20],[21,22]>,
  <[],[15],[],[21],[11,12],[16],[19,20],[22]>,
  <[],[15],[],[21,22],[11,12],[16],[19,20],[]>,
  <[],[15],[],[],[11,12],[16],[19,20],[23,24]>,
  <[],[15],[],[23],[11,12],[16],[19,20],[24]>,
  <[],[15],[],[23,24],[11,12],[16],[19,20],[]>,
  <[],[15],[19],[],[11,12],[16],[20],[21,22]>,
  <[],[15],[19],[21],[11,12],[16],[20],[22]>,
  <[],[15],[19],[21,22],[11,12],[16],[20],[]>,
  <[],[15],[19],[],[11,12],[16],[20],[23,24]>,
  <[],[15],[19],[23],[11,12],[16],[20],[24]>,
  <[],[15],[19],[23,24],[11,12],[16],[20],[]>,
  <[],[15],[19,20],[],[11,12],[16],[],[21,22]>,
  <[],[15],[19,20],[21],[11,12],[16],[],[22]>,
  <[],[15],[19,20],[21,22],[11,12],[16],[],[]>,
  <[],[15],[19,20],[],[11,12],[16],[],[23,24]>,
  <[],[15],[19,20],[23],[11,12],[16],[],[24]>,
  <[],[15],[19,20],[23,24],[11,12],[16],[],[]>,
  <[],[15],[],[],[11,12],[16],[25,26],[29,30]>,
  <[],[15],[],[29],[11,12],[16],[25,26],[30]>,
  <[],[15],[],[29,30],[11,12],[16],[25,26],[]>,
  <[],[15],[],[],[11,12],[16],[25,26],[31,32]>,
  <[],[15],[],[31],[11,12],[16],[25,26],[32]>,
  <[],[15],[],[31,32],[11,12],[16],[25,26],[]>,
  <[],[15],[25],[],[11,12],[16],[26],[29,30]>,
  <[],[15],[25],[29],[11,12],[16],[26],[30]>,
  <[],[15],[25],[29,30],[11,12],[16],[26],[]>,
  <[],[15],[25],[],[11,12],[16],[26],[31,32]>,
  <[],[15],[25],[31],[11,12],[16],[26],[32]>,
  <[],[15],[25],[31,32],[11,12],[16],[26],[]>,
  <[],[15],[25,26],[],[11,12],[16],[],[29,30]>,
  <[],[15],[25,26],[29],[11,12],[16],[],[30]>,
  <[],[15],[25,26],[29,30],[11,12],[16],[],[]>,
  <[],[15],[25,26],[],[11,12],[16],[],[31,32]>,
  <[],[15],[25,26],[31],[11,12],[16],[],[32]>,
  <[],[15],[25,26],[31,32],[11,12],[16],[],[]>,
  <[],[15],[],[],[11,12],[16],[27,28],[29,30]>,
  <[],[15],[],[29],[11,12],[16],[27,28],[30]>,
  <[],[15],[],[29,30],[11,12],[16],[27,28],[]>,
  <[],[15],[],[],[11,12],[16],[27,28],[31,32]>,
  <[],[15],[],[31],[11,12],[16],[27,28],[32]>,
  <[],[15],[],[31,32],[11,12],[16],[27,28],[]>,
  <[],[15],[27],[],[11,12],[16],[28],[29,30]>,
  <[],[15],[27],[29],[11,12],[16],[28],[30]>,
  <[],[15],[27],[29,30],[11,12],[16],[28],[]>,
  <[],[15],[27],[],[11,12],[16],[28],[31,32]>,
  <[],[15],[27],[31],[11,12],[16],[28],[32]>,
  <[],[15],[27],[31,32],[11,12],[16],[28],[]>,
  <[],[15],[27,28],[],[11,12],[16],[],[29,30]>,
  <[],[15],[27,28],[29],[11,12],[16],[],[30]>,
  <[],[15],[27,28],[29,30],[11,12],[16],[],[]>,
  <[],[15],[27,28],[],[11,12],[16],[],[31,32]>,
  <[],[15],[27,28],[31],[11,12],[16],[],[32]>,
  <[],[15],[27,28],[31,32],[11,12],[16],[],[]>,
  <[],[15,16],[],[],[11,12],[],[17,18],[21,22]>,
  <[],[15,16],[],[21],[11,12],[],[17,18],[22]>,
  <[],[15,16],[],[21,22],[11,12],[],[17,18],[]>,
  <[],[15,16],[],[],[11,12],[],[17,18],[23,24]>,
  <[],[15,16],[],[23],[11,12],[],[17,18],[24]>,
  <[],[15,16],[],[23,24],[11,12],[],[17,18],[]>,
  <[],[15,16],[17],[],[11,12],[],[18],[21,22]>,
  <[],[15,16],[17],[21],[11,12],[],[18],[22]>,
  <[],[15,16],[17],[21,22],[11,12],[],[18],[]>,
  <[],[15,16],[17],[],[11,12],[],[18],[23,24]>,
  <[],[15,16],[17],[23],[11,12],[],[18],[24]>,
  <[],[15,16],[17],[23,24],[11,12],[],[18],[]>,
  <[],[15,16],[17,18],[],[11,12],[],[],[21,22]>,
  <[],[15,16],[17,18],[21],[11,12],[],[],[22]>,
  <[],[15,16],[17,18],[21,22],[11,12],[],[],[]>,
  <[],[15,16],[17,18],[],[11,12],[],[],[23,24]>,
  <[],[15,16],[17,18],[23],[11,12],[],[],[24]>,
  <[],[15,16],[17,18],[23,24],[11,12],[],[],[]>,
  <[],[15,16],[],[],[11,12],[],[19,20],[21,22]>,
  <[],[15,16],[],[21],[11,12],[],[19,20],[22]>,
  <[],[15,16],[],[21,22],[11,12],[],[19,20],[]>,
  <[],[15,16],[],[],[11,12],[],[19,20],[23,24]>,
  <[],[15,16],[],[23],[11,12],[],[19,20],[24]>,
  <[],[15,16],[],[23,24],[11,12],[],[19,20],[]>,
  <[],[15,16],[19],[],[11,12],[],[20],[21,22]>,
  <[],[15,16],[19],[21],[11,12],[],[20],[22]>,
  <[],[15,16],[19],[21,22],[11,12],[],[20],[]>,
  <[],[15,16],[19],[],[11,12],[],[20],[23,24]>,
  <[],[15,16],[19],[23],[11,12],[],[20],[24]>,
  <[],[15,16],[19],[23,24],[11,12],[],[20],[]>,
  <[],[15,16],[19,20],[],[11,12],[],[],[21,22]>,
  <[],[15,16],[19,20],[21],[11,12],[],[],[22]>,
  <[],[15,16],[19,20],[21,22],[11,12],[],[],[]>,
  <[],[15,16],[19,20],[],[11,12],[],[],[23,24]>,
  <[],[15,16],[19,20],[23],[11,12],[],[],[24]>,
  <[],[15,16],[19,20],[23,24],[11,12],[],[],[]>,
  <[],[15,16],[],[],[11,12],[],[25,26],[29,30]>,
  <[],[15,16],[],[29],[11,12],[],[25,26],[30]>,
  <[],[15,16],[],[29,30],[11,12],[],[25,26],[]>,
  <[],[15,16],[],[],[11,12],[],[25,26],[31,32]>,
  <[],[15,16],[],[31],[11,12],[],[25,26],[32]>,
  <[],[15,16],[],[31,32],[11,12],[],[25,26],[]>,
  <[],[15,16],[25],[],[11,12],[],[26],[29,30]>,
  <[],[15,16],[25],[29],[11,12],[],[26],[30]>,
  <[],[15,16],[25],[29,30],[11,12],[],[26],[]>,
  <[],[15,16],[25],[],[11,12],[],[26],[31,32]>,
  <[],[15,16],[25],[31],[11,12],[],[26],[32]>,
  <[],[15,16],[25],[31,32],[11,12],[],[26],[]>,
  <[],[15,16],[25,26],[],[11,12],[],[],[29,30]>,
  <[],[15,16],[25,26],[29],[11,12],[],[],[30]>,
  <[],[15,16],[25,26],[29,30],[11,12],[],[],[]>,
  <[],[15,16],[25,26],[],[11,12],[],[],[31,32]>,
  <[],[15,16],[25,26],[31],[11,12],[],[],[32]>,
  <[],[15,16],[25,26],[31,32],[11,12],[],[],[]>,
  <[],[15,16],[],[],[11,12],[],[27,28],[29,30]>,
  <[],[15,16],[],[29],[11,12],[],[27,28],[30]>,
  <[],[15,16],[],[29,30],[11,12],[],[27,28],[]>,
  <[],[15,16],[],[],[11,12],[],[27,28],[31,32]>,
  <[],[15,16],[],[31],[11,12],[],[27,28],[32]>,
  <[],[15,16],[],[31,32],[11,12],[],[27,28],[]>,
  <[],[15,16],[27],[],[11,12],[],[28],[29,30]>,
  <[],[15,16],[27],[29],[11,12],[],[28],[30]>,
  <[],[15,16],[27],[29,30],[11,12],[],[28],[]>,
  <[],[15,16],[27],[],[11,12],[],[28],[31,32]>,
  <[],[15,16],[27],[31],[11,12],[],[28],[32]>,
  <[],[15,16],[27],[31,32],[11,12],[],[28],[]>,
  <[],[15,16],[27,28],[],[11,12],[],[],[29,30]>,
  <[],[15,16],[27,28],[29],[11,12],[],[],[30]>,
  <[],[15,16],[27,28],[29,30],[11,12],[],[],[]>,
  <[],[15,16],[27,28],[],[11,12],[],[],[31,32]>,
  <[],[15,16],[27,28],[31],[11,12],[],[],[32]>,
  <[],[15,16],[27,28],[31,32],[11,12],[],[],[]>,
  <[11],[],[],[],[12],[13,14],[17,18],[21,22]>,
  <[11],[],[],[21],[12],[13,14],[17,18],[22]>,
  <[11],[],[],[21,22],[12],[13,14],[17,18],[]>,
  <[11],[],[],[],[12],[13,14],[17,18],[23,24]>,
  <[11],[],[],[23],[12],[13,14],[17,18],[24]>,
  <[11],[],[],[23,24],[12],[13,14],[17,18],[]>,
  <[11],[],[17],[],[12],[13,14],[18],[21,22]>,
  <[11],[],[17],[21],[12],[13,14],[18],[22]>,
  <[11],[],[17],[21,22],[12],[13,14],[18],[]>,
  <[11],[],[17],[],[12],[13,14],[18],[23,24]>,
  <[11],[],[17],[23],[12],[13,14],[18],[24]>,
  <[11],[],[17],[23,24],[12],[13,14],[18],[]>,
  <[11],[],[17,18],[],[12],[13,14],[],[21,22]>,
  <[11],[],[17,18],[21],[12],[13,14],[],[22]>,
  <[11],[],[17,18],[21,22],[12],[13,14],[],[]>,
  <[11],[],[17,18],[],[12],[13,14],[],[23,24]>,
  <[11],[],[17,18],[23],[12],[13,14],[],[24]>,
  <[11],[],[17,18],[23,24],[12],[13,14],[],[]>,
  <[11],[],[],[],[12],[13,14],[19,20],[21,22]>,
  <[11],[],[],[21],[12],[13,14],[19,20],[22]>,
  <[11],[],[],[21,22],[12],[13,14],[19,20],[]>,
  <[11],[],[],[],[12],[13,14],[19,20],[23,24]>,
  <[11],[],[],[23],[12],[13,14],[19,20],[24]>,
  <[11],[],[],[23,24],[12],[13,14],[19,20],[]>,
  <[11],[],[19],[],[12],[13,14],[20],[21,22]>,
  <[11],[],[19],[21],[12],[13,14],[20],[22]>,
  <[11],[],[19],[21,22],[12],[13,14],[20],[]>,
  <[11],[],[19],[],[12],[13,14],[20],[23,24]>,
  <[11],[],[19],[23],[12],[13,14],[20],[24]>,
  <[11],[],[19],[23,24],[12],[13,14],[20],[]>,
  <[11],[],[19,20],[],[12],[13,14],[],[21,22]>,
  <[11],[],[19,20],[21],[12],[13,14],[],[22]>,
  <[11],[],[19,20],[21,22],[12],[13,14],[],[]>,
  <[11],[],[19,20],[],[12],[13,14],[],[23,24]>,
  <[11],[],[19,20],[23],[12],[13,14],[],[24]>,
  <[11],[],[19,20],[23,24],[12],[13,14],[],[]>,
  <[11],[],[],[],[12],[13,14],[25,26],[29,30]>,
  <[11],[],[],[29],[12],[13,14],[25,26],[30]>,
  <[11],[],[],[29,30],[12],[13,14],[25,26],[]>,
  <[11],[],[],[],[12],[13,14],[25,26],[31,32]>,
  <[11],[],[],[31],[12],[13,14],[25,26],[32]>,
  <[11],[],[],[31,32],[12],[13,14],[25,26],[]>,
  <[11],[],[25],[],[12],[13,14],[26],[29,30]>,
  <[11],[],[25],[29],[12],[13,14],[26],[30]>,
  <[11],[],[25],[29,30],[12],[13,14],[26],[]>,
  <[11],[],[25],[],[12],[13,14],[26],[31,32]>,
  <[11],[],[25],[31],[12],[13,14],[26],[32]>,
  <[11],[],[25],[31,32],[12],[13,14],[26],[]>,
  <[11],[],[25,26],[],[12],[13,14],[],[29,30]>,
  <[11],[],[25,26],[29],[12],[13,14],[],[30]>,
  <[11],[],[25,26],[29,30],[12],[13,14],[],[]>,
  <[11],[],[25,26],[],[12],[13,14],[],[31,32]>,
  <[11],[],[25,26],[31],[12],[13,14],[],[32]>,
  <[11],[],[25,26],[31,32],[12],[13,14],[],[]>,
  <[11],[],[],[],[12],[13,14],[27,28],[29,30]>,
  <[11],[],[],[29],[12],[13,14],[27,28],[30]>,
  <[11],[],[],[29,30],[12],[13,14],[27,28],[]>,
  <[11],[],[],[],[12],[13,14],[27,28],[31,32]>,
  <[11],[],[],[31],[12],[13,14],[27,28],[32]>,
  <[11],[],[],[31,32],[12],[13,14],[27,28],[]>,
  <[11],[],[27],[],[12],[13,14],[28],[29,30]>,
  <[11],[],[27],[29],[12],[13,14],[28],[30]>,
  <[11],[],[27],[29,30],[12],[13,14],[28],[]>,
  <[11],[],[27],[],[12],[13,14],[28],[31,32]>,
  <[11],[],[27],[31],[12],[13,14],[28],[32]>,
  <[11],[],[27],[31,32],[12],[13,14],[28],[]>,
  <[11],[],[27,28],[],[12],[13,14],[],[29,30]>,
  <[11],[],[27,28],[29],[12],[13,14],[],[30]>,
  <[11],[],[27,28],[29,30],[12],[13,14],[],[]>,
  <[11],[],[27,28],[],[12],[13,14],[],[31,32]>,
  <[11],[],[27,28],[31],[12],[13,14],[],[32]>,
  <[11],[],[27,28],[31,32],[12],[13,14],[],[]>,
  <[11],[13],[],[],[12],[14],[17,18],[21,22]>,
  <[11],[13],[],[21],[12],[14],[17,18],[22]>,
  <[11],[13],[],[21,22],[12],[14],[17,18],[]>,
  <[11],[13],[],[],[12],[14],[17,18],[23,24]>,
  <[11],[13],[],[23],[12],[14],[17,18],[24]>,
  <[11],[13],[],[23,24],[12],[14],[17,18],[]>,
  <[11],[13],[17],[],[12],[14],[18],[21,22]>,
  <[11],[13],[17],[21],[12],[14],[18],[22]>,
  <[11],[13],[17],[21,22],[12],[14],[18],[]>,
  <[11],[13],[17],[],[12],[14],[18],[23,24]>,
  <[11],[13],[17],[23],[12],[14],[18],[24]>,
  <[11],[13],[17],[23,24],[12],[14],[18],[]>,
  <[11],[13],[17,18],[],[12],[14],[],[21,22]>,
  <[11],[13],[17,18],[21],[12],[14],[],[22]>,
  <[11],[13],[17,18],[21,22],[12],[14],[],[]>,
  <[11],[13],[17,18],[],[12],[14],[],[23,24]>,
  <[11],[13],[17,18],[23],[12],[14],[],[24]>,
  <[11],[13],[17,18],[23,24],[12],[14],[],[]>,
  <[11],[13],[],[],[12],[14],[19,20],[21,22]>,
  <[11],[13],[],[21],[12],[14],[19,20],[22]>,
  <[11],[13],[],[21,22],[12],[14],[19,20],[]>,
  <[11],[13],[],[],[12],[14],[19,20],[23,24]>,
  <[11],[13],[],[23],[12],[14],[19,20],[24]>,
  <[11],[13],[],[23,24],[12],[14],[19,20],[]>,
  <[11],[13],[19],[],[12],[14],[20],[21,22]>,
  <[11],[13],[19],[21],[12],[14],[20],[22]>,
  <[11],[13],[19],[21,22],[12],[14],[20],[]>,
  <[11],[13],[19],[],[12],[14],[20],[23,24]>,
  <[11],[13],[19],[23],[12],[14],[20],[24]>,
  <[11],[13],[19],[23,24],[12],[14],[20],[]>,
  <[11],[13],[19,20],[],[12],[14],[],[21,22]>,
  <[11],[13],[19,20],[21],[12],[14],[],[22]>,
  <[11],[13],[19,20],[21,22],[12],[14],[],[]>,
  <[11],[13],[19,20],[],[12],[14],[],[23,24]>,
  <[11],[13],[19,20],[23],[12],[14],[],[24]>,
  <[11],[13],[19,20],[23,24],[12],[14],[],[]>,
  <[11],[13],[],[],[12],[14],[25,26],[29,30]>,
  <[11],[13],[],[29],[12],[14],[25,26],[30]>,
  <[11],[13],[],[29,30],[12],[14],[25,26],[]>,
  <[11],[13],[],[],[12],[14],[25,26],[31,32]>,
  <[11],[13],[],[31],[12],[14],[25,26],[32]>,
  <[11],[13],[],[31,32],[12],[14],[25,26],[]>,
  <[11],[13],[25],[],[12],[14],[26],[29,30]>,
  <[11],[13],[25],[29],[12],[14],[26],[30]>,
  <[11],[13],[25],[29,30],[12],[14],[26],[]>,
  <[11],[13],[25],[],[12],[14],[26],[31,32]>,
  <[11],[13],[25],[31],[12],[14],[26],[32]>,
  <[11],[13],[25],[31,32],[12],[14],[26],[]>,
  <[11],[13],[25,26],[],[12],[14],[],[29,30]>,
  <[11],[13],[25,26],[29],[12],[14],[],[30]>,
  <[11],[13],[25,26],[29,30],[12],[14],[],[]>,
  <[11],[13],[25,26],[],[12],[14],[],[31,32]>,
  <[11],[13],[25,26],[31],[12],[14],[],[32]>,
  <[11],[13],[25,26],[31,32],[12],[14],[],[]>,
  <[11],[13],[],[],[12],[14],[27,28],[29,30]>,
  <[11],[13],[],[29],[12],[14],[27,28],[30]>,
  <[11],[13],[],[29,30],[12],[14],[27,28],[]>,
  <[11],[13],[],[],[12],[14],[27,28],[31,32]>,
  <[11],[13],[],[31],[12],[14],[27,28],[32]>,
  <[11],[13],[],[31,32],[12],[14],[27,28],[]>,
  <[11],[13],[27],[],[12],[14],[28],[29,30]>,
  <[11],[13],[27],[29],[12],[14],[28],[30]>,
  <[11],[13],[27],[29,30],[12],[14],[28],[]>,
  <[11],[13],[27],[],[12],[14],[28],[31,32]>,
  <[11],[13],[27],[31],[12],[14],[28],[32]>,
  <[11],[13],[27],[31,32],[12],[14],[28],[]>,
  <[11],[13],[27,28],[],[12],[14],[],[29,30]>,
  <[11],[13],[27,28],[29],[12],[14],[],[30]>,
  <[11],[13],[27,28],[29,30],[12],[14],[],[]>,
  <[11],[13],[27,28],[],[12],[14],[],[31,32]>,
  <[11],[13],[27,28],[31],[12],[14],[],[32]>,
  <[11],[13],[27,28],[31,32],[12],[14],[],[]>,
  <[11],[13,14],[],[],[12],[],[17,18],[21,22]>,
  <[11],[13,14],[],[21],[12],[],[17,18],[22]>,
  <[11],[13,14],[],[21,22],[12],[],[17,18],[]>,
  <[11],[13,14],[],[],[12],[],[17,18],[23,24]>,
  <[11],[13,14],[],[23],[12],[],[17,18],[24]>,
  <[11],[13,14],[],[23,24],[12],[],[17,18],[]>,
  <[11],[13,14],[17],[],[12],[],[18],[21,22]>,
  <[11],[13,14],[17],[21],[12],[],[18],[22]>,
  <[11],[13,14],[17],[21,22],[12],[],[18],[]>,
  <[11],[13,14],[17],[],[12],[],[18],[23,24]>,
  <[11],[13,14],[17],[23],[12],[],[18],[24]>,
  <[11],[13,14],[17],[23,24],[12],[],[18],[]>,
  <[11],[13,14],[17,18],[],[12],[],[],[21,22]>,
  <[11],[13,14],[17,18],[21],[12],[],[],[22]>,
  <[11],[13,14],[17,18],[21,22],[12],[],[],[]>,
  <[11],[13,14],[17,18],[],[12],[],[],[23,24]>,
  <[11],[13,14],[17,18],[23],[12],[],[],[24]>,
  <[11],[13,14],[17,18],[23,24],[12],[],[],[]>,
  <[11],[13,14],[],[],[12],[],[19,20],[21,22]>,
  <[11],[13,14],[],[21],[12],[],[19,20],[22]>,
  <[11],[13,14],[],[21,22],[12],[],[19,20],[]>,
  <[11],[13,14],[],[],[12],[],[19,20],[23,24]>,
  <[11],[13,14],[],[23],[12],[],[19,20],[24]>,
  <[11],[13,14],[],[23,24],[12],[],[19,20],[]>,
  <[11],[13,14],[19],[],[12],[],[20],[21,22]>,
  <[11],[13,14],[19],[21],[12],[],[20],[22]>,
  <[11],[13,14],[19],[21,22],[12],[],[20],[]>,
  <[11],[13,14],[19],[],[12],[],[20],[23,24]>,
  <[11],[13,14],[19],[23],[12],[],[20],[24]>,
  <[11],[13,14],[19],[23,24],[12],[],[20],[]>,
  <[11],[13,14],[19,20],[],[12],[],[],[21,22]>,
  <[11],[13,14],[19,20],[21],[12],[],[],[22]>,
  <[11],[13,14],[19,20],[21,22],[12],[],[],[]>,
  <[11],[13,14],[19,20],[],[12],[],[],[23,24]>,
  <[11],[13,14],[19,20],[23],[12],[],[],[24]>,
  <[11],[13,14],[19,20],[23,24],[12],[],[],[]>,
  <[11],[13,14],[],[],[12],[],[25,26],[29,30]>,
  <[11],[13,14],[],[29],[12],[],[25,26],[30]>,
  <[11],[13,14],[],[29,30],[12],[],[25,26],[]>,
  <[11],[13,14],[],[],[12],[],[25,26],[31,32]>,
  <[11],[13,14],[],[31],[12],[],[25,26],[32]>,
  <[11],[13,14],[],[31,32],[12],[],[25,26],[]>,
  <[11],[13,14],[25],[],[12],[],[26],[29,30]>,
  <[11],[13,14],[25],[29],[12],[],[26],[30]>,
  <[11],[13,14],[25],[29,30],[12],[],[26],[]>,
  <[11],[13,14],[25],[],[12],[],[26],[31,32]>,
  <[11],[13,14],[25],[31],[12],[],[26],[32]>,
  <[11],[13,14],[25],[31,32],[12],[],[26],[]>,
  <[11],[13,14],[25,26],[],[12],[],[],[29,30]>,
  <[11],[13,14],[25,26],[29],[12],[],[],[30]>,
  <[11],[13,14],[25,26],[29,30],[12],[],[],[]>,
  <[11],[13,14],[25,26],[],[12],[],[],[31,32]>,
  <[11],[13,14],[25,26],[31],[12],[],[],[32]>,
  <[11],[13,14],[25,26],[31,32],[12],[],[],[]>,
  <[11],[13,14],[],[],[12],[],[27,28],[29,30]>,
  <[11],[13,14],[],[29],[12],[],[27,28],[30]>,
  <[11],[13,14],[],[29,30],[12],[],[27,28],[]>,
  <[11],[13,14],[],[],[12],[],[27,28],[31,32]>,
  <[11],[13,14],[],[31],[12],[],[27,28],[32]>,
  <[11],[13,14],[],[31,32],[12],[],[27,28],[]>,
  <[11],[13,14],[27],[],[12],[],[28],[29,30]>,
  <[11],[13,14],[27],[29],[12],[],[28],[30]>,
  <[11],[13,14],[27],[29,30],[12],[],[28],[]>,
  <[11],[13,14],[27],[],[12],[],[28],[31,32]>,
  <[11],[13,14],[27],[31],[12],[],[28],[32]>,
  <[11],[13,14],[27],[31,32],[12],[],[28],[]>,
  <[11],[13,14],[27,28],[],[12],[],[],[29,30]>,
  <[11],[13,14],[27,28],[29],[12],[],[],[30]>,
  <[11],[13,14],[27,28],[29,30],[12],[],[],[]>,
  <[11],[13,14],[27,28],[],[12],[],[],[31,32]>,
  <[11],[13,14],[27,28],[31],[12],[],[],[32]>,
  <[11],[13,14],[27,28],[31,32],[12],[],[],[]>,
  <[11],[],[],[],[12],[15,16],[17,18],[21,22]>,
  <[11],[],[],[21],[12],[15,16],[17,18],[22]>,
  <[11],[],[],[21,22],[12],[15,16],[17,18],[]>,
  <[11],[],[],[],[12],[15,16],[17,18],[23,24]>,
  <[11],[],[],[23],[12],[15,16],[17,18],[24]>,
  <[11],[],[],[23,24],[12],[15,16],[17,18],[]>,
  <[11],[],[17],[],[12],[15,16],[18],[21,22]>,
  <[11],[],[17],[21],[12],[15,16],[18],[22]>,
  <[11],[],[17],[21,22],[12],[15,16],[18],[]>,
  <[11],[],[17],[],[12],[15,16],[18],[23,24]>,
  <[11],[],[17],[23],[12],[15,16],[18],[24]>,
  <[11],[],[17],[23,24],[12],[15,16],[18],[]>,
  <[11],[],[17,18],[],[12],[15,16],[],[21,22]>,
  <[11],[],[17,18],[21],[12],[15,16],[],[22]>,
  <[11],[],[17,18],[21,22],[12],[15,16],[],[]>,
  <[11],[],[17,18],[],[12],[15,16],[],[23,24]>,
  <[11],[],[17,18],[23],[12],[15,16],[],[24]>,
  <[11],[],[17,18],[23,24],[12],[15,16],[],[]>,
  <[11],[],[],[],[12],[15,16],[19,20],[21,22]>,
  <[11],[],[],[21],[12],[15,16],[19,20],[22]>,
  <[11],[],[],[21,22],[12],[15,16],[19,20],[]>,
  <[11],[],[],[],[12],[15,16],[19,20],[23,24]>,
  <[11],[],[],[23],[12],[15,16],[19,20],[24]>,
  <[11],[],[],[23,24],[12],[15,16],[19,20],[]>,
  <[11],[],[19],[],[12],[15,16],[20],[21,22]>,
  <[11],[],[19],[21],[12],[15,16],[20],[22]>,
  <[11],[],[19],[21,22],[12],[15,16],[20],[]>,
  <[11],[],[19],[],[12],[15,16],[20],[23,24]>,
  <[11],[],[19],[23],[12],[15,16],[20],[24]>,
  <[11],[],[19],[23,24],[12],[15,16],[20],[]>,
  <[11],[],[19,20],[],[12],[15,16],[],[21,22]>,
  <[11],[],[19,20],[21],[12],[15,16],[],[22]>,
  <[11],[],[19,20],[21,22],[12],[15,16],[],[]>,
  <[11],[],[19,20],[],[12],[15,16],[],[23,24]>,
  <[11],[],[19,20],[23],[12],[15,16],[],[24]>,
  <[11],[],[19,20],[23,24],[12],[15,16],[],[]>,
  <[11],[],[],[],[12],[15,16],[25,26],[29,30]>,
  <[11],[],[],[29],[12],[15,16],[25,26],[30]>,
  <[11],[],[],[29,30],[12],[15,16],[25,26],[]>,
  <[11],[],[],[],[12],[15,16],[25,26],[31,32]>,
  <[11],[],[],[31],[12],[15,16],[25,26],[32]>,
  <[11],[],[],[31,32],[12],[15,16],[25,26],[]>,
  <[11],[],[25],[],[12],[15,16],[26],[29,30]>,
  <[11],[],[25],[29],[12],[15,16],[26],[30]>,
  <[11],[],[25],[29,30],[12],[15,16],[26],[]>,
  <[11],[],[25],[],[12],[15,16],[26],[31,32]>,
  <[11],[],[25],[31],[12],[15,16],[26],[32]>,
  <[11],[],[25],[31,32],[12],[15,16],[26],[]>,
  <[11],[],[25,26],[],[12],[15,16],[],[29,30]>,
  <[11],[],[25,26],[29],[12],[15,16],[],[30]>,
  <[11],[],[25,26],[29,30],[12],[15,16],[],[]>,
  <[11],[],[25,26],[],[12],[15,16],[],[31,32]>,
  <[11],[],[25,26],[31],[12],[15,16],[],[32]>,
  <[11],[],[25,26],[31,32],[12],[15,16],[],[]>,
  <[11],[],[],[],[12],[15,16],[27,28],[29,30]>,
  <[11],[],[],[29],[12],[15,16],[27,28],[30]>,
  <[11],[],[],[29,30],[12],[15,16],[27,28],[]>,
  <[11],[],[],[],[12],[15,16],[27,28],[31,32]>,
  <[11],[],[],[31],[12],[15,16],[27,28],[32]>,
  <[11],[],[],[31,32],[12],[15,16],[27,28],[]>,
  <[11],[],[27],[],[12],[15,16],[28],[29,30]>,
  <[11],[],[27],[29],[12],[15,16],[28],[30]>,
  <[11],[],[27],[29,30],[12],[15,16],[28],[]>,
  <[11],[],[27],[],[12],[15,16],[28],[31,32]>,
  <[11],[],[27],[31],[12],[15,16],[28],[32]>,
  <[11],[],[27],[31,32],[12],[15,16],[28],[]>,
  <[11],[],[27,28],[],[12],[15,16],[],[29,30]>,
  <[11],[],[27,28],[29],[12],[15,16],[],[30]>,
  <[11],[],[27,28],[29,30],[12],[15,16],[],[]>,
  <[11],[],[27,28],[],[12],[15,16],[],[31,32]>,
  <[11],[],[27,28],[31],[12],[15,16],[],[32]>,
  <[11],[],[27,28],[31,32],[12],[15,16],[],[]>,
  <[11],[15],[],[],[12],[16],[17,18],[21,22]>,
  <[11],[15],[],[21],[12],[16],[17,18],[22]>,
  <[11],[15],[],[21,22],[12],[16],[17,18],[]>,
  <[11],[15],[],[],[12],[16],[17,18],[23,24]>,
  <[11],[15],[],[23],[12],[16],[17,18],[24]>,
  <[11],[15],[],[23,24],[12],[16],[17,18],[]>,
  <[11],[15],[17],[],[12],[16],[18],[21,22]>,
  <[11],[15],[17],[21],[12],[16],[18],[22]>,
  <[11],[15],[17],[21,22],[12],[16],[18],[]>,
  <[11],[15],[17],[],[12],[16],[18],[23,24]>,
  <[11],[15],[17],[23],[12],[16],[18],[24]>,
  <[11],[15],[17],[23,24],[12],[16],[18],[]>,
  <[11],[15],[17,18],[],[12],[16],[],[21,22]>,
  <[11],[15],[17,18],[21],[12],[16],[],[22]>,
  <[11],[15],[17,18],[21,22],[12],[16],[],[]>,
  <[11],[15],[17,18],[],[12],[16],[],[23,24]>,
  <[11],[15],[17,18],[23],[12],[16],[],[24]>,
  <[11],[15],[17,18],[23,24],[12],[16],[],[]>,
  <[11],[15],[],[],[12],[16],[19,20],[21,22]>,
  <[11],[15],[],[21],[12],[16],[19,20],[22]>,
  <[11],[15],[],[21,22],[12],[16],[19,20],[]>,
  <[11],[15],[],[],[12],[16],[19,20],[23,24]>,
  <[11],[15],[],[23],[12],[16],[19,20],[24]>,
  <[11],[15],[],[23,24],[12],[16],[19,20],[]>,
  <[11],[15],[19],[],[12],[16],[20],[21,22]>,
  <[11],[15],[19],[21],[12],[16],[20],[22]>,
  <[11],[15],[19],[21,22],[12],[16],[20],[]>,
  <[11],[15],[19],[],[12],[16],[20],[23,24]>,
  <[11],[15],[19],[23],[12],[16],[20],[24]>,
  <[11],[15],[19],[23,24],[12],[16],[20],[]>,
  <[11],[15],[19,20],[],[12],[16],[],[21,22]>,
  <[11],[15],[19,20],[21],[12],[16],[],[22]>,
  <[11],[15],[19,20],[21,22],[12],[16],[],[]>,
  <[11],[15],[19,20],[],[12],[16],[],[23,24]>,
  <[11],[15],[19,20],[23],[12],[16],[],[24]>,
  <[11],[15],[19,20],[23,24],[12],[16],[],[]>,
  <[11],[15],[],[],[12],[16],[25,26],[29,30]>,
  <[11],[15],[],[29],[12],[16],[25,26],[30]>,
  <[11],[15],[],[29,30],[12],[16],[25,26],[]>,
  <[11],[15],[],[],[12],[16],[25,26],[31,32]>,
  <[11],[15],[],[31],[12],[16],[25,26],[32]>,
  <[11],[15],[],[31,32],[12],[16],[25,26],[]>,
  <[11],[15],[25],[],[12],[16],[26],[29,30]>,
  <[11],[15],[25],[29],[12],[16],[26],[30]>,
  <[11],[15],[25],[29,30],[12],[16],[26],[]>,
  <[11],[15],[25],[],[12],[16],[26],[31,32]>,
  <[11],[15],[25],[31],[12],[16],[26],[32]>,
  <[11],[15],[25],[31,32],[12],[16],[26],[]>,
  <[11],[15],[25,26],[],[12],[16],[],[29,30]>,
  <[11],[15],[25,26],[29],[12],[16],[],[30]>,
  <[11],[15],[25,26],[29,30],[12],[16],[],[]>,
  <[11],[15],[25,26],[],[12],[16],[],[31,32]>,
  <[11],[15],[25,26],[31],[12],[16],[],[32]>,
  <[11],[15],[25,26],[31,32],[12],[16],[],[]>,
  <[11],[15],[],[],[12],[16],[27,28],[29,30]>,
  <[11],[15],[],[29],[12],[16],[27,28],[30]>,
  <[11],[15],[],[29,30],[12],[16],[27,28],[]>,
  <[11],[15],[],[],[12],[16],[27,28],[31,32]>,
  <[11],[15],[],[31],[12],[16],[27,28],[32]>,
  <[11],[15],[],[31,32],[12],[16],[27,28],[]>,
  <[11],[15],[27],[],[12],[16],[28],[29,30]>,
  <[11],[15],[27],[29],[12],[16],[28],[30]>,
  <[11],[15],[27],[29,30],[12],[16],[28],[]>,
  <[11],[15],[27],[],[12],[16],[28],[31,32]>,
  <[11],[15],[27],[31],[12],[16],[28],[32]>,
  <[11],[15],[27],[31,32],[12],[16],[28],[]>,
  <[11],[15],[27,28],[],[12],[16],[],[29,30]>,
  <[11],[15],[27,28],[29],[12],[16],[],[30]>,
  <[11],[15],[27,28],[29,30],[12],[16],[],[]>,
  <[11],[15],[27,28],[],[12],[16],[],[31,32]>,
  <[11],[15],[27,28],[31],[12],[16],[],[32]>,
  <[11],[15],[27,28],[31,32],[12],[16],[],[]>,
  <[11],[15,16],[],[],[12],[],[17,18],[21,22]>,
  <[11],[15,16],[],[21],[12],[],[17,18],[22]>,
  <[11],[15,16],[],[21,22],[12],[],[17,18],[]>,
  <[11],[15,16],[],[],[12],[],[17,18],[23,24]>,
  <[11],[15,16],[],[23],[12],[],[17,18],[24]>,
  <[11],[15,16],[],[23,24],[12],[],[17,18],[]>,
  <[11],[15,16],[17],[],[12],[],[18],[21,22]>,
  <[11],[15,16],[17],[21],[12],[],[18],[22]>,
  <[11],[15,16],[17],[21,22],[12],[],[18],[]>,
  <[11],[15,16],[17],[],[12],[],[18],[23,24]>,
  <[11],[15,16],[17],[23],[12],[],[18],[24]>,
  <[11],[15,16],[17],[23,24],[12],[],[18],[]>,
  <[11],[15,16],[17,18],[],[12],[],[],[21,22]>,
  <[11],[15,16],[17,18],[21],[12],[],[],[22]>,
  <[11],[15,16],[17,18],[21,22],[12],[],[],[]>,
  <[11],[15,16],[17,18],[],[12],[],[],[23,24]>,
  <[11],[15,16],[17,18],[23],[12],[],[],[24]>,
  <[11],[15,16],[17,18],[23,24],[12],[],[],[]>,
  <[11],[15,16],[],[],[12],[],[19,20],[21,22]>,
  <[11],[15,16],[],[21],[12],[],[19,20],[22]>,
  <[11],[15,16],[],[21,22],[12],[],[19,20],[]>,
  <[11],[15,16],[],[],[12],[],[19,20],[23,24]>,
  <[11],[15,16],[],[23],[12],[],[19,20],[24]>,
  <[11],[15,16],[],[23,24],[12],[],[19,20],[]>,
  <[11],[15,16],[19],[],[12],[],[20],[21,22]>,
  <[11],[15,16],[19],[21],[12],[],[20],[22]>,
  <[11],[15,16],[19],[21,22],[12],[],[20],[]>,
  <[11],[15,16],[19],[],[12],[],[20],[23,24]>,
  <[11],[15,16],[19],[23],[12],[],[20],[24]>,
  <[11],[15,16],[19],[23,24],[12],[],[20],[]>,
  <[11],[15,16],[19,20],[],[12],[],[],[21,22]>,
  <[11],[15,16],[19,20],[21],[12],[],[],[22]>,
  <[11],[15,16],[19,20],[21,22],[12],[],[],[]>,
  <[11],[15,16],[19,20],[],[12],[],[],[23,24]>,
  <[11],[15,16],[19,20],[23],[12],[],[],[24]>,
  <[11],[15,16],[19,20],[23,24],[12],[],[],[]>,
  <[11],[15,16],[],[],[12],[],[25,26],[29,30]>,
  <[11],[15,16],[],[29],[12],[],[25,26],[30]>,
  <[11],[15,16],[],[29,30],[12],[],[25,26],[]>,
  <[11],[15,16],[],[],[12],[],[25,26],[31,32]>,
  <[11],[15,16],[],[31],[12],[],[25,26],[32]>,
  <[11],[15,16],[],[31,32],[12],[],[25,26],[]>,
  <[11],[15,16],[25],[],[12],[],[26],[29,30]>,
  <[11],[15,16],[25],[29],[12],[],[26],[30]>,
  <[11],[15,16],[25],[29,30],[12],[],[26],[]>,
  <[11],[15,16],[25],[],[12],[],[26],[31,32]>,
  <[11],[15,16],[25],[31],[12],[],[26],[32]>,
  <[11],[15,16],[25],[31,32],[12],[],[26],[]>,
  <[11],[15,16],[25,26],[],[12],[],[],[29,30]>,
  <[11],[15,16],[25,26],[29],[12],[],[],[30]>,
  <[11],[15,16],[25,26],[29,30],[12],[],[],[]>,
  <[11],[15,16],[25,26],[],[12],[],[],[31,32]>,
  <[11],[15,16],[25,26],[31],[12],[],[],[32]>,
  <[11],[15,16],[25,26],[31,32],[12],[],[],[]>,
  <[11],[15,16],[],[],[12],[],[27,28],[29,30]>,
  <[11],[15,16],[],[29],[12],[],[27,28],[30]>,
  <[11],[15,16],[],[29,30],[12],[],[27,28],[]>,
  <[11],[15,16],[],[],[12],[],[27,28],[31,32]>,
  <[11],[15,16],[],[31],[12],[],[27,28],[32]>,
  <[11],[15,16],[],[31,32],[12],[],[27,28],[]>,
  <[11],[15,16],[27],[],[12],[],[28],[29,30]>,
  <[11],[15,16],[27],[29],[12],[],[28],[30]>,
  <[11],[15,16],[27],[29,30],[12],[],[28],[]>,
  <[11],[15,16],[27],[],[12],[],[28],[31,32]>,
  <[11],[15,16],[27],[31],[12],[],[28],[32]>,
  <[11],[15,16],[27],[31,32],[12],[],[28],[]>,
  <[11],[15,16],[27,28],[],[12],[],[],[29,30]>,
  <[11],[15,16],[27,28],[29],[12],[],[],[30]>,
  <[11],[15,16],[27,28],[29,30],[12],[],[],[]>,
  <[11],[15,16],[27,28],[],[12],[],[],[31,32]>,
  <[11],[15,16],[27,28],[31],[12],[],[],[32]>,
  <[11],[15,16],[27,28],[31,32],[12],[],[],[]>,
  <[11,12],[],[],[],[],[13,14],[17,18],[21,22]>,
  <[11,12],[],[],[21],[],[13,14],[17,18],[22]>,
  <[11,12],[],[],[21,22],[],[13,14],[17,18],[]>,
  <[11,12],[],[],[],[],[13,14],[17,18],[23,24]>,
  <[11,12],[],[],[23],[],[13,14],[17,18],[24]>,
  <[11,12],[],[],[23,24],[],[13,14],[17,18],[]>,
  <[11,12],[],[17],[],[],[13,14],[18],[21,22]>,
  <[11,12],[],[17],[21],[],[13,14],[18],[22]>,
  <[11,12],[],[17],[21,22],[],[13,14],[18],[]>,
  <[11,12],[],[17],[],[],[13,14],[18],[23,24]>,
  <[11,12],[],[17],[23],[],[13,14],[18],[24]>,
  <[11,12],[],[17],[23,24],[],[13,14],[18],[]>,
  <[11,12],[],[17,18],[],[],[13,14],[],[21,22]>,
  <[11,12],[],[17,18],[21],[],[13,14],[],[22]>,
  <[11,12],[],[17,18],[21,22],[],[13,14],[],[]>,
  <[11,12],[],[17,18],[],[],[13,14],[],[23,24]>,
  <[11,12],[],[17,18],[23],[],[13,14],[],[24]>,
  <[11,12],[],[17,18],[23,24],[],[13,14],[],[]>,
  <[11,12],[],[],[],[],[13,14],[19,20],[21,22]>,
  <[11,12],[],[],[21],[],[13,14],[19,20],[22]>,
  <[11,12],[],[],[21,22],[],[13,14],[19,20],[]>,
  <[11,12],[],[],[],[],[13,14],[19,20],[23,24]>,
  <[11,12],[],[],[23],[],[13,14],[19,20],[24]>,
  <[11,12],[],[],[23,24],[],[13,14],[19,20],[]>,
  <[11,12],[],[19],[],[],[13,14],[20],[21,22]>,
  <[11,12],[],[19],[21],[],[13,14],[20],[22]>,
  <[11,12],[],[19],[21,22],[],[13,14],[20],[]>,
  <[11,12],[],[19],[],[],[13,14],[20],[23,24]>,
  <[11,12],[],[19],[23],[],[13,14],[20],[24]>,
  <[11,12],[],[19],[23,24],[],[13,14],[20],[]>,
  <[11,12],[],[19,20],[],[],[13,14],[],[21,22]>,
  <[11,12],[],[19,20],[21],[],[13,14],[],[22]>,
  <[11,12],[],[19,20],[21,22],[],[13,14],[],[]>,
  <[11,12],[],[19,20],[],[],[13,14],[],[23,24]>,
  <[11,12],[],[19,20],[23],[],[13,14],[],[24]>,
  <[11,12],[],[19,20],[23,24],[],[13,14],[],[]>,
  <[11,12],[],[],[],[],[13,14],[25,26],[29,30]>,
  <[11,12],[],[],[29],[],[13,14],[25,26],[30]>,
  <[11,12],[],[],[29,30],[],[13,14],[25,26],[]>,
  <[11,12],[],[],[],[],[13,14],[25,26],[31,32]>,
  <[11,12],[],[],[31],[],[13,14],[25,26],[32]>,
  <[11,12],[],[],[31,32],[],[13,14],[25,26],[]>,
  <[11,12],[],[25],[],[],[13,14],[26],[29,30]>,
  <[11,12],[],[25],[29],[],[13,14],[26],[30]>,
  <[11,12],[],[25],[29,30],[],[13,14],[26],[]>,
  <[11,12],[],[25],[],[],[13,14],[26],[31,32]>,
  <[11,12],[],[25],[31],[],[13,14],[26],[32]>,
  <[11,12],[],[25],[31,32],[],[13,14],[26],[]>,
  <[11,12],[],[25,26],[],[],[13,14],[],[29,30]>,
  <[11,12],[],[25,26],[29],[],[13,14],[],[30]>,
  <[11,12],[],[25,26],[29,30],[],[13,14],[],[]>,
  <[11,12],[],[25,26],[],[],[13,14],[],[31,32]>,
  <[11,12],[],[25,26],[31],[],[13,14],[],[32]>,
  <[11,12],[],[25,26],[31,32],[],[13,14],[],[]>,
  <[11,12],[],[],[],[],[13,14],[27,28],[29,30]>,
  <[11,12],[],[],[29],[],[13,14],[27,28],[30]>,
  <[11,12],[],[],[29,30],[],[13,14],[27,28],[]>,
  <[11,12],[],[],[],[],[13,14],[27,28],[31,32]>,
  <[11,12],[],[],[31],[],[13,14],[27,28],[32]>,
  <[11,12],[],[],[31,32],[],[13,14],[27,28],[]>,
  <[11,12],[],[27],[],[],[13,14],[28],[29,30]>,
  <[11,12],[],[27],[29],[],[13,14],[28],[30]>,
  <[11,12],[],[27],[29,30],[],[13,14],[28],[]>,
  <[11,12],[],[27],[],[],[13,14],[28],[31,32]>,
  <[11,12],[],[27],[31],[],[13,14],[28],[32]>,
  <[11,12],[],[27],[31,32],[],[13,14],[28],[]>,
  <[11,12],[],[27,28],[],[],[13,14],[],[29,30]>,
  <[11,12],[],[27,28],[29],[],[13,14],[],[30]>,
  <[11,12],[],[27,28],[29,30],[],[13,14],[],[]>,
  <[11,12],[],[27,28],[],[],[13,14],[],[31,32]>,
  <[11,12],[],[27,28],[31],[],[13,14],[],[32]>,
  <[11,12],[],[27,28],[31,32],[],[13,14],[],[]>,
  <[11,12],[13],[],[],[],[14],[17,18],[21,22]>,
  <[11,12],[13],[],[21],[],[14],[17,18],[22]>,
  <[11,12],[13],[],[21,22],[],[14],[17,18],[]>,
  <[11,12],[13],[],[],[],[14],[17,18],[23,24]>,
  <[11,12],[13],[],[23],[],[14],[17,18],[24]>,
  <[11,12],[13],[],[23,24],[],[14],[17,18],[]>,
  <[11,12],[13],[17],[],[],[14],[18],[21,22]>,
  <[11,12],[13],[17],[21],[],[14],[18],[22]>,
  <[11,12],[13],[17],[21,22],[],[14],[18],[]>,
  <[11,12],[13],[17],[],[],[14],[18],[23,24]>,
  <[11,12],[13],[17],[23],[],[14],[18],[24]>,
  <[11,12],[13],[17],[23,24],[],[14],[18],[]>,
  <[11,12],[13],[17,18],[],[],[14],[],[21,22]>,
  <[11,12],[13],[17,18],[21],[],[14],[],[22]>,
  <[11,12],[13],[17,18],[21,22],[],[14],[],[]>,
  <[11,12],[13],[17,18],[],[],[14],[],[23,24]>,
  <[11,12],[13],[17,18],[23],[],[14],[],[24]>,
  <[11,12],[13],[17,18],[23,24],[],[14],[],[]>,
  <[11,12],[13],[],[],[],[14],[19,20],[21,22]>,
  <[11,12],[13],[],[21],[],[14],[19,20],[22]>,
  <[11,12],[13],[],[21,22],[],[14],[19,20],[]>,
  <[11,12],[13],[],[],[],[14],[19,20],[23,24]>,
  <[11,12],[13],[],[23],[],[14],[19,20],[24]>,
  <[11,12],[13],[],[23,24],[],[14],[19,20],[]>,
  <[11,12],[13],[19],[],[],[14],[20],[21,22]>,
  <[11,12],[13],[19],[21],[],[14],[20],[22]>,
  <[11,12],[13],[19],[21,22],[],[14],[20],[]>,
  <[11,12],[13],[19],[],[],[14],[20],[23,24]>,
  <[11,12],[13],[19],[23],[],[14],[20],[24]>,
  <[11,12],[13],[19],[23,24],[],[14],[20],[]>,
  <[11,12],[13],[19,20],[],[],[14],[],[21,22]>,
  <[11,12],[13],[19,20],[21],[],[14],[],[22]>,
  <[11,12],[13],[19,20],[21,22],[],[14],[],[]>,
  <[11,12],[13],[19,20],[],[],[14],[],[23,24]>,
  <[11,12],[13],[19,20],[23],[],[14],[],[24]>,
  <[11,12],[13],[19,20],[23,24],[],[14],[],[]>,
  <[11,12],[13],[],[],[],[14],[25,26],[29,30]>,
  <[11,12],[13],[],[29],[],[14],[25,26],[30]>,
  <[11,12],[13],[],[29,30],[],[14],[25,26],[]>,
  <[11,12],[13],[],[],[],[14],[25,26],[31,32]>,
  <[11,12],[13],[],[31],[],[14],[25,26],[32]>,
  <[11,12],[13],[],[31,32],[],[14],[25,26],[]>,
  <[11,12],[13],[25],[],[],[14],[26],[29,30]>,
  <[11,12],[13],[25],[29],[],[14],[26],[30]>,
  <[11,12],[13],[25],[29,30],[],[14],[26],[]>,
  <[11,12],[13],[25],[],[],[14],[26],[31,32]>,
  <[11,12],[13],[25],[31],[],[14],[26],[32]>,
  <[11,12],[13],[25],[31,32],[],[14],[26],[]>,
  <[11,12],[13],[25,26],[],[],[14],[],[29,30]>,
  <[11,12],[13],[25,26],[29],[],[14],[],[30]>,
  <[11,12],[13],[25,26],[29,30],[],[14],[],[]>,
  <[11,12],[13],[25,26],[],[],[14],[],[31,32]>,
  <[11,12],[13],[25,26],[31],[],[14],[],[32]>,
  <[11,12],[13],[25,26],[31,32],[],[14],[],[]>,
  <[11,12],[13],[],[],[],[14],[27,28],[29,30]>,
  <[11,12],[13],[],[29],[],[14],[27,28],[30]>,
  <[11,12],[13],[],[29,30],[],[14],[27,28],[]>,
  <[11,12],[13],[],[],[],[14],[27,28],[31,32]>,
  <[11,12],[13],[],[31],[],[14],[27,28],[32]>,
  <[11,12],[13],[],[31,32],[],[14],[27,28],[]>,
  <[11,12],[13],[27],[],[],[14],[28],[29,30]>,
  <[11,12],[13],[27],[29],[],[14],[28],[30]>,
  <[11,12],[13],[27],[29,30],[],[14],[28],[]>,
  <[11,12],[13],[27],[],[],[14],[28],[31,32]>,
  <[11,12],[13],[27],[31],[],[14],[28],[32]>,
  <[11,12],[13],[27],[31,32],[],[14],[28],[]>,
  <[11,12],[13],[27,28],[],[],[14],[],[29,30]>,
  <[11,12],[13],[27,28],[29],[],[14],[],[30]>,
  <[11,12],[13],[27,28],[29,30],[],[14],[],[]>,
  <[11,12],[13],[27,28],[],[],[14],[],[31,32]>,
  <[11,12],[13],[27,28],[31],[],[14],[],[32]>,
  <[11,12],[13],[27,28],[31,32],[],[14],[],[]>,
  <[11,12],[13,14],[],[],[],[],[17,18],[21,22]>,
  <[11,12],[13,14],[],[21],[],[],[17,18],[22]>,
  <[11,12],[13,14],[],[21,22],[],[],[17,18],[]>,
  <[11,12],[13,14],[],[],[],[],[17,18],[23,24]>,
  <[11,12],[13,14],[],[23],[],[],[17,18],[24]>,
  <[11,12],[13,14],[],[23,24],[],[],[17,18],[]>,
  <[11,12],[13,14],[17],[],[],[],[18],[21,22]>,
  <[11,12],[13,14],[17],[21],[],[],[18],[22]>,
  <[11,12],[13,14],[17],[21,22],[],[],[18],[]>,
  <[11,12],[13,14],[17],[],[],[],[18],[23,24]>,
  <[11,12],[13,14],[17],[23],[],[],[18],[24]>,
  <[11,12],[13,14],[17],[23,24],[],[],[18],[]>,
  <[11,12],[13,14],[17,18],[],[],[],[],[21,22]>,
  <[11,12],[13,14],[17,18],[21],[],[],[],[22]>,
  <[11,12],[13,14],[17,18],[21,22],[],[],[],[]>,
  <[11,12],[13,14],[17,18],[],[],[],[],[23,24]>,
  <[11,12],[13,14],[17,18],[23],[],[],[],[24]>,
  <[11,12],[13,14],[17,18],[23,24],[],[],[],[]>,
  <[11,12],[13,14],[],[],[],[],[19,20],[21,22]>,
  <[11,12],[13,14],[],[21],[],[],[19,20],[22]>,
  <[11,12],[13,14],[],[21,22],[],[],[19,20],[]>,
  <[11,12],[13,14],[],[],[],[],[19,20],[23,24]>,
  <[11,12],[13,14],[],[23],[],[],[19,20],[24]>,
  <[11,12],[13,14],[],[23,24],[],[],[19,20],[]>,
  <[11,12],[13,14],[19],[],[],[],[20],[21,22]>,
  <[11,12],[13,14],[19],[21],[],[],[20],[22]>,
  <[11,12],[13,14],[19],[21,22],[],[],[20],[]>,
  <[11,12],[13,14],[19],[],[],[],[20],[23,24]>,
  <[11,12],[13,14],[19],[23],[],[],[20],[24]>,
  <[11,12],[13,14],[19],[23,24],[],[],[20],[]>,
  <[11,12],[13,14],[19,20],[],[],[],[],[21,22]>,
  <[11,12],[13,14],[19,20],[21],[],[],[],[22]>,
  <[11,12],[13,14],[19,20],[21,22],[],[],[],[]>,
  <[11,12],[13,14],[19,20],[],[],[],[],[23,24]>,
  <[11,12],[13,14],[19,20],[23],[],[],[],[24]>,
  <[11,12],[13,14],[19,20],[23,24],[],[],[],[]>,
  <[11,12],[13,14],[],[],[],[],[25,26],[29,30]>,
  <[11,12],[13,14],[],[29],[],[],[25,26],[30]>,
  <[11,12],[13,14],[],[29,30],[],[],[25,26],[]>,
  <[11,12],[13,14],[],[],[],[],[25,26],[31,32]>,
  <[11,12],[13,14],[],[31],[],[],[25,26],[32]>,
  <[11,12],[13,14],[],[31,32],[],[],[25,26],[]>,
  <[11,12],[13,14],[25],[],[],[],[26],[29,30]>,
  <[11,12],[13,14],[25],[29],[],[],[26],[30]>,
  <[11,12],[13,14],[25],[29,30],[],[],[26],[]>,
  <[11,12],[13,14],[25],[],[],[],[26],[31,32]>,
  <[11,12],[13,14],[25],[31],[],[],[26],[32]>,
  <[11,12],[13,14],[25],[31,32],[],[],[26],[]>,
  <[11,12],[13,14],[25,26],[],[],[],[],[29,30]>,
  <[11,12],[13,14],[25,26],[29],[],[],[],[30]>,
  <[11,12],[13,14],[25,26],[29,30],[],[],[],[]>,
  <[11,12],[13,14],[25,26],[],[],[],[],[31,32]>,
  <[11,12],[13,14],[25,26],[31],[],[],[],[32]>,
  <[11,12],[13,14],[25,26],[31,32],[],[],[],[]>,
  <[11,12],[13,14],[],[],[],[],[27,28],[29,30]>,
  <[11,12],[13,14],[],[29],[],[],[27,28],[30]>,
  <[11,12],[13,14],[],[29,30],[],[],[27,28],[]>,
  <[11,12],[13,14],[],[],[],[],[27,28],[31,32]>,
  <[11,12],[13,14],[],[31],[],[],[27,28],[32]>,
  <[11,12],[13,14],[],[31,32],[],[],[27,28],[]>,
  <[11,12],[13,14],[27],[],[],[],[28],[29,30]>,
  <[11,12],[13,14],[27],[29],[],[],[28],[30]>,
  <[11,12],[13,14],[27],[29,30],[],[],[28],[]>,
  <[11,12],[13,14],[27],[],[],[],[28],[31,32]>,
  <[11,12],[13,14],[27],[31],[],[],[28],[32]>,
  <[11,12],[13,14],[27],[31,32],[],[],[28],[]>,
  <[11,12],[13,14],[27,28],[],[],[],[],[29,30]>,
  <[11,12],[13,14],[27,28],[29],[],[],[],[30]>,
  <[11,12],[13,14],[27,28],[29,30],[],[],[],[]>,
  <[11,12],[13,14],[27,28],[],[],[],[],[31,32]>,
  <[11,12],[13,14],[27,28],[31],[],[],[],[32]>,
  <[11,12],[13,14],[27,28],[31,32],[],[],[],[]>,
  <[11,12],[],[],[],[],[15,16],[17,18],[21,22]>,
  <[11,12],[],[],[21],[],[15,16],[17,18],[22]>,
  <[11,12],[],[],[21,22],[],[15,16],[17,18],[]>,
  <[11,12],[],[],[],[],[15,16],[17,18],[23,24]>,
  <[11,12],[],[],[23],[],[15,16],[17,18],[24]>,
  <[11,12],[],[],[23,24],[],[15,16],[17,18],[]>,
  <[11,12],[],[17],[],[],[15,16],[18],[21,22]>,
  <[11,12],[],[17],[21],[],[15,16],[18],[22]>,
  <[11,12],[],[17],[21,22],[],[15,16],[18],[]>,
  <[11,12],[],[17],[],[],[15,16],[18],[23,24]>,
  <[11,12],[],[17],[23],[],[15,16],[18],[24]>,
  <[11,12],[],[17],[23,24],[],[15,16],[18],[]>,
  <[11,12],[],[17,18],[],[],[15,16],[],[21,22]>,
  <[11,12],[],[17,18],[21],[],[15,16],[],[22]>,
  <[11,12],[],[17,18],[21,22],[],[15,16],[],[]>,
  <[11,12],[],[17,18],[],[],[15,16],[],[23,24]>,
  <[11,12],[],[17,18],[23],[],[15,16],[],[24]>,
  <[11,12],[],[17,18],[23,24],[],[15,16],[],[]>,
  <[11,12],[],[],[],[],[15,16],[19,20],[21,22]>,
  <[11,12],[],[],[21],[],[15,16],[19,20],[22]>,
  <[11,12],[],[],[21,22],[],[15,16],[19,20],[]>,
  <[11,12],[],[],[],[],[15,16],[19,20],[23,24]>,
  <[11,12],[],[],[23],[],[15,16],[19,20],[24]>,
  <[11,12],[],[],[23,24],[],[15,16],[19,20],[]>,
  <[11,12],[],[19],[],[],[15,16],[20],[21,22]>,
  <[11,12],[],[19],[21],[],[15,16],[20],[22]>,
  <[11,12],[],[19],[21,22],[],[15,16],[20],[]>,
  <[11,12],[],[19],[],[],[15,16],[20],[23,24]>,
  <[11,12],[],[19],[23],[],[15,16],[20],[24]>,
  <[11,12],[],[19],[23,24],[],[15,16],[20],[]>,
  <[11,12],[],[19,20],[],[],[15,16],[],[21,22]>,
  <[11,12],[],[19,20],[21],[],[15,16],[],[22]>,
  <[11,12],[],[19,20],[21,22],[],[15,16],[],[]>,
  <[11,12],[],[19,20],[],[],[15,16],[],[23,24]>,
  <[11,12],[],[19,20],[23],[],[15,16],[],[24]>,
  <[11,12],[],[19,20],[23,24],[],[15,16],[],[]>,
  <[11,12],[],[],[],[],[15,16],[25,26],[29,30]>,
  <[11,12],[],[],[29],[],[15,16],[25,26],[30]>,
  <[11,12],[],[],[29,30],[],[15,16],[25,26],[]>,
  <[11,12],[],[],[],[],[15,16],[25,26],[31,32]>,
  <[11,12],[],[],[31],[],[15,16],[25,26],[32]>,
  <[11,12],[],[],[31,32],[],[15,16],[25,26],[]>,
  <[11,12],[],[25],[],[],[15,16],[26],[29,30]>,
  <[11,12],[],[25],[29],[],[15,16],[26],[30]>,
  <[11,12],[],[25],[29,30],[],[15,16],[26],[]>,
  <[11,12],[],[25],[],[],[15,16],[26],[31,32]>,
  <[11,12],[],[25],[31],[],[15,16],[26],[32]>,
  <[11,12],[],[25],[31,32],[],[15,16],[26],[]>,
  <[11,12],[],[25,26],[],[],[15,16],[],[29,30]>,
  <[11,12],[],[25,26],[29],[],[15,16],[],[30]>,
  <[11,12],[],[25,26],[29,30],[],[15,16],[],[]>,
  <[11,12],[],[25,26],[],[],[15,16],[],[31,32]>,
  <[11,12],[],[25,26],[31],[],[15,16],[],[32]>,
  <[11,12],[],[25,26],[31,32],[],[15,16],[],[]>,
  <[11,12],[],[],[],[],[15,16],[27,28],[29,30]>,
  <[11,12],[],[],[29],[],[15,16],[27,28],[30]>,
  <[11,12],[],[],[29,30],[],[15,16],[27,28],[]>,
  <[11,12],[],[],[],[],[15,16],[27,28],[31,32]>,
  <[11,12],[],[],[31],[],[15,16],[27,28],[32]>,
  <[11,12],[],[],[31,32],[],[15,16],[27,28],[]>,
  <[11,12],[],[27],[],[],[15,16],[28],[29,30]>,
  <[11,12],[],[27],[29],[],[15,16],[28],[30]>,
  <[11,12],[],[27],[29,30],[],[15,16],[28],[]>,
  <[11,12],[],[27],[],[],[15,16],[28],[31,32]>,
  <[11,12],[],[27],[31],[],[15,16],[28],[32]>,
  <[11,12],[],[27],[31,32],[],[15,16],[28],[]>,
  <[11,12],[],[27,28],[],[],[15,16],[],[29,30]>,
  <[11,12],[],[27,28],[29],[],[15,16],[],[30]>,
  <[11,12],[],[27,28],[29,30],[],[15,16],[],[]>,
  <[11,12],[],[27,28],[],[],[15,16],[],[31,32]>,
  <[11,12],[],[27,28],[31],[],[15,16],[],[32]>,
  <[11,12],[],[27,28],[31,32],[],[15,16],[],[]>,
  <[11,12],[15],[],[],[],[16],[17,18],[21,22]>,
  <[11,12],[15],[],[21],[],[16],[17,18],[22]>,
  <[11,12],[15],[],[21,22],[],[16],[17,18],[]>,
  <[11,12],[15],[],[],[],[16],[17,18],[23,24]>,
  <[11,12],[15],[],[23],[],[16],[17,18],[24]>,
  <[11,12],[15],[],[23,24],[],[16],[17,18],[]>,
  <[11,12],[15],[17],[],[],[16],[18],[21,22]>,
  <[11,12],[15],[17],[21],[],[16],[18],[22]>,
  <[11,12],[15],[17],[21,22],[],[16],[18],[]>,
  <[11,12],[15],[17],[],[],[16],[18],[23,24]>,
  <[11,12],[15],[17],[23],[],[16],[18],[24]>,
  <[11,12],[15],[17],[23,24],[],[16],[18],[]>,
  <[11,12],[15],[17,18],[],[],[16],[],[21,22]>,
  <[11,12],[15],[17,18],[21],[],[16],[],[22]>,
  <[11,12],[15],[17,18],[21,22],[],[16],[],[]>,
  <[11,12],[15],[17,18],[],[],[16],[],[23,24]>,
  <[11,12],[15],[17,18],[23],[],[16],[],[24]>,
  <[11,12],[15],[17,18],[23,24],[],[16],[],[]>,
  <[11,12],[15],[],[],[],[16],[19,20],[21,22]>,
  <[11,12],[15],[],[21],[],[16],[19,20],[22]>,
  <[11,12],[15],[],[21,22],[],[16],[19,20],[]>,
  <[11,12],[15],[],[],[],[16],[19,20],[23,24]>,
  <[11,12],[15],[],[23],[],[16],[19,20],[24]>,
  <[11,12],[15],[],[23,24],[],[16],[19,20],[]>,
  <[11,12],[15],[19],[],[],[16],[20],[21,22]>,
  <[11,12],[15],[19],[21],[],[16],[20],[22]>,
  <[11,12],[15],[19],[21,22],[],[16],[20],[]>,
  <[11,12],[15],[19],[],[],[16],[20],[23,24]>,
  <[11,12],[15],[19],[23],[],[16],[20],[24]>,
  <[11,12],[15],[19],[23,24],[],[16],[20],[]>,
  <[11,12],[15],[19,20],[],[],[16],[],[21,22]>,
  <[11,12],[15],[19,20],[21],[],[16],[],[22]>,
  <[11,12],[15],[19,20],[21,22],[],[16],[],[]>,
  <[11,12],[15],[19,20],[],[],[16],[],[23,24]>,
  <[11,12],[15],[19,20],[23],[],[16],[],[24]>,
  <[11,12],[15],[19,20],[23,24],[],[16],[],[]>,
  <[11,12],[15],[],[],[],[16],[25,26],[29,30]>,
  <[11,12],[15],[],[29],[],[16],[25,26],[30]>,
  <[11,12],[15],[],[29,30],[],[16],[25,26],[]>,
  <[11,12],[15],[],[],[],[16],[25,26],[31,32]>,
  <[11,12],[15],[],[31],[],[16],[25,26],[32]>,
  <[11,12],[15],[],[31,32],[],[16],[25,26],[]>,
  <[11,12],[15],[25],[],[],[16],[26],[29,30]>,
  <[11,12],[15],[25],[29],[],[16],[26],[30]>,
  <[11,12],[15],[25],[29,30],[],[16],[26],[]>,
  <[11,12],[15],[25],[],[],[16],[26],[31,32]>,
  <[11,12],[15],[25],[31],[],[16],[26],[32]>,
  <[11,12],[15],[25],[31,32],[],[16],[26],[]>,
  <[11,12],[15],[25,26],[],[],[16],[],[29,30]>,
  <[11,12],[15],[25,26],[29],[],[16],[],[30]>,
  <[11,12],[15],[25,26],[29,30],[],[16],[],[]>,
  <[11,12],[15],[25,26],[],[],[16],[],[31,32]>,
  <[11,12],[15],[25,26],[31],[],[16],[],[32]>,
  <[11,12],[15],[25,26],[31,32],[],[16],[],[]>,
  <[11,12],[15],[],[],[],[16],[27,28],[29,30]>,
  <[11,12],[15],[],[29],[],[16],[27,28],[30]>,
  <[11,12],[15],[],[29,30],[],[16],[27,28],[]>,
  <[11,12],[15],[],[],[],[16],[27,28],[31,32]>,
  <[11,12],[15],[],[31],[],[16],[27,28],[32]>,
  <[11,12],[15],[],[31,32],[],[16],[27,28],[]>,
  <[11,12],[15],[27],[],[],[16],[28],[29,30]>,
  <[11,12],[15],[27],[29],[],[16],[28],[30]>,
  <[11,12],[15],[27],[29,30],[],[16],[28],[]>,
  <[11,12],[15],[27],[],[],[16],[28],[31,32]>,
  <[11,12],[15],[27],[31],[],[16],[28],[32]>,
  <[11,12],[15],[27],[31,32],[],[16],[28],[]>,
  <[11,12],[15],[27,28],[],[],[16],[],[29,30]>,
  <[11,12],[15],[27,28],[29],[],[16],[],[30]>,
  <[11,12],[15],[27,28],[29,30],[],[16],[],[]>,
  <[11,12],[15],[27,28],[],[],[16],[],[31,32]>,
  <[11,12],[15],[27,28],[31],[],[16],[],[32]>,
  <[11,12],[15],[27,28],[31,32],[],[16],[],[]>,
  <[11,12],[15,16],[],[],[],[],[17,18],[21,22]>,
  <[11,12],[15,16],[],[21],[],[],[17,18],[22]>,
  <[11,12],[15,16],[],[21,22],[],[],[17,18],[]>,
  <[11,12],[15,16],[],[],[],[],[17,18],[23,24]>,
  <[11,12],[15,16],[],[23],[],[],[17,18],[24]>,
  <[11,12],[15,16],[],[23,24],[],[],[17,18],[]>,
  <[11,12],[15,16],[17],[],[],[],[18],[21,22]>,
  <[11,12],[15,16],[17],[21],[],[],[18],[22]>,
  <[11,12],[15,16],[17],[21,22],[],[],[18],[]>,
  <[11,12],[15,16],[17],[],[],[],[18],[23,24]>,
  <[11,12],[15,16],[17],[23],[],[],[18],[24]>,
  <[11,12],[15,16],[17],[23,24],[],[],[18],[]>,
  <[11,12],[15,16],[17,18],[],[],[],[],[21,22]>,
  <[11,12],[15,16],[17,18],[21],[],[],[],[22]>,
  <[11,12],[15,16],[17,18],[21,22],[],[],[],[]>,
  <[11,12],[15,16],[17,18],[],[],[],[],[23,24]>,
  <[11,12],[15,16],[17,18],[23],[],[],[],[24]>,
  <[11,12],[15,16],[17,18],[23,24],[],[],[],[]>,
  <[11,12],[15,16],[],[],[],[],[19,20],[21,22]>,
  <[11,12],[15,16],[],[21],[],[],[19,20],[22]>,
  <[11,12],[15,16],[],[21,22],[],[],[19,20],[]>,
  <[11,12],[15,16],[],[],[],[],[19,20],[23,24]>,
  <[11,12],[15,16],[],[23],[],[],[19,20],[24]>,
  <[11,12],[15,16],[],[23,24],[],[],[19,20],[]>,
  <[11,12],[15,16],[19],[],[],[],[20],[21,22]>,
  <[11,12],[15,16],[19],[21],[],[],[20],[22]>,
  <[11,12],[15,16],[19],[21,22],[],[],[20],[]>,
  <[11,12],[15,16],[19],[],[],[],[20],[23,24]>,
  <[11,12],[15,16],[19],[23],[],[],[20],[24]>,
  <[11,12],[15,16],[19],[23,24],[],[],[20],[]>,
  <[11,12],[15,16],[19,20],[],[],[],[],[21,22]>,
  <[11,12],[15,16],[19,20],[21],[],[],[],[22]>,
  <[11,12],[15,16],[19,20],[21,22],[],[],[],[]>,
  <[11,12],[15,16],[19,20],[],[],[],[],[23,24]>,
  <[11,12],[15,16],[19,20],[23],[],[],[],[24]>,
  <[11,12],[15,16],[19,20],[23,24],[],[],[],[]>,
  <[11,12],[15,16],[],[],[],[],[25,26],[29,30]>,
  <[11,12],[15,16],[],[29],[],[],[25,26],[30]>,
  <[11,12],[15,16],[],[29,30],[],[],[25,26],[]>,
  <[11,12],[15,16],[],[],[],[],[25,26],[31,32]>,
  <[11,12],[15,16],[],[31],[],[],[25,26],[32]>,
  <[11,12],[15,16],[],[31,32],[],[],[25,26],[]>,
  <[11,12],[15,16],[25],[],[],[],[26],[29,30]>,
  <[11,12],[15,16],[25],[29],[],[],[26],[30]>,
  <[11,12],[15,16],[25],[29,30],[],[],[26],[]>,
  <[11,12],[15,16],[25],[],[],[],[26],[31,32]>,
  <[11,12],[15,16],[25],[31],[],[],[26],[32]>,
  <[11,12],[15,16],[25],[31,32],[],[],[26],[]>,
  <[11,12],[15,16],[25,26],[],[],[],[],[29,30]>,
  <[11,12],[15,16],[25,26],[29],[],[],[],[30]>,
  <[11,12],[15,16],[25,26],[29,30],[],[],[],[]>,
  <[11,12],[15,16],[25,26],[],[],[],[],[31,32]>,
  <[11,12],[15,16],[25,26],[31],[],[],[],[32]>,
  <[11,12],[15,16],[25,26],[31,32],[],[],[],[]>,
  <[11,12],[15,16],[],[],[],[],[27,28],[29,30]>,
  <[11,12],[15,16],[],[29],[],[],[27,28],[30]>,
  <[11,12],[15,16],[],[29,30],[],[],[27,28],[]>,
  <[11,12],[15,16],[],[],[],[],[27,28],[31,32]>,
  <[11,12],[15,16],[],[31],[],[],[27,28],[32]>,
  <[11,12],[15,16],[],[31,32],[],[],[27,28],[]>,
  <[11,12],[15,16],[27],[],[],[],[28],[29,30]>,
  <[11,12],[15,16],[27],[29],[],[],[28],[30]>,
  <[11,12],[15,16],[27],[29,30],[],[],[28],[]>,
  <[11,12],[15,16],[27],[],[],[],[28],[31,32]>,
  <[11,12],[15,16],[27],[31],[],[],[28],[32]>,
  <[11,12],[15,16],[27],[31,32],[],[],[28],[]>,
  <[11,12],[15,16],[27,28],[],[],[],[],[29,30]>,
  <[11,12],[15,16],[27,28],[29],[],[],[],[30]>,
  <[11,12],[15,16],[27,28],[29,30],[],[],[],[]>,
  <[11,12],[15,16],[27,28],[],[],[],[],[31,32]>,
  <[11,12],[15,16],[27,28],[31],[],[],[],[32]>,
  <[11,12],[15,16],[27,28],[31,32],[],[],[],[]>
];
}
