---
title: Rascal Language Reference
sidebar_position: 7
details:
  - Declarations
  - Patterns
  - Expressions
  - Statements
  - Tests
  - Errors
---

#### Synopsis

Reference manual for the Rascal meta-programming language. 

#### Syntax

#### Types

#### Function

#### Description

Here we describe _all_ features of the Rascal language in detail, for reference purposes.

(((TOC)))

You can find more (accessible) information about programming in Rascal here:

*  [Why Rascal](/docs/WhyRascal/): gives the motivation for the Rascal language and describes various usage scenarios.
*  [Getting Started](/docs/GettingStarted) describes how to download, install and start Rascal. 
*  [Getting Help](/docs/GettingHelp) shows how to use the help facilties and search the documentation. 
*  See [Further Reading](/docs/GettingHelp/FurtherReading/) for a reading guide to the documentation.
*  Library functies are described in [Rascal Libraries](/docs/Library/).
*  We do not maintain a long list of frequently asked questions (FAQ) but 
   use [StackOverflow](http://stackoverflow.com/questions/tagged/rascal) instead.


#### Examples

*  We show examples for each Rascal language construct described here.
*  You can find many simple code examples in [Recipes](/docs/Recipes/). 
*  The [Rascal Libraries](/docs/Library/) contain examples for most functions. 

#### Benefits

*  Rascal has everything you need for any kind of (meta-)program you want to write. See [Why Rascal](/docs/WhyRascal/).

#### Pitfalls

*  Rascal is a procedural/functional language with immutable data. Do not confuse this with object-oriented programming.
*  Rascal allows you to write highly imperative code, but it has declarative constructs that lead to shorter and more readable code.

