#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Scripts to reproduce the results from
#
# T. Richter, R Ulrich, M. Janczyk:
#    "Diffusion models with time-dependent parameters:
#     Comparing the computation effort and accuracy
#     of different numerical methods"
#
# Thomas Richter
# Otto-von-Guericke University of Magdeburg
# 39106 Magdeburg, Germany
# thomas.richter@ovgu.de
#
# You can use this code under ther terms of the
# Creative Commons Attribution 4.0 License

"""
Created on Sat Apr 16 13:03:23 2022

@author: Thomas Richter thomas.richter@ovgu.de
"""

import numpy as np
import matplotlib.pyplot as plt

plt.rcParams['text.usetex'] = True


kfe = np.loadtxt('results/testcase3-kfe.txt')
rw = np.loadtxt('results/testcase3-rw.txt')
sde = np.loadtxt('../C++/results/testcase3-sde.txt')
inte = np.loadtxt('results/testcase3-int.txt')


plt.figure(figsize=(10, 2))

plt.subplots_adjust(left=None, bottom=None, right=None, top=None, wspace=0.15, hspace=0.4)

plt.subplot(121)
plt.xlabel('$\displaystyle \\tau$', labelpad=-10)
plt.ylabel('Error')
plt.title('Reaching upper threshold (CDF)')
plt.loglog(kfe[:,0],kfe[:,4],'-o', label='Kolmogorov Forward Equation')
plt.loglog(inte[:,0],inte[:,4],'-o',label='Integral Equation')
plt.loglog(rw[:,0],rw[:,4],'-o',label='Random Walks')
plt.loglog(sde[:,0],sde[:,4],'-o',label='Stochastic Euler')
#plt.loglog([10,100],[1,0.1])

plt.legend(loc='lower center', bbox_to_anchor=(1.1,-.5), fancybox=True,ncol=2)


#plt.loglog([0.05,0.45],[0.8,2.4],'--',color='gray')
#plt.text(0.08,2.0,'$\displaystyle O(\\sqrt{\Delta t)}$')

#plt.loglog([0.6,2.4],[0.04,0.64],'--',color='gray')
#plt.text(1.6,0.2,'$\displaystyle O(\Delta t^2)$')

plt.loglog([16.4,16.4],[0.02,35],'--', color='gray')
plt.text(6,0.07,'hyperbolic')
plt.text(6,0.03,'time step restr.')

plt.subplot(122)
plt.xlabel('$\displaystyle \\tau$', labelpad=-10)


plt.title('Reaching lower threshold (CDF)')
plt.loglog(kfe[:,0],kfe[:,5],'-o', label='Kolmogorov Forward Equation')
plt.loglog(inte[:,0],inte[:,5],'-o',label='Integral Equation')
plt.loglog(rw[:,0],rw[:,5],'-o',label='Random Walks')
plt.loglog(sde[:,0],sde[:,5],'-o',label='Stochastic Euler')

plt.loglog([16.4,16.4],[0.02,120],'--', color='gray')
plt.text(6,1.1,'hyperbolic')
plt.text(6,0.5,'time step restr.')


#plt.loglog([0.05,0.45],[0.8,2.4],'--',color='gray')
#plt.text(0.08,2.0,'$\displaystyle O(\\sqrt{\Delta t)}$')

#plt.loglog([0.6,2.4],[0.04,0.64],'--',color='gray')
#plt.text(1.6,0.2,'$\displaystyle O(\Delta t^2)$')




plt.savefig('pics/testcase3-1.png', dpi=300,bbox_inches='tight')
plt.show()
