#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Scripts to reproduce the results from
#
# T. Richter, R Ulrich, M. Janczyk:
#    "Diffusion models with time-dependent parameters:
#     Comparing the computation effort and accuracy
#     of different numerical methods"
#
# Thomas Richter
# Otto-von-Guericke University of Magdeburg
# 39106 Magdeburg, Germany
# thomas.richter@ovgu.de
#
# You can use this code under ther terms of the
# Creative Commons Attribution 4.0 License



import numpy as np
import matplotlib.pyplot as plt

plt.rcParams['text.usetex'] = True



kfe = np.loadtxt('results/testcase2-kfe.txt')
rw = np.loadtxt('results/testcase2-rw.txt')
sde = np.loadtxt('../C++/results/testcase2-sde.txt')
integral = np.loadtxt('results/testcase2-int.txt')


plt.figure(figsize=(4,4))

plt.subplots_adjust(left=None, bottom=None, right=None, top=None, wspace=0.15, hspace=0.4)

plt.subplot(211)
plt.xlabel('$\displaystyle \Delta t$')

#plt.title('Convergence: error vs. time step')
plt.ylabel('Error')
plt.loglog(kfe[:,1],kfe[:,3],'-o', label='Kolmogorov Forward Equation')
plt.loglog(integral[:,1],integral[:,3],'-o',label='Integral')
plt.loglog(rw[:,1],rw[:,3],'-o',label='Random Walks')
plt.loglog(sde[:,1],sde[:,3],'-o',label='Stochastic Euler')

plt.loglog([0.08,0.8],[0.4,0.4*np.sqrt(10)],'--',color='gray')
plt.text(0.09,0.2,'$\displaystyle O(\\sqrt{\Delta t)}$')

plt.loglog([1.5,6.],[0.03,0.48],'--',color='gray')
plt.text(1.2,0.18,'$\displaystyle O(\Delta t^2)$')

plt.subplot(212)

#plt.title('Efficiency: computational time vs. error')

plt.ylabel('Comp. Time')
plt.xlabel('Error $\displaystyle \epsilon$')


plt.loglog(kfe[:,3],kfe[:,2],'-o', label='Kolmogorov Forward Equation')
plt.loglog(integral[:,3],integral[:,2],'-o',label='Integral Equation')
plt.loglog(rw[:,3],rw[:,2],'-o',label='Random Walks')
plt.loglog(sde[:,3],sde[:,2],'-o',label='Stochastic Euler')


plt.loglog([0.02,0.32],[0.02,0.005],'--',color='gray')
plt.text(0.03,0.003,'$\displaystyle O(\epsilon^{-\\frac{1}{2}})$')


plt.loglog([0.5,2],[0.16,0.01],'--',color='gray')
plt.text(0.3,0.02,'$\displaystyle O(\epsilon^{-2})$')

plt.loglog([0.01,0.1],[2.,2./31.6],'--',color='gray')
plt.text(0.02,1.,'$\displaystyle O(\epsilon^{-\\frac{3}{2}})$')


plt.loglog([0.8,1.6],[4,0.25],'--',color='gray')
plt.text(1.3,1.,'$\displaystyle O(\epsilon^{-4})$')


plt.legend(loc=(1.04,1.9))
plt.savefig('pics/testcase2.png',bbox_inches = 'tight', dpi=300)

plt.show()
