#!/usr/bin/env python3
# -*- coding: utf-8 -*-


# Scripts to reproduce the results from
#
# T. Richter, R Ulrich, M. Janczyk:
#    "Diffusion models with time-dependent parameters:
#     Comparing the computation effort and accuracy
#     of different numerical methods"
#
# Thomas Richter
# Otto-von-Guericke University of Magdeburg
# 39106 Magdeburg, Germany
# thomas.richter@ovgu.de
#
# You can use this code under ther terms of the
# Creative Commons Attribution 4.0 License


import numpy as np
import matplotlib.pyplot as plt

plt.rcParams['text.usetex'] = True

# Plots accuracy and efficiency of the three different methods
# for Case I.
# Requires txt-files with the results

kfe = np.loadtxt('results/testcase1-kfe.txt')
rw = np.loadtxt('results/testcase1-rw.txt')
intm = np.loadtxt('results/testcase1-int.txt')
sde = np.loadtxt('../C++/results/testcase1-sde.txt')[:-1,:]


plt.figure(figsize=(8, 4))

plt.subplots_adjust(left=None, bottom=None, right=None, top=None, wspace=0.15, hspace=0.4)

plt.subplot(221)
plt.xlabel('$\displaystyle \Delta t$')
plt.ylabel('Error')


plt.title('Upper threshold')
plt.loglog(kfe[:,1],kfe[:,3],'-o', label='Kolmogorov Forward Equation')
plt.loglog(intm[:,1],intm[:,3],'-o', label='Integral Method')
plt.loglog(rw[:,1],rw[:,3],'-o',label='Random Walks')
plt.loglog(sde[:,1],sde[:,3],'-o',label='Stochastic Euler')



### ^2
plt.loglog([1,10.0],[0.02,2.],'--',color='gray')
plt.text(1.4,0.018,'$\displaystyle O(\Delta t^2)$')

## sqrt
plt.loglog([0.05,0.5],[0.3,0.3*np.sqrt(10.0)],'--',color='gray')
plt.text(0.08,0.16,'$\displaystyle O(\\sqrt{\Delta t)}$')

### linear
plt.loglog([0.05,0.5],[0.008,0.08],'--',color='gray')
plt.text(0.08,0.006,'$\displaystyle O(\Delta t)$')




plt.subplot(222)
plt.xlabel('$\displaystyle \Delta t$')


plt.title('Lower threshold')
plt.loglog(kfe[:,1],kfe[:,4],'-o', label='Kolmogorov Forward Equation')
plt.loglog(intm[:,1],intm[:,4],'-o', label='Integral Method')
plt.loglog(rw[:,1],rw[:,4],'-o',label='Random Walks')
plt.loglog(sde[:,1],sde[:,4],'-o',label='Stochastic Euler')

plt.loglog([0.05,0.45],[1.6,4.8],'--',color='gray')
plt.text(0.08,1.,'$\displaystyle O(\\sqrt{\Delta t)}$')


plt.loglog([0.1,1.0],[0.1,1.0],'--',color='gray')
plt.text(0.2,0.1,'$\displaystyle O(\Delta t)$')


plt.loglog([3.,12.],[0.02,0.32],'--',color='gray')
plt.text(6.,0.04,'$\displaystyle O(\Delta t^2)$')



plt.subplot(223)

plt.xlabel('Error $\displaystyle \epsilon$')
plt.ylabel('Comp. Time')


plt.loglog(kfe[:,3],kfe[:,2],'-o', label='Kolmogorov Forward Equation')
plt.loglog(intm[:,3],intm[:,2],'-o', label='Integral Mehtod')
plt.loglog(rw[:,3],rw[:,2],'-o',label='Random Walks')
plt.loglog(sde[:,3],sde[:,2],'-o',label='Stochastic Euler')


plt.loglog([0.01,0.1],[0.4,0.04],'--',color='gray')
plt.text(0.02,0.3,'$\displaystyle O(\epsilon^{-1})$')

plt.loglog([0.12,1.92],[0.05,0.0125],'--',color='gray')
plt.text(0.4,0.05,'$\displaystyle O(\epsilon^{-\\frac{1}{2}})$')

plt.loglog([0.8,1.6],[3.2,0.2],'--',color='gray')
plt.text(1.2,1.1,'$\displaystyle O(\epsilon^{-4})$')

plt.loglog([0.016,0.004],[0.02,0.02*4.0*np.sqrt(4.0)],'--',color='gray')
plt.text(0.005,0.007,'$\displaystyle O(\epsilon^{-\\frac{3}{2}})$')


plt.subplot(224)
plt.xlabel('Error $\displaystyle \epsilon$')


plt.loglog(kfe[:,4],kfe[:,2],'-o', label='Kolmogorov Forward Equation')
plt.loglog(intm[:,4],intm[:,2],'-o', label='Integral Equation')
plt.loglog(rw[:,4],rw[:,2],'-o',label='Random Walks')
plt.loglog(sde[:,4],sde[:,2],'-o',label='Stochastic Euler')

plt.loglog([0.16,1.6],[0.2,0.02],'--',color='gray')
plt.text(0.4,0.1,'$\displaystyle O(\epsilon^{-1})$')

plt.loglog([0.16,2.56],[0.016,0.004],'--',color='gray')
plt.text(0.16,0.004,'$\displaystyle O(\epsilon^{-\\frac{1}{2}})$')

plt.loglog([3,6],[2,0.125],'--',color='gray')
plt.text(1.3,0.2,'$\displaystyle O(\epsilon^{-4})$')

#plt.legend(loc=(-.35,1.02),prop={'size': 7})
plt.legend(loc='lower center', bbox_to_anchor=(0,-.7), fancybox=True,ncol=2)

plt.savefig('pics/testcase1.png', dpi=300, bbox_inches='tight')

plt.show()
