% This is a matlab script that generates the input data

% the configuation approximately the ISOMIP+ experiment no. 1
% require matlab functions for equation of state

% Dimensions of grid
nx=242; 
ny=1;
nz=36;
dz = -20.0;
z_top = 0.0;
dx = 2000.0;
domain_length = 480e3;
shelf_length = 320e3;

eos = 'linear';
acc = 'real*8';

XG = [-dx:dx:domain_length];
XC = XG+dx/2;
ZG = [z_top:dz:(z_top+nz*dz)-dz];
ZC = ZG + dz/2;

% Bathymetry
H = -720;
bathy = ones(nx,ny)*H;
bathy([1 end],:)=0;

fid=fopen('bathy.box','w','b'); fwrite(fid,bathy,acc);fclose(fid);

% Ice draft
nx_shelf = floor((shelf_length / domain_length)*nx);
open_ocean_indexes=[nx_shelf:nx];
Hmin = -640; 
Hmax = -120;
dHdx = (Hmax-Hmin)/shelf_length;

icetopo = transpose(min(Hmax,Hmin + dHdx*(XC-XG(1)))) *ones(1,ny);
icetopo(open_ocean_indexes,:) = 0.0;
fid=fopen('icetopo.bin','w','b'); fwrite(fid,icetopo,acc);fclose(fid);

phi0surf = zeros(nx,ny);
fid=fopen('phi0surf.bin','w','b'); fwrite(fid,phi0surf,acc);fclose(fid);


% Files specifying T and S restoring on the Northern boundary
Tref = 1.0; Tmin = -2.1; Tmax = Tref;
Sref = 34.4; Smin = 34.35; Smax = Sref;




% % Specify mean velocity on Northern boundary
% Umean = zeros(nx,nz);
% fid = fopen('OB_N_U.bin', 'w', 'b'); fwrite(fid, Umean, acc); fclose(fid);
% fid = fopen('OB_N_V.bin', 'w', 'b'); fwrite(fid, Umean, acc); fclose(fid);
% fid = fopen('OB_N_W.bin', 'w', 'b'); fwrite(fid, Umean, acc); fclose(fid);


% RBCS: Create files for relaxation of temperature and salinity near the open boundary
% and the initial conditons 

Tsurf = -1.9;
Tbot = 1.0;
Ssurf = 33.8;
Sbot = 34.7;
TresN = zeros(nx,ny,nz);
SresN = zeros(nx,ny,nz);
for k=1:nz
    zi = ZG(k);
    TresN(:,:,k)=(Tbot - Tsurf)*zi/ZG(end) + Tsurf;
    SresN(:,:,k)=(Sbot - Ssurf)*zi/ZG(end) + Ssurf;
end

fid = fopen('RBC_Trelax.bin', 'w', 'b'); fwrite(fid, TresN, acc); fclose(fid);
fid = fopen('RBC_Srelax.bin', 'w', 'b'); fwrite(fid, SresN, acc); fclose(fid);

sponge_fraction = 0.02;
sponge_cutoff = domain_length*sponge_fraction;
mask = zeros(nx,ny,nz);
for i = 1:nx
  x = XG(i);
  
  % use XG(end-1) so that the second last cell has max restoring
  % this means in the 'wall' cell you get a slightly lower 
  %restoring hopefully this wont make a difference
  if abs(x-XG(end-1)) < sponge_cutoff
      mask(i,:,:) = (sponge_cutoff - abs(x-XG(end-1)))/sponge_cutoff;
      
     
  end
end
% imagesc(mask);
% colorbar()
% disp(mask)
fid = fopen('RBC_Trelax_mask.bin', 'w', 'b'); fwrite(fid, mask, acc); fclose(fid);
fid = fopen('RBC_Srelax_mask.bin', 'w', 'b'); fwrite(fid, mask, acc); fclose(fid);

