% This is a matlab script that generates the input data

% the configuation approximately the ISOMIP experiment no. 1
% require matlab functions for equation of state

% Dimensions of grid
nx=1; %nxi=20;
ny=200;
nz=102;
dz = -1.0;
z_top = -498.0;
dy = 50.0;

eos = 'linear';
acc = 'real*8';

YG = [0:dy:10000.0-dy];
YC = YG+dy/2;
ZG = [z_top:dz:(z_top+nz*dz)-dz];
ZC = ZG + dz/2;

% Bathymetry
H = -600;
bathy = ones(nx,ny)*H;
bathy(:,1) = 0;
fid=fopen('bathy.box','w','b'); fwrite(fid,bathy,acc);fclose(fid);

% Ice draft
Hmin = -598; 
Hmax = -498;
dHdx = (Hmax-Hmin)/10000.0;

icetopo = ones(nx,1)*min(Hmax,Hmin + dHdx*(YC-YG(1)));
fid=fopen('icetopo.bin','w','b'); fwrite(fid,icetopo,acc);fclose(fid);

phi0surf = zeros(nx,ny);
fid=fopen('phi0surf.bin','w','b'); fwrite(fid,phi0surf,acc);fclose(fid);


% Files specifying T and S restoring on the Northern boundary
Tref = 1.0; Tmin = -2.1; Tmax = Tref;
Sref = 34.4; Smin = 34.35; Smax = Sref;

%Tprof = linspace(Tmin,Tmax,nz);
%Sprof = linspace(Smin,Smax,nz);
%TresN = ones(1,nx).'*Tprof;
TresN = Tref*ones(nx,nz);
%SresN = ones(1,nx).'*Sprof;
SresN = Sref*ones(nx,nz);

fid = fopen('OB_N_T.bin', 'w', 'b');
fwrite(fid, TresN, acc);
fclose(fid);
fid = fopen('OB_N_S.bin', 'w', 'b');
fwrite(fid, SresN, acc);
fclose(fid);

% % Specify mean velocity on Northern boundary
% Umean = zeros(nx,nz);
% fid = fopen('OB_N_U.bin', 'w', 'b'); fwrite(fid, Umean, acc); fclose(fid);
% fid = fopen('OB_N_V.bin', 'w', 'b'); fwrite(fid, Umean, acc); fclose(fid);
% fid = fopen('OB_N_W.bin', 'w', 'b'); fwrite(fid, Umean, acc); fclose(fid);


% RBCS: Create files for relaxation of temperature and salinity near the open boundary
TresN = (Tref)*ones(nx,ny,nz);
SresN = Sref*ones(nx,ny,nz);
fid = fopen('RBC_Trelax.bin', 'w', 'b'); fwrite(fid, TresN, acc); fclose(fid);
fid = fopen('RBC_Srelax.bin', 'w', 'b'); fwrite(fid, SresN, acc); fclose(fid);

mask = zeros(nx,ny,nz);
for j = 1:ny
  y = YC(j);
  for k = 1:nz
    z = ZC(k);
    % d = ( (y - YC(end))^2 + (z - ZC(end))^2 )^0.5;
    % mask(:,j,k) = max([round(1-d/80.0), 0.0]);
    if abs(z - ZC(end)) < 120.0 && abs(y-YC(end)) < 600.0
      mask(:,j,k) = 1.0;
    end
  end
end
% imagesc(mask);
% colorbar()
% disp(mask)
fid = fopen('RBC_Trelax_mask.bin', 'w', 'b'); fwrite(fid, mask, acc); fclose(fid);
fid = fopen('RBC_Srelax_mask.bin', 'w', 'b'); fwrite(fid, mask, acc); fclose(fid);

