import  scipy.signal.signaltools
from os import listdir
from os.path import isfile, join
import pandas as pd
import warnings
from joblib import load
# Import for LIME
import lime
import lime.lime_tabular
import matplotlib
import matplotlib.pyplot as plt
import numpy as np

warnings.filterwarnings("ignore")


def _centered(arr, newsize):
    # Return the center newsize portion of the array.
    newsize = np.asarray(newsize)
    currsize = np.array(arr.shape)
    startind = (currsize - newsize) // 2
    endind = startind + newsize
    myslice = [slice(startind[k], endind[k]) for k in range(len(endind))]
    return arr[tuple(myslice)]

scipy.signal.signaltools._centered = _centered



def generate_limeExp(dump_file: str, train_data: str, test_data: str) -> None:

    print("Loading classifier...")

    features = ["patient_freewill","patient_age","patient_health","doctor_x","doctor_y","robot_speed","robot_charge"]
    outcome = "success"

    freewill_mapping = {
        "foc" : 0,
        "distr" : 1,
        "free" : 2
    }

    age_mapping = {
        "y" : 0,
        "e" : 1
    }

    health_mapping = {
        "h" : 0,
        "s" : 1,
        "u" : 2
    }

    classifier = load(dump_file) 


    dataset = pd.read_csv(train_data)
    X_train = dataset[features].replace({'patient_freewill': freewill_mapping}).replace({'patient_age': age_mapping}).replace({'patient_health': health_mapping}).to_numpy()
    y_train = dataset[["success"]].to_numpy()
    dataset = pd.read_csv(test_data)
    X_test = dataset[features].replace({'patient_freewill': freewill_mapping}).replace({'patient_age': age_mapping}).replace({'patient_health': health_mapping}).to_numpy()
    y_test = dataset[["success"]].to_numpy()

    # construct a lime explainer
    print("Building LIME explainer...")
    lime_explainer = lime.lime_tabular.LimeTabularExplainer(
                                training_data = X_train,
                                mode='classification',
                                training_labels=y_train,
                                feature_names=features,
                                class_names = ['Failure', 'Success'],
                                discretize_continuous=True,
                                random_state = 1234)

    instance = np.reshape([2, 1, 1, 3062.5, 761.2, 40.0, 12.2], (1,7)) # failure example
    print('HMT mission from {} has probability {}'.format(instance[0,:], classifier.predict_proba(instance[0:,])[0][1]))

    #generate a LIME local explanation of the instance
    print("Building LIME local explanation of the instance...")
    lime_local_explanation = lime_explainer.explain_instance(
                               data_row = instance[0,:],
                               predict_fn = classifier.predict_proba,
                               num_features=7,
                               top_labels=1)

    # visual LIME
    exp = lime_local_explanation.as_list(label = lime_local_explanation.available_labels()[0])

    # textual explanation
    print(exp)

    print("Creating visual explanation...")
    # visual explanation
    matplotlib.rcParams.update({'font.size': 11})
    xticks = np.arange(-0.4, 0.45, 0.1)
    #yticks = np.arange(-0.25, 0.05, 0.25)
    #yrange = (yticks[0], yticks[-1])
    fig = plt.figure(figsize=[6.0, 3.0])
    vals = [x[1] for x in exp]
    names = [x[0] for x in exp]
    names[1] = 'patient_freewill is nom' # failure example
    names[2] = 'patient_health is heal' # failure example
    names[6] = 'patient_age is eld' # both examples
    vals.reverse()
    names.reverse()
    colors = ['red' if x > 0 else 'green' for x in vals]
    pos = np.arange(len(exp)) + .5
    plt.barh(pos, vals, align='center', color=colors)
    plt.yticks(pos, names)
    plt.xticks(xticks)
    plt.gca().xaxis.grid(True)
    plt.xlabel('weight')
    plt.ylabel('feature')
    #title = 'Local explanation for class %s' % lime_local_explanation.class_names[1]
    #plt.title(title)
    fig.tight_layout()
    fig.savefig('plots/lime_failure.pdf', bbox_inches='tight', pad_inches=0.1) # failure example

    instance = np.reshape([2, 1, 1, 3062.5, 761.2, 85.0, 12.2], (1,7)) # success example
    print('HMT mission from {} has probability {}'.format(instance[0,:], classifier.predict_proba(instance[0:,])[0][1]))

    #generate a LIME local explanation of the instance
    print("Building LIME local explanation of the instance...")
    lime_local_explanation = lime_explainer.explain_instance(
                               data_row = instance[0,:],
                               predict_fn = classifier.predict_proba,
                               num_features=7,
                               top_labels=1)

    # visual LIME
    exp = lime_local_explanation.as_list(label = lime_local_explanation.available_labels()[0])

    # textual explanation
    print(exp)

    print("Creating visual explanation...")
    # visual explanation
    matplotlib.rcParams.update({'font.size': 11})
    xticks = np.arange(-0.4, 0.45, 0.1)
    #yticks = np.arange(-0.25, 0.05, 0.25)
    #yrange = (yticks[0], yticks[-1])
    fig = plt.figure(figsize=[6.0, 3.0])
    vals = [x[1] for x in exp]
    names = [x[0] for x in exp]
    names[0] = 'patient_freewill is nom' # success example
    names[1] = 'patient_health is heal' # success example
    names[6] = 'patient_age is eld' # both examples
    vals.reverse()
    names.reverse()
    colors = ['green' if x > 0 else 'red' for x in vals]
    pos = np.arange(len(exp)) + .5
    plt.barh(pos, vals, align='center', color=colors)
    plt.yticks(pos, names)
    plt.xticks(xticks)
    plt.gca().xaxis.grid(True)
    plt.xlabel('weight')
    plt.ylabel('feature')
    #title = 'Local explanation for class %s' % lime_local_explanation.class_names[1]
    #plt.title(title)
    fig.tight_layout()
    fig.savefig('plots/lime_success.pdf', bbox_inches='tight', pad_inches=0.1) # success example


def main():
    generate_limeExp("data/best_classifier.joblib", "data/formalise2023_dataset500.csv", "data/formalise2023_dataset500_2.csv")

if __name__ == "__main__":
    main()
