# Formalise 2023 submission 1917

Anonymized replication package of submission #1917: "Explainable Human-Machine Teaming using Model Checking and Interpretable Machine Learning".

## Requirements

* `Python (>= 3)`
* `sklearn lib (>= 1.2)`
* `xgboost lib (>= 1.7)`
* `pandas lib (>= 1.5)`
* `numpy lib (>= 1.23)`
* `seaborn lib (>= 0.12)`
* `psutils lib (>= 5.9)`
* `joblib lib (>= 1.2)`
* `matplotlib lib (>= 3.6)`
* `lime lib (>= 0.2)`

## Package structure

- `data/`: raw data of SMC results (both verification outcomes and resources), dump of the best classifier;
- `plots/`: plots generated by running `python` scripts.
- `.`: `python` scripts to replicate the results.

## Scripts

**Building and validating the classifiers**:

Run the following script to generate the results. The outcome of the AUC validation can be found in `plots/xvalidation_auc.pdf`

```
python build_models.py
```

**Computing the cost**:

Run the following script to generate the results. The outcome of the cost analysis can be found in `plots/cost_mem.pdf`, `plots/cost_time.pdf`.

```
python compute_cost.py
```

**Computing the explanations**:

Run the following scripts to generate the results. The outcome of PDP and LIME explanations can be found in `plots/pdp_*time*.pdf`, `plots/lime_*.pdf`.

```
python explainer_global.py
python explainer_local.py
```