

function figure_of_merit_dc_bolometer()
	
	
	close all
	global customFontSize % customLineWidth customMarkerSize
    customFontSize = 12; % customLineWidth=1.5; customMarkerSize=2;
    set(0,'DefaultAxesFontSize', customFontSize);
	
	
	load('noise_0bias_Pp_0dBm_fp_594750kHz.dat.mat');
	data_noise = data;
	figure('name','Noise density','units','centimeters','Position', [11 2 9 8]); loglog(data_noise(1,:),data_noise(2,:),'.','markersize',2);
	xlabel('Noise frequency (Hz)','interpreter','latex','fontsize',15);
	ylabel('Noise density (V/$\sqrt{\rm{Hz}}$)','interpreter','latex','fontsize',15);
	xticks([1,1e2,1e4,1e6]);
	xlim([1,5e6]);
	dim = [0 0.92 .1 .09];
	str = '(b)';
	annotation('textbox',dim,'String',str,'fontname','Helvetica','FitBoxToText','off','backgroundColor','white','EdgeColor','None','HorizontalAlignment','right','fontsize',14,'FontWeight','bold');
	%print('noise_300dpi','-dpng','-r300')
	
	load('nep_0bias_Pp_0dBm_fp_594750kHz.dat.mat');
	data_nep = data;
	figure('name','NEP','units','centimeters','Position', [20 2 9 8]); loglog(data_nep(1,:),data_nep(2,:),'.','markersize',2);
	xlabel('Noise frequency (Hz)','interpreter','latex','fontsize',15);
	ylabel('NEP (W/$\sqrt{\rm{Hz}}$)','interpreter','latex','fontsize',15);
	xticks([1,1e2,1e4,1e6]);
	xlim([1,5e6]);
	dim = [0 0.92 .1 .09];
	str = '(a)';
	annotation('textbox',dim,'String',str,'fontname','Helvetica','FitBoxToText','off','backgroundColor','white','EdgeColor','None','HorizontalAlignment','right','fontsize',14,'FontWeight','bold');
	%print('NEP_300dpi','-dpng','-r300')
	
	load('timetrace_0dBm_594750KHz.mat');
	data_tt = data;
	f = figure('name','Timetrace','units','centimeters','Position', [2 2 9 8]); plot(data_tt(1,:)*1e3,data_tt(2,:)*1e3,'-','markersize',2,'linewidth',1.5);
	hold on; plot(data_tt(1,:)*1e3,data_tt(3,:)*1e3+3.5,'-','markersize',2,'linewidth',1.5);
	hold on; plot(data_tt(1,:)*1e3,data_tt(4,:)*1e3,'-','linewidth',1.5,'color','#77AC30');
	legend({'Real','Imag','Single-exponential fit'},'interpreter','latex','fontsize',13);
	xlabel('Time (ms)','interpreter','latex','fontsize',15);
	ylabel('Digitized voltage (mV)','interpreter','latex','fontsize',15);
	ylim([-1,0.8])
	% the following adds an y-axis break  
	
	dim = [0.06 .31 .1 .09];
	str = '- 4';
	annotation('textbox',dim,'String',str,'fontname','Helvetica','FitBoxToText','off','backgroundColor','white','EdgeColor','None','HorizontalAlignment','right','fontsize',11);	
	dim = [0.03 0.12 .13 0.09];
	str = '- 4.5';
	annotation('textbox',dim,'String',str,'fontname','Helvetica','FitBoxToText','off','backgroundColor','white','EdgeColor','None','HorizontalAlignment','right','fontsize',11);
	axes('units','centimeters','Position',[1.3 3.7 .5 .5]);
	px=[1 5];
	py1=[1 2];
	height=1;
	py2=py1+height;
	plot(px,py1,'k','LineWidth',1);hold all;
	plot(px,py2,'k','LineWidth',1);hold all;
	fill([px flip(px)],[py1 flip(py2)],'w','EdgeColor','none');
	box off;
	axis off;
	dim = [0 0.92 .1 .09];
	str = '(c)';
	annotation('textbox',dim,'String',str,'fontname','Helvetica','FitBoxToText','off','backgroundColor','white','EdgeColor','None','HorizontalAlignment','right','fontsize',14,'FontWeight','bold');
	
	%print('timetrace_300dpi','-dpng','-r300')
	
	
	%%%% unrelated, plot IV curves
	
	f = figure('name','IV','units','centimeters','Position', [2 2 9 8]);
	plot(data{1}*1e6,data{2}*1e3,'.',data{3}*1e6,data{4}*1e3,'.');
	xlabel('Current (uA)','interpreter','latex','fontsize',15); ylabel('Voltage (mV)','interpreter','latex','fontsize',15);
	legend({'$T_{\rm{b}} = 10\, \rm{mK}$','Room temperature'},'interpreter','latex','fontsize',13);
	
	
	
end