## Github Repository for
# Seasonal activities of the phyllosphere microbiome of perennial crops

## by Adina Howe, Nejc Stopnisek, Shane K. Dooley, Fan Yang, Keara L. Grady, and Ashley Shade


<i>This work is published.</i>


### Data
The raw data (metagenomes and metatranscriptomes) for this study are available in the Joint Genomes Institute Genome Portal (https://genome.jgi.doe.gov/portal/ Project ID [503249](https://genome.jgi.doe.gov/portal/Seadynanfunction)) with projects designated by year and product type.  The MAG genomes analyzed in this paper are available on NCBI, as bioproject [PRJNA800073](https://www.ncbi.nlm.nih.gov/bioproject/PRJNA800073).


### To cite this work or code
Howe A, N Stopnisek, SK Dooley, F Yang, KL Grady and A Shade.  2023. Seasonal activities of the phyllosphere microbiome of perennial crops. Nature Communications.  


### Abstract
Plants and microorganisms form beneficial associations. Understanding plant-microbe interactions will inform microbiome management to enhance crop productivity and resilience to stress. Here, we apply a genome-centric approach to identify ecologically important leaf microbiome members on field-grown switchgrass and miscanthus and to quantify their activities for switchgrass over two growing seasons. We integrate metagenome and metatranscriptome sequencing from 192 leaf samples collected over representative time points in crop phenology. We curated 40 medium- and high-quality metagenome-assembled-genomes (MAGs) and focused analysis on seasonal transcript recruitment to them. Classes represented by these focal MAGs (Actinomycetia, Alpha- and Gamma- Proteobacteria, and Bacteroidota) were active and had increases in transcripts for short-chain dehydrogenase, molybdopterin oxidoreductase, and polyketide cyclase in the late season. The majority of MAGs had activated stress-associated pathways, including trehalose metabolism, indole acetic acid degradation, betaine biosynthesis, and reactive oxygen species degradation, suggesting direct engagement with the host environment. We also detected seasonally activated biosynthetic pathways for terpenes (carotenoids and isoprenoids) and for various non-ribosomal peptide pathways that were poorly annotated. Overall, this study overcame laboratory and bioinformatic challenges associated with field-based leaf metatranscriptome analysis to inform both general and likely specialized activities of these phyllosphere populations. These activities collectively support that leaf-associated bacterial populations are seasonally dynamic, responsive to host cues, and interactively engage in feedback with the plant. 

### Organization of this repository
This analysis represented quality filtering of metagenomes and metatranscriptomes (data-preparation folder), metagenome assemblies (metagenome-assembly folder) and metagenome-assembled genome binning, curation, refinement, annotation (mag-evaluation folder).  Abundances of sequencing libraries were calculated based on reads mapped (mapping folder).  Additionallly, analysis of our annotated results are also included (analysis folder).  



### Funding
Support for this research was provided by the Great Lakes Bioenergy Research Center, U.S. Department of Energy, Office of Science, Office of Biological and Environmental Research (Awards DE-SC0018409 and DE-FC02-07ER64494), by the National Science Foundation Long-term Ecological Research Program (DEB 1637653 and 1832042) at the Kellogg Biological Station, by Michigan State University AgBioResearch, and by the DOE Center for Advanced Bioenergy and Bioproducts Innovation (US Department of Energy, Office of Science, Office of Biological and Environmental Research under award number DE-SC0018420).  This work was also supported in part by Michigan State University through computational resources provided by the Institute for Cyber-Enabled Research and in part by the University of Wisconsin-Madison Wisconsin Energy Institute as supported by GLBRC Information Services. The work conducted by the U.S. Department of Energy Joint Genome Institute, a DOE Office of Science User Facility, is supported under Contract No. DE-AC02-05CH11231.  AS acknowledges support by the USDA National Institute of Food and Agriculture and Michigan State University AgBioResearch. NS acknowledges support from the Michigan State University Plant Resilience Institute.  



### More info
[ShadeLab](http://ashley17061.wixsite.com/shadelab/home)

[GERMS Lab](http://www.germslab.org/about/)

[GLBRC](https://www.glbrc.org/)

[CABBI](https://cabbi.bio/)
