# -*- coding: utf-8 -*-
"""parsingGBKantismah.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1qDa4pQZ1oHPpbRv-WhpUZQc9ukmxIElM

This is the notbook for parsing the start and stop position of predicted BGCs
identified by antiSMASH from the switchgrass and miscanthus phyllosphere.
"""

try:
    import google.colab
    # Running on Google Colab, so install Biopython first
    !pip install biopython
except ImportError:
    pass

import Bio
from Bio import SeqIO
import pandas as pd
import os
import glob

from google.colab import drive
drive.mount('/content/drive')

"""Now we can import our .gbk file and extract information."""

CDSstart=[]
CDSend=[]
CDSsource=[]

for filepath in glob.glob(os.path.join('/content/drive/MyDrive/Colab Notebooks/bgc_prediction', '*.gbk')):
  for rec in SeqIO.parse(filepath, "genbank"):
    if rec.features:
      for feature in rec.features:
        if feature.type == "CDS":
          #print (feature.location)
          CDSstart.append(feature.location.start)
          CDSend.append(feature.location.end)
          CDSsource.append(rec.description)
          df=pd.DataFrame(list(zip(CDSsource, CDSstart,CDSend)),
                columns=['contig','start', 'end'])

print(df)
df.to_csv(r'/content/drive/MyDrive/Colab Notebooks/bgcPosition.csv', index=None, sep='\t', mode='a')

COREposition=[]
COREend=[]
CDSsource=[]
CDSdesc=[]
CDSprod=[]
for filepath in glob.glob(os.path.join('/content/drive/MyDrive/Colab Notebooks/bgc_prediction', '*.gbk')):
  for rec in SeqIO.parse(filepath, "genbank"):
    if rec.features:
      for feature in rec.features:
        print(feature)
       if feature.type == "protocluster":
          COREposition.append(feature.qualifiers['core_location'])
          #COREend.append(feature.location.end)
          CDSsource.append(rec.description)
          CDSdesc.append(feature.qualifiers['detection_rule'])
          CDSprod.append(feature.qualifiers['product'])
          df=pd.DataFrame(list(zip(CDSsource, COREposition,CDSdesc,CDSprod)),
                columns=['contig','position', 'desc', 'product'])

print(df)

df.to_csv(r'/content/drive/MyDrive/Colab Notebooks/bgcCorePositionDescription.csv', index=None, sep='\t', mode='a')
