SELECT 
        l.problem AS problem,
        l.real AS pq_time,
        r.real AS virtual_best_time,
        (r.real/l.real) AS speedup,
        l.result AS pq_result
	FROM pq AS l
	LEFT JOIN (SELECT id,MIN(real) AS real FROM (
		SELECT * FROM caqe WHERE status = 'ok'
		UNION ALL
		SELECT * FROM depqbf WHERE status = 'ok'
		UNION ALL
		SELECT * FROM rareqs WHERE status = 'ok'
		)
		GROUP BY id
		ORDER BY real) AS r
	ON l.id = r.id
	WHERE (l.result = 'SATISFIABLE' OR l.result = 'UNSATISFIABLE')
    ORDER BY speedup DESC
