set datafile separator '|'

set terminal pngcairo
set output "qbf22.png"

set key left top

plot \
'<sqlite3 qbf22.db "SELECT real FROM caqe WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "caqe", \
'<sqlite3 qbf22.db "SELECT real FROM depqbf WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "depqbf", \
'<sqlite3 qbf22.db "SELECT real FROM rareqs WHERE status = ''ok'' ORDER BY real ASC"' u 0:1 w point title "rareqs", \
'<sqlite3 qbf22.db < qbf22-vbs.sql' u 0:1 w point title "vbs", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_depqbf WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-depqbf", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_caqe WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-caqe", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_rareqs WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-rareqs", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_portfolio_depqbf_rareqs WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-port: depqbf,rareqs", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_portfolio_depqbf_caqe WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-port: depqbf,caqe", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_portfolio_depqbf_caqe WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-port: rareqs,caqe", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_portfolio_depqbf_caqe_rareqs WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-port: all 3" \
;

# With pre-processing at leaves:
set output "qbf22-preprocessed-leaves.png"

plot \
'<sqlite3 qbf22.db < qbf22-vbs.sql' u 0:1 w point title "vbs", \
'<sqlite3 qbf22.db < qbf22-bvbs.sql' u 0:1 w point title "bvbs", \
'<sqlite3 qbf22.db "SELECT real FROM bcaqe WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "bcaqe", \
'<sqlite3 qbf22.db "SELECT real FROM bdepqbf WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "bdepqbf", \
'<sqlite3 qbf22.db "SELECT real FROM brareqs WHERE status = ''ok'' ORDER BY real ASC"' u 0:1 w point title "brareqs", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_bloqqer_depqbf WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-depqbf", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_bloqqer_caqe WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-caqe", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_bloqqer_rareqs WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-rareqs", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_portfolio_bloqqer_depqbf_rareqs WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-port: depqbf,rareqs", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_portfolio_bloqqer_depqbf_caqe WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-port: depqbf,caqe", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_portfolio_bloqqer_depqbf_caqe WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-port: rareqs,caqe", \
'<sqlite3 qbf22.db "SELECT real FROM pq_16c_portfolio_bloqqer_depqbf_caqe_rareqs WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-port: all 3" \
;

# '<sqlite3 qbf22.db "SELECT real FROM pq_16c_bloqqer_depqbf WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-bloqqer-depqbf", \
# '<sqlite3 qbf22.db "SELECT real FROM pq_16c_portfolio_bloqqer_depqbf_caqe_rareqs WHERE result = ''SATISFIABLE'' OR result = ''UNSATISFIABLE'' ORDER BY real ASC"' u 0:1 w point title "pq-bloqqer-port: all 3" \

set output "qbf22-depqbf-scatter.png"

set xlabel "DepQBF"
set ylabel "PQ-DepQBF"
set key below 

plot \
'<sqlite3 qbf22.db "SELECT depqbf.real,pq_16c_depqbf.real FROM depqbf INNER JOIN pq_16c_depqbf ON depqbf.id = pq_16c_depqbf.id WHERE depqbf.status = ''ok'' ORDER BY depqbf.id"' u 1:2 w point title "Solved by DepQBF", \
'<sqlite3 qbf22.db "SELECT depqbf.real,pq_16c_depqbf.real FROM depqbf INNER JOIN pq_16c_depqbf ON depqbf.id = pq_16c_depqbf.id WHERE pq_16c_depqbf.status = ''ok'' ORDER BY depqbf.id"' u 1:2 w point title "Solved by PQ-DepQBF" \
;

set output "qbf22-all3-scatter.png"

set xlabel "All3"
set ylabel "Caqe/DepQBF/RaReQs"
set key below 
set logscale x
set logscale y

plot \
'<sqlite3 qbf22.db "SELECT r.real,l.real FROM depqbf AS l INNER JOIN pq_16c_portfolio_depqbf_caqe_rareqs AS r ON l.id = r.id WHERE l.status = ''ok'' AND r.status = ''ok'' ORDER BY l.id"' u 1:2 w point title "DepQBF", \
'<sqlite3 qbf22.db "SELECT r.real,l.real FROM caqe AS l INNER JOIN pq_16c_portfolio_depqbf_caqe_rareqs AS r ON l.id = r.id WHERE l.status = ''ok'' AND r.status = ''ok''  ORDER BY l.id"' u 1:2 w point title "Caqe", \
'<sqlite3 qbf22.db "SELECT r.real,l.real FROM rareqs AS l INNER JOIN pq_16c_portfolio_depqbf_caqe_rareqs AS r ON l.id = r.id WHERE l.status = ''ok'' AND r.status = ''ok''  ORDER BY l.id"' u 1:2 w point title "RaReQs", \
'<sqlite3 qbf22.db "SELECT l.real,r.real FROM pq_16c_portfolio_depqbf_caqe_rareqs AS l INNER JOIN (SELECT MIN(real) as real,id,status FROM (SELECT * FROM caqe WHERE status = ''ok'' UNION ALL SELECT * FROM depqbf WHERE status = ''ok'' UNION ALL SELECT * FROM rareqs WHERE status = ''ok'' ) GROUP BY id ORDER BY real) AS r ON l.id = r.id WHERE l.status = ''ok'' AND r.status = ''ok''  ORDER BY l.id"' u 1:2 w point title "VBS", \
'<sqlite3 qbf22.db "SELECT l.real,3700 FROM pq_16c_portfolio_depqbf_caqe_rareqs AS l WHERE l.status = ''ok'' AND l.id NOT IN (SELECT id FROM (SELECT * FROM caqe WHERE status = ''ok'' UNION ALL SELECT * FROM depqbf WHERE status = ''ok'' UNION ALL SELECT * FROM rareqs WHERE status = ''ok'' ) GROUP BY id) ORDER BY l.id"' u 1:2 w point title "OnlyPQ", \
x
;

set output "qbf22-all3-bloqqer-scatter.png"

set xlabel "All3"
set ylabel "Caqe/DepQBF/RaReQs"
set key below 
set logscale x
set logscale y

plot \
'<sqlite3 qbf22.db "SELECT r.real,l.real FROM bdepqbf AS l INNER JOIN pq_16c_portfolio_bloqqer_depqbf_caqe_rareqs AS r ON l.id = r.id WHERE l.status = ''ok'' AND r.status = ''ok'' ORDER BY l.id"' u 1:2 w point title "BDepQBF", \
'<sqlite3 qbf22.db "SELECT r.real,l.real FROM bcaqe AS l INNER JOIN pq_16c_portfolio_bloqqer_depqbf_caqe_rareqs AS r ON l.id = r.id WHERE l.status = ''ok'' AND r.status = ''ok''  ORDER BY l.id"' u 1:2 w point title "BCaqe", \
'<sqlite3 qbf22.db "SELECT r.real,l.real FROM brareqs AS l INNER JOIN pq_16c_portfolio_bloqqer_depqbf_caqe_rareqs AS r ON l.id = r.id WHERE l.status = ''ok'' AND r.status = ''ok''  ORDER BY l.id"' u 1:2 w point title "BRaReQs", \
'<sqlite3 qbf22.db "SELECT l.real,r.real FROM pq_16c_portfolio_bloqqer_depqbf_caqe_rareqs AS l INNER JOIN (SELECT MIN(real) as real,id,status FROM (SELECT * FROM bcaqe WHERE status = ''ok'' UNION ALL SELECT * FROM bdepqbf WHERE status = ''ok'' UNION ALL SELECT * FROM brareqs WHERE status = ''ok'' ) GROUP BY id ORDER BY real) AS r ON l.id = r.id WHERE l.status = ''ok'' AND r.status = ''ok''  ORDER BY l.id"' u 1:2 w point title "VBS", \
'<sqlite3 qbf22.db "SELECT l.real,3700 FROM pq_16c_portfolio_bloqqer_depqbf_caqe_rareqs AS l WHERE l.status = ''ok'' AND l.id NOT IN (SELECT id FROM (SELECT * FROM bcaqe WHERE status = ''ok'' UNION ALL SELECT * FROM bdepqbf WHERE status = ''ok'' UNION ALL SELECT * FROM brareqs WHERE status = ''ok'' ) GROUP BY id) ORDER BY l.id"' u 1:2 w point title "OnlyPQ", \
'<sqlite3 qbf22.db "SELECT 3700,l.real FROM (SELECT id,real,status FROM (SELECT * FROM bcaqe WHERE status = ''ok'' UNION ALL SELECT * FROM bdepqbf WHERE status = ''ok'' UNION ALL SELECT * FROM brareqs WHERE status = ''ok'' ) GROUP BY id) AS l WHERE l.status = ''ok'' AND l.id NOT IN (SELECT id FROM pq_16c_portfolio_bloqqer_depqbf_caqe_rareqs WHERE status == ''ok'') ORDER BY l.id"' u 1:2 w point title "OnlyVBS", \
x
;