set datafile separator '|'
set term tikz standalone createstyle tightboundingbox
set output "scatter.tex"

set key above
set ylabel "Solve Time Bloqqer + Caqe/DepQBF/RaReQs/VBS [s]"
set xlabel "PQ Portfolio with Bloqqer-Leaves [s]"

set logscale x
set logscale y

set xrange [0:4000]
set yrange [0:4000]

plot \
     '<sqlite3 < scatter-bcaqe.sql' u 1:2 w point title "Caqe", \
     '<sqlite3 < scatter-depqbf.sql' u 1:2 w point title "DepQBF", \
     '<sqlite3 < scatter-rareqs.sql' u 1:2 w point title "RaReQs", \
     '<sqlite3 < scatter-vbs.sql' u 1:2 w point title "VBS", \
     x notitle \
;
