set datafile separator '|'
set term tikz standalone createstyle tightboundingbox
set output "scalability.tex"

set key bottom right
set xlabel "worker-time (wall-clock times worker count) [s]"
set ylabel "nr. of solved instances"
set size 1,0.6

set key samplen 1

set logscale x

plot \
     '<sqlite3 < scalability-pq-0.sql' u 1:0 w point title "PQ Portfolio, Depth 0 (164)", \
     '<sqlite3 < scalability-pq-1.sql' u ($1*2):0 w point title "PQ Portfolio, Depth 1 (169)", \
     '<sqlite3 < scalability-pq-2.sql' u ($1*4):0 w point title "PQ Portfolio, Depth 2 (176)", \
     '<sqlite3 < scalability-pq-3.sql' u ($1*8):0 w point title "PQ Portfolio, Depth 3 (181)", \
     '<sqlite3 < scalability-pq-4.sql' u ($1*16):0 w point title "PQ Portfolio, Depth 4 (184)", \
;
