set datafile separator '|'
set term tikz standalone createstyle tightboundingbox
set output "hex.tex"

set key bottom right
set xlabel "time [s]"
set ylabel "nr. of solved instances"

set size 1,0.7

plot \
     '<sqlite3 < hex-pq_all3.sql' u 1:0 w point title "PQ Portfolio, Depth 4", \
     '<sqlite3 < hex-vbs.sql' u 1:0 w point title "Virtual Portfolio", \
     '<sqlite3 < hex-pqvbs.sql' u 1:0 w point title "PQ Portfolio, Depth 0", \
     '<sqlite3 < hex-caqe.sql' u 1:0 w point title "\\caqe{}", \
     '<sqlite3 < hex-depqbf.sql' u 1:0 w point title "\\depqbf{}", \
     '<sqlite3 < hex-horde.sql' u 1:0 w point title "\\hordeqbf{}", \
     '<sqlite3 < hex-rareqs.sql' u 1:0 w point title "\\rareqs{}" \
;
