# References

Click on each reference to see more details.

### B

??? note "B15: Bach (2015) *Biogeosciences*"
    Bach, L. T. (2015). Reconsidering the role of carbonate ion concentration in calcification by marine organisms. *Biogeosciences* 12(16), 4939–4951. [doi:10.5194/bg-12-4939-2015](https://doi.org/10.5194/bg-12-4939-2015).

??? note "B76: Berner (1976) *Am. J. Sci.*"
    Berner, R. A. (1976). The solubility of calcite and aragonite in seawater at atmospheric pressure and 34.5 ‰ salinity. *American Journal of Science* 276, 713–730. [doi:10.2475/ajs.276.6.713](https://doi.org/10.2475/ajs.276.6.713).

??? note "BTSP79: Broecker et al. (1979) *Science*"
    Broecker, W. S., Takahashi, T., Simpson, H. J., and Peng, T.-H. (1979). Fate of Fossil Fuel Carbon Dioxide and the Global Carbon Budget. *Science* 206, 409–418. [doi:10.1126/science.206.4417.409](https://doi.org/10.1126/science.206.4417.409).

### C

??? note "C65: Culkin (1965) in *Chemical Oceanography*"
    Culkin, F. (1965). “The major constituents of sea water,” in *Chemical Oceanography*, eds. J. P. Riley and G. Skirrow (London, UK: Academic Press), 121–161.

??? note "CP68: Culberson & Pytkowicz (1968) *Limnol. Oceanogr.*"
    Culberson, C., and Pytkowicz, R. M. (1968). Effect of pressure on carbonic acid, boric acid, and the <i>p</i>H in seawater. *Limnology and Oceanography* 13, 403–417. [doi:10.4319/lo.1968.13.3.0403](https://doi.org/10.4319/lo.1968.13.3.0403).

??? note "CW95: Clegg & Whitfield (1995) *Geochim. Cosmochim. Acta*"
    Clegg, S. L., and Whitfield, M. (1995). A chemical model of seawater including dissolved ammonia and the stoichiometric dissociation constant of ammonia in estuarine water and seawater from −2 to 40°C. *Geochimica et Cosmochimica Acta* 59, 2403–2421. <a href='https://doi.org/10.1016/0016-7037(95)00135-2'>doi:10.1016/0016-7037(95)00135-2</a>.

??? note "CW98: Cai & Wang (1998) *Limnol. Oceanogr.*"
    Cai, W.-J., and Wang, Y. (1998). The chemistry, fluxes, and sources of carbon dioxide in the estuarine waters of the Satilla and Altamaha Rivers, Georgia. *Limnology and Oceanography* 43, 657–668. [doi:10.4319/lo.1998.43.4.0657](https://doi.org/10.4319/lo.1998.43.4.0657).

### D

??? note "D90a: Dickson (1990) *J. Chem. Thermodyn.*"
    Dickson, A. G. (1990). Standard potential of the reaction: AgCl(s) + 0.5 H<sub>2</sub>(g) = Ag(s) + HCl(aq), and the standard acidity constant of the ion HSO<sub>4</sub><sup>−</sup> in synthetic sea water from 273.15 to 318.15 K. *Journal of Chemical Thermodynamics* 22, 113–127. <a href='https://doi.org/10.1016/0021-9614(90)90074-Z'>doi:10.1016/0021-9614(90)90074-Z</a>.

??? note "D90b: Dickson (1990) *Deep-Sea Res. Pt. A*"
    Dickson, A. G. (1990). Thermodynamics of the dissociation of boric acid in synthetic seawater from 273.15 to 318.15 K. *Deep-Sea Research Part A* 37, 755–766. <a href='https://doi.org/10.1016/0198-0149(90)90004-F'>doi:10.1016/0198-0149(90)90004-F</a>.

??? note "DM87: Dickson & Millero (1987) *Deep-Sea Res. Pt. A*"
    Dickson, A. G., and Millero, F. J. (1987). A comparison of the equilibrium constants for the dissociation of carbonic acid in seawater media. *Deep-Sea Research Part A* 34, 1733–1743. <a href='https://doi.org/10.1016/0198-0149(87)90021-5'>doi:10.1016/0198-0149(87)90021-5</a>.

??? note "DOE94: DOE (1994) *"Handbook of methods..."*"
    DOE (1994). *Handbook of methods for the analysis of the various parameters of the carbon dioxide system in sea water, version 2.* ORNL/CDIAC-74.

??? note "DR79: Dickson & Riley (1979) *Mar. Chem.*"
    Dickson, A. G., and Riley, J. P. (1979). The estimation of acid dissociation constants in sea-water media from potentiometric titrations with strong base. II. The dissociation of phosphoric acid. *Marine Chemistry* 7, 101–109. <a href='https://doi.org/10.1016/0304-4203(79)90002-1'>doi:10.1016/0304-4203(79)90002-1</a>.

### E

??? note "EG70: Edmond & Gieskes (1970) *Geochim. Cosmochim. Acta*"
    Edmond, J. M., and Gieskes, J. M. T. M. (1970). On the calculation of the degree of saturation of sea water with respect to calcium carbonate under in situ conditions. *Geochimica et Cosmochimica Acta* 34(12), 1261–1291. <a href='https://doi.org/10.1016/0016-7037(70)90041-4'>doi:10.1016/0016-7037(70)90041-4</a>.

??? note "ESM10: Egleston et al. (2010) *Global Biogeochem. Cy.*"
    Egleston, E. S., Sabine, C. L., and Morel, F. M. M. (2010). Revelle revisited: Buffer factors that quantify the response of ocean chemistry to changes in DIC and alkalinity. *Global Biogeochemical Cycles* 24, GB1002. [doi:10.1029/2008GB003407](https://doi.org/10.1029/2008GB003407).

### F

??? note "FCG94: Frankignoulle et al. (1994) *Limnol. Oceanogr.*"
    Frankignoulle, M., Canon, C., and Gattuso, J.-P. (1994). Marine calcification as a source of carbon dioxide: Positive feedback of increasing atmospheric CO<sub>2</sub>. *Limnology and Oceanography* 39, 458–462. [doi:10.4319/lo.1994.39.2.0458](https://doi.org/10.4319/lo.1994.39.2.0458).

### G

<!-- ??? note "GELO19: Gattuso et al. (2019) *seacarb: seawater carbonate...*"
    Gattuso J.-P., Epitalon J.-M., Lavigne H. and Orr J., 2019. seacarb: seawater carbonate chemistry. R package version 3.2.12. https://CRAN.R-project.org/package=seacarb. -->

??? note "GG46: Goff & Gratch (1946) *Trans. Am. Heat. Vent. Eng.*"
    Goff, J. A., and Gratch, S. (1946). Low-pressure properties of water from -160 to 212 °F. *Transactions of the American Society of Heating and Ventilating Engineers* 52, 95–122.

??? note "GP89: Goyet & Poisson (1989) *Deep-Sea Res. Pt. A*"
    Goyet, C., and Poisson, A. (1989). New determination of carbonic acid dissociation constants in seawater as a function of temperature and salinity. *Deep-Sea Research Part A* 36, 1635–1654. <a href='https://doi.org/10.1016/0198-0149(89)90064-2'>doi:10.1016/0198-0149(89)90064-2</a>.

### H

??? note "H73a: Hansson (1973) *Deep-Sea Res.*"
    Hansson, I. (1973). A new set of acidity constants for carbonic acid and boric acid in sea water. *Deep-Sea Research* 20, 461–478. <a href='https://doi.org/10.1016/0011-7471(73)90100-9'>doi:10.1016/0011-7471(73)90100-9</a>.

??? note "H73b: Hansson (1973) *Acta Chem. Scand.*"
    Hansson, I. (1973). The Determination of Dissociation Constants of Carbonic Acid in Synthetic Sea Water in the Salinity Range of 20–40 ‰ and Temperature Range of 5–30°C. *Acta Chemica Scandinavica* 27, 931–944. [doi:10.3891/acta.chem.scand.27-0931](https://doi.org/10.3891/acta.chem.scand.27-0931).

??? note "HDW18: Humphreys et al. (2018) *Mar. Chem.*"
    Humphreys, M. P., Daniels, C. J., Wolf-Gladrow, D. A., Tyrrell, T., and Achterberg, E. P. (2018). On the influence of marine biogeochemical processes over CO<sub>2</sub> exchange between the atmosphere and ocean. *Marine Chemistry* 199, 1–11. [doi:10.1016/j.marchem.2017.12.006](https://doi.org/10.1016/j.marchem.2017.12.006).

??? note "HLSP22: Humphreys et al. (2022) *Geosci. Model Dev.*"
    Humphreys, M. P., Lewis, E. R., Sharp, J. D., and Pierrot, D. (2021).  PyCO2SYS v1.8: marine carbonate system calculations in Python.  *Geoscientific Model Development* 15, 15–43.  [doi:10.5194/gmd-15-15-2022](https://doi.org/10.5194/gmd-15-15-2022).

??? note "HSS22: Humphreys et al. (2022) *"PyCO2SYS: marine carbonate..."*"
    Humphreys, M. P., Schiller, A. J., Sandborn, D. E., Gregor, L., Pierrot, D., van Heuven, S. M. A. C., Lewis, E. R., and Wallace, D. W. R. (2022). PyCO2SYS: marine carbonate system calculations in Python.  *Zenodo.* [doi:10.5281/zenodo.3744275](https://doi.org/10.5281/zenodo.3744275).

??? note "HPR11: van Heuven et al. (2011) *"CO<sub>2</sub>SYS v1.1, MATLAB..."*"
    van Heuven, S., Pierrot, D., Rae, J. W. B., Lewis, E., and Wallace, D. W. R. (2011). CO<sub>2</sub>SYS v 1.1, MATLAB program developed for CO<sub>2</sub> system calculations. ORNL/CDIAC-105b, Carbon Dioxide Information Analysis Center, Oak Ridge National Laboratory, U.S. Department of Energy, Oak Ridge, TN, USA. [doi:10.3334/CDIAC/otg.CO2SYS_MATLAB_v1.1](https://doi.org/10.3334/CDIAC/otg.CO2SYS_MATLAB_v1.1).

### I

??? note "I75: Ingle (1975) *Mar. Chem.*"
    Ingle, S. E. (1975). Solubility of calcite in the ocean. *Marine Chemistry* 3, 301–319. <a href='https://doi.org/10.1016/0304-4203(75)90010-9'>doi:10.1016/0304-4203(75)90010-9</a>.

??? note "ICHP73: Ingle et al. (1973) *Mar. Chem.*"
    Ingle, S. E., Culberson, C. H., Hawley, J. E., and Pytkowicz, R. M. (1973). The solubility of calcite in seawater at atmospheric pressure and 35‰ salinity. *Marine Chemistry* 1, 295–307. <a href='https://doi.org/10.1016/0304-4203(73)90019-4'>doi:10.1016/0304-4203(73)90019-4</a>.

### K

??? note "KP67: Kester & Pytkowicz (1967) *Limnol. Oceanogr.*"
    Kester, D. R., and Pytkowicz, R. M. (1967). Determination of the Apparent Dissociation Constants of Phosphoric Acid in Seawater. *Limnology and Oceanography* 12, 243–252. [doi:10.4319/lo.1967.12.2.0243](https://doi.org/10.4319/lo.1967.12.2.0243).

??? note "KRCB77: Khoo et al. (1977) *Anal. Chem.*"
    Khoo, K. H., Ramette, R. W., Culberson, C. H., and Bates, R. G. (1977). Determination of hydrogen ion concentrations in seawater from 5 to 40C: standard potentials at salinities from 20 to 45 per mille. *Analytical Chemistry* 49, 29–34. [doi:10.1021/ac50009a016](https://doi.org/10.1021/ac50009a016).

??? note "KSK18: Kuliński et al. (2018) *Mar. Chem.*"
    Kuliński, K., Szymczycha, B., Koziorowska, K., Hammer, K., Schneider, B. (2018). Anomaly of total boron concentration in the brackish waters of the Baltic Sea and its consequence for the CO<sub>2</sub> system calculations. *Marine Chemistry* 204, 11-19. [doi:10.1016/j.marchem.2018.05.007](https://doi.org/10.1016/j.marchem.2018.05.007).

### L

??? note "LDK00: Lueker et al. (2000) *Mar. Chem.*"
    Lueker, T. J., Dickson, A. G., and Keeling, C. D. (2000). Ocean <i>p</i>CO<sub>2</sub> calculated from dissolved inorganic carbon, alkalinity, and equations for K<sub>1</sub> and K<sub>2</sub>: validation based on laboratory measurements of CO<sub>2</sub> in gas and seawater at equilibrium. *Marine Chemistry* 70, 105–119. <a href='https://doi.org/10.1016/S0304-4203(00)00022-0'>doi:10.1016/S0304-4203(00)00022-0</a>.

??? note "LKB10: Lee et al. (2010) *Geochim. Cosmochim. Acta*"
    Lee, K., Kim, T.-W., Byrne, R. H., Millero, F. J., Feely, R. A., and Liu, Y.-M. (2010). The universal ratio of boron to chlorinity for the North Pacific and North Atlantic oceans. *Geochimica et Cosmochimica Acta* 74, 1801–1811. [doi:10.1016/j.gca.2009.12.027](https://doi.org/10.1016/j.gca.2009.12.027).

??? note "LTB69: Li et al. (1969) *J. Geophys. Res.*"
    Li, Y.-H., Takahashi, T., and Broecker, W. S. (1969). Degree of saturation of CaCO<sub>3</sub> in the oceans. *Journal of Geophysical Research* 74, 5507–5525. [doi:10.1029/JC074i023p05507](https://doi.org/10.1029/JC074i023p05507).

??? note "LW98: Lewis & Wallace (1998) *"Program developed for..."*"
    Lewis, E., and Wallace, D. W. R. (1998). Program Developed for CO<sub>2</sub> System Calculations. ORNL/CDIAC-105, Carbon Dioxide Information Analysis Center, Oak Ridge National Laboratory, U.S. Department of Energy, Oak Ridge, TN, USA.

### M

??? note "M10: Millero (2010) *Mar. Freshwater Res.*"
    Millero, F. J. (2010). Carbonate constants for estuarine waters. *Marine and Freshwater Research* 61(2), 139–142. [doi:10.1071/MF09254](https://doi.org/10.1071/MF09254).

??? note "M13: Munhoven (2013) *Geosci. Model Dev.*"
    Munhoven, G. (2013). Mathematics of the total alkalinity–pH equation – pathway to robust and universal solution algorithms: the SolveSAPHE package v1.0.1. *Geoscientific Model Development* 6, 1367–1388. [doi:10.5194/gmd-6-1367-2013](https://doi.org/10.5194/gmd-6-1367-2013).

??? note "M16: Maclaurin (2016) *Autograd: Automatic Differentiation...*"
    Maclaurin, D. (2016). “Autograd: Automatic Differentiation for Python,” in *Modeling, Inference and Optimization with Composable Differentiable Procedures* (PhD thesis, Harvard University, Cambridge, MA), 41–57.

??? note "M79: Millero (1979) *Geochim. Cosmochim. Acta*"
    Millero, F. J. (1979). The thermodynamics of the carbonate system in seawater. *Geochimica et Cosmochimica Acta* 43, 1651–1661. <a href='https://doi.org/10.1016/0016-7037(79)90184-4'>doi:10.1016/0016-7037(79)90184-4</a>.

??? note "M83: Mucci (1983) *Am. J. Sci.*"
    Mucci, A. (1983). The solubility of calcite and aragonite in seawater at various salinities, temperatures, and one atmosphere total pressure. *American Journal of Science* 283, 780–799. [doi:10.2475/ajs.283.7.780](doi:10.2475/ajs.283.7.780).

??? note "Mi83: Millero (1983) in *"Chemical Oceanography"*"
    Millero, F. J. (1983). “Influence of pressure on chemical processes in the sea,” in *Chemical Oceanography*, eds. J. P. Riley and R. Chester (Academic Press).

??? note "MS92: Millero & Sohn (1992) *"Chemical Oceanography"*"
    Millero, F. J., and Sohn, M. L. (1992). *Chemical Oceanography.* CRC Press, Florida, USA.

??? note "M95: Millero (1995) *Geochim. Cosmochim. Acta*"
    Millero, F. J. (1995). Thermodynamics of the carbon dioxide system in the oceans. *Geochimica et Cosmochimica Acta* 59, 661–677. <a href='https://doi.org/10.1016/0016-7037(94)00354-O'>doi:10.1016/0016-7037(94)00354-O</a>.

??? note "MCHP73: Mehrbach et al. (1973) *Limnol. Oceanogr.*"
    Mehrbach, C., Culberson, C. H., Hawley, J. E., and Pytkowicz, R. M. (1973). Measurement of the Apparent Dissociation Constants of Carbonic Acid in Seawater at Atmospheric Pressure. *Limnology and Oceanography* 18, 897–907. [doi:10.4319/lo.1973.18.6.0897](https://doi.org/10.4319/lo.1973.18.6.0897).

??? note "MGH06: Millero et al. (2006) *Mar. Chem.*"
    Millero, F. J., Graham, T. B., Huang, F., Bustos-Serrano, H., and Pierrot, D. (2006). Dissociation constants of carbonic acid in seawater as a function of salinity and temperature. *Marine Chemistry* 100, 80–94. [doi:10.1016/j.marchem.2005.12.001](https://doi.org/10.1016/j.marchem.2005.12.001).

??? note "MM02: Mojica Prieto & Millero (2002) *Geochim. Cosmochim. Acta*"
    Mojica Prieto, F. J., and Millero, F. J. (2002). The values of pK<sub>1</sub> + pK<sub>2</sub> for the dissociation of carbonic acid in seawater. *Geochimica et Cosmochimica Acta* 66, 2529–2540. <a href='https://doi.org/10.1016/S0016-7037(02)00855-4'>doi:10.1016/S0016-7037(02)00855-4</a>.

??? note "MPL02: Millero et al. (2002) *Deep-Sea Res. Pt. I* "
    Millero, F. J., Pierrot, D., Lee, K., Wanninkhof, R., Feely, R., Sabine, C. L., et al. (2002). Dissociation constants for carbonic acid determined from field measurements. *Deep-Sea Research Part I* 49, 1705–1723. <a href='https://doi.org/10.1016/S0967-0637(02)00093-6'>doi:10.1016/S0967-0637(02)00093-6</a>.

??? note "MR66: Morris & Riley (1966) *Deep-Sea Res.*"
    Morris, A. W., and Riley, J. P. (1966). The bromide/chlorinity and sulphate/chlorinity ratio in sea water. *Deep-Sea Research* 13, 699–705. <a href='https://doi.org/10.1016/0011-7471(66)90601-2'>doi:10.1016/0011-7471(66)90601-2</a>.

### O

??? note "OE15: Orr & Epitalon (2015) *Geosci. Model Dev.*"
    Orr, J. C., and Epitalon, J.-M. (2015). Improved routines to model the ocean carbonate system: mocsy 2.0. *Geoscientific Model Development* 8, 485–499. [doi:10.5194/gmd-8-485-2015](https://doi.org/10.5194/gmd-8-485-2015).

??? note "OEG15: Orr et al. (2015) *Biogeosciences*"
    Orr, J. C., Epitalon, J.-M., and Gattuso, J.-P. (2015). Comparison of ten packages that compute ocean carbonate chemistry. *Biogeosciences* 12, 1483–1510. [doi:10.5194/bg-12-1483-2015](https://doi.org/10.5194/bg-12-1483-2015).

??? note "OEDG18: Orr et al. (2018) *Mar. Chem.*"
    Orr, J. C., Epitalon, J.-M., Dickson, A. G., and Gattuso, J.-P. (2018). Routine uncertainty propagation for the marine carbon dioxide system. *Marine Chemistry* 207, 84–107. [doi:10.1016/j.marchem.2018.10.006](https://doi.org/10.1016/j.marchem.2018.10.006).

### P

??? note "PF87: Perez & Fraga (1987) *Mar. Chem.*"
    Perez, F. F., and Fraga, F. (1987). Association constant of fluoride and hydrogen ions in seawater. *Marine Chemistry* 21, 161–168. <a href='https://doi.org/10.1016/0304-4203(87)90036-3'>doi:10.1016/0304-4203(87)90036-3</a>.

??? note "PTBO87: Peng et al. (1987) *Tellus B*"
    Peng, T.-H., Takahashi, T., Broecker, W. S., and Olafsson, J. (1987). Seasonal variability of carbon dioxide, nutrients and oxygen in the northern North Atlantic surface water: observations and a model. *Tellus B* 39, 439–458. [doi:10.3402/tellusb.v39i5.15361](https://doi.org/10.3402/tellusb.v39i5.15361).

### R

??? note "R54: Robinson (1954) *J. Mar. Biol. Ass. U.K.*"
    Robinson, R. A. (1954). The vapour pressure and osmotic equivalence of sea water. *Journal of the Marine Biological Association of the United Kingdom* 33, 449–455. [doi:10.1017/S0025315400008468](https://doi.org/10.1017/S0025315400008468).

??? note "R65: Riley (1965) *Deep-Sea Res.*"
    Riley, J. P. (1965). The occurrence of anomalously high fluoride concentrations in the North Atlantic. *Deep-Sea Research* 12, 219–220. <a href='https://doi.org/10.1016/0011-7471(65)90027-6'>doi:10.1016/0011-7471(65)90027-6</a>.

??? note "RAH18: Richier et al. (2018) *Glob. Change Biol.*"
    Richier, S., Achterberg, E. P., Humphreys, M. P., Poulton, A. J., Suggett, D. J., Tyrrell, T., et al. (2018). Geographical CO<sub>2</sub> sensitivity of phytoplankton correlates with ocean buffer capacity. *Global Change Biology* 24, 4438–4452. [doi:10.1111/gcb.14324](https://doi.org/10.1111/gcb.14324).

<!-- ??? note "RG20: Raitzsch & Gattuso (2020) *ScarFace - seacarb calculations...*"
    Raitzsch, M. and Gattuso, J.-P. (2020). ScarFace - seacarb calculations with R Shiny user interface. Version 1.1.0. *Zenodo.* [doi:10.5281/zenodo.3662139](https://doi.org/10.5281/zenodo.3662139). -->

??? note "RRV93: Roy et al. (1993) *Mar. Chem.*"
    Roy, R. N., Roy, L. N., Vogel, K. M., Porter-Moore, C., Pearson, T., Good, C. E., et al. (1993). The dissociation constants of carbonic acid in seawater at salinities 5 to 45 and temperatures 0 to 45°C. *Marine Chemistry* 44, 249–267. <a href='https://doi.org/10.1016/0304-4203(93)90207-5'>doi:10.1016/0304-4203(93)90207-5</a>.

??? note "RT67: Riley & Tongudai (1967) *Chem. Geol.*"
    Riley, J. P., and Tongudai, M. (1967). The major cation/chlorinity ratios in sea water. *Chemical Geology* 2, 263–269. <a href='https://doi.org/10.1016/0009-2541(67)90026-5'>doi:10.1016/0009-2541(67)90026-5</a>.

### S

??? note "SB21: Schockman & Byrne (2021) *Geochim. Cosmochim. Acta*"
    Schockman, K. M., and Byrne, R. H. (2021). Spectrophotometric Determination of the Bicarbonate Dissociation Constant in Seawater. *Geochemica Cosmochimica Acta*, in press.  [doi:10.1016/j.gca.2021.02.008](https://doi.org/10.1016/j.gca.2021.02.008).

??? note "SLH20: Sulpis et al. (2020) *Ocean Sci.*"
    Sulpis, O., Lauvset, S. K., and Hagens, M. (2020). Current estimates of K<sub>1</sub><sup>&ast;</sup> and K<sub>2</sub><sup>&ast;</sup> appear inconsistent with measured CO<sub>2</sub> system parameters in cold oceanic regions. *Ocean Science* 16(4), 847–862. [doi:10.5194/os-2020-19](https://doi.org/10.5194/os-2020-19).

??? note "SMB64: Sillén et al. (1964) *Chem. Soc. London*"
    Sillén, L. G., Martell, A. E., and Bjerrum, J. (1964). Stability constants of metal-ion complexes. Special Publication 17. London, UK: Chemical Society.

??? note "SPH20: Sharp et al. (2020) *CO2-System-Extd*"
    Sharp, J. D., Pierrot, D., Humphreys, M. P., Epitalon, J.-M., Orr, J. C., Lewis, E., Wallace, D. W. R. (2020). CO2-System-Extd, v3.0.  MATLAB (MathWorks).  Available from [github.com/jonathansharp/CO2-System-Extd](https://github.com/jonathansharp/CO2-System-Extd).

### T

??? note "TSW09: Takahashi et al. (2009) *Deep-Sea Res. Pt. II*"
    Takahashi, T., Sutherland, S. C., Wanninkhof, R., Sweeney, C., Feely, R. A., Chipman, D. W., Hales, B., Friederich, G., Chavez, F., Sabine, C., Watson, A., Bakker, D. C. E., Schuster, U., Metzl, N., Yoshikawa-Inoue, H., Ishii, M., Midorikawa, T., Nojiri, Y., Körtzinger, A., Steinhoff, T., Hoppema, M., Olafsson, J., Arnarson, T. S., Tilbrook, B., Johannessen, T., Olsen, A., Bellerby, R., Wong, C. S., Delille, B., Bates, N. R., and de Baar, H. J. W. (2009).  Climatological mean and decadal change in surface ocean pCO<sub>2</sub>, and net sea-air CO<sub>2</sub> flux over the global oceans.  *Deep-Sea Research II* 56, 554–577.  [doi:10.1016/j.dsr2.2008.12.009](https://doi.org/10.1016/j.dsr2.2008.12.009).

??? note "TWB82: Takahashi et al. (1982) in *"GEOSECS Pacific Expedition"*"
    Takahashi, T., Williams, R. T., and Bos, D. L. (1982). “Carbonate Chemistry,” in *GEOSECS Pacific Expedition: Hydrographic Data* (Washington, D. C.: National Science Foundation), 77–105.

### U

??? note "U74: Uppström (1974) *Deep-Sea Res.*"
    Uppström, L. R. (1974). The boron/chlorinity ratio of deep-sea water from the Pacific Ocean. *Deep-Sea Research* 21, 161–162. <a href='https://doi.org/10.1016/0011-7471(74)90074-6'>doi:10.1016/0011-7471(74)90074-6</a>.

### W

??? note "W74: Weiss (1974) *Mar. Chem.*"
    Weiss, R. F. (1974). Carbon dioxide in water and seawater: the solubility of a non-ideal gas. *Marine Chemistry* 2, 203–215. <a href='https://doi.org/10.1016/0304-4203(74)90015-2'>doi:10.1016/0304-4203(74)90015-2</a>.

??? note "WM13: Waters & Millero (2013) *Mar. Chem.*"
    Waters, J.F., Millero, F.J. (2013). The free proton concentration scale for seawater pH. *Marine Chemistry* 149, 8–22. [doi:10.1016/j.marchem.2012.11.003](https://doi.org/10.1016/j.marchem.2012.11.003).

??? note "WMW14: Waters et al. (2014) *Mar. Chem.*"
    Waters, J., Millero, F. J., and Woosley, R. J. (2014). Corrigendum to “The free proton concentration scale for seawater pH”, [MARCHE: 149 (2013) 8–22]. *Marine Chemistry* 165, 66–67. [doi:10.1016/j.marchem.2014.07.004](https://doi.org/10.1016/j.marchem.2014.07.004).

??? note "WP80: Weiss & Price (1980) *Mar. Chem.*"
    Weiss, R. F., and Price, B. A. (1980). Nitrous oxide solubility in water and seawater. *Marine Chemistry* 8, 347–359. [doi:10.1016/0304-4203(80)90024-9](https://doi.org/10.1016/0304-4203(80)90024-9).

??? note "WZK07: Wolf-Gladrow et al. (2007) *Mar. Chem.*"
    Wolf-Gladrow, D. A., Zeebe, R. E., Klaas, C., Körtzinger, A., and Dickson, A. G. (2007). Total alkalinity: The explicit conservative expression and its application to biogeochemical processes. *Marine Chemistry* 106, 287-300. [doi:10.1016/j.marchem.2007.01.006](https://doi.org/10.1016/j.marchem.2007.01.006).

### Y

??? note "YM95: Yao & Millero (1995) *Aquat. Geochem.*"
    Yao, W., and Millero, F. J. (1995). The chemistry of the anoxic waters in the Framvaren Fjord, Norway. *Aquatic Geochemistry* 1, 53–88. [doi:10.1007/BF01025231](https://doi.org/10.1007/BF01025231).

### Z

??? note "ZW01: Zeebe & Wolf-Gladrow (2001) *"CO<sub>2</sub> in Seawater..."*"
    Zeebe, R. E., and Wolf-Gladrow, D. (2001). <i>CO<sub>2</sub> in Seawater: Equilibrium, Kinetics, Isotopes.</i> Elsevier B.V., Amsterdam, the Netherlands.
