    You should have received a copy of the GNU Lesser General Public License
    along with Tate Bilinear Pairing Core.  If not, see http://www.gnu.org/licenses/lgpl.txt
*/
 
`default_nettype none
 
// drop def & const here :D
 
`define M     97          // M is the degree of the irreducible polynomial
`define WIDTH (2*`M-1)    // width for a GF(3^M) element
`define W2    (4*`M-1)    // width for a GF(3^{2*M}) element
`define W3    (6*`M-1)    // width for a GF(3^{3*M}) element
`define W6    (12*`M-1)   // width for a GF(3^{6*M}) element
`define PX    196'h4000000000000000000000000000000000000000001000002 // PX is the irreducible polynomial

`define ZERO {(2*`M){1'b0}}
`define TWO {(2*`M-2){1'b0}},2'b10
 
// The Modified Duursma-Lee Algorithm
// out == e_({xp,yp}, {xr,yr})
module duursma_lee_algo(clk, reset, xp, yp, xr, yr, done, out);
    input clk, reset;
    input [`WIDTH:0] xp, yp, xr, yr;
    output reg done;
    output reg [`W6:0] out;
 
    reg [`W6:0] t;
    reg [`WIDTH:0] a, b, y;
    reg [1:0] d;
    reg [`M:0] i;
    reg f3m_reset, delay1, delay2;
    wire [`W6:0] g,v7,v8;
    wire [`WIDTH:0] mu /* my name is "mew" */,nmu,ny,
                    x,v2,v3,v4,v5,v6;
    wire [1:0] v9;
    wire f36m_reset, dummy, f3m_done, f36m_done, finish, change;
 
    assign g = {`ZERO,`TWO,`ZERO,nmu,v6,v5};
    assign finish = i[0];
 
    f3m_cubic
        ins1 (xr, x), // x == {x_r}^3
        ins2 (yr, v2); // v2 == {y_r}^3
    f3m_nine
        ins3 (clk, a, v3), // v3 == a^9
        ins4 (clk, b, v4); // v4 == b^9
    f3m_add3
        ins5 (v3, x, {{(2*`M-2){1'b0}},d}, mu); // mu == a^9+x+d
    f3m_neg
// BUG:
//        ins6 (nmu, mu), // nmu == -mu
// FIX:
