/*
 * Copyright 2013, Homer Hsing <homer.hsing@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* test "f permutation".
 * write a block, wait 3 cycles, write another block, do not wait, write the third block */

`timescale 1ns / 1ps
`define P 20

module test_f_permutation;

    // Inputs
    reg clk;
    reg reset;
    reg [575:0] in;
    reg in_ready;

    // Outputs
    wire ack;
    wire [1599:0] out;
    wire out_ready;

    integer i;
    integer error_flag;

    // Instantiate the Unit Under Test (UUT)
    f_permutation uut (
        .clk(clk),
        .reset(reset),
        .in(in),
        .in_ready(in_ready),
        .ack(ack),
        .out(out),
        .out_ready(out_ready)
    );

    integer f;
    integer tmpcount;
    initial begin
        f = $fopen("output_test_f_permutation_t1.txt");
        $fwrite(f, "time,ack,out[1599],out[1598],out[1597],out[1596],out[1595],out[1594],out[1593],out[1592],out[1591],out[1590],out[1589],out[1588],out[1587],out[1586],out[1585],out[1584],out[1583],out[1582],out[1581],out[1580],out[1579],out[1578],out[1577],out[1576],out[1575],out[1574],out[1573],out[1572],out[1571],out[1570],out[1569],out[1568],out[1567],out[1566],out[1565],out[1564],out[1563],out[1562],out[1561],out[1560],out[1559],out[1558],out[1557],out[1556],out[1555],out[1554],out[1553],out[1552],out[1551],out[1550],out[1549],out[1548],out[1547],out[1546],out[1545],out[1544],out[1543],out[1542],out[1541],out[1540],out[1539],out[1538],out[1537],out[1536],out[1535],out[1534],out[1533],out[1532],out[1531],out[1530],out[1529],out[1528],out[1527],out[1526],out[1525],out[1524],out[1523],out[1522],out[1521],out[1520],out[1519],out[1518],out[1517],out[1516],out[1515],out[1514],out[1513],out[1512],out[1511],out[1510],out[1509],out[1508],out[1507],out[1506],out[1505],out[1504],out[1503],out[1502],out[1501],out[1500],out[1499],out[1498],out[1497],out[1496],out[1495],out[1494],out[1493],out[1492],out[1491],out[1490],out[1489],out[1488],out[1487],out[1486],out[1485],out[1484],out[1483],out[1482],out[1481],out[1480],out[1479],out[1478],out[1477],out[1476],out[1475],out[1474],out[1473],out[1472],out[1471],out[1470],out[1469],out[1468],out[1467],out[1466],out[1465],out[1464],out[1463],out[1462],out[1461],out[1460],out[1459],out[1458],out[1457],out[1456],out[1455],out[1454],out[1453],out[1452],out[1451],out[1450],out[1449],out[1448],out[1447],out[1446],out[1445],out[1444],out[1443],out[1442],out[1441],out[1440],out[1439],out[1438],out[1437],out[1436],out[1435],out[1434],out[1433],out[1432],out[1431],out[1430],out[1429],out[1428],out[1427],out[1426],out[1425],out[1424],out[1423],out[1422],out[1421],out[1420],out[1419],out[1418],out[1417],out[1416],out[1415],out[1414],out[1413],out[1412],out[1411],out[1410],out[1409],out[1408],out[1407],out[1406],out[1405],out[1404],out[1403],out[1402],out[1401],out[1400],out[1399],out[1398],out[1397],out[1396],out[1395],out[1394],out[1393],out[1392],out[1391],out[1390],out[1389],out[1388],out[1387],out[1386],out[1385],out[1384],out[1383],out[1382],out[1381],out[1380],out[1379],out[1378],out[1377],out[1376],out[1375],out[1374],out[1373],out[1372],out[1371],out[1370],out[1369],out[1368],out[1367],out[1366],out[1365],out[1364],out[1363],out[1362],out[1361],out[1360],out[1359],out[1358],out[1357],out[1356],out[1355],out[1354],out[1353],out[1352],out[1351],out[1350],out[1349],out[1348],out[1347],out[1346],out[1345],out[1344],out[1343],out[1342],out[1341],out[1340],out[1339],out[1338],out[1337],out[1336],out[1335],out[1334],out[1333],out[1332],out[1331],out[1330],out[1329],out[1328],out[1327],out[1326],out[1325],out[1324],out[1323],out[1322],out[1321],out[1320],out[1319],out[1318],out[1317],out[1316],out[1315],out[1314],out[1313],out[1312],out[1311],out[1310],out[1309],out[1308],out[1307],out[1306],out[1305],out[1304],out[1303],out[1302],out[1301],out[1300],out[1299],out[1298],out[1297],out[1296],out[1295],out[1294],out[1293],out[1292],out[1291],out[1290],out[1289],out[1288],out[1287],out[1286],out[1285],out[1284],out[1283],out[1282],out[1281],out[1280],out[1279],out[1278],out[1277],out[1276],out[1275],out[1274],out[1273],out[1272],out[1271],out[1270],out[1269],out[1268],out[1267],out[1266],out[1265],out[1264],out[1263],out[1262],out[1261],out[1260],out[1259],out[1258],out[1257],out[1256],out[1255],out[1254],out[1253],out[1252],out[1251],out[1250],out[1249],out[1248],out[1247],out[1246],out[1245],out[1244],out[1243],out[1242],out[1241],out[1240],out[1239],out[1238],out[1237],out[1236],out[1235],out[1234],out[1233],out[1232],out[1231],out[1230],out[1229],out[1228],out[1227],out[1226],out[1225],out[1224],out[1223],out[1222],out[1221],out[1220],out[1219],out[1218],out[1217],out[1216],out[1215],out[1214],out[1213],out[1212],out[1211],out[1210],out[1209],out[1208],out[1207],out[1206],out[1205],out[1204],out[1203],out[1202],out[1201],out[1200],out[1199],out[1198],out[1197],out[1196],out[1195],out[1194],out[1193],out[1192],out[1191],out[1190],out[1189],out[1188],out[1187],out[1186],out[1185],out[1184],out[1183],out[1182],out[1181],out[1180],out[1179],out[1178],out[1177],out[1176],out[1175],out[1174],out[1173],out[1172],out[1171],out[1170],out[1169],out[1168],out[1167],out[1166],out[1165],out[1164],out[1163],out[1162],out[1161],out[1160],out[1159],out[1158],out[1157],out[1156],out[1155],out[1154],out[1153],out[1152],out[1151],out[1150],out[1149],out[1148],out[1147],out[1146],out[1145],out[1144],out[1143],out[1142],out[1141],out[1140],out[1139],out[1138],out[1137],out[1136],out[1135],out[1134],out[1133],out[1132],out[1131],out[1130],out[1129],out[1128],out[1127],out[1126],out[1125],out[1124],out[1123],out[1122],out[1121],out[1120],out[1119],out[1118],out[1117],out[1116],out[1115],out[1114],out[1113],out[1112],out[1111],out[1110],out[1109],out[1108],out[1107],out[1106],out[1105],out[1104],out[1103],out[1102],out[1101],out[1100],out[1099],out[1098],out[1097],out[1096],out[1095],out[1094],out[1093],out[1092],out[1091],out[1090],out[1089],out[1088],out[1087],out[1086],out[1085],out[1084],out[1083],out[1082],out[1081],out[1080],out[1079],out[1078],out[1077],out[1076],out[1075],out[1074],out[1073],out[1072],out[1071],out[1070],out[1069],out[1068],out[1067],out[1066],out[1065],out[1064],out[1063],out[1062],out[1061],out[1060],out[1059],out[1058],out[1057],out[1056],out[1055],out[1054],out[1053],out[1052],out[1051],out[1050],out[1049],out[1048],out[1047],out[1046],out[1045],out[1044],out[1043],out[1042],out[1041],out[1040],out[1039],out[1038],out[1037],out[1036],out[1035],out[1034],out[1033],out[1032],out[1031],out[1030],out[1029],out[1028],out[1027],out[1026],out[1025],out[1024],out[1023],out[1022],out[1021],out[1020],out[1019],out[1018],out[1017],out[1016],out[1015],out[1014],out[1013],out[1012],out[1011],out[1010],out[1009],out[1008],out[1007],out[1006],out[1005],out[1004],out[1003],out[1002],out[1001],out[1000],out[999],out[998],out[997],out[996],out[995],out[994],out[993],out[992],out[991],out[990],out[989],out[988],out[987],out[986],out[985],out[984],out[983],out[982],out[981],out[980],out[979],out[978],out[977],out[976],out[975],out[974],out[973],out[972],out[971],out[970],out[969],out[968],out[967],out[966],out[965],out[964],out[963],out[962],out[961],out[960],out[959],out[958],out[957],out[956],out[955],out[954],out[953],out[952],out[951],out[950],out[949],out[948],out[947],out[946],out[945],out[944],out[943],out[942],out[941],out[940],out[939],out[938],out[937],out[936],out[935],out[934],out[933],out[932],out[931],out[930],out[929],out[928],out[927],out[926],out[925],out[924],out[923],out[922],out[921],out[920],out[919],out[918],out[917],out[916],out[915],out[914],out[913],out[912],out[911],out[910],out[909],out[908],out[907],out[906],out[905],out[904],out[903],out[902],out[901],out[900],out[899],out[898],out[897],out[896],out[895],out[894],out[893],out[892],out[891],out[890],out[889],out[888],out[887],out[886],out[885],out[884],out[883],out[882],out[881],out[880],out[879],out[878],out[877],out[876],out[875],out[874],out[873],out[872],out[871],out[870],out[869],out[868],out[867],out[866],out[865],out[864],out[863],out[862],out[861],out[860],out[859],out[858],out[857],out[856],out[855],out[854],out[853],out[852],out[851],out[850],out[849],out[848],out[847],out[846],out[845],out[844],out[843],out[842],out[841],out[840],out[839],out[838],out[837],out[836],out[835],out[834],out[833],out[832],out[831],out[830],out[829],out[828],out[827],out[826],out[825],out[824],out[823],out[822],out[821],out[820],out[819],out[818],out[817],out[816],out[815],out[814],out[813],out[812],out[811],out[810],out[809],out[808],out[807],out[806],out[805],out[804],out[803],out[802],out[801],out[800],out[799],out[798],out[797],out[796],out[795],out[794],out[793],out[792],out[791],out[790],out[789],out[788],out[787],out[786],out[785],out[784],out[783],out[782],out[781],out[780],out[779],out[778],out[777],out[776],out[775],out[774],out[773],out[772],out[771],out[770],out[769],out[768],out[767],out[766],out[765],out[764],out[763],out[762],out[761],out[760],out[759],out[758],out[757],out[756],out[755],out[754],out[753],out[752],out[751],out[750],out[749],out[748],out[747],out[746],out[745],out[744],out[743],out[742],out[741],out[740],out[739],out[738],out[737],out[736],out[735],out[734],out[733],out[732],out[731],out[730],out[729],out[728],out[727],out[726],out[725],out[724],out[723],out[722],out[721],out[720],out[719],out[718],out[717],out[716],out[715],out[714],out[713],out[712],out[711],out[710],out[709],out[708],out[707],out[706],out[705],out[704],out[703],out[702],out[701],out[700],out[699],out[698],out[697],out[696],out[695],out[694],out[693],out[692],out[691],out[690],out[689],out[688],out[687],out[686],out[685],out[684],out[683],out[682],out[681],out[680],out[679],out[678],out[677],out[676],out[675],out[674],out[673],out[672],out[671],out[670],out[669],out[668],out[667],out[666],out[665],out[664],out[663],out[662],out[661],out[660],out[659],out[658],out[657],out[656],out[655],out[654],out[653],out[652],out[651],out[650],out[649],out[648],out[647],out[646],out[645],out[644],out[643],out[642],out[641],out[640],out[639],out[638],out[637],out[636],out[635],out[634],out[633],out[632],out[631],out[630],out[629],out[628],out[627],out[626],out[625],out[624],out[623],out[622],out[621],out[620],out[619],out[618],out[617],out[616],out[615],out[614],out[613],out[612],out[611],out[610],out[609],out[608],out[607],out[606],out[605],out[604],out[603],out[602],out[601],out[600],out[599],out[598],out[597],out[596],out[595],out[594],out[593],out[592],out[591],out[590],out[589],out[588],out[587],out[586],out[585],out[584],out[583],out[582],out[581],out[580],out[579],out[578],out[577],out[576],out[575],out[574],out[573],out[572],out[571],out[570],out[569],out[568],out[567],out[566],out[565],out[564],out[563],out[562],out[561],out[560],out[559],out[558],out[557],out[556],out[555],out[554],out[553],out[552],out[551],out[550],out[549],out[548],out[547],out[546],out[545],out[544],out[543],out[542],out[541],out[540],out[539],out[538],out[537],out[536],out[535],out[534],out[533],out[532],out[531],out[530],out[529],out[528],out[527],out[526],out[525],out[524],out[523],out[522],out[521],out[520],out[519],out[518],out[517],out[516],out[515],out[514],out[513],out[512],out[511],out[510],out[509],out[508],out[507],out[506],out[505],out[504],out[503],out[502],out[501],out[500],out[499],out[498],out[497],out[496],out[495],out[494],out[493],out[492],out[491],out[490],out[489],out[488],out[487],out[486],out[485],out[484],out[483],out[482],out[481],out[480],out[479],out[478],out[477],out[476],out[475],out[474],out[473],out[472],out[471],out[470],out[469],out[468],out[467],out[466],out[465],out[464],out[463],out[462],out[461],out[460],out[459],out[458],out[457],out[456],out[455],out[454],out[453],out[452],out[451],out[450],out[449],out[448],out[447],out[446],out[445],out[444],out[443],out[442],out[441],out[440],out[439],out[438],out[437],out[436],out[435],out[434],out[433],out[432],out[431],out[430],out[429],out[428],out[427],out[426],out[425],out[424],out[423],out[422],out[421],out[420],out[419],out[418],out[417],out[416],out[415],out[414],out[413],out[412],out[411],out[410],out[409],out[408],out[407],out[406],out[405],out[404],out[403],out[402],out[401],out[400],out[399],out[398],out[397],out[396],out[395],out[394],out[393],out[392],out[391],out[390],out[389],out[388],out[387],out[386],out[385],out[384],out[383],out[382],out[381],out[380],out[379],out[378],out[377],out[376],out[375],out[374],out[373],out[372],out[371],out[370],out[369],out[368],out[367],out[366],out[365],out[364],out[363],out[362],out[361],out[360],out[359],out[358],out[357],out[356],out[355],out[354],out[353],out[352],out[351],out[350],out[349],out[348],out[347],out[346],out[345],out[344],out[343],out[342],out[341],out[340],out[339],out[338],out[337],out[336],out[335],out[334],out[333],out[332],out[331],out[330],out[329],out[328],out[327],out[326],out[325],out[324],out[323],out[322],out[321],out[320],out[319],out[318],out[317],out[316],out[315],out[314],out[313],out[312],out[311],out[310],out[309],out[308],out[307],out[306],out[305],out[304],out[303],out[302],out[301],out[300],out[299],out[298],out[297],out[296],out[295],out[294],out[293],out[292],out[291],out[290],out[289],out[288],out[287],out[286],out[285],out[284],out[283],out[282],out[281],out[280],out[279],out[278],out[277],out[276],out[275],out[274],out[273],out[272],out[271],out[270],out[269],out[268],out[267],out[266],out[265],out[264],out[263],out[262],out[261],out[260],out[259],out[258],out[257],out[256],out[255],out[254],out[253],out[252],out[251],out[250],out[249],out[248],out[247],out[246],out[245],out[244],out[243],out[242],out[241],out[240],out[239],out[238],out[237],out[236],out[235],out[234],out[233],out[232],out[231],out[230],out[229],out[228],out[227],out[226],out[225],out[224],out[223],out[222],out[221],out[220],out[219],out[218],out[217],out[216],out[215],out[214],out[213],out[212],out[211],out[210],out[209],out[208],out[207],out[206],out[205],out[204],out[203],out[202],out[201],out[200],out[199],out[198],out[197],out[196],out[195],out[194],out[193],out[192],out[191],out[190],out[189],out[188],out[187],out[186],out[185],out[184],out[183],out[182],out[181],out[180],out[179],out[178],out[177],out[176],out[175],out[174],out[173],out[172],out[171],out[170],out[169],out[168],out[167],out[166],out[165],out[164],out[163],out[162],out[161],out[160],out[159],out[158],out[157],out[156],out[155],out[154],out[153],out[152],out[151],out[150],out[149],out[148],out[147],out[146],out[145],out[144],out[143],out[142],out[141],out[140],out[139],out[138],out[137],out[136],out[135],out[134],out[133],out[132],out[131],out[130],out[129],out[128],out[127],out[126],out[125],out[124],out[123],out[122],out[121],out[120],out[119],out[118],out[117],out[116],out[115],out[114],out[113],out[112],out[111],out[110],out[109],out[108],out[107],out[106],out[105],out[104],out[103],out[102],out[101],out[100],out[99],out[98],out[97],out[96],out[95],out[94],out[93],out[92],out[91],out[90],out[89],out[88],out[87],out[86],out[85],out[84],out[83],out[82],out[81],out[80],out[79],out[78],out[77],out[76],out[75],out[74],out[73],out[72],out[71],out[70],out[69],out[68],out[67],out[66],out[65],out[64],out[63],out[62],out[61],out[60],out[59],out[58],out[57],out[56],out[55],out[54],out[53],out[52],out[51],out[50],out[49],out[48],out[47],out[46],out[45],out[44],out[43],out[42],out[41],out[40],out[39],out[38],out[37],out[36],out[35],out[34],out[33],out[32],out[31],out[30],out[29],out[28],out[27],out[26],out[25],out[24],out[23],out[22],out[21],out[20],out[19],out[18],out[17],out[16],out[15],out[14],out[13],out[12],out[11],out[10],out[9],out[8],out[7],out[6],out[5],out[4],out[3],out[2],out[1],out[0],out_ready\n");
        forever begin
          @(posedge clk);
          $fwrite(f, "%g,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b,%b\n", 
          $time,ack,out[1599],out[1598],out[1597],out[1596],out[1595],out[1594],out[1593],out[1592],out[1591],out[1590],out[1589],out[1588],out[1587],out[1586],out[1585],out[1584],out[1583],out[1582],out[1581],out[1580],out[1579],out[1578],out[1577],out[1576],out[1575],out[1574],out[1573],out[1572],out[1571],out[1570],out[1569],out[1568],out[1567],out[1566],out[1565],out[1564],out[1563],out[1562],out[1561],out[1560],out[1559],out[1558],out[1557],out[1556],out[1555],out[1554],out[1553],out[1552],out[1551],out[1550],out[1549],out[1548],out[1547],out[1546],out[1545],out[1544],out[1543],out[1542],out[1541],out[1540],out[1539],out[1538],out[1537],out[1536],out[1535],out[1534],out[1533],out[1532],out[1531],out[1530],out[1529],out[1528],out[1527],out[1526],out[1525],out[1524],out[1523],out[1522],out[1521],out[1520],out[1519],out[1518],out[1517],out[1516],out[1515],out[1514],out[1513],out[1512],out[1511],out[1510],out[1509],out[1508],out[1507],out[1506],out[1505],out[1504],out[1503],out[1502],out[1501],out[1500],out[1499],out[1498],out[1497],out[1496],out[1495],out[1494],out[1493],out[1492],out[1491],out[1490],out[1489],out[1488],out[1487],out[1486],out[1485],out[1484],out[1483],out[1482],out[1481],out[1480],out[1479],out[1478],out[1477],out[1476],out[1475],out[1474],out[1473],out[1472],out[1471],out[1470],out[1469],out[1468],out[1467],out[1466],out[1465],out[1464],out[1463],out[1462],out[1461],out[1460],out[1459],out[1458],out[1457],out[1456],out[1455],out[1454],out[1453],out[1452],out[1451],out[1450],out[1449],out[1448],out[1447],out[1446],out[1445],out[1444],out[1443],out[1442],out[1441],out[1440],out[1439],out[1438],out[1437],out[1436],out[1435],out[1434],out[1433],out[1432],out[1431],out[1430],out[1429],out[1428],out[1427],out[1426],out[1425],out[1424],out[1423],out[1422],out[1421],out[1420],out[1419],out[1418],out[1417],out[1416],out[1415],out[1414],out[1413],out[1412],out[1411],out[1410],out[1409],out[1408],out[1407],out[1406],out[1405],out[1404],out[1403],out[1402],out[1401],out[1400],out[1399],out[1398],out[1397],out[1396],out[1395],out[1394],out[1393],out[1392],out[1391],out[1390],out[1389],out[1388],out[1387],out[1386],out[1385],out[1384],out[1383],out[1382],out[1381],out[1380],out[1379],out[1378],out[1377],out[1376],out[1375],out[1374],out[1373],out[1372],out[1371],out[1370],out[1369],out[1368],out[1367],out[1366],out[1365],out[1364],out[1363],out[1362],out[1361],out[1360],out[1359],out[1358],out[1357],out[1356],out[1355],out[1354],out[1353],out[1352],out[1351],out[1350],out[1349],out[1348],out[1347],out[1346],out[1345],out[1344],out[1343],out[1342],out[1341],out[1340],out[1339],out[1338],out[1337],out[1336],out[1335],out[1334],out[1333],out[1332],out[1331],out[1330],out[1329],out[1328],out[1327],out[1326],out[1325],out[1324],out[1323],out[1322],out[1321],out[1320],out[1319],out[1318],out[1317],out[1316],out[1315],out[1314],out[1313],out[1312],out[1311],out[1310],out[1309],out[1308],out[1307],out[1306],out[1305],out[1304],out[1303],out[1302],out[1301],out[1300],out[1299],out[1298],out[1297],out[1296],out[1295],out[1294],out[1293],out[1292],out[1291],out[1290],out[1289],out[1288],out[1287],out[1286],out[1285],out[1284],out[1283],out[1282],out[1281],out[1280],out[1279],out[1278],out[1277],out[1276],out[1275],out[1274],out[1273],out[1272],out[1271],out[1270],out[1269],out[1268],out[1267],out[1266],out[1265],out[1264],out[1263],out[1262],out[1261],out[1260],out[1259],out[1258],out[1257],out[1256],out[1255],out[1254],out[1253],out[1252],out[1251],out[1250],out[1249],out[1248],out[1247],out[1246],out[1245],out[1244],out[1243],out[1242],out[1241],out[1240],out[1239],out[1238],out[1237],out[1236],out[1235],out[1234],out[1233],out[1232],out[1231],out[1230],out[1229],out[1228],out[1227],out[1226],out[1225],out[1224],out[1223],out[1222],out[1221],out[1220],out[1219],out[1218],out[1217],out[1216],out[1215],out[1214],out[1213],out[1212],out[1211],out[1210],out[1209],out[1208],out[1207],out[1206],out[1205],out[1204],out[1203],out[1202],out[1201],out[1200],out[1199],out[1198],out[1197],out[1196],out[1195],out[1194],out[1193],out[1192],out[1191],out[1190],out[1189],out[1188],out[1187],out[1186],out[1185],out[1184],out[1183],out[1182],out[1181],out[1180],out[1179],out[1178],out[1177],out[1176],out[1175],out[1174],out[1173],out[1172],out[1171],out[1170],out[1169],out[1168],out[1167],out[1166],out[1165],out[1164],out[1163],out[1162],out[1161],out[1160],out[1159],out[1158],out[1157],out[1156],out[1155],out[1154],out[1153],out[1152],out[1151],out[1150],out[1149],out[1148],out[1147],out[1146],out[1145],out[1144],out[1143],out[1142],out[1141],out[1140],out[1139],out[1138],out[1137],out[1136],out[1135],out[1134],out[1133],out[1132],out[1131],out[1130],out[1129],out[1128],out[1127],out[1126],out[1125],out[1124],out[1123],out[1122],out[1121],out[1120],out[1119],out[1118],out[1117],out[1116],out[1115],out[1114],out[1113],out[1112],out[1111],out[1110],out[1109],out[1108],out[1107],out[1106],out[1105],out[1104],out[1103],out[1102],out[1101],out[1100],out[1099],out[1098],out[1097],out[1096],out[1095],out[1094],out[1093],out[1092],out[1091],out[1090],out[1089],out[1088],out[1087],out[1086],out[1085],out[1084],out[1083],out[1082],out[1081],out[1080],out[1079],out[1078],out[1077],out[1076],out[1075],out[1074],out[1073],out[1072],out[1071],out[1070],out[1069],out[1068],out[1067],out[1066],out[1065],out[1064],out[1063],out[1062],out[1061],out[1060],out[1059],out[1058],out[1057],out[1056],out[1055],out[1054],out[1053],out[1052],out[1051],out[1050],out[1049],out[1048],out[1047],out[1046],out[1045],out[1044],out[1043],out[1042],out[1041],out[1040],out[1039],out[1038],out[1037],out[1036],out[1035],out[1034],out[1033],out[1032],out[1031],out[1030],out[1029],out[1028],out[1027],out[1026],out[1025],out[1024],out[1023],out[1022],out[1021],out[1020],out[1019],out[1018],out[1017],out[1016],out[1015],out[1014],out[1013],out[1012],out[1011],out[1010],out[1009],out[1008],out[1007],out[1006],out[1005],out[1004],out[1003],out[1002],out[1001],out[1000],out[999],out[998],out[997],out[996],out[995],out[994],out[993],out[992],out[991],out[990],out[989],out[988],out[987],out[986],out[985],out[984],out[983],out[982],out[981],out[980],out[979],out[978],out[977],out[976],out[975],out[974],out[973],out[972],out[971],out[970],out[969],out[968],out[967],out[966],out[965],out[964],out[963],out[962],out[961],out[960],out[959],out[958],out[957],out[956],out[955],out[954],out[953],out[952],out[951],out[950],out[949],out[948],out[947],out[946],out[945],out[944],out[943],out[942],out[941],out[940],out[939],out[938],out[937],out[936],out[935],out[934],out[933],out[932],out[931],out[930],out[929],out[928],out[927],out[926],out[925],out[924],out[923],out[922],out[921],out[920],out[919],out[918],out[917],out[916],out[915],out[914],out[913],out[912],out[911],out[910],out[909],out[908],out[907],out[906],out[905],out[904],out[903],out[902],out[901],out[900],out[899],out[898],out[897],out[896],out[895],out[894],out[893],out[892],out[891],out[890],out[889],out[888],out[887],out[886],out[885],out[884],out[883],out[882],out[881],out[880],out[879],out[878],out[877],out[876],out[875],out[874],out[873],out[872],out[871],out[870],out[869],out[868],out[867],out[866],out[865],out[864],out[863],out[862],out[861],out[860],out[859],out[858],out[857],out[856],out[855],out[854],out[853],out[852],out[851],out[850],out[849],out[848],out[847],out[846],out[845],out[844],out[843],out[842],out[841],out[840],out[839],out[838],out[837],out[836],out[835],out[834],out[833],out[832],out[831],out[830],out[829],out[828],out[827],out[826],out[825],out[824],out[823],out[822],out[821],out[820],out[819],out[818],out[817],out[816],out[815],out[814],out[813],out[812],out[811],out[810],out[809],out[808],out[807],out[806],out[805],out[804],out[803],out[802],out[801],out[800],out[799],out[798],out[797],out[796],out[795],out[794],out[793],out[792],out[791],out[790],out[789],out[788],out[787],out[786],out[785],out[784],out[783],out[782],out[781],out[780],out[779],out[778],out[777],out[776],out[775],out[774],out[773],out[772],out[771],out[770],out[769],out[768],out[767],out[766],out[765],out[764],out[763],out[762],out[761],out[760],out[759],out[758],out[757],out[756],out[755],out[754],out[753],out[752],out[751],out[750],out[749],out[748],out[747],out[746],out[745],out[744],out[743],out[742],out[741],out[740],out[739],out[738],out[737],out[736],out[735],out[734],out[733],out[732],out[731],out[730],out[729],out[728],out[727],out[726],out[725],out[724],out[723],out[722],out[721],out[720],out[719],out[718],out[717],out[716],out[715],out[714],out[713],out[712],out[711],out[710],out[709],out[708],out[707],out[706],out[705],out[704],out[703],out[702],out[701],out[700],out[699],out[698],out[697],out[696],out[695],out[694],out[693],out[692],out[691],out[690],out[689],out[688],out[687],out[686],out[685],out[684],out[683],out[682],out[681],out[680],out[679],out[678],out[677],out[676],out[675],out[674],out[673],out[672],out[671],out[670],out[669],out[668],out[667],out[666],out[665],out[664],out[663],out[662],out[661],out[660],out[659],out[658],out[657],out[656],out[655],out[654],out[653],out[652],out[651],out[650],out[649],out[648],out[647],out[646],out[645],out[644],out[643],out[642],out[641],out[640],out[639],out[638],out[637],out[636],out[635],out[634],out[633],out[632],out[631],out[630],out[629],out[628],out[627],out[626],out[625],out[624],out[623],out[622],out[621],out[620],out[619],out[618],out[617],out[616],out[615],out[614],out[613],out[612],out[611],out[610],out[609],out[608],out[607],out[606],out[605],out[604],out[603],out[602],out[601],out[600],out[599],out[598],out[597],out[596],out[595],out[594],out[593],out[592],out[591],out[590],out[589],out[588],out[587],out[586],out[585],out[584],out[583],out[582],out[581],out[580],out[579],out[578],out[577],out[576],out[575],out[574],out[573],out[572],out[571],out[570],out[569],out[568],out[567],out[566],out[565],out[564],out[563],out[562],out[561],out[560],out[559],out[558],out[557],out[556],out[555],out[554],out[553],out[552],out[551],out[550],out[549],out[548],out[547],out[546],out[545],out[544],out[543],out[542],out[541],out[540],out[539],out[538],out[537],out[536],out[535],out[534],out[533],out[532],out[531],out[530],out[529],out[528],out[527],out[526],out[525],out[524],out[523],out[522],out[521],out[520],out[519],out[518],out[517],out[516],out[515],out[514],out[513],out[512],out[511],out[510],out[509],out[508],out[507],out[506],out[505],out[504],out[503],out[502],out[501],out[500],out[499],out[498],out[497],out[496],out[495],out[494],out[493],out[492],out[491],out[490],out[489],out[488],out[487],out[486],out[485],out[484],out[483],out[482],out[481],out[480],out[479],out[478],out[477],out[476],out[475],out[474],out[473],out[472],out[471],out[470],out[469],out[468],out[467],out[466],out[465],out[464],out[463],out[462],out[461],out[460],out[459],out[458],out[457],out[456],out[455],out[454],out[453],out[452],out[451],out[450],out[449],out[448],out[447],out[446],out[445],out[444],out[443],out[442],out[441],out[440],out[439],out[438],out[437],out[436],out[435],out[434],out[433],out[432],out[431],out[430],out[429],out[428],out[427],out[426],out[425],out[424],out[423],out[422],out[421],out[420],out[419],out[418],out[417],out[416],out[415],out[414],out[413],out[412],out[411],out[410],out[409],out[408],out[407],out[406],out[405],out[404],out[403],out[402],out[401],out[400],out[399],out[398],out[397],out[396],out[395],out[394],out[393],out[392],out[391],out[390],out[389],out[388],out[387],out[386],out[385],out[384],out[383],out[382],out[381],out[380],out[379],out[378],out[377],out[376],out[375],out[374],out[373],out[372],out[371],out[370],out[369],out[368],out[367],out[366],out[365],out[364],out[363],out[362],out[361],out[360],out[359],out[358],out[357],out[356],out[355],out[354],out[353],out[352],out[351],out[350],out[349],out[348],out[347],out[346],out[345],out[344],out[343],out[342],out[341],out[340],out[339],out[338],out[337],out[336],out[335],out[334],out[333],out[332],out[331],out[330],out[329],out[328],out[327],out[326],out[325],out[324],out[323],out[322],out[321],out[320],out[319],out[318],out[317],out[316],out[315],out[314],out[313],out[312],out[311],out[310],out[309],out[308],out[307],out[306],out[305],out[304],out[303],out[302],out[301],out[300],out[299],out[298],out[297],out[296],out[295],out[294],out[293],out[292],out[291],out[290],out[289],out[288],out[287],out[286],out[285],out[284],out[283],out[282],out[281],out[280],out[279],out[278],out[277],out[276],out[275],out[274],out[273],out[272],out[271],out[270],out[269],out[268],out[267],out[266],out[265],out[264],out[263],out[262],out[261],out[260],out[259],out[258],out[257],out[256],out[255],out[254],out[253],out[252],out[251],out[250],out[249],out[248],out[247],out[246],out[245],out[244],out[243],out[242],out[241],out[240],out[239],out[238],out[237],out[236],out[235],out[234],out[233],out[232],out[231],out[230],out[229],out[228],out[227],out[226],out[225],out[224],out[223],out[222],out[221],out[220],out[219],out[218],out[217],out[216],out[215],out[214],out[213],out[212],out[211],out[210],out[209],out[208],out[207],out[206],out[205],out[204],out[203],out[202],out[201],out[200],out[199],out[198],out[197],out[196],out[195],out[194],out[193],out[192],out[191],out[190],out[189],out[188],out[187],out[186],out[185],out[184],out[183],out[182],out[181],out[180],out[179],out[178],out[177],out[176],out[175],out[174],out[173],out[172],out[171],out[170],out[169],out[168],out[167],out[166],out[165],out[164],out[163],out[162],out[161],out[160],out[159],out[158],out[157],out[156],out[155],out[154],out[153],out[152],out[151],out[150],out[149],out[148],out[147],out[146],out[145],out[144],out[143],out[142],out[141],out[140],out[139],out[138],out[137],out[136],out[135],out[134],out[133],out[132],out[131],out[130],out[129],out[128],out[127],out[126],out[125],out[124],out[123],out[122],out[121],out[120],out[119],out[118],out[117],out[116],out[115],out[114],out[113],out[112],out[111],out[110],out[109],out[108],out[107],out[106],out[105],out[104],out[103],out[102],out[101],out[100],out[99],out[98],out[97],out[96],out[95],out[94],out[93],out[92],out[91],out[90],out[89],out[88],out[87],out[86],out[85],out[84],out[83],out[82],out[81],out[80],out[79],out[78],out[77],out[76],out[75],out[74],out[73],out[72],out[71],out[70],out[69],out[68],out[67],out[66],out[65],out[64],out[63],out[62],out[61],out[60],out[59],out[58],out[57],out[56],out[55],out[54],out[53],out[52],out[51],out[50],out[49],out[48],out[47],out[46],out[45],out[44],out[43],out[42],out[41],out[40],out[39],out[38],out[37],out[36],out[35],out[34],out[33],out[32],out[31],out[30],out[29],out[28],out[27],out[26],out[25],out[24],out[23],out[22],out[21],out[20],out[19],out[18],out[17],out[16],out[15],out[14],out[13],out[12],out[11],out[10],out[9],out[8],out[7],out[6],out[5],out[4],out[3],out[2],out[1],out[0],out_ready);
        end
    end

    initial begin
        // Initialize Inputs
        clk = 0;
        reset = 1;
        in = 0;
        in_ready = 0;

        // Wait 100 ns for global reset to finish
        #100;

        // Add stimulus here
        @ (negedge clk);
        if (out !== 0) error; /* should be 0 */
        if (ack !== 0) error; /* should be 0 */
        if (out_ready !== 0) error; /* should be 0 */

        #(`P);
        reset = 0;
        in = 0;
        in_ready = 1;
        #(`P);
        if (out_ready !== 0) error; /* should be 0 */
        in_ready = 0;

        /* check 1~22-th cycles */
        for(i=0; i<22; i=i+1)
          begin
            if (out === 0) error; /* should not be 0 */
            if (ack !== 0) error; /* should be 0 */
            if (out_ready !== 0) error; /* should be 0 */
            #(`P);
          end

        /* check the 23-th cycle */
        if (out === 0) error; /* should not be 0 */
        if (ack !== 0) error; /* should be 0 */
        if (out_ready !== 0) error; /* should be 0 */
        #(`P);

        /* check the 24-th cycle */
        #(`P); /* wait out */
        if (out_ready !== 1) error; /* should be 1 */
        if(out !== 1600'hf1258f7940e1dde784d5ccf933c0478ad598261ea65aa9eebd1547306f80494d8b284e056253d057ff97a42d7f8e6fd490fee5a0a44647c48c5bda0cd6192e76ad30a6f71b19059c30935ab7d08ffc64eb5aa93f2317d635a9a6e6260d71210381a57c16dbcf555f43b831cd0347c82601f22f1a11a5569f05e5635a21d9ae6164befef28cc970f2613670957bc46611b87c5a554fd00ecb8c3ee88a1ccf32c8940c7922ae3a26141841f924a2c509e416f53526e70465c275f644e97f30a13beaf1ff7b5ceca249) error;

        #(3*`P); /* wait more cycles */
        if (out_ready !== 1) error; /* should be 1 */
        /* "out" should not change */
        if(out !== 1600'hf1258f7940e1dde784d5ccf933c0478ad598261ea65aa9eebd1547306f80494d8b284e056253d057ff97a42d7f8e6fd490fee5a0a44647c48c5bda0cd6192e76ad30a6f71b19059c30935ab7d08ffc64eb5aa93f2317d635a9a6e6260d71210381a57c16dbcf555f43b831cd0347c82601f22f1a11a5569f05e5635a21d9ae6164befef28cc970f2613670957bc46611b87c5a554fd00ecb8c3ee88a1ccf32c8940c7922ae3a26141841f924a2c509e416f53526e70465c275f644e97f30a13beaf1ff7b5ceca249) error;

        in_ready = 1; /* feed in one more block */
        in = 0;
        #(`P);
        if (out_ready !== 0) error; /* should be 0 */
        in_ready = 0;
        
        while (out_ready !== 1)
            #(`P);
        if(out !== 1600'h2d5c954df96ecb3c6a332cd07057b56d093d8d1270d76b6c8a20d9b25569d0944f9c4f99e5e7f156f957b9a2da65fb3885773dae1275af0dfaf4f247c3d810f71f1b9ee6f79a8759e4fecc0fee98b42568ce61b6b9ce68a1deea66c4ba8f974f33c43d836eafb1f5e00654042719dbd97cf8a9f009831265fd5449a6bf17474397ddad33d8994b4048ead5fc5d0be774e3b8c8ee55b7b03c91a0226e649e42e9900e3129e7badd7b202a9ec5faa3cce85b3402464e1c3db6609f4e62a44c105920d06cd26a8fbf5c) error;
        
        /* no wait, feed in one more block */
        in_ready = 1;
        #(`P);
        if (out_ready !== 0) error; /* should be 0 */
        in_ready = 0;

        while (out_ready !== 1)
            #(`P);
        if(out !== 1600'h55eabb80767d364686c354c8d01cbace9452d254b0979b3dde59422be2c66f16c660e4f2d4d8212e78414f691b639bb3cbb20f9f1b22e381cf16da5fac2da63f83c0b76552d95f7c44efc84eaf017e1548d380ff3e532c9592436ec5c5e02f05bde57ca1ee8de7e9240970468a1fd1b012a978439cbb7686d26b59fcceff8b4dd2aa0f472110fff87bd44abf53f72551e15ad2b722d00bb7c56095932c792c459e02d1766ad3a79c312f2da72ada4ec368b9f274a8d7d6b92b7239f7e51eea1eb6947f6894d77aeb) error;

        if (error_flag !== 1) $display("Good!");
        $finish;
    end

    always #(`P/2) clk = ~ clk;

    task error;
      begin
        $display("Error!");
        error_flag <= 1;
        //$finish;
      end
    endtask
endmodule

`undef P
