`timescale 1ns / 1ns
module test_f3m_cubic;
  reg [193 : 0] a, P;
  wire [193 : 0] c;
  reg clk;
  f3m_cubic uut(.in(a), .out(c));  
  always #5 clk = ~clk;
  initial  begin
  a=0; P=0; clk=0; #100;
  @(negedge clk);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01000100000101010100000010000100100110000000101001100000011001000001100101000110101010010100100101010010010110000100010010100010100110101000101001000100011010010110000110011010100100100010000000;
  #20 if(c !== 194'b10101001010110011010100110100000010110101010010101011000100101000000000001000110100110101001101001000010000000010101101010001000010110010001001010101001011010010001010110100100100101001010101001) $display("Error0: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10000000100000010010000100010101000001100000100100011000101001100110000000010100000000100101000000001000100110000010011001000100000100010101011001011001011000100100000001010001000110001000100101;
  #20 if(c !== 194'b00010101011000100001001001001001010001010110010001100001100010001001100101010010010100010110000101010000100100001000000001101010100000011001010000100010101010000000101001010101000010010101001010) $display("Error1: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00011001010100000000010001100000100110100010000101101000010000100000010001100110011010000001000001100101011010011010100110100000010010101010010101001001001001100001100001001000100110001001011000;
  #20 if(c !== 194'b01100100011010000010010110001010000001100101100001010000010010100001001000100010101001101010100000000001001010100100000001101000000101001001000001001000001001100000011010100110100000001001001001) $display("Error2: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01000101000100100000010110010101100010011010001010100101010001011010001010100110000001000010010001101000100000000001100000100001100100100101000100000010000101010010100110000001001001001010011000;
  #20 if(c !== 194'b10000101000100101010000101101001101000001001100100000100010100000110000000100001000001100001000100100010100110100001000110101010100100011000000110001010100100101000100100001000100110000100011000) $display("Error3: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00101001100001011000101000000101000110011000001001100101100000000010100110001010010101010101010110010001011010100101100100101010010100010101000010101000000000010001010000001001010010001001101001;
  #20 if(c !== 194'b01010101101000001001100101010101100000010100010110001010000110001000000100101000000100010001000100010001100001010000100100001000011000000110010000010001100110000010101001001000100101100110101000) $display("Error4: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10101010000101011010000010100101010010100010100100101001100001001000011001101001000010000100100010000000010001001000010010000001101001011001101010000101000110000100100100100010000000010010101001;
  #20 if(c !== 194'b10010110011001100001010010010101101010001010011010101000000101000001000000100001000110101000000101010100000110100001000100101000000101001000001001000100001010010100100010100001000010000010010101) $display("Error5: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00000100000001001001010101101010000100010100000110010100100010010010011010001000010001000001000110101000011001010110100000101000010000010010011000000010011001100010010101011001010101010110010100;
  #20 if(c !== 194'b01011000100100100001100100010010000001010110000000010000100100010010100101011010100001011010010100010010001001010101101001001001000110100000011001010101000001000100000001001010100101100100001000) $display("Error6: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00011000011000010001010000100110010110101000010100001000100000100100000001100101010101010010000001010001001001010100101010000101001000011000010110101000001000001010010101011001100001010110010110;
  #20 if(c !== 194'b00000110010100100001100110000100011001001001000010010110100110010100010100100010010000000100101010010010100101101001000001100101100001100010100010100010000010011001011000100100000001010000011000) $display("Error7: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01010010010001000101010001011001000010010100100101101010010101000110101000100000000010100010100010100010000110101000000100000100101000001000010000100000101010011010011001010100010000011000010010;
  #20 if(c !== 194'b10010010001000101000101010000000101001010100010100001010011000001000101010011010000110100001010010101010011001010010000101010000010000101000010010100010001000101000010110000010001010011001000101) $display("Error8: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01000101011010100001001000000010000100000010100101100100010101101000010100001010000000011010010000100010000010100110001000100000100001010101000101010101000000011000010000000100101010010000101010;
  #20 if(c !== 194'b10101000000001100001101001000101000000101001010001010001011001100001010100100000000000011001010010000100101001010000000100101010011001100110000001010101000000000010100001001010100101000010000110) $display("Error9: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10000001011001000000000000101000100010101010100101010010000100001000000101001001000001001010100000001010000000100010100110001010100000101001100100011001000010000110001001100001100000011000011001;
  #20 if(c !== 194'b10010000001000010110000110010101000110010001010000011001011010100101001000100100100110000000010001001010000000100110001001000000010100011001010001010010101001000000100010100100000100100000101010) $display("Error10: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10000101010010100101101000010101010001100101010110011000011010100101001000100001011000001010100000000010011010011000101010010010010010010010100100101000001000100001100000011001010101101001010001;
  #20 if(c !== 194'b01010100100110001001011000101010001010001001011000101010001010010100001000101010101000100010010100100101011010010100010000100110100110001000100000000100100101100100000100100001010101001000100001) $display("Error11: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10010010010010101010010101000101000101001001011010011001010100011000000010100010101001101001100100000000000110100010010000010010100000100101000010001010101010010010000001001010100110010101011010;
  #20 if(c !== 194'b10001000010000000010011001000101001000100100000110000000010010100010011010100010011010100001010000000110100000010100010001001001100001010010100100001000011010011010011010001001010110000001100100) $display("Error12: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01101000000001010110001000001001100100100000100101000010011000001010000010011000001010000100011010100001010001010010011000010000000000010001100000101001010001010110010010010001000010100101001010;
  #20 if(c !== 194'b00001000010100010001000000100101101010000000000100100010100010011001011001101000010101010101010101010010100101101000001010011000011001001010100000000100010110010001101000001010010010000010000000) $display("Error13: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00000100101010010010000101010100000101100100100010001000001000010010000000100100010101000010010101000000001010100010000001001000000010010101100000010110010101010110000100100001010001100100100101;
  #20 if(c !== 194'b00001000000110100001001001100001011010000000001000010101100101001010100001101001101001010101011001010010010100011001011000000010001000100100100101101001100110011000000100010010000001100001000110) $display("Error14: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01100110010000000101001010010110100001011000100000011001100001010110011001100000011001100001100000101001011001100101000000010010000110010001100101100001010000010001001000010000000110000101010100;
  #20 if(c !== 194'b00000001000010010101100100000101001010100101010101011010011000101001101001000000100100000101100000100101000100011010101000000100010101011010101001010000000010000100010101000100010100000010101010) $display("Error15: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10100010011010101000101000100100101001010010001010010001011000100010001001100000101001000101011000000001000110010100011000010000100000000100011010011010001000100010100110101001100010011001000001;
  #20 if(c !== 194'b10101000000100000100100001100000000101101010000110010101010110000110010000011010010000011010010000000110101010010101000110100000011000010001101000010010101000010010101000000101010001000010000010) $display("Error16: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10000110001001000101101010010100100100001001010110000101101000011000000001011010001000001000011000100101100010001001010000011001010101100101010001010001010001100100100000000101001010100101101000;
  #20 if(c !== 194'b01010001100001010110010101010001100101100100101001011001100000100001011001100000010001001010010101010000101010101000011000000001100001011000000001100010001000100101101001000000011001100001010110) $display("Error17: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00010001001010000000100101010000011001010101010110010110100001010001011001010010001001101000100000011000010001010000101010001000100000100000000100100110010110100101001010100101000110010100001010;
  #20 if(c !== 194'b10100000000000010110001000010100100000100101000100011010100001100010101001100001100110001010001001100101010100010010100110011010001000100001100110010101001000000010101001101000001000100001001000) $display("Error18: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10010001101000100001010001100001001000000000000101011001000001011000010100000001010001001010100110010101000110101000000000000101100000101000001000001010000110001000000110000010010000001001101001;
  #20 if(c !== 194'b10100100000100010110000010100000001000100110010000100100011010100110100100000101010110010000001010100100000000101001101010010101010110100010100000100001000101100100100000000110000010010010010001) $display("Error19: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10010010100100000100000010010101001001100010101001100001001000100110000100000000100100010001101001001001000000000100011001100110000100001000100000101000001010011001000001001010010001010101010100;
  #20 if(c !== 194'b00011001101000000000011010011000101010000100100100100010000010011000100000101010011010000101011010010101000000100000011001100101000001101010011010001001010000000001000101011010100000010001100110) $display("Error20: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01000010100000011000011001101001000100000010011001100001010001001000011010010100100001000000010101100001001001000001011010011010010000011010010010010100000001001000010010010101010100101010010010;
  #20 if(c !== 194'b01001000100000000101101010001010011001000000000110100001000001000000100000100100011001010000000010010100001001100100010010001000010101001001010010010110001000101010000001101010010001100000100110) $display("Error21: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00010110010110011001010100101010101001001010010100100110100110010100011001010010001001001000000010001000100010100000100110100000001001100110010100000000000110010001100001010001010000001010101010;
  #20 if(c !== 194'b00000010100001010110000101010010100101101001100100010100101000010100000000000101000010010101000000000101000010000000010001100101001010000100010110010010010010100101011001100100100101000110001010) $display("Error22: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10011001000101100010001010000101000001000110010110100100001000100000010100010101101010000000000100100101010110100000000010000110011001010100000000001000100000100000100000010010000101101000000010;
  #20 if(c !== 194'b01001010100101000001001001011000100000101000011000101000101010101000100010000000011000100010001000100000010110100000100100010010010010101000100010011001000100101001010000100010001010011000100110) $display("Error23: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10001000100110010001010000000100100110100000101001000010000110000100011000000000000101001001100110010101101000010010000101010010000100100010001001100000100110100010010110011000001010100110011010;
  #20 if(c !== 194'b00010101001000011010100100001010101000100110000101011010001000100100101010001001000110011010000100000010100101010101000010100110000110000101000100101000010101000000100100011000010110000100100100) $display("Error24: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01011010100101000101010110001000010101000010100001000000100100101010010010000001100000001000010000100001010000011000010001101010000000010000011000011010001010010110000010000101001010101010011010;
  #20 if(c !== 194'b00000100100000010101100000001000001001000110010100000101001010100110000100100010010010011001100001101010100000000000000010100010000000101010011001011000010001100101011010010010101000101010101001) $display("Error25: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00101010101000010110011010100110010001010110000101010010011000000101000110010001000100101000000101010110001010101000001001101010001010100001011000001000100001001010000010001000100010010001011001;
  #20 if(c !== 194'b00100010000010000010001000101001000001001010101000010100010110000000011010010100100101101000100110010010100000100100000110010000101000100001000000010001010100010001000010010000100110100001101001) $display("Error26: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10011001001010100001010010000010100001010000101010100110010000000100100001001001100000100010100000100000001000100010010010101001101001100010010000100001011000011010000010010100000100000100000001;
  #20 if(c !== 194'b10001010000101001010100000101010000001100000100100100110010100011001100001000110000000100001001010000110001000000100011010000010001000100001100110010101001001100001101010100010100000100101010001) $display("Error27: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10011010001001010010011000100000100101001000000100010100100010101010000001001000100000100010000110011000000001100001010000011000001000010010000100000001000110100110100000101010100101000101000110;
  #20 if(c !== 194'b00011010101000010101001000100010000000101001010000101000011000001001011000010101010010010110010101100110011010011000010100000100100101000000100000000101000010100010001000000000010100101001001010) $display("Error28: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00001010010010100000100010010100100101101010000110010010001001010100000001100101001010100010101001000110101010010110100110000001000010000000010000010000100101100000100000010100100010010100001001;
  #20 if(c !== 194'b00000100010010100000100100010000000101101000101000000101001000000100001010100001100101011010000000100000010110100100011000010101001001000101000100100010100010100110000010101001001000000100010110) $display("Error29: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01010001101010100100100001101010011010010001100001010100100000101010000101001010000000010000100110010000100010010001011010011010001001010001011010100000001010010000011000100110000100100001100110;
  #20 if(c !== 194'b00010110100001010101100000010101000101100010010110000010000100010000000000011010101010100001010000001000010101011010100100100001101000010010101010011010000001100100000001100001010110100000100110) $display("Error30: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01100100100100100000010010100100010001010100100100101010000001010101010000010100100010000110100010100100101010100110010100101010001000101010000000101010001010001000010100001001001000000110011000;
  #20 if(c !== 194'b00010010000000001010001010010110010000101000001000010010011010000010000100100110001010010100001010001000001001101001010100010110001000011000010100010100000010100100100010001010101001100000100110) $display("Error31: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00010001100110010010000000010100100001010110010001000010000110100101001010010001100000010000000000011010000001101000000100010110000101011000100101101001000000001001010101000010010100100101100101;
  #20 if(c !== 194'b00101001000101001001011010001000010110000001000101101010000010001001010100000000100000010000010110000101011001011001000001011000000010010010010100101010101010101000100000001000010001011000100000) $display("Error32: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10101000000110001000101000010101001001000101011000010001011010011000100110100100100110011001010101000001010001100110011010000000011001101000011010000001011000100010000010010010100100101010101010;
  #20 if(c !== 194'b01000110010001010010011010001000011001101010100010001000000000010101000001010110010100010010000000000110000100101000100010001010010101000000000110100001100010010100100010101001001010000000000010) $display("Error33: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10100100000001001001010001001000100101000000010100010110100001100101100110010001001001100001001010101000010000010110101001010001011010100101000000000001100000011000001000100101100000011000101010;
  #20 if(c !== 194'b01100110000010100010000001100001100100100100100000001000011000010101000010010000100100010101100110011000101000100010100000001000010110010000101010000000011000100100011010010110011001001001010110) $display("Error34: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10100010010000100000010010000100000001101000000010100101100001100110100010100010010010001010010000100010000100010000101000100101010101010000000010001001010110001010001010000001010110011000011001;
  #20 if(c !== 194'b01100001001001100101010100010000100000011000101010101000010010010001001001100101000010011000011010000110011000001010010010000001011001011001100010001000010110010101010000000100100100011010011010) $display("Error35: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01000000011000000101000101000100010101100010010101100010100110000001101000100110100101100101000110011010100010101001010001001000001010000100000101011010011010010110010000100010000100001001000100;
  #20 if(c !== 194'b00000010100010010000000101010000010000000101000101010001001010011010010001101010000010010001100001001010011001001000001000000001101000010010100000010000010101100100000110011000000010100001000100) $display("Error36: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00011000010001010001010100000100000001101000000101000110010010100010010101101001011010100000010010000010100010100000100000010010100001000101100101101010011000100001100100101010000000101001000010;
  #20 if(c !== 194'b10100100001001100100001001000101000110000001101001010010100110010010100001011010000000011010010000000001000010011001001000100110000001000000101000001010101000100101011001000110010101000100100100) $display("Error37: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00010101010000000001100001100101010010100100000001000010010101101000100010101010000101000101010110100110010010000010100010000000010101100001000100010001010001001010000110000100100100000000010010;
  #20 if(c !== 194'b01000101011001000010010100101001010000010001100100101001000000001001100001100000101001000000100010010010100000101001100110010000010100000110000101010100100100100000000100101001000110001001001000) $display("Error38: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01000000011010100001010100101000011000100110000010010101001010100100010010010000000000101010100000101001000000010110010010000100010001100010100101010001100101100010101001011001001010000110000000;
  #20 if(c !== 194'b01101000100001010010000000100110011010001001010001010101011000010001100010101001000001001010101000000110101010100110000001100000011010100001010000100001100000000101000010101001001010010110001010) $display("Error39: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01000110010000101010010000101000100001100000000000101010011001001000000001100000001000011010101001011010000001101000010001010010000100000000010000000001100101101010000000100010101000100000000000;
  #20 if(c !== 194'b00010101011000001000000100010000000101000000101000010100000100010101101010011001011001000010001010011010011000010000000100010101000100000001101000010001100100010010011001011010011000000101100001) $display("Error40: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01000100010010000000010001001001100010000101100101100010011000000000000010100000010101100010011001010010100100010110001000101010010001000100010100011010100010001010000001100110000010101001101010;
  #20 if(c !== 194'b01011000010001000100000001011000010001101001010100010001100010001010000110100100010110010000001010100110000000000100010001010001101001001001100000011010000110010000001010000100101010100010100010) $display("Error41: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00010000100101100000101001010100001010011001011000011000000010100010001000101001010110001001000001010101100010100101010100011000010101001010010110100100010100000100010110000001100000100100100101;
  #20 if(c !== 194'b01001001001001010000010110100010011001000101010110100110000001101000000001010001000100100100100001101000010101101001100010011000101010011001010110010001000010100101010110000010010101101010000000) $display("Error42: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01000001100010100010001010100110011001101000000010100101000000011001010110000100101000100101010010011010100001101001000001010001000000010001100010100010010010001000000000010110010110011001101010;
  #20 if(c !== 194'b00000000011000001001011000000101010110010000010010010010010000101010100001101000000110101000010110001000010100011000000000000100101001010110101000010110000010001010100000010101011010001001010010) $display("Error43: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01101010101001010000010010101000100010011010100001100010011000010010100101010001100100011001100010000110010110100101010000001010001010010100001010010101100010011010011000010101010110011000100001;
  #20 if(c !== 194'b00100010010110100101000001100100000100000110000110000101001001011001010110000000010110010001010110011010100101100110000000000100000010011010100010011010010000101000010101000100000000100100100001) $display("Error44: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01101001010100101001000101010101011000100101101001100110000100000010001000010010100001000010000000000010100110010001000101100000011000000100001001001000000110000001000010010010010101001000000010;
  #20 if(c !== 194'b01000110010100001000000101010100010000100110100101100100010110010100000100000001100110000000011000010001101000010000010010101000000101100000000100100100101000000100010100010010101000000010000110) $display("Error45: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b00011010100001001000011001010101001010011010011010010110011000000010010110011001000100010100100100011001000010010110100001100000000000010110100100100101010001010001100001000110000100000100000101;
  #20 if(c !== 194'b00010100010100100101000101101010000110100001000000100010010001010101000101010000101001000101000100000101011010000100001001101000011000001000010101000010001000101010000001010110100001001001001000) $display("Error46: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01010001100010000100101000010101000001000000010001100101100000011000101000011010001010011001001001101000100010100100011000000000100110010010100001100000000000000110000100011000001010000100011010;
  #20 if(c !== 194'b10100101100110000101000000000010100110001000010001010110010100100100100000010000100100010000100101100110101000000001010100010000001001011000001010011000001010010001100101000000000010000101001000) $display("Error47: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b01000101101000000000011001100000100101000001011010100100010110010010010110101010011010100010101001000101000100101010010110000110100000100000100001100100100010010000100110010101100100101000011001;
  #20 if(c !== 194'b10010000001000101010100000010000000110000100001001010010000001001000001010100000100110011001011000010100100110010001101010010000100101100100010001000010101001000110101010100100001000010100100010) $display("Error48: %b, %b", a, c);
  P=194'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010;
  a = 194'b10101001010110010110000100011010010101010110010001000010010010101010011010000000010000010110100101100100011010000000000010100010000110100001011010101010100010010110011010011000001010101000010000;
  #20 if(c !== 194'b00000101101010010110100000011001000101000110100110001010010110010010000110001000000110010101010001000010000001101010000010010010101000100001000110010101011001000000010001101000100101000101100010) $display("Error49: %b, %b", a, c);
  a = 194'h5206962805a8a465894054aa459116a64646289a89009a00;
  #20;
  if (c !== 194'h215026a44886612a8a449999a5a499512a0a4919985aa9a59)
    $display("E");
  $finish;
  end
endmodule

