module tb_bug7
import keymgr_pkg::*;();
    reg clk_i, rst_ni, adv_en_i;
    wire kmac_done_error_o, done_o;
    kmac_pkg::app_rsp_t kmac_data_i;

    // wire [9:0] state_d_o;

    integer i;
    // bit ft_passed = 0;

    localparam period = 20;
    keymgr_kmac_if  UUT (
    .clk_i(clk_i), .rst_ni(rst_ni), .adv_en_i(adv_en_i), .kmac_data_i(kmac_data_i),
    .kmac_done_error_o(kmac_done_error_o), .done_o(done_o)
    // , .state_d_o(state_d_o)
      );

    initial // Clock generation
        begin
        clk_i = 0;
        forever begin
        #(period/2);
        clk_i = ~clk_i;
        end
    end

    initial begin

        rst_ni = 0;
        #period;
        if( kmac_done_error_o === 1) begin
            $display("test 1 failed");
            $finish;
        end

        rst_ni = 1;
        #period;
        if( kmac_done_error_o === 1) begin
            $display("test 2 failed");
            $finish;
        end

        adv_en_i = 1;
        #period;
        if( kmac_done_error_o === 1) begin
            $display("test 3 failed");
            $finish;
        end

        kmac_data_i.ready=1;
        #(period*10);
        kmac_data_i.done=1;
        #period;
        if( kmac_done_error_o !==1 ) begin
            $display("test 4 failed");
            $finish;
        end

        kmac_data_i.done=0;
        #(period*15);
        if( kmac_done_error_o !==1 ) begin
            $display("test 5 failed");
            $finish;
        end

        rst_ni = 0;
        #period;
        rst_ni = 1;
        #period;
        adv_en_i = 1;
        #period;
        kmac_data_i.ready=1;
        #(period*25);
        kmac_data_i.done=1;
        if( kmac_done_error_o ===1 ) begin
            $display("test 6 failed");
            $finish;
        end



        $display("all tests passed");
        $finish;
    end

endmodule