module tb_bug6
import otp_ctrl_pkg::*;
import otp_ctrl_reg_pkg::*;
import otp_ctrl_part_pkg::*;
();

    reg clk_i, rst_ni, lci_en_i, lc_req_i, otp_gnt_i, otp_rvalid_i;
    wire lc_ack_o, lc_err_o, fsm_err_o, lci_prog_idle_o, otp_req_o;
    lc_ctrl_pkg::lc_tx_t escalate_en_i;
    // reg [Info.size*8-1:0]  lc_data_i;
    otp_err_e error_o;
    prim_otp_pkg::cmd_e                otp_cmd_o;
    wire [OtpSizeWidth-1:0]           otp_size_o;
    wire [OtpIfWidth-1:0]             otp_wdata_o;
    wire [OtpAddrWidth-1:0]           otp_addr_o;
    reg  [ScrmblBlockWidth-1:0]             otp_rdata_i;
    reg                otp_err_i;

    localparam period = 20;
    otp_ctrl_lci  UUT (
    .clk_i(clk_i), .rst_ni(rst_ni), .lci_en_i(lci_en_i), .lc_req_i(lc_req_i), .fsm_err_o(fsm_err_o), 
    .otp_req_o(otp_req_o), .lc_err_o(lc_err_o), .escalate_en_i(escalate_en_i)
    );

    initial // Clock generation
        begin
        clk_i = 0;
        forever begin
        #(period/2);
        clk_i = ~clk_i;
        end
    end

    initial begin

        rst_ni = 0;
        #period;
        // $display("fsm_err_o=%b, lc_err_o=%b, ", fsm_err_o, lc_err_o);

        lci_en_i = 1;
        #period;
        // $display("fsm_err_o=%b, lc_err_o=%b, ", fsm_err_o, lc_err_o);

        lc_req_i = 1;
        #period;
        // $display("fsm_err_o=%b, lc_err_o=%b, ", fsm_err_o, lc_err_o);

        escalate_en_i = lc_ctrl_pkg::Off;
        #period;
        if( fsm_err_o!==0 ) begin
            $display("test 1 failed");
            $finish;
        end
        // $display("fsm_err_o=%b, lc_err_o=%b, ", fsm_err_o, lc_err_o);

        escalate_en_i = lc_ctrl_pkg::On;
        #period;
        if( fsm_err_o!==1 ) begin
            $display("test 2 failed");
            $finish;
        end
        // $display("fsm_err_o=%b, lc_err_o=%b, ", fsm_err_o, lc_err_o);

        $display("all tests passed");
        $finish;
    end

endmodule