module tb_bug5;

    parameter int NumWords = 2;

    reg clk_i, rst_ni, start_i;
    reg [NumWords*32-1:0] digest_i, exp_digest_i;
    wire done_o, alert_o;

    // duration for each bit = 20 * timescale = 20 * 1 ns  = 20ns
    localparam period = 20;
    rom_ctrl_compare UUT (
        .clk_i(clk_i), .rst_ni(rst_ni), .start_i(start_i), .digest_i(digest_i), .exp_digest_i(exp_digest_i), 
        .done_o(done_o), .alert_o(alert_o)
    );

    initial // Clock generation
        begin
        clk_i = 0;
        forever begin
        #(period/2);
        clk_i = ~clk_i;
        end
    end

    initial begin
        rst_ni = 0;
        start_i = 0;
        digest_i = 64'h0000_0000;
        exp_digest_i= 64'h0000_0000;
        # period;
        # period;
        // $display("done_o=%b, alert_o=%b", done_o, alert_o);
        if(alert_o !== 1'b0 || done_o!==1'b0 ) begin
            $display("test 1 failed");
            $finish;
        end

        start_i = 1;
        digest_i = 64'h0001_0000;
        exp_digest_i= 64'h0001_0000;
        # period;
        // $display("done_o=%b, alert_o=%b", done_o, alert_o);
        if(alert_o !== 1'b0 || done_o!==1'b0 ) begin
            $display("test 2 failed");
            $finish;
        end

        rst_ni = 1;
        digest_i = 64'h0001_0000;
        exp_digest_i= 64'h0001_0000;
        # period;
        // $display("done_o=%b, alert_o=%b", done_o, alert_o);
        if(alert_o !== 1'b1 || done_o!==1'b0 ) begin
            $display("test 3 failed");
            $finish;
        end

        start_i = 0;
        # period;
        // $display("done_o=%b, alert_o=%b", done_o, alert_o);
        if(alert_o !== 1'b0 || done_o!==0) begin
            $display("test 4 failed");
            $finish;
        end
        # period;
        // $display("done_o=%b, alert_o=%b", done_o, alert_o);
        if(alert_o !== 1'b0 || done_o!==1) begin
            $display("test 5 failed");
            $finish;
        end
        # period;
        // $display("done_o=%b, alert_o=%b", done_o, alert_o);
        if(alert_o !== 1'b0 || done_o!==1) begin
            $display("test 6 failed");
            $finish;
        end

        $display("all tests passed");
        $finish;

    end

endmodule