module tb_bug2;

    reg clk, resetn, unlock, d;
    wire locked;

    reg locked_prev_value;
    bit test1 = 0; 
    bit test2 = 0; 
    
    // duration for each bit = 20 * timescale = 20 * 1 ns  = 20ns
    localparam period = 20;
    lock_on_reset UUT (
        .clk(clk), .resetn(resetn), .unlock(unlock), .locked(locked), .d(d)
    );

    initial // Clock generation
        begin
        clk = 0;
        forever begin
        #(period/2);
        clk = ~clk;
        end
    end

    initial begin

        // checking for reset condition (~reset_n). test 1
        resetn=0;
        unlock=1;
        d=1;
        # period;
        $display("locked: %b.", locked);
        locked_prev_value = locked;
        d=0;
        #period;
        $display("locked: %b.", locked);
        if(locked_prev_value === locked ) test1 = 1;

        // checking for reset condition (reset_n). test 2
        resetn=1;
        unlock=1;
        d=1;
        # period;
        locked_prev_value = locked;
        d=0;
        #period;
        if(locked_prev_value === locked ) test2 = 1;

        $display("test 1: %b, test2: %b.", test1, test2);

        if((test1 || test2)!=1) begin
            $display("test 1 or 2 failed");
            $finish;
        end

        // // get out of reset
        // resetn=1;
        // # period;

        // // unlock and assign 1 to locked
        // unlock = 1;
        // d = 1;
        // # period;
        // if(locked !== 1 ) begin
        //     $display("test 1 failed");
        //     $finish;
        // end

        // // assign 0 to locked
        // d = 0;
        // # period;
        // if(locked !== 0 ) begin
        //     $display("test 2 failed");
        //     $finish;
        // end

        // // lock and assign 1 to locked. locked should not change, should remain 0
        // unlock = 0;
        // #period;
        // d = 1;
        // # period;
        // if(locked !== 0 ) begin
        //     $display("test 3 failed");
        //     $finish;
        // end

        // // assign 1 to locked
        // unlock=1;
        // # period;
        // d = 1;
        // # period;

        // // lock and assign 0 to locked. locked should not change, should remain 1
        // unlock = 0;
        // #period;
        // d = 0;
        // # period;
        // if(locked !== 1 ) begin
        //     $display("test 4 failed");
        //     $finish;
        // end
        
        $display("all tests passed");
        $finish;

    end


endmodule