# takes as inputs bug_file and functional/secure

import os
import sys

n = len(sys.argv)
if(n!=3):
    sys.exit('Number of arguments is not correct. There should be 2 inputs. bug_file and f/s')

f_files_needed = ['bug4', 'bug5', 'bug6']
bug_file = sys.argv[1]
bug_id = bug_file[:4]
if bug_file[4]=="0":
    bug_id = bug_file[:5]

mode = sys.argv[2] # could be f (functional) or s (secure)
# print(mode)
if(mode!='f' and mode!='s'):
    sys.exit('Incorrect mode specified. Should be f or s')

if mode=='f':
    testbench_path = "functional_tests/testbenches/"
elif mode=='s':
    testbench_path = "security_tests/testbenches/"

if bug_id in f_files_needed:
    
    # ready .f file with test file and tb
    f_file = open(bug_id+".f","r")
    pre = ''.join( f_file.readlines() )
    f_file.close()
    f_file_new = open(bug_id+".f","w")
    f_file_new.seek(0)
    f_file_content = pre + "\ntests/"+bug_file+".v\n"+ testbench_path+"tb_"+bug_id+".sv"
    f_file_new.write(f_file_content)
    f_file_new.truncate()

    # form command
    cmd = "xvlog -sv -f "+bug_id+".f " + "&& xelab -debug typical -top tb_"+bug_id+ " -snapshot "+bug_id+"_tb_snapshot && xsim "+bug_id+"_tb_snapshot -R"
    print("running ", cmd)
    os.system(cmd)

    f_file_new.seek(0)
    f_file_new.write(pre)
    f_file_new.truncate()
    f_file_new.close()

else:
    cmd = "xvlog -sv tests/" + bug_file+ ".v "+testbench_path+"tb_"+bug_id+".sv && xelab -debug typical -top tb_"+bug_id+ " -snapshot "+bug_id+"_tb_snapshot && xsim "+bug_id+"_tb_snapshot -R"
    print("running ", cmd)
    os.system(cmd)

