module tb_bug9();

    reg clk, rst_ni;
    reg start_i; 
    reg [31:0] done_i;
    wire [31:0] valid_o;

    integer  i;
    
    // duration for each bit = 20 * timescale = 20 * 1 ns  = 20ns
    localparam period = 20;
    dma UUT (.clk_i(clk), .rst_ni(rst_ni), .done_i(done_i), .start_i(start_i),
        .valid_o(valid_o)
        // .set_pc_commit_o(set_pc_commit), .flush_if_o(flush_if), 
        // .flush_unissued_instr_o(flush_unissued_instr), .flush_id_o(flush_id), 
        // .flush_ex_o(flush_ex)
    );

    initial // Clock generation
        begin
        clk = 0;
        forever begin
        #(period/2);
        clk = ~clk;
        end
    end

    initial begin

        // set inputs
        rst_ni = 0;
        start_i = 0;
        #period;
        // $display("valid_o = %b", valid_o);

        if(valid_o !== 0) begin
            $display("test 1 failed");
            $finish;
        end

        rst_ni = 1;
        #period;
        // $display("valid_o = %b", valid_o);
        if(valid_o !== 1'b0) begin
            $display("test 2 failed");
            $display("valid_o = %b", valid_o);
            $finish;
        end

        start_i = 1;
        #period;
        // $display("valid_o = %b", valid_o);
        if(valid_o !== 1'b0) begin
            $display("test 3 failed");
            $display("valid_o = %b", valid_o);
            $finish;
        end

        // for (i=0;i<100;i=i+1) begin
        //     #period;
        //     $display("valid_o = %b", valid_o);
        // end

        // done_i = 1;

        // for (i=0;i<100;i=i+1) begin
        //     #period;
        //     $display("valid_o = %b", valid_o);
        // end

        $display("all tests passed");
        $finish;

    end


endmodule