module tb_bug8
import ariane_pkg::*;();

    // typedef struct packed {
    //     logic [63:0] cause; // cause of exception
    //     logic [63:0] tval;  // additional information of causing exception (e.g.: instruction causing it),
    //                         // address of LD/ST fault
    //     logic        valid;
    // } exception_t;

    // typedef enum logic [6:0] { // basic ALU op
    //                            ADD, SUB, ADDW, SUBW,
    //                            // logic operations
    //                            XORL, ORL, ANDL,
    //                            // shifts
    //                            SRA, SRL, SLL, SRLW, SLLW, SRAW,
    //                            // comparisons
    //                            LTS, LTU, GES, GEU, EQ, NE,
    //                            // jumps
    //                            JALR, BRANCH,
    //                            // set lower than operations
    //                            SLTS, SLTU,
    //                            // CSR functions
    //                            MRET, SRET, DRET, ECALL, WFI, FENCE, FENCE_I, SFENCE_VMA, CSR_WRITE, CSR_READ, CSR_SET, CSR_CLEAR,
    //                            // LSU functions
    //                            LD, SD, LW, LWU, SW, LH, LHU, SH, LB, SB, LBU,
    //                            // Atomic Memory Operations
    //                            AMO_LRW, AMO_LRD, AMO_SCW, AMO_SCD,
    //                            AMO_SWAPW, AMO_ADDW, AMO_ANDW, AMO_ORW, AMO_XORW, AMO_MAXW, AMO_MAXWU, AMO_MINW, AMO_MINWU,
    //                            AMO_SWAPD, AMO_ADDD, AMO_ANDD, AMO_ORD, AMO_XORD, AMO_MAXD, AMO_MAXDU, AMO_MIND, AMO_MINDU,
    //                            // Multiplications
    //                            MUL, MULH, MULHU, MULHSU, MULW,
    //                            // Divisions
    //                            DIV, DIVU, DIVW, DIVUW, REM, REMU, REMW, REMUW,
    //                            // Floating-Point Load and Store Instructions
    //                            FLD, FLW, FLH, FLB, FSD, FSW, FSH, FSB,
    //                            // Floating-Point Computational Instructions
    //                            FADD, FSUB, FMUL, FDIV, FMIN_MAX, FSQRT, FMADD, FMSUB, FNMSUB, FNMADD,
    //                            // Floating-Point Conversion and Move Instructions
    //                            FCVT_F2I, FCVT_I2F, FCVT_F2F, FSGNJ, FMV_F2X, FMV_X2F,
    //                            // Floating-Point Compare Instructions
    //                            FCMP,
    //                            // Floating-Point Classify Instruction
    //                            FCLASS,
    //                            // Vectorial Floating-Point Instructions that don't directly map onto the scalar ones
    //                            VFMIN, VFMAX, VFSGNJ, VFSGNJN, VFSGNJX, VFEQ, VFNE, VFLT, VFGE, VFLE, VFGT, VFCPKAB_S, VFCPKCD_S, VFCPKAB_D, VFCPKCD_D
    // } fu_op;

    reg clk, rst_ni, debug_req_i;
    reg [1:0] irq_i;
    wire halt_csr_o;
    fu_op csr_op_i;
    exception_t ex_i;
    
    // duration for each bit = 20 * timescale = 20 * 1 ns  = 20ns
    localparam period = 20;
    csr_regfile UUT (.clk_i(clk), .rst_ni(rst_ni),
        .debug_req_i(debug_req_i) , .irq_i(irq_i), .ex_i(ex_i),
        .halt_csr_o(halt_csr_o), 
        .csr_op_i(csr_op_i)
        // .set_pc_commit_o(set_pc_commit), .flush_if_o(flush_if), 
        // .flush_unissued_instr_o(flush_unissued_instr), .flush_id_o(flush_id), 
        // .flush_ex_o(flush_ex)
    );

    initial // Clock generation
        begin
        clk = 0;
        forever begin
        #(period/2);
        clk = ~clk;
        end
    end

    initial begin

        // set inputs
        rst_ni = 0;
        debug_req_i = 0;
        irq_i = 0;
        # period;
        // check output
        if(halt_csr_o !== 1'b0) begin
            $display("test 1 failed");
            $display("halt_csr_o = %b", halt_csr_o);
            $finish;
        end

        rst_ni = 1;
        if(halt_csr_o !== 1'b0) begin
            $display("test 2 failed");
            $display("halt_csr_o = %b", halt_csr_o);
            $finish;
        end

        // set inputs to assert halt_csr_o
        csr_op_i = WFI; 
        ex_i.valid=0;
        # period;
        if(halt_csr_o !== 1'b1) begin
            $display("test 3 failed");
            $display("halt_csr_o = %b", halt_csr_o);
            $finish;
        end
        // $display("halt_csr_o = %b", halt_csr_o);
        // # period;
        // $display("halt_csr_o = %b", halt_csr_o);
        // # period;
        // $display("halt_csr_o = %b", halt_csr_o);

        // if(halt_csr_o !== 1'b1) begin
        //     $display("test 2 failed");
        //     $display("halt_csr_o = %b", halt_csr_o);
            // $finish;
        // end

        // set inputs to deassert halt_csr_o
        debug_req_i = 0;
        irq_i[1] = 1;
        # period;
        // check output
        if(halt_csr_o !== 1'b0) begin
            $display("test 4 failed");
            $display("halt_csr_o = %b", halt_csr_o);
            $finish;
        end


        $display("all tests passed");
        $finish;

    end


endmodule