module tb_bug10();

    reg clk, rst;
    reg start;
    wire ct_valid_out;
    // reg start_i; 
    // reg [31:0] done_i;
    // wire [31:0] valid_o;

    integer  i;
    bit tests_passed = 0;
    
    // duration for each bit = 20 * timescale = 20 * 1 ns  = 20ns
    localparam period = 20;
    aes2_interface UUT (.clk(clk), .rst(rst), 
        .start(start),
        .ct_valid_out(ct_valid_out)
        // .done_i(done_i), .start_i(start_i),
        // .valid_o(valid_o)
        // .set_pc_commit_o(set_pc_commit), .flush_if_o(flush_if), 
        // .flush_unissued_instr_o(flush_unissued_instr), .flush_id_o(flush_id), 
        // .flush_ex_o(flush_ex)
    );

    initial // Clock generation
        begin
        clk = 0;
        forever begin
        #(period/2);
        clk = ~clk;
        end
    end

    initial begin

        // set inputs
        rst = 0;
        start = 0;
        #period;
        // $display("ct_valid_out = %b", ct_valid_out);
        if(ct_valid_out !== 0) begin
            $display("test 1 failed");
            $finish;
        end

        rst = 1;
        #period;
        // $display("ct_valid_out = %b", ct_valid_out);
        if(ct_valid_out !== 1'b0) begin
            $display("test 2 failed");
            $finish;
        end

        start = 1;
        #period;
        // $display("ct_valid_out = %b", ct_valid_out);
        if(ct_valid_out !== 1'b0) begin
            $display("test 3 failed");
            $finish;
        end

        for (i=0;i<100;i=i+1) begin
            #period;
            // $display("ct_valid_out = %b", ct_valid_out);
            if (ct_valid_out == 1) begin
                tests_passed = 1;
                break;
            end
        end

        if(tests_passed != 1)begin
            $display("test 4 failed");
            $finish;
        end

        // done_i = 1;

        // for (i=0;i<100;i=i+1) begin
        //     #period;
        //     $display("valid_o = %b", valid_o);
        // end

        $display("all tests passed");
        $finish;

    end


endmodule