module tb_bug1;

    reg clk, resetn, write, lock_status, debug_unlocked;
    reg [15:0] Data_in;
    wire [15:0] Data_out; 
    
    // duration for each bit = 20 * timescale = 20 * 1 ns  = 20ns
    localparam period = 20;
    locked_register UUT (
        .clk(clk), .resetn(resetn), .write(write), .Data_in(Data_in),
        .lock_status(lock_status), .debug_unlocked(debug_unlocked),
        .Data_out(Data_out)
    );

    initial // Clock generation
        begin
        clk = 0;
        forever begin
        #(period/2);
        clk = ~clk;
        end
    end

    initial begin

        // set inputs
        resetn=0;
        Data_in=16'h0010;
        write=0;
        lock_status=0; 
        debug_unlocked=0;
        # period;
        // check output
        if(Data_out !== 16'h0000 ) begin
            $display("test 1 failed");
            $finish;
        end
        // else $display("load =%b, amount = %b, ena=%b, q=%b",load,amount,ena, q);

        // set inputs
        resetn=1;
        Data_in=16'h0010;
        write=1;
        lock_status=0; 
        debug_unlocked=0;
        # period;
        // check output
        if(Data_out !== 16'h0010 ) begin
            $display("test 2 failed");
            $finish;
        end

        // set inputs
        resetn=1;
        Data_in=16'h1010;
        write=0;
        lock_status=0; 
        debug_unlocked=0;
        # period;
        // check output
        if(Data_out === 16'h1010 ) begin
            $display("test 3 failed");
            $finish;
        end

        // set inputs
        resetn=1;
        Data_in=16'h0011;
        write=1;
        lock_status=1; 
        debug_unlocked=0;
        # period;
        // check output
        if(Data_out === 16'h0011 ) begin
            $display("test 4 failed");
            $finish;
        end

        $display("all tests passed");
        $finish;

    end


endmodule