import os
import csv
import subprocess

# log file
log_file = open("evaluation_repairs_CWEAT.log","w")
log_file.write("starting evaluation...\n")

# form a list of dictionaries with all bugs
bugs_dicts = []
designs = ['h-21']
for design in designs:
    with open ('../results/bug_locations/'+design+'.csv', mode='r') as csv_file: 
        bugs_dict = csv.DictReader(csv_file) # each row of bugs_dict is a bug
        for bug_dict in bugs_dict:
            # (bug_dict, setup file)
            bugs_dicts.append((bug_dict,design))

log_file.write("This list of dictionaries contains all bugs:\n")
for bug in bugs_dicts:
    log_file.write( str(bug) )
    log_file.write('\n')

# print(bugs_dicts)

# file for all results
repair_results_file = open("../results/repairs/results_codegen_bug10.csv","w")
repair_results_file.write('Bug ID,Instruciton variation, Temp, Example#, Functional?, Secure?\n')
log_file.write("repair results file created and initiated.\n")

# for each bug
    # for each example
        # replace the repaired file in SoC/design (repair copy) with the example
        # run the detection tool
        # output result to a csv
        # read the csv to see if the bug found is the same

n = 20
instruction_variations = ['-a','-b','-c','-d','-e']
temp = [0.1, 0.3, 0.5, 0.7, 0.9]

for bug in bugs_dicts:

    str_temp = "\nworking on bug " + bug[0]["ID"] + '\n'
    log_file.write( str_temp )

    # design filepaths file
    design_filepaths_repaired = "designs_filepaths/"+ bug[1] + "_repaired.txt"
    #repaired result file (temp)
    repaired_result_filepath = "../results/bug_locations/"+bug[1]+"_repaired.csv"

    # buggy file path (repair copy)
    bug_id = bug[0]["ID"]
    # print(bug_id)
    buggy_file_path = bug[0]["filepath"]
    original_cwe = bug[0]["cwe"]
    original_start_loc = bug[0]["line-start"]

    if(bug_id != 'bug10'):
        continue
    
    # replacing design name in filepath
    sub1 = "designs/"
    sub2 = "/"
    idx1 = buggy_file_path.find(sub1)
    idx2 = buggy_file_path[idx1+ len(sub1):].find(sub2)
    res = buggy_file_path[idx1 + len(sub1) : idx1 + len(sub1) + idx2]
    repaired_file_path = buggy_file_path.replace( res , res + "_repaired" )[12:]

    # print(repaired_file_path)

    # getting the original buggy text
    buggy_file = open(buggy_file_path[12:],"r")
    original_buggy_text = ''.join(buggy_file.readlines())
    buggy_file.close()
    repaired_file = open(repaired_file_path,"w")

    # get paths for examples
    # r=root, d=directories, f = files
    # examples_paths=[]
    # for r, d, f in os.walk(os.path.join('..','repairs',bug_id)):
    #     for file in f:
    #         if file.startswith("example"):
    #             examples_paths.append(os.path.join(r, file))

    log_file.write(bug_id+" \n\n")
    log_file.flush()

    # pre is the .f file without the design file and the testbench. It contains all the necessary dependencies
    pre=''
    f_file = open(bug_id+".f","r")
    pre = ''.join( f_file.readlines() )
    f_file.close()

    for instruction_variation in instruction_variations:
        for t in temp:
            print("evaluating bug ",bug_id, " instruction variation ", instruction_variation, " temp ",t)
            for i in range(n):

                example_filename = "example"+str(i)+ '_i'+instruction_variation+'_t-'+str(t)+".v"

                # if not (example_filename == 'example7_i-b_t-0.9.v'): # to run specific file
                #     continue

                if (example_filename == 'example13_i-b_t-0.9.v'): # to ignore specific file
                    continue

                functional = False
                secure = True

                log_file.write(example_filename + "\n\n")
                log_file.flush()
        
                # get repaired file
                example_file = open(os.path.join('..','repairs',bug_id,example_filename),"r")
                example = ''.join(example_file.readlines())
                example_file.close()
                # print(example)
        
                # owerwrite buggy file (in repaired copy)
                repaired_file.seek(0)
                repaired_file.write(example)
                repaired_file.truncate()

                ''' functional evaluation '''
                # add the following lines to the .f file for the bug
                # ../repairs/bug1/example0.v
                # functional_tests/testbenches/tb_bug1.sv
                f_file_new = open(bug_id+"-new.f","w")
                f_file_new.seek(0)
                f_file_content = pre + "\n../repairs/"+bug_id+"/"+ example_filename + "\nfunctional_tests/testbenches/tb_"+bug_id+".sv"
                f_file_new.write(f_file_content)
                # f_file_new.flush()
                # print(f_file_content)
                f_file_new.truncate()
                f_file_new.close()
                log_file.write(".f file created: \n" + f_file_content + "\n")
                log_file.flush()

                # run the analysis command (e.g. cmd = "xvlog -sv -f bug1.f" )
                cmd = "xvlog -sv -f "+bug_id+"-new.f"
                result = subprocess.run(cmd.split(' '), stdout=subprocess.PIPE).stdout.decode('utf-8')
                log_file.write("running " + cmd + '\n')
                log_file.write("output: " + result + '\n')
                log_file.flush()


                # run the elaboration command (e.g. cmd = "xelab -debug typical -top tb_bug1 -snapshot bug1_tb_snapshot")
                bug_snapshot = bug_id+"_tb_snapshot"
                cmd = "xelab -debug typical -top tb_"+bug_id+" -snapshot "+bug_snapshot
                result = subprocess.run(cmd.split(' '), stdout=subprocess.PIPE).stdout.decode('utf-8')
                log_file.write("running " + cmd + '\n')
                log_file.write("output: " + result + '\n')
                log_file.flush()

                # run the simulation command (e.g. cmd = "xsim bug1_tb_snapshot -R)
                cmd  = 'xsim '+bug_snapshot+' -R'
                result = subprocess.run(cmd.split(' '), stdout=subprocess.PIPE).stdout.decode('utf-8')
                log_file.write("running " + cmd + '\n')
                log_file.write("output: " + result + '\n')
                log_file.flush()

                # print(result)
                if("all tests passed" in result):
                    functional = True

                # clean all the files generated by modelsim
                cmd = "rm *.wdb *.pb *.jou *.backup.log xsim.log xvlog.log xelab.log"
                os.system(cmd)
                cmd = "rm -rf xsim.dir"
                os.system(cmd)

                ''' security evaluation '''

                # run detection tool
                base_dir = os.getcwd()
                os.chdir("CWEAT/verific_lib_eval/examples/CWEET-internal-main/")
                repaired_file_path = "../../../../" + repaired_file_path
                cmd = "./cweet_scanner-linux " + design_filepaths_repaired + " "+ repaired_file_path + " " + original_cwe
                # print(cmd)
                log_file.write( "running "+ cmd + '\n' )
                result = subprocess.run(cmd.split(' '), stdout=subprocess.PIPE).stdout.decode('utf-8')
                # os.system(cmd)
                # log_file.write("output: " + result + '\n')


                # get back to repairs directory
                os.chdir(base_dir)
                repaired_file_path = repaired_file_path[12:]

                with open (repaired_result_filepath, mode='r') as csv_file: 
                    bugs_dicts_repaired = csv.DictReader(csv_file) # each row of bugs_dict is a bug
                    # write the temporary result of the repaired design to the log file
                    log_file.write("temp results:\n")
                    for b in bugs_dicts_repaired:
                        log_file.write(str(b) + '\n')
                        if( b["filepath"][12:]==repaired_file_path and b["cwe"]==original_cwe and b["line-start"]==original_start_loc ):
                            log_file.write ( " b[\"filepath\"][12:]= "+ b["filepath"][12:]+" repaired_file_path= "+repaired_file_path )
                            secure=False
                            break
        
                # write to results repairs
                str_temp = bug_id+','+instruction_variation+','+str(t)+','+str(i)+','+str(functional)+','+str(secure)+'\n'
                repair_results_file.write(str_temp)
                repair_results_file.flush()

                # reset the buggy file to original version
                repaired_file.seek(0)
                repaired_file.write(original_buggy_text)
                repaired_file.truncate()
    
    repaired_file.close()

repair_results_file.close()
log_file.close()