# requires testbenches files for all bugs separately

import os
import subprocess

# log file
log_file = open('evaluate_repairs.log',"w")

# bugs = ["bug4"]
bugs = ["bug4","bug5","bug6", "bug7"]
# bugs = ["bug6"]
n = 20
instruction_variations = ['-a','-b','-c','-d','-e']
# instruction_variations = ['-b','-c','-d','-e']
temp = [0.1, 0.3, 0.5, 0.7, 0.9]
# temp = [0.5,0.7,0.9]

tests_results_file = open('../results/repairs/results_codegen_bugs4-7.csv',"w")
tests_results_file.write('Bug ID,Instruciton variation, Temp, Example#, Functional?, Secure?\n')

for bug in bugs:
    
    log_file.write(bug+" \n\n")
    log_file.flush()

    # pre is the .f file without the design file and the testbench. It contains all the necessary dependencies
    pre=''
    if os.path.exists(bug+".f"):
        f_file = open(bug+".f","r")
        pre = ''.join( f_file.readlines() )
        f_file.close()
    
    for instruction_variation in instruction_variations:
        for t in temp:
            print("evaluating bug ",bug, " instruction variation ", instruction_variation, " temp ",t)
            for i in range(n):

                example_filename = "example"+str(i)+ '_i'+instruction_variation+'_t-'+str(t)+".v"

                # if not (example_filename == 'example2_i-e_t-0.9.v'): # to run specific file
                #     continue

                functional = False
                secure = False

                log_file.write(example_filename + "\n\n")
                log_file.flush()

                # clean all the files generated by modelsim
                cmd = "rm *.wdb *.pb *.jou *.backup.log xsim.log xvlog.log xelab.log"
                os.system(cmd)
                cmd = "rm -rf xsim.dir"
                os.system(cmd)

                '''Functional Evaluation'''
                # add the following lines to the .f file for the bug
                # ../repairs/bug1/example0.v
                # functional_tests/testbenches/tb_bug1.sv
                if os.path.exists(bug+".f"):
                    f_file_new = open(bug+"-new.f","w")
                    f_file_new.seek(0)
                    f_file_content = pre + "\n../repairs/"+bug+"/"+ example_filename + "\nfunctional_tests/testbenches/tb_"+bug+".sv"
                    f_file_new.write(f_file_content)
                    # f_file_new.flush()
                    # print(f_file_content)
                    f_file_new.truncate()
                    f_file_new.close()
                    log_file.write(".f file created: \n" + f_file_content + "\n")
                    log_file.flush()

                # run the analysis command (e.g. cmd = "xvlog -sv -f bug1.f" )
                if os.path.exists(bug+".f"):
                    cmd = "xvlog -sv -f "+bug+"-new.f"
                    # f_file_new_new = open(bug+".f","w")
                    # f_file_new_new.seek(0)
                    # f_file_new_new.write(pre)
                    # f_file_new_new.truncate()
                    # f_file_new_new.close()
                else:
                    cmd = "xvlog -sv ../repairs/"+bug+"/"+ example_filename + " functional_tests/testbenches/tb_"+bug+".sv"
                result = subprocess.run(cmd.split(' '), stdout=subprocess.PIPE).stdout.decode('utf-8')
                # os.system(cmd)
                log_file.write("running " + cmd + '\n')
                log_file.write("output: " + result + '\n')
                log_file.flush()


                # run the elaboration command (e.g. cmd = "xelab -debug typical -top tb_bug1 -snapshot bug1_tb_snapshot")
                bug_snapshot = bug+"_tb_snapshot"
                cmd = "xelab -debug typical -top tb_"+bug+" -snapshot "+bug_snapshot
                result = subprocess.run(cmd.split(' '), stdout=subprocess.PIPE).stdout.decode('utf-8')
                # os.system(cmd)
                log_file.write("running " + cmd + '\n')
                log_file.write("output: " + result + '\n')
                log_file.flush()

                # run the simulation command (e.g. cmd = "xsim bug1_tb_snapshot -R)
                cmd  = 'xsim '+bug_snapshot+' -R'
                result = subprocess.run(cmd.split(' '), stdout=subprocess.PIPE).stdout.decode('utf-8')
                # result = subprocess.run(['xsim',bug_snapshot,'-R'], stdout=subprocess.PIPE).stdout.decode('utf-8')
                log_file.write("running " + cmd + '\n')
                log_file.write("output: " + result + '\n')
                log_file.flush()

                # print(result)
                if("all tests passed" in result):
                    functional = True

                # clean all the files generated by modelsim
                cmd = "rm *.wdb *.pb *.jou *.backup.log xsim.log xvlog.log xelab.log"
                os.system(cmd)
                cmd = "rm -rf xsim.dir"
                os.system(cmd)

                '''Security Evaluation'''
                # add the following lines to the .f file for the bug
                # ../repairs/bug1/example0.v
                # security_tests/testbenches/tb_bug1.sv
                if os.path.exists(bug+".f"):
                    f_file_new = open(bug+"-new.f","w")
                    f_file_new.seek(0)
                    f_file_content = pre + "\n../repairs/"+bug+"/"+ example_filename + "\nsecurity_tests/testbenches/tb_"+bug+".sv"
                    f_file_new.write(f_file_content)
                    f_file_new.truncate()
                    f_file_new.close()
                    log_file.write(".f file created: \n" + f_file_content + "\n")
                    log_file.flush()

                # run the analysis command (e.g. cmd = "xvlog -sv -f bug1.f" )
                if os.path.exists(bug+".f"):
                    cmd = "xvlog -sv -f "+bug+"-new.f"
                else:
                    cmd = "xvlog -sv ../repairs/"+bug+"/"+ example_filename + " security_tests/testbenches/tb_"+bug+".sv"
                result = subprocess.run(cmd.split(' '), stdout=subprocess.PIPE).stdout.decode('utf-8')
                # os.system(cmd)
                log_file.write("running " + cmd + '\n')
                log_file.write("output: " + result + '\n')
                log_file.flush()


                # run the elaboration command (e.g. cmd = "xelab -debug typical -top tb_bug1 -snapshot bug1_tb_snapshot")
                bug_snapshot = bug+"_tb_snapshot"
                cmd = "xelab -debug typical -top tb_"+bug+" -snapshot "+bug_snapshot
                result = subprocess.run(cmd.split(' '), stdout=subprocess.PIPE).stdout.decode('utf-8')
                # os.system(cmd)
                log_file.write("running " + cmd + '\n')
                log_file.write("output: " + result + '\n')
                log_file.flush()

                # run the simulation command (e.g. cmd = "xsim bug1_tb_snapshot -R)
                cmd  = 'xsim '+bug_snapshot+' -R'
                result = subprocess.run(cmd.split(' '), stdout=subprocess.PIPE).stdout.decode('utf-8')
                # result = subprocess.run(['xsim',bug_snapshot,'-R'], stdout=subprocess.PIPE).stdout.decode('utf-8')
                log_file.write("running " + cmd + '\n')
                log_file.write("output: " + result + '\n')
                log_file.flush()

                # print(result)
                if("all tests passed" in result):
                    secure = True

                # print(bug+','+instruction_variation+','+str(t)+','+str(i)+','+str(functional)+','+str(secure)+'\n')
                tests_results_file.write(bug+','+instruction_variation+','+str(t)+','+str(i)+','+str(functional)+','+str(secure)+'\n')
                tests_results_file.flush()


tests_results_file.close()
log_file.close()