#ifndef __CWE1314__
#define __CWE1314__
#include <string>
#include <iostream>
#include <vector>
#include "utils/result.h"
#include "VeriVisitor.h"
#include "VeriModule.h"
#include "VeriModuleItem.h"
#include "VeriId.h"
#include "VeriStatement.h"
#include "VeriExpression.h"
#include <map>
#include <set>
#include "VeriConstVal.h"
#include "Array.h"          // a dynamic array
#include "VeriMisc.h"
#include "scanner.h"

#ifdef VERIFIC_NAMESPACE
using namespace Verific ;
#endif

extern std::ofstream log_detail;
extern Result result;

// =============================CWE 1314 Detector============================//


class Visitor1314 : public VeriVisitor
{
public:
    Visitor1314() : VeriVisitor(),is_lhs(false),is_rhs(false),index(INT_MAX),index2(INT_MAX),range_index(false),signal_count(0),control(false),is_wdata(false){ }
    virtual ~Visitor1314() {notprotected.clear();protectedSignal.clear();}    
    void VERI_VISIT(VeriIdRef, node) ;
    void VERI_VISIT(VeriIndexedId, node) ;
    void VERI_VISIT(VeriIndexedMemoryId, node) ;
    void VERI_VISIT(VeriBlockingAssign, node) ;
    void VERI_VISIT(VeriQuestionColon, node) ;
    void VERI_VISIT(VeriFor, node);
    void VERI_VISIT(VeriCaseStatement, node) ;
    // void VERI_VISIT(VeriSeqBlock, node) ;
    void VERI_VISIT(VeriAlwaysConstruct, node) ;
    void VERI_VISIT(VeriIntVal, node) ;
    void VERI_VISIT(VeriNonBlockingAssign, node) ;
    void VERI_VISIT(VeriConditionalStatement, node) ;
    void identifyNotProtected();
    void compareArrayProtection();
private:
    bool is_lhs;
    bool is_rhs;
    int index;
    int index2;
    bool range_index;
    std::vector<std::string> notprotected;
    std::vector<std::string> protection;
    int signal_count;
    std::map<std::string,std::vector<std::string>> protection_map;
    // std::vector<std::tuple<std::string,std::string>> protectedSignal;
    std::vector<std::string> protectedSignal;
    bool control;
    bool is_wdata;
} ; // class Visitor1314


class Scanner_CWE1314 : public Scanner {
    public:
    void scan(VeriModule * mod){
        Visitor1314 v1314 ;
        mod->Accept(v1314) ;
        // results for 1314
        v1314.identifyNotProtected();
        v1314.compareArrayProtection();
    }
};
#endif