#ifndef __CWE1280__
#define __CWE1280__

#include <iostream>
#include <cstdio>
#include <typeinfo>

#include "VeriModule.h"
#include "VeriId.h"
#include "VeriMisc.h"
#include "VeriExpression.h"
#include "veri_tokens.h"
#include "VeriVisitor.h"
#include "VeriStatement.h"
#include "Map.h"
#include <list>
#include <tuple>
#include <string.h>
#include <FileFinder.h>
#include "Array.h"
#include "scanner.h"
#include "utils/result.h"

#ifdef VERIFIC_NAMESPACE
using namespace Verific ;
#endif

extern std::ofstream log_detail;
extern Result result;

class Visitor1280 : public VeriVisitor
{
public:
    Visitor1280() : VeriVisitor(), _Bassign(0), _last_seq_block(0){ }
    virtual ~Visitor1280() { _Bassign = 0 ;  _last_seq_block = 0;}

    virtual void VERI_VISIT(VeriSeqBlock, node) ;

    virtual void VERI_VISIT(VeriIdRef, node) ;
    virtual void VERI_VISIT(VeriIndexedId, node) ;
    virtual void VERI_VISIT(VeriIndexedMemoryId, node) ;
    virtual void VERI_VISIT(VeriSelectedName, node) ;
    virtual void VERI_VISIT(VeriBlockingAssign, node) ;
    virtual void VERI_VISIT(VeriBinaryOperator, node) ; 
    //virtual void VERI_VISIT(VeriTreeNode, node);
    virtual void VERI_VISIT(VeriEventControlStatement, node);
    virtual void VERI_VISIT(VeriAlwaysConstruct, node);
    std::list<std::tuple<VeriIdDef *, VeriSeqBlock *, unsigned int>> read;

    std::list<std::tuple<VeriIdDef *, VeriSeqBlock *, unsigned int>> write; 
private:
    VeriBlockingAssign *_Bassign ;
    VeriSeqBlock * _last_seq_block;
    char is_lhs;
    char is_always;
    std::list<std::string> sensList; 
} ; // class Visitor1280


class Scanner_CWE1280 : public Scanner{   \
    public:
        Visitor1280 v1280;
        void scan(VeriModule * mod){
            mod->Accept(v1280);
            // results for 1280
            for (std::tuple<VeriIdDef *, VeriSeqBlock *, unsigned int> t : v1280.write){
                VeriIdDef * w_id = std::get<0>(t);
                VeriSeqBlock * w_sb =  std::get<1>(t);
                int w_n = std::get<2>(t);

                for (std::tuple<VeriIdDef *, VeriSeqBlock *, int> t2 : v1280.read){
                    VeriIdDef * r_id = std::get<0>(t2);
                    VeriSeqBlock * r_sb =  std::get<1>(t2);
                    int r_n = std::get<2>(t2);

                    if (strcmp(w_id->GetPrettyPrintedString(),r_id->GetPrettyPrintedString()) == 0 && w_sb == r_sb && w_n > r_n)
                    {
                        if (!result.cwe_1280){
                            result.cwe_1280 = true;
                            log_detail<<"potential CWE 1280 detected\n";
                        }
                        log_detail<<"\nWARNING! write after read of signal: " <<  w_id->GetPrettyPrintedString();
                        log_detail<<"\nWrite at line: " << w_n;
                        log_detail<<"\nRead at line: " << r_n;
                    }    
                    
                }

            }
        }
};

#endif